ALTER TABLE ADR.WKF_MESSAGING_CASE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_MESSAGING_CASE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_MESSAGING_CASE_H
(
  WKF_MESSAGING_CASE_H_ID       NUMBER(20)      NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  WKF_MESSAGING_CASE_ID         NUMBER(20)      NOT NULL,
  HL7_MESSAGE_ID                VARCHAR2(50 BYTE),
  WKF_CASE_ID                   VARCHAR2(50 BYTE),
  MESSAGE_TRANSMISSION_TYPE_ID  VARCHAR2(50 BYTE),
  ACK_TYPE_ID                   VARCHAR2(50 BYTE),
  STD_INSTITUTION_ID            VARCHAR2(50 BYTE),
  TRANSMISSION_TYPE_CODE        VARCHAR2(50 BYTE),
  TRANSMISSION_DATE             DATE,
  ACK_DATE                      DATE,
  ERROR_MESSAGE_TEXT            VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_MESSAGING_CASE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.WKF_MESSAGING_CASE_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.WKF_MESSAGING_CASE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.HL7_MESSAGE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.ACK_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.TRANSMISSION_TYPE_CODE IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.TRANSMISSION_DATE IS 'BR2216Thedate/timethe transmissionwasmadeto thissiteorreceived fromthissite.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.ACK_DATE IS 'BR2228TheACKdate/time isdefinedasthedate andtimeHECreceivedthe ACKonoutboundmessages orthedate/timeHECsent theackoninbound messages.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFMSGCSH_PK ON ADR.WKF_MESSAGING_CASE_H
(WKF_MESSAGING_CASE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKF_MESSAGING_CASE_H_FK_I ON ADR.WKF_MESSAGING_CASE_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_MESSAGING_CASE_H FOR ADR.WKF_MESSAGING_CASE_H;


ALTER TABLE ADR.WKF_MESSAGING_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_000
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFMSGCSH_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_H_ID)
  USING INDEX ADR.WKFMSGCSH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_MESSAGING_CASE_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_MESSAGING_CASE_H TO ADR_RW;
ALTER TABLE ADR.WKF_MESSAGING_CASE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_MESSAGING_CASE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_MESSAGING_CASE
(
  WKF_MESSAGING_CASE_ID         NUMBER(20)      NOT NULL,
  WKF_CASE_ID                   NUMBER(20)      NOT NULL,
  ACK_TYPE_ID                   NUMBER(20),
  HL7_MESSAGE_ID                VARCHAR2(50 BYTE),
  MESSAGE_TRANSMISSION_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID            NUMBER(20),
  TRANSMISSION_TYPE_CODE        VARCHAR2(50 BYTE),
  TRANSMISSION_DATE             DATE,
  ACK_DATE                      DATE,
  ERROR_MESSAGE_TEXT            VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_MESSAGING_CASE IS 'Stores information for a case associated with or initiated by an HL7 message. This requires permanent retention (due to potential future adjudication) of information critical to the case. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.WKF_MESSAGING_CASE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.ACK_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.HL7_MESSAGE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.TRANSMISSION_TYPE_CODE IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.TRANSMISSION_DATE IS 'BR2216Thedate/timethe transmissionwasmadeto thissiteorreceived fromthissite.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.ACK_DATE IS 'BR2228TheACKdate/time isdefinedasthedate andtimeHECreceivedthe ACKonoutboundmessages orthedate/timeHECsent theackoninbound messages.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.ERROR_MESSAGE_TEXT IS 'Additionaltextinfo associatedwiththe messageevent';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_MESSAGING_CASE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFMSGCS_PK ON ADR.WKF_MESSAGING_CASE
(WKF_MESSAGING_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_STDINST_FK_I ON ADR.WKF_MESSAGING_CASE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_2_I ON ADR.WKF_MESSAGING_CASE
(ACK_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_STD_MSGTYP_FK_I ON ADR.WKF_MESSAGING_CASE
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFMSGCS_WKFCASE_FK_I ON ADR.WKF_MESSAGING_CASE
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.wkf_msg_case_audir_trgr
after Update or Delete or Insert
ON ADR.WKF_MESSAGING_CASE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into WKF_MESSAGING_CASE_H
		(
		WKF_MESSAGING_CASE_H_ID,
		WKF_MESSAGING_CASE_ID,
		HL7_MESSAGE_ID,
		WKF_CASE_ID,
		MESSAGE_TRANSMISSION_TYPE_ID,
		ACK_TYPE_ID,
		STD_INSTITUTION_ID,
		TRANSMISSION_TYPE_CODE,
		TRANSMISSION_DATE,
		ACK_DATE,
		ERROR_MESSAGE_TEXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_MESSAGING_CASE_H_S.nextval,
		:old.WKF_MESSAGING_CASE_ID,
		:old.HL7_MESSAGE_ID,
		:old.WKF_CASE_ID,
		:old.MESSAGE_TRANSMISSION_TYPE_ID,
		:old.ACK_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.TRANSMISSION_TYPE_CODE,
		:old.TRANSMISSION_DATE,
		:old.ACK_DATE,
		:old.ERROR_MESSAGE_TEXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into WKF_MESSAGING_CASE_H
		(
		WKF_MESSAGING_CASE_H_ID,
		WKF_MESSAGING_CASE_ID,
		HL7_MESSAGE_ID,
		WKF_CASE_ID,
		MESSAGE_TRANSMISSION_TYPE_ID,
		ACK_TYPE_ID,
		STD_INSTITUTION_ID,
		TRANSMISSION_TYPE_CODE,
		TRANSMISSION_DATE,
		ACK_DATE,
		ERROR_MESSAGE_TEXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_MESSAGING_CASE_H_S.nextval,
		:new.WKF_MESSAGING_CASE_ID,
		:new.HL7_MESSAGE_ID,
		:new.WKF_CASE_ID,
		:new.MESSAGE_TRANSMISSION_TYPE_ID,
		:new.ACK_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.TRANSMISSION_TYPE_CODE,
		:new.TRANSMISSION_DATE,
		:new.ACK_DATE,
		:new.ERROR_MESSAGE_TEXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;
end wkf_msg_case_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_MESSAGING_CASE FOR ADR.WKF_MESSAGING_CASE;


ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_PK
  PRIMARY KEY
  (WKF_MESSAGING_CASE_ID)
  USING INDEX ADR.WKFMSGCS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_MESSAGING_CASE ADD (
  CONSTRAINT WKFMSGCS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_MESSAGING_CASE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_MESSAGING_CASE TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_STATUS_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_STATUS_DETAIL_H
(
  WKF_CASE_STATUS_DETAIL_H_ID  NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  WKF_CASE_STATUS_DETAIL_ID    NUMBER(20)       NOT NULL,
  WKF_CASE_ID                  NUMBER(20)       NOT NULL,
  WKF_CASE_REQUEST_TYPE_ID     NUMBER(20),
  WKF_CASE_STATUS_TYPE_ID      NUMBER(20),
  WKF_CASE_ACTIVITY_TYPE_ID    NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_STATUS_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.WKF_CASE_STATUS_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.WKF_CASE_STATUS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSESTH_PK ON ADR.WKF_CASE_STATUS_DETAIL_H
(WKF_CASE_STATUS_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKF_CASE_STATUS_DETAIL_H_FK_I ON ADR.WKF_CASE_STATUS_DETAIL_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_STATUS_DETAIL_H FOR ADR.WKF_CASE_STATUS_DETAIL_H;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_066
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTH_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_H_ID)
  USING INDEX ADR.WKFCSESTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_STATUS_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_STATUS_DETAIL
(
  WKF_CASE_STATUS_DETAIL_ID  NUMBER(20)         NOT NULL,
  WKF_CASE_ID                NUMBER(20),
  WKF_CASE_ACTIVITY_TYPE_ID  NUMBER(20),
  WKF_CASE_REQUEST_TYPE_ID   NUMBER(20),
  WKF_CASE_STATUS_TYPE_ID    NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_STATUS_DETAIL IS 'The table stores status information used PoImIrk progress toward completion for a particular workflow case. The status is the current phase of the case. The status value acts as a progress indicator as the case activities are completed. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.WKF_CASE_STATUS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_STATUS_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSESTAT_PK ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_STATUS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFACTVTY_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_ACTIVITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFCSST_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_STD_WKFRQST_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_REQUEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSESTAT_WKFCASE_FK_I ON ADR.WKF_CASE_STATUS_DETAIL
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_STA_DET_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_STATUS_DETAIL for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_STATUS_DETAIL_H
		(
		WKF_CASE_STATUS_DETAIL_H_ID,
		WKF_CASE_STATUS_DETAIL_ID,
		WKF_CASE_ID,
		WKF_CASE_REQUEST_TYPE_ID ,
		WKF_CASE_STATUS_TYPE_ID ,
		WKF_CASE_ACTIVITY_TYPE_ID,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_STATUS_DETAIL_H_S.nextval  ,
		:old.WKF_CASE_STATUS_DETAIL_ID,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_REQUEST_TYPE_ID,
		:old.WKF_CASE_STATUS_TYPE_ID ,
		:old.WKF_CASE_ACTIVITY_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_STATUS_DETAIL_H
		(
		WKF_CASE_STATUS_DETAIL_H_ID,
		WKF_CASE_STATUS_DETAIL_ID,
		WKF_CASE_ID,
		WKF_CASE_REQUEST_TYPE_ID ,
		WKF_CASE_STATUS_TYPE_ID ,
		WKF_CASE_ACTIVITY_TYPE_ID,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_STATUS_DETAIL_H_S.nextval  ,
		:new.WKF_CASE_STATUS_DETAIL_ID,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_REQUEST_TYPE_ID,
		:new.WKF_CASE_STATUS_TYPE_ID ,
		:new.WKF_CASE_ACTIVITY_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_STA_det_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_STATUS_DETAIL FOR ADR.WKF_CASE_STATUS_DETAIL;


ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_PK
  PRIMARY KEY
  (WKF_CASE_STATUS_DETAIL_ID)
  USING INDEX ADR.WKFCSESTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE_STATUS_DETAIL ADD (
  CONSTRAINT WKFCSESTAT_STD_WKFACTVTY_FK 
  FOREIGN KEY (WKF_CASE_ACTIVITY_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEACTIVITY (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTAT_STD_WKFCSST_FK 
  FOREIGN KEY (WKF_CASE_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASESTATUS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTAT_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCSESTAT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_STATUS_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_STATUS_DETAIL TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_H
(
  WKF_CASE_H_ID             NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  WKF_CASE_ID               NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20),
  WKF_CASE_TYPE_ID          NUMBER(20),
  WKF_CASE_REQUEST_TYPE_ID  NUMBER(20),
  WKF_CASE_ISSUE_TYPE_ID    NUMBER(20),
  REQUEST_RECEIVED_SITE_ID  NUMBER(20),
  STD_USERGROUPTYPE_ID      NUMBER(20),
  REQUEST_RECEIVED_DATE     DATE,
  CASE_DUE_DATE             DATE,
  ERROR_MESSAGE_TEXT        VARCHAR2(250 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  BF_PROCESSED              NUMBER(1)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_CASE_H.WKF_CASE_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_CASE_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCASEH_PK ON ADR.WKF_CASE_H
(WKF_CASE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_H FOR ADR.WKF_CASE_H;


ALTER TABLE ADR.WKF_CASE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_068
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFCASEH_PK
  PRIMARY KEY
  (WKF_CASE_H_ID)
  USING INDEX ADR.WKFCASEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_H TO ADR_R;

GRANT SELECT ON ADR.WKF_CASE_H TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_COMMENTS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_COMMENTS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_COMMENTS_H
(
  WKF_CASE_COMMENT_H_ID  NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  WKF_CASE_ID            NUMBER(20)             NOT NULL,
  WKF_CASE_COMMENT_ID    NUMBER(20)             NOT NULL,
  COMMENT_VALUE          VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_COMMENTS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.WKF_CASE_COMMENT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.WKF_CASE_COMMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.COMMENT_VALUE IS 'Additionaltextinfo associatedwiththe messageevent';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCMTSH_PK ON ADR.WKF_CASE_COMMENTS_H
(WKF_CASE_COMMENT_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKF_CASE_COMMENTS_H_FK_I ON ADR.WKF_CASE_COMMENTS_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_COMMENTS_H FOR ADR.WKF_CASE_COMMENTS_H;


ALTER TABLE ADR.WKF_CASE_COMMENTS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_067
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFCMTSH_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_H_ID)
  USING INDEX ADR.WKFCMTSH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_COMMENTS_H TO ADR_R;

GRANT SELECT ON ADR.WKF_CASE_COMMENTS_H TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_COMMENTS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_COMMENTS CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_COMMENTS
(
  WKF_CASE_COMMENT_ID    NUMBER(20)             NOT NULL,
  WKF_CASE_ID            NUMBER(20),
  COMMENT_VALUE          VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_COMMENTS IS 'The table stores user remarks pertinent to a particular workflow case. Contains all the comment records for a case Freeform text which may be entered by the user to document pertinent information regarding the case. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.WKF_CASE_COMMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.COMMENT_VALUE IS 'Additionaltextinfo associatedwiththe messageevent';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_COMMENTS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCMTS_PK ON ADR.WKF_CASE_COMMENTS
(WKF_CASE_COMMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCMTS_WKFCASE_FK_I ON ADR.WKF_CASE_COMMENTS
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_COMM_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_COMMENTS for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_Comments_H
		(
		WKF_CASE_COMMENT_H_ID,
		WKF_CASE_ID,
		WKF_CASE_COMMENT_ID,
		COMMENT_VALUE ,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_COMMENTS_H_S.nextval  ,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_COMMENT_ID,
		:old.COMMENT_VALUE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_Comments_H
		(
		WKF_CASE_COMMENT_H_ID,
		WKF_CASE_ID,
		WKF_CASE_COMMENT_ID,
		COMMENT_VALUE ,
		RECORD_CREATED_BY ,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY ,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_COMMENTS_H_S.nextval  ,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_COMMENT_ID,
		:new.COMMENT_VALUE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_COMM_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_COMMENTS FOR ADR.WKF_CASE_COMMENTS;


ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_PK
  PRIMARY KEY
  (WKF_CASE_COMMENT_ID)
  USING INDEX ADR.WKFCMTS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE_COMMENTS ADD (
  CONSTRAINT WKFCMTS_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_COMMENTS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_COMMENTS TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_ASSIGNMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_ASSIGNMENT_H
(
  WKF_CASE_ASSIGNMENT_H_ID  NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  WKF_CASE_ASSIGNMENT_ID    NUMBER(20)          NOT NULL,
  WKF_CASE_ID               NUMBER(20),
  WKF_CASE_ASSIGNED_BY      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNED_TO      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNMENT_DATE  DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_ASSIGNMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.WKF_CASE_ASSIGNMENT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.WKF_CASE_ASSIGNMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSASGH_PK ON ADR.WKF_CASE_ASSIGNMENT_H
(WKF_CASE_ASSIGNMENT_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKF_CASE_ASSIGNMENT_H_FK_I ON ADR.WKF_CASE_ASSIGNMENT_H
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_ASSIGNMENT_H FOR ADR.WKF_CASE_ASSIGNMENT_H;


ALTER TABLE ADR.WKF_CASE_ASSIGNMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_049
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT WKFCSASGH_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_H_ID)
  USING INDEX ADR.WKFCSASGH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H TO ADR_R;

GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT_H TO ADR_RW;
ALTER TABLE ADR.WKF_CASE_ASSIGNMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE_ASSIGNMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE_ASSIGNMENT
(
  WKF_CASE_ASSIGNMENT_ID    NUMBER(20)          NOT NULL,
  WKF_CASE_ID               NUMBER(20),
  WKF_CASE_ASSIGNED_BY      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNED_TO      VARCHAR2(30 BYTE),
  WKF_CASE_ASSIGNMENT_DATE  DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE_ASSIGNMENT IS 'The table stores data about the user assigned to a particular workflow case. Each Workflow case can be assigned or re-assigned to users in the system. This table keeps a record of all case assignments. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.WKF_CASE_ASSIGNMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE_ASSIGNMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCSASGMT_PK ON ADR.WKF_CASE_ASSIGNMENT
(WKF_CASE_ASSIGNMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCSASGMT_WKFCASE_FK_I ON ADR.WKF_CASE_ASSIGNMENT
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_ASSGN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE_ASSIGNMENT for each row
declare
   	mDML char(1);
begin

	if DELETING then
	     insert into WKF_CASE_ASSIGNMENT_H
		(
		WKF_CASE_ASSIGNMENT_H_ID,
		WKF_CASE_ASSIGNMENT_ID,
		WKF_CASE_ID,
		WKF_CASE_ASSIGNED_BY,
		WKF_CASE_ASSIGNED_TO,
		WKF_CASE_ASSIGNMENT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_ASSIGNMENT_H_S.nextval  ,
		:old.WKF_CASE_ASSIGNMENT_ID,
		:old.WKF_CASE_ID,
		:old.WKF_CASE_ASSIGNED_BY,
		:old.WKF_CASE_ASSIGNED_TO,
		:old.WKF_CASE_ASSIGNMENT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

	     insert into WKF_CASE_ASSIGNMENT_H
		(
		WKF_CASE_ASSIGNMENT_H_ID,
		WKF_CASE_ASSIGNMENT_ID,
		WKF_CASE_ID,
		WKF_CASE_ASSIGNED_BY,
		WKF_CASE_ASSIGNED_TO,
		WKF_CASE_ASSIGNMENT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		WKF_CASE_ASSIGNMENT_H_S.nextval  ,
		:new.WKF_CASE_ASSIGNMENT_ID,
		:new.WKF_CASE_ID,
		:new.WKF_CASE_ASSIGNED_BY,
		:new.WKF_CASE_ASSIGNED_TO,
		:new.WKF_CASE_ASSIGNMENT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

End WKF_CASE_ASSGN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_ASSIGNMENT FOR ADR.WKF_CASE_ASSIGNMENT;


ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_PK
  PRIMARY KEY
  (WKF_CASE_ASSIGNMENT_ID)
  USING INDEX ADR.WKFCSASGMT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE_ASSIGNMENT ADD (
  CONSTRAINT WKFCSASGMT_WKFCASE_FK 
  FOREIGN KEY (WKF_CASE_ID) 
  REFERENCES ADR.WKF_CASE (WKF_CASE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE_ASSIGNMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE_ASSIGNMENT TO ADR_RW;
ALTER TABLE ADR.WKF_CASE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WKF_CASE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WKF_CASE
(
  WKF_CASE_ID               NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20),
  WKF_CASE_TYPE_ID          NUMBER(20)          NOT NULL,
  WKF_CASE_REQUEST_TYPE_ID  NUMBER(20),
  WKF_CASE_ISSUE_TYPE_ID    NUMBER(20),
  REQUEST_RECEIVED_SITE_ID  NUMBER(20),
  STD_USERGROUPTYPE_ID      NUMBER(20),
  REQUEST_RECEIVED_DATE     DATE,
  CASE_DUE_DATE             DATE,
  ERROR_MESSAGE_TEXT        VARCHAR2(250 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  BF_PROCESSED              NUMBER(1)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WKF_CASE IS 'Contains all the workflow records that are manual cases i.e. a business event that requires staff to perform work. Workflow Cases may be handled by the system auPIIatically or may become a case that a staff member will work. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.WKF_CASE.WKF_CASE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.WKF_CASE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WKF_CASE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WKFCASE_PK ON ADR.WKF_CASE
(WKF_CASE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_PRSN_FK_I ON ADR.WKF_CASE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STDINST_FK_I ON ADR.WKF_CASE
(REQUEST_RECEIVED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STD_USRGRPTYP_FK_I ON ADR.WKF_CASE
(STD_USERGROUPTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STD_WKFCSTYPE_FK_I ON ADR.WKF_CASE
(WKF_CASE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_STD_WKFRQST_FK_I ON ADR.WKF_CASE
(WKF_CASE_REQUEST_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.WKFCASE_WKFISUTYPE_FK_I ON ADR.WKF_CASE
(WKF_CASE_ISSUE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.WKF_CASE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.WKF_CASE for each row
declare
    mDML char(1);
begin

  if DELETING then
       insert into WKF_CASE_H
    (

    WKF_CASE_H_ID,
    WKF_CASE_ID,
    PERSON_ID,
    WKF_CASE_TYPE_ID,
    WKF_CASE_REQUEST_TYPE_ID,
    WKF_CASE_ISSUE_TYPE_ID,
    REQUEST_RECEIVED_SITE_ID,
    REQUEST_RECEIVED_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE,
    Bf_Processed
    )
    values
    (
    WKF_CASE_H_S.nextval,
    :old.WKF_CASE_ID,
    :old.PERSON_ID,
    :old.WKF_CASE_TYPE_ID,
    :old.WKF_CASE_REQUEST_TYPE_ID,
    :old.WKF_CASE_ISSUE_TYPE_ID,
    :old.REQUEST_RECEIVED_SITE_ID,
    :old.REQUEST_RECEIVED_DATE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RECORD_MODIFIED_COUNT,
    'D',
    :old.Bf_Processed
    );
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

       insert into WKF_CASE_H
    (
    WKF_CASE_H_ID,
    WKF_CASE_ID,
    PERSON_ID,
    WKF_CASE_TYPE_ID,
    WKF_CASE_REQUEST_TYPE_ID,
    WKF_CASE_ISSUE_TYPE_ID,
    REQUEST_RECEIVED_SITE_ID,
    REQUEST_RECEIVED_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RECORD_MODIFIED_COUNT,
    TRANSACTION_TYPE_CODE,
    Bf_Processed
    )
    values
    (
    WKF_CASE_H_S.nextval,
    :new.WKF_CASE_ID,
    :new.PERSON_ID,
    :new.WKF_CASE_TYPE_ID,
    :new.WKF_CASE_REQUEST_TYPE_ID,
    :new.WKF_CASE_ISSUE_TYPE_ID,
    :new.REQUEST_RECEIVED_SITE_ID,
    :new.REQUEST_RECEIVED_DATE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RECORD_MODIFIED_COUNT,
    mDML,
    :new.Bf_Processed
    );
  end if;

End WKF_CASE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE FOR ADR.WKF_CASE;


ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PK
  PRIMARY KEY
  (WKF_CASE_ID)
  USING INDEX ADR.WKFCASE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.WKF_CASE ADD (
  CONSTRAINT WKFCASE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCASE_STD_WKFCSTYPE_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCASE_STD_WKFRQST_FK 
  FOREIGN KEY (WKF_CASE_REQUEST_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASEREQUEST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WKFCASE_WKFISUTYPE_FK 
  FOREIGN KEY (WKF_CASE_ISSUE_TYPE_ID) 
  REFERENCES ADRREF.STD_WKFISSUETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WKF_CASE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WKF_CASE TO ADR_RW;

GRANT INSERT, SELECT, UPDATE ON ADR.WKF_CASE TO BIZFLOW_RW;
ALTER TABLE ADR.WAITTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WAITTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WAITTYPE
(
  WAITTYPE_ID  NUMBER(20)                       NOT NULL,
  CODE         VARCHAR2(3 BYTE)                 NOT NULL,
  NAME         VARCHAR2(30 BYTE)                NOT NULL,
  DESCRIPTION  VARCHAR2(250 BYTE),
  CREATED      DATE                             NOT NULL,
  UPDATED      DATE,
  CREATEDBY    VARCHAR2(32 BYTE)                NOT NULL,
  UPDATEDBY    VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WAITTYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.WAITTYPE.WAITTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WAITTYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.WAITTYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.WAITTYPE.DESCRIPTION IS 'Description of the wait type code';

COMMENT ON COLUMN ADR.WAITTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WAITTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WAITTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WAITTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.WAITTYPE_PK ON ADR.WAITTYPE
(WAITTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WAITTYPE FOR ADR.WAITTYPE;


ALTER TABLE ADR.WAITTYPE ADD (
  CONSTRAINT WAITTYPE_PK
  PRIMARY KEY
  (WAITTYPE_ID)
  USING INDEX ADR.WAITTYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WAITTYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTYPE TO ADR_RW;
ALTER TABLE ADR.WAITTIME_STAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WAITTIME_STAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WAITTIME_STAGE
(
  WAITTIME_STAGE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  WAITTYPE_ID            NUMBER(20)             NOT NULL,
  STD_INSTITUTION_ID     NUMBER(20)             NOT NULL,
  CLINIC_STOPCODE        VARCHAR2(6 BYTE),
  CLINIC_STOPCODE_NAME   VARCHAR2(30 BYTE),
  WAITLIST_START_DATE    DATE                   NOT NULL,
  DESIRED_APPT_DATE      DATE,
  DAYS_ELAPSED           NUMBER(4),
  RECORD_RESOLVED_IND    NUMBER(1),
  CLINIC_NAME            VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION WAITTIME_STAGE_P001 VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WAITTIME_STAGE IS 'Current Wait-Time data';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.WAITTIME_STAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.WAITTYPE_ID IS 'FK to ADR.WAITTYPE table';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.STD_INSTITUTION_ID IS 'FK to ADR.STD_INSTITUTION table';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.CLINIC_STOPCODE IS 'Clinic stopcode';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.CLINIC_STOPCODE_NAME IS 'Name of the clinic stopcode';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.WAITLIST_START_DATE IS 'Date Veteran was put on waitlist';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.DESIRED_APPT_DATE IS 'Veterans desired appointment date';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.DAYS_ELAPSED IS 'Number of days Veteran has been waiting for appointment';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.RECORD_RESOLVED_IND IS 'Indicator of whether or not the wait-time record was resolved';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.CLINIC_NAME IS 'The name of the clinic where the patient will be seen.';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WAITTIME_STAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WAITTIME_STAGE_PK ON ADR.WAITTIME_STAGE
(RECORD_CREATED_DATE, WAITTIME_STAGE_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION WAITTIME_STAGE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.WTS_PERSONID_IDX ON ADR.WAITTIME_STAGE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WTS_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION WTS_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION WTS_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION WTS_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WAITTIME_STAGE FOR ADR.WAITTIME_STAGE;


ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_STAGE_ID)
  USING INDEX LOCAL
  ENABLE VALIDATE);

ALTER TABLE ADR.WAITTIME_STAGE ADD (
  CONSTRAINT WAITTIME_STAGE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WAITTIME_STAGE_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WAITTIME_STAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTIME_STAGE TO ADR_RW;
ALTER TABLE ADR.WAITTIME_ARCHIVE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WAITTIME_ARCHIVE CASCADE CONSTRAINTS;

CREATE TABLE ADR.WAITTIME_ARCHIVE
(
  WAITTIME_ID            NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  WAITTYPE_ID            NUMBER(20)             NOT NULL,
  STD_INSTITUTION_ID     NUMBER(20)             NOT NULL,
  CLINIC_STOPCODE        VARCHAR2(6 BYTE),
  CLINIC_STOPCODE_NAME   VARCHAR2(30 BYTE),
  WAITLIST_START_DATE    DATE                   NOT NULL,
  DESIRED_APPT_DATE      DATE,
  DAYS_ELAPSED           NUMBER(4),
  RECORD_RESOLVED_IND    NUMBER(1),
  CLINIC_NAME            VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION WAITTIME_ARCHIVE_P001 VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WAITTIME_ARCHIVE IS 'Current Wait-Time data';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.WAITTIME_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.WAITTYPE_ID IS 'FK to ADR.WAITTYPE table';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.STD_INSTITUTION_ID IS 'FK to ADR.STD_INSTITUTION table';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.CLINIC_STOPCODE IS 'Clinic stopcode';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.CLINIC_STOPCODE_NAME IS 'Name of the clinic stopcode';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.WAITLIST_START_DATE IS 'Date Veteran was put on waitlist';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.DESIRED_APPT_DATE IS 'Veterans desired appointment date';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.DAYS_ELAPSED IS 'Number of days Veteran has been waiting for appointment';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.RECORD_RESOLVED_IND IS 'Indicator of whether or not the wait-time record was resolved';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.CLINIC_NAME IS 'The name of the clinic where the patient will be seen.';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WAITTIME_ARCHIVE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WAITTIME_ARCHIVE_PK ON ADR.WAITTIME_ARCHIVE
(RECORD_CREATED_DATE, WAITTIME_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION WAITTIME_ARCHIVE_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.WTA_PERSONID_IDX ON ADR.WAITTIME_ARCHIVE
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WTA_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION WTA_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION WTA_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION WTA_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WAITTIME_ARCHIVE FOR ADR.WAITTIME_ARCHIVE;


ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_ID)
  USING INDEX LOCAL
  ENABLE VALIDATE);

ALTER TABLE ADR.WAITTIME_ARCHIVE ADD (
  CONSTRAINT WAITTIME_ARCHIVE_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WAITTIME_ARCHIVE_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WAITTIME_ARCHIVE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTIME_ARCHIVE TO ADR_RW;
ALTER TABLE ADR.WAITTIME
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.WAITTIME CASCADE CONSTRAINTS;

CREATE TABLE ADR.WAITTIME
(
  WAITTIME_ID            NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  WAITTYPE_ID            NUMBER(20)             NOT NULL,
  STD_INSTITUTION_ID     NUMBER(20)             NOT NULL,
  CLINIC_STOPCODE        VARCHAR2(6 BYTE),
  CLINIC_STOPCODE_NAME   VARCHAR2(30 BYTE),
  WAITLIST_START_DATE    DATE                   NOT NULL,
  DESIRED_APPT_DATE      DATE,
  DAYS_ELAPSED           NUMBER(4),
  RECORD_RESOLVED_IND    NUMBER(1),
  CLINIC_NAME            VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION WAITTIME_P001 VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_01
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.WAITTIME IS 'Current Wait-Time data';

COMMENT ON COLUMN ADR.WAITTIME.WAITTIME_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.WAITTIME.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.WAITTIME.WAITTYPE_ID IS 'FK to ADR.WAITTYPE table';

COMMENT ON COLUMN ADR.WAITTIME.STD_INSTITUTION_ID IS 'FK to ADR.STD_INSTITUTION table';

COMMENT ON COLUMN ADR.WAITTIME.CLINIC_STOPCODE IS 'Clinic stopcode';

COMMENT ON COLUMN ADR.WAITTIME.CLINIC_STOPCODE_NAME IS 'Name of the clinic stopcode';

COMMENT ON COLUMN ADR.WAITTIME.WAITLIST_START_DATE IS 'Date Veteran was put on waitlist';

COMMENT ON COLUMN ADR.WAITTIME.DESIRED_APPT_DATE IS 'Veterans desired appointment date';

COMMENT ON COLUMN ADR.WAITTIME.DAYS_ELAPSED IS 'Number of days Veteran has been waiting for appointment';

COMMENT ON COLUMN ADR.WAITTIME.RECORD_RESOLVED_IND IS 'Indicator of whether or not the wait-time record was resolved';

COMMENT ON COLUMN ADR.WAITTIME.CLINIC_NAME IS 'The name of the clinic where the patient will be seen.';

COMMENT ON COLUMN ADR.WAITTIME.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.WAITTIME.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.WAITTIME.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.WAITTIME.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.WAITTIME.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.WAITTIME_PK ON ADR.WAITTIME
(RECORD_CREATED_DATE, WAITTIME_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
LOCAL (  
  PARTITION WAITTIME_P001
    LOGGING
    NOCOMPRESS 
    TABLESPACE L_INDEX_01
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOPARALLEL;

CREATE INDEX ADR.WT_PERSONID_IDX ON ADR.WAITTIME
(PERSON_ID)
  TABLESPACE L_INDEX_01
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
GLOBAL PARTITION BY HASH (PERSON_ID) (  
  PARTITION WT_PERSONID_IDX_P001
    TABLESPACE L_INDEX_01,  
  PARTITION WT_PERSONID_IDX_P002
    TABLESPACE L_INDEX_01,  
  PARTITION WT_PERSONID_IDX_P003
    TABLESPACE L_INDEX_01,  
  PARTITION WT_PERSONID_IDX_P004
    TABLESPACE L_INDEX_01
)
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM WAITTIME FOR ADR.WAITTIME;


ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_PK
  PRIMARY KEY
  (RECORD_CREATED_DATE, WAITTIME_ID)
  USING INDEX LOCAL
  ENABLE VALIDATE);

ALTER TABLE ADR.WAITTIME ADD (
  CONSTRAINT WAITTIME_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT WAITTIME_WAITTYPE_FK 
  FOREIGN KEY (WAITTYPE_ID) 
  REFERENCES ADR.WAITTYPE (WAITTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.WAITTIME TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.WAITTIME TO ADR_RW;
ALTER TABLE ADR.VCESTATUSTYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCESTATUSTYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCESTATUSTYPE
(
  VCESTATUSTYPE_ID  NUMBER(20)                  NOT NULL,
  CODE              VARCHAR2(3 BYTE)            NOT NULL,
  NAME              VARCHAR2(30 BYTE)           NOT NULL,
  DESCRIPTION       VARCHAR2(250 BYTE),
  CREATED           DATE                        NOT NULL,
  UPDATED           DATE,
  CREATEDBY         VARCHAR2(32 BYTE)           NOT NULL,
  UPDATEDBY         VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCESTATUSTYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.VCESTATUSTYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.DESCRIPTION IS 'Description of the status';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCESTATUSTYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.VCESTATUSTYPE_PK ON ADR.VCESTATUSTYPE
(VCESTATUSTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCESTATUSTYPE FOR ADR.VCESTATUSTYPE;


ALTER TABLE ADR.VCESTATUSTYPE ADD (
  CONSTRAINT VCESTATUSTYPE_PK
  PRIMARY KEY
  (VCESTATUSTYPE_ID)
  USING INDEX ADR.VCESTATUSTYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCESTATUSTYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCESTATUSTYPE TO ADR_RW;
ALTER TABLE ADR.VCELIGIBILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCELIGIBILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCELIGIBILITY_H
(
  VCELIGIBILITY_H_ID     NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  VCELIGIBILITY_ID       NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  VCESTATUSTYPE_ID       NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCELIGIBILITY_H IS 'Historical VC Eligibility determinations';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.VCELIGIBILITY_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.VCELIGIBILITY_ID IS 'FK to ADR.VCELIGIBILITY table';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.VCESTATUSTYPE_ID IS 'FK to ADR.VCESTATUSTYPE table';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCELIGIBILITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VCELIGIBILITY_H_PK ON ADR.VCELIGIBILITY_H
(VCELIGIBILITY_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCELIGIBILITY_H FOR ADR.VCELIGIBILITY_H;


ALTER TABLE ADR.VCELIGIBILITY_H ADD (
  CONSTRAINT VCELIGIBILITY_H_PK
  PRIMARY KEY
  (VCELIGIBILITY_H_ID)
  USING INDEX ADR.VCELIGIBILITY_H_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VCELIGIBILITY_H ADD (
  CONSTRAINT VCEELGB_H_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT VCEELGB_H_VCESTATS_FK 
  FOREIGN KEY (VCESTATUSTYPE_ID) 
  REFERENCES ADR.VCESTATUSTYPE (VCESTATUSTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT VCELIGIBILITY_ID_FK 
  FOREIGN KEY (VCELIGIBILITY_ID) 
  REFERENCES ADR.VCELIGIBILITY (VCELIGIBILITY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCELIGIBILITY_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY_H TO ADR_RW;
ALTER TABLE ADR.VCELIGIBILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCELIGIBILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCELIGIBILITY
(
  VCELIGIBILITY_ID       NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  VCESTATUSTYPE_ID       NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCELIGIBILITY IS 'Current VC Eligibility determinations';

COMMENT ON COLUMN ADR.VCELIGIBILITY.VCELIGIBILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCELIGIBILITY.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCELIGIBILITY.VCESTATUSTYPE_ID IS 'FK to ADR.VCESTATUSTYPE table';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCELIGIBILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VCELIGIBILITY_PK ON ADR.VCELIGIBILITY
(VCELIGIBILITY_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VCELIGIB_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.VCELIGIBILITY for each row
declare
     mDML char(1);
begin

  if DELETING then

INSERT INTO ADR.VCELIGIBILITY_H (
   VCELIGIBILITY_H_ID,TRANSACTION_TYPE_CODE,VCELIGIBILITY_ID, PERSON_ID, VCESTATUSTYPE_ID,
   RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT)
VALUES ( VCELIGIBILITY_H_S.nextval,
'D',
:old.VCELIGIBILITY_ID,
 :old.PERSON_ID ,
 :old.VCESTATUSTYPE_ID ,
 :old.RECORD_CREATED_BY ,
 :old.RECORD_CREATED_DATE ,
 :old.RECORD_MODIFIED_BY ,
 :old.RECORD_MODIFIED_DATE ,
 :old.RECORD_MODIFIED_COUNT  );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

  INSERT INTO ADR.VCELIGIBILITY_H (
   VCELIGIBILITY_H_ID,TRANSACTION_TYPE_CODE,VCELIGIBILITY_ID, PERSON_ID, VCESTATUSTYPE_ID,
   RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT)
VALUES ( VCELIGIBILITY_H_S.nextval,
mDML,
:new.VCELIGIBILITY_ID,
 :new.PERSON_ID ,
 :new.VCESTATUSTYPE_ID ,
 :new.RECORD_CREATED_BY ,
 :new.RECORD_CREATED_DATE ,
 :new.RECORD_MODIFIED_BY ,
 :new.RECORD_MODIFIED_DATE ,
 :new.RECORD_MODIFIED_COUNT  );

  end if;

end VCELIGIB_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM VCELIGIBILITY FOR ADR.VCELIGIBILITY;


ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCELIGIBILITY_PK
  PRIMARY KEY
  (VCELIGIBILITY_ID)
  USING INDEX ADR.VCELIGIBILITY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VCELIGIBILITY ADD (
  CONSTRAINT VCEELGB_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT VCEELGB_VCESTATS_FK 
  FOREIGN KEY (VCESTATUSTYPE_ID) 
  REFERENCES ADR.VCESTATUSTYPE (VCESTATUSTYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCELIGIBILITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCELIGIBILITY TO ADR_RW;
ALTER TABLE ADR.VCADMISTATUS_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCADMISTATUS_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCADMISTATUS_TYPE
(
  VCADMISTATUS_TYPE_ID  NUMBER(20)              NOT NULL,
  CODE                  VARCHAR2(3 BYTE)        NOT NULL,
  NAME                  VARCHAR2(30 BYTE)       NOT NULL,
  DESCRIPTION           VARCHAR2(250 BYTE),
  CREATED               DATE                    NOT NULL,
  UPDATED               DATE,
  CREATEDBY             VARCHAR2(32 BYTE)       NOT NULL,
  UPDATEDBY             VARCHAR2(32 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCADMISTATUS_TYPE IS 'Lookup table used by VetChoice';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.VCADMISTATUS_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.CODE IS 'Shortened code';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.NAME IS 'User readable name';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.DESCRIPTION IS 'Description of the status';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.CREATED IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.UPDATED IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.CREATEDBY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCADMISTATUS_TYPE.UPDATEDBY IS 'Account/user ID for this modification to the record.';


CREATE UNIQUE INDEX ADR.VCADMISTATUS_TYPE_PK ON ADR.VCADMISTATUS_TYPE
(VCADMISTATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCADMISTATUS_TYPE FOR ADR.VCADMISTATUS_TYPE;


ALTER TABLE ADR.VCADMISTATUS_TYPE ADD (
  CONSTRAINT VCADMISTATUS_TYPE_PK
  PRIMARY KEY
  (VCADMISTATUS_TYPE_ID)
  USING INDEX ADR.VCADMISTATUS_TYPE_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCADMISTATUS_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMISTATUS_TYPE TO ADR_RW;
ALTER TABLE ADR.VCADMIN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCADMIN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCADMIN_H
(
  VCADMIN_H_ID           NUMBER(20)             NOT NULL,
  VCADMIN_ID             NUMBER(20),
  PERSON_ID              NUMBER(20)             NOT NULL,
  ERROR_TXT              VARCHAR2(30 BYTE),
  VCADMISTATUS_TYPE_ID   NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCADMIN_H IS 'History table of VC Contractor log';

COMMENT ON COLUMN ADR.VCADMIN_H.VCADMIN_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCADMIN_H.VCADMIN_ID IS 'FK to ADR.VCADMIN table';

COMMENT ON COLUMN ADR.VCADMIN_H.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCADMIN_H.ERROR_TXT IS 'Error message';

COMMENT ON COLUMN ADR.VCADMIN_H.VCADMISTATUS_TYPE_ID IS 'FK to ADR.VCADMISTATUS_TYPE table';

COMMENT ON COLUMN ADR.VCADMIN_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCADMIN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VCADMIN_H_PK ON ADR.VCADMIN_H
(VCADMIN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VCADMIN_H FOR ADR.VCADMIN_H;


ALTER TABLE ADR.VCADMIN_H ADD (
  CONSTRAINT VCADMIN_H_PK
  PRIMARY KEY
  (VCADMIN_H_ID)
  USING INDEX ADR.VCADMIN_H_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VCADMIN_H ADD (
  CONSTRAINT VCADMIN_H_ADMIN_FK 
  FOREIGN KEY (VCADMIN_ID) 
  REFERENCES ADR.VCADMIN (VCADMIN_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT VCADMIN_H_VCEADMINSTATS_FK 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT VCADMIN_PRSON_H_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCADMIN_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN_H TO ADR_RW;
ALTER TABLE ADR.VCADMIN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VCADMIN CASCADE CONSTRAINTS;

CREATE TABLE ADR.VCADMIN
(
  VCADMIN_ID             NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  VCADMISTATUS_TYPE_ID   NUMBER(20),
  ERROR_TXT              VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VCADMIN IS 'Log of records sent to VC Contractor';

COMMENT ON COLUMN ADR.VCADMIN.VCADMIN_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VCADMIN.PERSON_ID IS 'FK to ADR.PERSON table';

COMMENT ON COLUMN ADR.VCADMIN.VCADMISTATUS_TYPE_ID IS 'FK to ADR.VCADMISTATUS_TYPE table';

COMMENT ON COLUMN ADR.VCADMIN.ERROR_TXT IS 'Error message';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VCADMIN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VCADMIN_PK ON ADR.VCADMIN
(VCADMIN_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VCADMIN_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.VCADMIN for each row
declare
     mDML char(1);
begin

  if DELETING then

  INSERT INTO ADR.VCADMIN_H (
   VCADMIN_H_ID, VCADMIN_ID, PERSON_ID,
   ERROR_TXT, VCADMISTATUS_TYPE_ID, TRANSACTION_TYPE_CODE,
   RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT)
VALUES ( VCADMIN_H_S.nextval,
 :old.VCADMIN_ID,
 :old.PERSON_ID ,
 :old.ERROR_TXT ,
 :old.VCADMISTATUS_TYPE_ID ,
 'D' ,
 :old.RECORD_CREATED_BY ,
 :old.RECORD_CREATED_DATE ,
 :old.RECORD_MODIFIED_BY ,
 :old.RECORD_MODIFIED_DATE ,
 :old.RECORD_MODIFIED_COUNT );

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;
       INSERT INTO ADR.VCADMIN_H (
   VCADMIN_H_ID, VCADMIN_ID, PERSON_ID,
   ERROR_TXT, VCADMISTATUS_TYPE_ID, TRANSACTION_TYPE_CODE,
   RECORD_CREATED_BY, RECORD_CREATED_DATE, RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE, RECORD_MODIFIED_COUNT)
VALUES ( VCADMIN_H_S.nextval,
 :new.VCADMIN_ID,
 :new.PERSON_ID ,
 :new.ERROR_TXT ,
 :old.VCADMISTATUS_TYPE_ID ,
 mDML ,
 :new.RECORD_CREATED_BY ,
 :new.RECORD_CREATED_DATE ,
 :new.RECORD_MODIFIED_BY ,
 :new.RECORD_MODIFIED_DATE ,
 :new.RECORD_MODIFIED_COUNT );

  end if;

end VCADMIN_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM VCADMIN FOR ADR.VCADMIN;


ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PK
  PRIMARY KEY
  (VCADMIN_ID)
  USING INDEX ADR.VCADMIN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VCADMIN ADD (
  CONSTRAINT VCADMIN_PRSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT VCADMIN_VCEADMINSTATS_FK 
  FOREIGN KEY (VCADMISTATUS_TYPE_ID) 
  REFERENCES ADR.VCADMISTATUS_TYPE (VCADMISTATUS_TYPE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VCADMIN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VCADMIN TO ADR_RW;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VA_PERSON_DIVISION_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VA_PERSON_DIVISION_DETAIL_H
(
  VA_PERSON_DIVISION_DETAIL_H_ID  NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  VA_PERSON_DIVISION_DETAIL_ID    NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  DEFAULT_DIVISION_FLAG           NUMBER(1)     DEFAULT 0                     NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_MODIFIED_SITE_ID         NUMBER(20),
  RECORD_MODIFIED_SRC_NAME        VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VA_PERSON_DIVISION_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.VA_PERSON_DIVISION_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.VA_PERSON_DIVISION_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.VAPERDVSNH_PK ON ADR.VA_PERSON_DIVISION_DETAIL_H
(VA_PERSON_DIVISION_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPERDVSNH_PRSNID_NU_I ON ADR.VA_PERSON_DIVISION_DETAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VA_PERSON_DIVISION_DETAIL_H FOR ADR.VA_PERSON_DIVISION_DETAIL_H;


ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_032
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT VAPERDVSNH_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_H_ID)
  USING INDEX ADR.VAPERDVSNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL_H TO PSIM_ADR_R;
ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VA_PERSON_DIVISION_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.VA_PERSON_DIVISION_DETAIL
(
  VA_PERSON_DIVISION_DETAIL_ID  NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_INSTITUTION_ID            NUMBER(20),
  DEFAULT_DIVISION_FLAG         NUMBER(1)       DEFAULT 0                     NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  RECORD_MODIFIED_SITE_ID       NUMBER(20),
  RECORD_MODIFIED_SRC_NAME      VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VA_PERSON_DIVISION_DETAIL IS 'The table stores data for persons designated as VA Associates and with what division they are associated.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.VA_PERSON_DIVISION_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.DEFAULT_DIVISION_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.VA_PERSON_DIVISION_DETAIL.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.VAPERDVSN_PK ON ADR.VA_PERSON_DIVISION_DETAIL
(VA_PERSON_DIVISION_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPERDVSN_PRSN_FK_I ON ADR.VA_PERSON_DIVISION_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPERDVSN_STDINST2_FK_I ON ADR.VA_PERSON_DIVISION_DETAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPERDVSN_STDINST_FK_I ON ADR.VA_PERSON_DIVISION_DETAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VA_PERSON_DIV_DET_audir_trgr
after Update or Delete or Insert
ON ADR.VA_PERSON_DIVISION_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into VA_PERSON_DIVISION_DETAIL_H
		(
		VA_PERSON_DIVISION_DETAIL_H_ID,
		VA_PERSON_DIVISION_DETAIL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		DEFAULT_DIVISION_FLAG,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_DIVISION_DETAIL_H_S.nextval,
		:old.VA_PERSON_DIVISION_DETAIL_ID,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.DEFAULT_DIVISION_FLAG,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into VA_PERSON_DIVISION_DETAIL_H
		(
		VA_PERSON_DIVISION_DETAIL_H_ID,
		VA_PERSON_DIVISION_DETAIL_ID,
		PERSON_ID,
		STD_INSTITUTION_ID,
		DEFAULT_DIVISION_FLAG,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_DIVISION_DETAIL_H_S.nextval,
		:new.VA_PERSON_DIVISION_DETAIL_ID,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.DEFAULT_DIVISION_FLAG,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;

end VA_PERSON_DIV_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM VA_PERSON_DIVISION_DETAIL FOR ADR.VA_PERSON_DIVISION_DETAIL;


ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT AVCON_1172521913_DEFAU_000
  CHECK (DEFAULT_DIVISION_FLAG BETWEEN 0
AND 0 OR DEFAULT_DIVISION_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT VAPERDVSN_PK
  PRIMARY KEY
  (VA_PERSON_DIVISION_DETAIL_ID)
  USING INDEX ADR.VAPERDVSN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VA_PERSON_DIVISION_DETAIL ADD (
  CONSTRAINT VAPERDVSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VA_PERSON_DIVISION_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_DIVISION_DETAIL TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.VA_PERSON_DIVISION_DETAIL TO PSIM_ADR_RW;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VA_PERSON_CLASS_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.VA_PERSON_CLASS_DETAIL_H
(
  VA_PERSON_CLASS_DETAIL_H_ID  NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  STD_PERSONCLASS_ID           NUMBER(20),
  VA_PERSON_CLASS_DETAIL_ID    NUMBER(20)       NOT NULL,
  STD_INSTITUTION_ID           NUMBER(20),
  PERSON_CLASS_START_DATE      DATE,
  PERSON_CLASS_END_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VA_PERSON_CLASS_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.VA_PERSON_CLASS_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.STD_PERSONCLASS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.VA_PERSON_CLASS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.PERSON_CLASS_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.PERSON_CLASS_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.VAPRSNCLAH_PK ON ADR.VA_PERSON_CLASS_DETAIL_H
(VA_PERSON_CLASS_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAH_PRSNID_NU_I ON ADR.VA_PERSON_CLASS_DETAIL_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM VA_PERSON_CLASS_DETAIL_H FOR ADR.VA_PERSON_CLASS_DETAIL_H;


ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_065
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT VAPRSNCLAH_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_H_ID)
  USING INDEX ADR.VAPRSNCLAH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO PSIM_ADR_R;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL_H TO VHAISPSTALLP;
ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.VA_PERSON_CLASS_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.VA_PERSON_CLASS_DETAIL
(
  VA_PERSON_CLASS_DETAIL_ID  NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_PERSONCLASS_ID         NUMBER(20),
  STD_INSTITUTION_ID         NUMBER(20),
  PERSON_CLASS_START_DATE    DATE,
  PERSON_CLASS_END_DATE      DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.VA_PERSON_CLASS_DETAIL IS 'The table stores data for persons designated as practitioners for the VHA. The Person Class designation shows what type of function(s) practitioners are authorized to perform (for example, audiologist, social worker, and chiropractor). DEMOGRAPHICS';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.VA_PERSON_CLASS_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.STD_PERSONCLASS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.PERSON_CLASS_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.PERSON_CLASS_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.VA_PERSON_CLASS_DETAIL.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.VAPRSNCLAS_PK ON ADR.VA_PERSON_CLASS_DETAIL
(VA_PERSON_CLASS_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_PRSN_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_STDINST2_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_STDINST_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.VAPRSNCLAS_STDPRCLASS_FK_I ON ADR.VA_PERSON_CLASS_DETAIL
(STD_PERSONCLASS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.VA_PERSON_CLASS_DET_audir_trgr
after Update or Delete or Insert
ON ADR.VA_PERSON_CLASS_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into VA_PERSON_CLASS_DETAIL_H
		(
		VA_PERSON_CLASS_DETAIL_H_ID,
		VA_PERSON_CLASS_DETAIL_ID,
		PERSON_CLASS_START_DATE,
		PERSON_CLASS_END_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_PERSONCLASS_ID,
		STD_INSTITUTION_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_CLASS_DETAIL_H_S.nextval,
		:old.VA_PERSON_CLASS_DETAIL_ID,
		:old.PERSON_CLASS_START_DATE,
		:old.PERSON_CLASS_END_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_PERSONCLASS_ID,
		:old.STD_INSTITUTION_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into VA_PERSON_CLASS_DETAIL_H
		(
		VA_PERSON_CLASS_DETAIL_H_ID,
		VA_PERSON_CLASS_DETAIL_ID,
		PERSON_CLASS_START_DATE,
		PERSON_CLASS_END_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_PERSONCLASS_ID,
		STD_INSTITUTION_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		VA_PERSON_CLASS_DETAIL_H_S.nextval,
		:new.VA_PERSON_CLASS_DETAIL_ID,
		:new.PERSON_CLASS_START_DATE,
		:new.PERSON_CLASS_END_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_PERSONCLASS_ID,
		:new.STD_INSTITUTION_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		mDML
		);
	end if;

end VA_PERSON_CLASS_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM VA_PERSON_CLASS_DETAIL FOR ADR.VA_PERSON_CLASS_DETAIL;


ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PK
  PRIMARY KEY
  (VA_PERSON_CLASS_DETAIL_ID)
  USING INDEX ADR.VAPRSNCLAS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.VA_PERSON_CLASS_DETAIL ADD (
  CONSTRAINT VAPRSNCLAS_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.VA_PERSON_CLASS_DETAIL TO ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.VA_PERSON_CLASS_DETAIL TO PSIM_ADR_RW;

GRANT SELECT ON ADR.VA_PERSON_CLASS_DETAIL TO VHAISPSTALLP;
ALTER TABLE ADR.USER_ROLES_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_ROLES_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_ROLES_H
(
  USER_ROLES_H_ID        NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  USER_ROLE_ID           NUMBER(20)             NOT NULL,
  USERID                 NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_ROLES_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_ROLES_H.USER_ROLES_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_ROLES_H.USER_ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_ROLES_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_ROLES_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_ROLES_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERROLEH_PK ON ADR.USER_ROLES_H
(USER_ROLES_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_ROLES_H FOR ADR.USER_ROLES_H;


ALTER TABLE ADR.USER_ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_024
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USERROLEH_PK
  PRIMARY KEY
  (USER_ROLES_H_ID)
  USING INDEX ADR.USERROLEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_ROLES_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES_H TO ADR_RW;

GRANT SELECT ON ADR.USER_ROLES_H TO CARUSR_R;

GRANT SELECT ON ADR.USER_ROLES_H TO IAM_R;

GRANT INSERT, SELECT ON ADR.USER_ROLES_H TO IAM_RW;
ALTER TABLE ADR.USER_ROLES
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_ROLES CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_ROLES
(
  USER_ROLE_ID           NUMBER(20)             NOT NULL,
  USERID                 NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_ROLES IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.USER_ROLES.USER_ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_ROLES.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_ROLES.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_ROLES.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_ROLES.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_ROLES.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_ROLES.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_ROLES.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERROLE_PK ON ADR.USER_ROLES
(USER_ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERROLE_ROLE_FK_I ON ADR.USER_ROLES
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERROLE_USER_1_FK_I ON ADR.USER_ROLES
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USER_ROLES_audir_trgr
after Update or Delete or Insert
ON ADR.USER_ROLES
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_ROLES_H
		(
		USER_ROLES_H_ID,
		USER_ROLE_ID,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		USERID,
		ROLE_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_ROLES_H_S.nextval,
		:old.USER_ROLE_ID,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.USERID,
		:old.ROLE_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_ROLES_H
		(
		USER_ROLES_H_ID,
		USER_ROLE_ID,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		USERID,
		ROLE_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_ROLES_H_S.nextval,
		:new.USER_ROLE_ID,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.USERID,
		:new.ROLE_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_ROLES_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USER_ROLES FOR ADR.USER_ROLES;


ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_116
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT USERROLE_PK
  PRIMARY KEY
  (USER_ROLE_ID)
  USING INDEX ADR.USERROLE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.USER_ROLES ADD (
  CONSTRAINT USERROLE_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT USERROLE_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_ROLES TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES TO ADR_RW;

GRANT SELECT ON ADR.USER_ROLES TO CARUSR_R;

GRANT SELECT ON ADR.USER_ROLES TO IAM_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_ROLES TO IAM_RW;
ALTER TABLE ADR.USER_PERMISSION_SETS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSION_SETS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSION_SETS_H
(
  USER_PERMISSION_SET_H_ID  NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  USER_PERMISSION_SET_ID    NUMBER(20)          NOT NULL,
  USERID                    NUMBER(20)          NOT NULL,
  PERMISSION_SET_ID         NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSION_SETS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.USER_PERMISSION_SET_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.USER_PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USRPERMSTH_PK ON ADR.USER_PERMISSION_SETS_H
(USER_PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSION_SETS_H FOR ADR.USER_PERMISSION_SETS_H;


ALTER TABLE ADR.USER_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_037
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USRPERMSTH_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_H_ID)
  USING INDEX ADR.USRPERMSTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSION_SETS_H TO ADR_R;

GRANT SELECT ON ADR.USER_PERMISSION_SETS_H TO ADR_RW;
ALTER TABLE ADR.USER_PERMISSION_SETS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSION_SETS CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSION_SETS
(
  USER_PERMISSION_SET_ID  NUMBER(20)            NOT NULL,
  PERMISSION_SET_ID       NUMBER(20)            NOT NULL,
  USERID                  NUMBER(20)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSION_SETS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.USER_PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSION_SETS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.USERPERMST_PERMSET_FK_I ON ADR.USER_PERMISSION_SETS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.USERPERMST_PK ON ADR.USER_PERMISSION_SETS
(USER_PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERPERMST_USER_1_FK_I ON ADR.USER_PERMISSION_SETS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USER_PERM_SET_audir_trgr
after Update or Delete or Insert
ON ADR.USER_PERMISSION_SETS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_PERMISSION_SETS_H
		(
		USER_PERMISSION_SET_H_ID,
		USER_PERMISSION_SET_ID,
		USERID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSION_SETS_H_S.nextval,
		:old.USER_PERMISSION_SET_ID,
		:old.USERID,
		:old.PERMISSION_SET_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_PERMISSION_SETS_H
		(
		USER_PERMISSION_SET_H_ID,
		USER_PERMISSION_SET_ID,
		USERID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSION_SETS_H_S.nextval,
		:new.USER_PERMISSION_SET_ID,
		:new.USERID,
		:new.PERMISSION_SET_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_PERM_SET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSION_SETS FOR ADR.USER_PERMISSION_SETS;


ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PK
  PRIMARY KEY
  (USER_PERMISSION_SET_ID)
  USING INDEX ADR.USERPERMST_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.USER_PERMISSION_SETS ADD (
  CONSTRAINT USERPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT USERPERMST_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSION_SETS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_PERMISSION_SETS TO ADR_RW;
ALTER TABLE ADR.USER_PERMISSIONS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSIONS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSIONS_H
(
  USER_PERMISSIONS_H_ID  NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  USER_PERMISSION_ID     NUMBER(20)             NOT NULL,
  USERID                 NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSIONS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.USER_PERMISSIONS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.USER_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USRPERMH_PK ON ADR.USER_PERMISSIONS_H
(USER_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSIONS_H FOR ADR.USER_PERMISSIONS_H;


ALTER TABLE ADR.USER_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_044
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USRPERMH_PK
  PRIMARY KEY
  (USER_PERMISSIONS_H_ID)
  USING INDEX ADR.USRPERMH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSIONS_H TO ADR_R;

GRANT SELECT ON ADR.USER_PERMISSIONS_H TO ADR_RW;

GRANT SELECT ON ADR.USER_PERMISSIONS_H TO CARUSR_R;
ALTER TABLE ADR.USER_PERMISSIONS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_PERMISSIONS CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_PERMISSIONS
(
  USER_PERMISSION_ID     NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  USERID                 NUMBER(20)             NOT NULL,
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_PERMISSIONS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.USER_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_PERMISSIONS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERPERM_PK ON ADR.USER_PERMISSIONS
(USER_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERPERM_STD_PERM_FK_I ON ADR.USER_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERPERM_USER_1_FK_I ON ADR.USER_PERMISSIONS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USER_PERMISSIONS_audir_trgr
after Update or Delete or Insert
ON ADR.USER_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_PERMISSIONS_H
		(
		USER_PERMISSIONS_H_ID,
		USER_PERMISSION_ID,
		USERID,
		PERMISSION_TYPE_ID,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSIONS_H_S.nextval,
		:old.USER_PERMISSION_ID,
		:old.USERID,
		:old.PERMISSION_TYPE_ID,
		:old.ACTIVE_DATE,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_PERMISSIONS_H
		(
		USER_PERMISSIONS_H_ID,
		USER_PERMISSION_ID,
		USERID,
		PERMISSION_TYPE_ID,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_PERMISSIONS_H_S.nextval,
		:new.USER_PERMISSION_ID,
		:new.USERID,
		:new.PERMISSION_TYPE_ID,
		:new.ACTIVE_DATE,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_PERMISSIONS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USER_PERMISSIONS FOR ADR.USER_PERMISSIONS;


ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_PK
  PRIMARY KEY
  (USER_PERMISSION_ID)
  USING INDEX ADR.USERPERM_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.USER_PERMISSIONS ADD (
  CONSTRAINT USERPERM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT USERPERM_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_PERMISSIONS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_PERMISSIONS TO ADR_RW;

GRANT SELECT ON ADR.USER_PERMISSIONS TO CARUSR_R;
ALTER TABLE ADR.USER_LOGIN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_LOGIN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_LOGIN_H
(
  USER_LOGIN_H_ID          NUMBER(20)           NOT NULL,
  TRANSACTION_TYPE_CODE    VARCHAR2(1 BYTE)     NOT NULL,
  ID                       NUMBER(20)           NOT NULL,
  USERID                   NUMBER(20)           NOT NULL,
  LAST_LOGIN_SUCCESS_DATE  DATE,
  LAST_LOGIN_FAILURE_DATE  DATE,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_LOGIN_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.USER_LOGIN_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.LAST_LOGIN_SUCCESS_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.USER_LOGIN_H.LAST_LOGIN_FAILURE_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_LOGIN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERLOGINH_PK ON ADR.USER_LOGIN_H
(USER_LOGIN_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USER_LOGIN_H FOR ADR.USER_LOGIN_H;


ALTER TABLE ADR.USER_LOGIN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_015
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USERLOGINH_PK
  PRIMARY KEY
  (USER_LOGIN_H_ID)
  USING INDEX ADR.USERLOGINH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_LOGIN_H TO ADR_R;

GRANT SELECT ON ADR.USER_LOGIN_H TO ADR_RW;

GRANT SELECT ON ADR.USER_LOGIN_H TO CARUSR_R;
ALTER TABLE ADR.USER_LOGIN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USER_LOGIN CASCADE CONSTRAINTS;

CREATE TABLE ADR.USER_LOGIN
(
  ID                       NUMBER(20)           NOT NULL,
  USERID                   NUMBER(20)           NOT NULL,
  LAST_LOGIN_SUCCESS_DATE  DATE,
  LAST_LOGIN_FAILURE_DATE  DATE,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USER_LOGIN IS 'The table is an application administration table that stores login history for database users.';

COMMENT ON COLUMN ADR.USER_LOGIN.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.USER_LOGIN.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN.LAST_LOGIN_SUCCESS_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN.LAST_LOGIN_FAILURE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USER_LOGIN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USER_LOGIN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USER_LOGIN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USER_LOGIN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USER_LOGIN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERLOGIN_PK ON ADR.USER_LOGIN
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USERLOGIN_USER_1_FK_I ON ADR.USER_LOGIN
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USER_LOGIN_audir_trgr
after Update or Delete or Insert
ON ADR.USER_LOGIN
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USER_LOGIN_H
		(
		USER_LOGIN_H_ID,
		ID,
		USERID,
		LAST_LOGIN_SUCCESS_DATE,
		LAST_LOGIN_FAILURE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_LOGIN_H_S.nextval,
		:old.ID,
		:old.USERID,
		:old.LAST_LOGIN_SUCCESS_DATE,
		:old.LAST_LOGIN_FAILURE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USER_LOGIN_H
		(
		USER_LOGIN_H_ID,
		ID,
		USERID,
		LAST_LOGIN_SUCCESS_DATE,
		LAST_LOGIN_FAILURE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USER_LOGIN_H_S.nextval,
		:new.ID,
		:new.USERID,
		:new.LAST_LOGIN_SUCCESS_DATE,
		:new.LAST_LOGIN_FAILURE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USER_LOGIN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USER_LOGIN FOR ADR.USER_LOGIN;


ALTER TABLE ADR.USER_LOGIN ADD (
  CONSTRAINT USERLOGIN_PK
  PRIMARY KEY
  (ID)
  USING INDEX ADR.USERLOGIN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.USER_LOGIN ADD (
  CONSTRAINT USERLOGIN_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USER_LOGIN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USER_LOGIN TO ADR_RW;

GRANT SELECT ON ADR.USER_LOGIN TO CARUSR_R;
ALTER TABLE ADR.USERS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USERS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.USERS_H
(
  USERS_H_ID                NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  USERID                    NUMBER(20)          NOT NULL,
  USER_GROUP_TYPE_ID        NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  USERNAME                  VARCHAR2(30 BYTE)   NOT NULL,
  FULL_NAME                 VARCHAR2(100 BYTE),
  PASSWORD                  VARCHAR2(128 BYTE),
  PASSWORD_CREATE_DATE      DATE,
  PASSWORD_CHANGE_DATE      DATE,
  PASSWORD_EXPIRE_DATE      DATE,
  ACCOUNT_EXPIRE_DATE       DATE,
  ACCOUNT_LOCK_DATE         DATE,
  INITIAL_LOGIN_DATE        DATE,
  NUMBER_OF_LOGIN_ATTEMPTS  NUMBER(3),
  FIRST_NAME                VARCHAR2(30 BYTE),
  MIDDLE_NAME               VARCHAR2(30 BYTE),
  LAST_NAME                 VARCHAR2(40 BYTE),
  MAIDEN_NAME               VARCHAR2(40 BYTE),
  EMPLOYEE_NUMBER           VARCHAR2(50 BYTE),
  JOB_TITLE                 VARCHAR2(80 BYTE),
  EMAIL_ADDRESS             VARCHAR2(128 BYTE),
  TELEPHONE_NUMBER          VARCHAR2(30 BYTE),
  FAX_NUMBER                VARCHAR2(30 BYTE),
  AGREEMENT_SIGNATURE_CODE  VARCHAR2(6 BYTE),
  SIGNATURE_VERIFIED_IND    VARCHAR2(1 BYTE),
  INACTIVE_FLAG             NUMBER(1)           DEFAULT 0                     NOT NULL,
  INACTIVE_DATE             DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USERS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.USERS_H.USERS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.USERS_H.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.USER_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.USERS_H.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.ACCOUNT_EXPIRE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.ACCOUNT_LOCK_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.NUMBER_OF_LOGIN_ATTEMPTS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.USERS_H.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.USERS_H.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.USERS_H.EMAIL_ADDRESS IS 'Theemailaddressforthe personorinsurance company.';

COMMENT ON COLUMN ADR.USERS_H.TELEPHONE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USERS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USERS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USERS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USERS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.USERH_PK ON ADR.USERS_H
(USERS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM USERS_H FOR ADR.USERS_H;


ALTER TABLE ADR.USERS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_028
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT USERH_PK
  PRIMARY KEY
  (USERS_H_ID)
  USING INDEX ADR.USERH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USERS_H TO ADR_R;

GRANT SELECT ON ADR.USERS_H TO ADR_RW;

GRANT SELECT ON ADR.USERS_H TO CARUSR_R;

GRANT SELECT ON ADR.USERS_H TO IAM_R;

GRANT INSERT, SELECT ON ADR.USERS_H TO IAM_RW;
ALTER TABLE ADR.USERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.USERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.USERS
(
  USERID                    NUMBER(20)          NOT NULL,
  USER_GROUP_TYPE_ID        NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  USERNAME                  VARCHAR2(30 BYTE)   NOT NULL,
  FULL_NAME                 VARCHAR2(100 BYTE),
  PASSWORD                  VARCHAR2(128 BYTE),
  PASSWORD_CREATE_DATE      DATE,
  PASSWORD_CHANGE_DATE      DATE                NOT NULL,
  PASSWORD_EXPIRE_DATE      DATE,
  ACCOUNT_EXPIRE_DATE       DATE,
  ACCOUNT_LOCK_DATE         DATE,
  INITIAL_LOGIN_DATE        DATE,
  NUMBER_OF_LOGIN_ATTEMPTS  NUMBER(3),
  FIRST_NAME                VARCHAR2(30 BYTE),
  MIDDLE_NAME               VARCHAR2(30 BYTE),
  LAST_NAME                 VARCHAR2(40 BYTE),
  MAIDEN_NAME               VARCHAR2(40 BYTE),
  EMPLOYEE_NUMBER           VARCHAR2(50 BYTE),
  JOB_TITLE                 VARCHAR2(80 BYTE),
  EMAIL_ADDRESS             VARCHAR2(128 BYTE),
  TELEPHONE_NUMBER          VARCHAR2(30 BYTE),
  AGREEMENT_SIGNATURE_CODE  VARCHAR2(6 BYTE),
  SIGNATURE_VERIFIED_IND    VARCHAR2(1 BYTE),
  FAX_NUMBER                VARCHAR2(30 BYTE),
  INACTIVE_FLAG             NUMBER(1)           DEFAULT 0                     NOT NULL,
  INACTIVE_DATE             DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.USERS IS 'The table is an application administration table used to designate the authorized users of the database.';

COMMENT ON COLUMN ADR.USERS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.USER_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.USERS.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.FULL_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.PASSWORD IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.PASSWORD_CHANGE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.PASSWORD_EXPIRE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.ACCOUNT_EXPIRE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.ACCOUNT_LOCK_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.FIRST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.MIDDLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.LAST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.MAIDEN_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.EMPLOYEE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.EMAIL_ADDRESS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.TELEPHONE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.FAX_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.USERS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.USERS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.USERS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.USERS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.USERS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.USER_1_STDINST_FK_I ON ADR.USERS
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.USER_1_UK2_UK ON ADR.USERS
(USERNAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.USER_1_USRGRPTYP_FK_I ON ADR.USERS
(USER_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.USER_PK ON ADR.USERS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.USERS_audir_trgr
after Update or Delete or Insert
ON ADR.USERS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into USERS_H
		(
		USERS_H_ID,
		USERID,
		STD_INSTITUTION_ID,
		USERNAME,
		FULL_NAME,
		PASSWORD,
		PASSWORD_CREATE_DATE,
		PASSWORD_CHANGE_DATE,
		PASSWORD_EXPIRE_DATE,
		USER_GROUP_TYPE_ID,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		EMPLOYEE_NUMBER,
		EMAIL_ADDRESS,
		TELEPHONE_NUMBER,
		FAX_NUMBER,
		JOB_TITLE,
		AGREEMENT_SIGNATURE_CODE,
		SIGNATURE_VERIFIED_IND,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		ACCOUNT_EXPIRE_DATE,
		ACCOUNT_LOCK_DATE,
		NUMBER_OF_LOGIN_ATTEMPTS,
		INITIAL_LOGIN_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USERS_H_S.nextval,
		:old.USERID,
		:old.STD_INSTITUTION_ID,
		:old.USERNAME,
		:old.FULL_NAME,
		:old.PASSWORD,
		:old.PASSWORD_CREATE_DATE,
		:old.PASSWORD_CHANGE_DATE,
		:old.PASSWORD_EXPIRE_DATE,
		:old.USER_GROUP_TYPE_ID,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.MAIDEN_NAME,
		:old.EMPLOYEE_NUMBER,
		:old.EMAIL_ADDRESS,
		:old.TELEPHONE_NUMBER,
		:old.FAX_NUMBER,
		:old.JOB_TITLE,
		:old.AGREEMENT_SIGNATURE_CODE,
		:old.SIGNATURE_VERIFIED_IND,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.ACCOUNT_EXPIRE_DATE,
		:old.ACCOUNT_LOCK_DATE,
		:old.NUMBER_OF_LOGIN_ATTEMPTS,
		:old.INITIAL_LOGIN_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into USERS_H
		(
		USERS_H_ID,
		USERID,
		STD_INSTITUTION_ID,
		USERNAME,
		FULL_NAME,
		PASSWORD,
		PASSWORD_CREATE_DATE,
		PASSWORD_CHANGE_DATE,
		PASSWORD_EXPIRE_DATE,
		USER_GROUP_TYPE_ID,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		EMPLOYEE_NUMBER,
		EMAIL_ADDRESS,
		TELEPHONE_NUMBER,
		FAX_NUMBER,
		JOB_TITLE,
		AGREEMENT_SIGNATURE_CODE,
		SIGNATURE_VERIFIED_IND,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		ACCOUNT_EXPIRE_DATE,
		ACCOUNT_LOCK_DATE,
		NUMBER_OF_LOGIN_ATTEMPTS,
		INITIAL_LOGIN_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		USERS_H_S.nextval,
		:new.USERID,
		:new.STD_INSTITUTION_ID,
		:new.USERNAME,
		:new.FULL_NAME,
		:new.PASSWORD,
		:new.PASSWORD_CREATE_DATE,
		:new.PASSWORD_CHANGE_DATE,
		:new.PASSWORD_EXPIRE_DATE,
		:new.USER_GROUP_TYPE_ID,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.MAIDEN_NAME,
		:new.EMPLOYEE_NUMBER,
		:new.EMAIL_ADDRESS,
		:new.TELEPHONE_NUMBER,
		:new.FAX_NUMBER,
		:new.JOB_TITLE,
		:new.AGREEMENT_SIGNATURE_CODE,
		:new.SIGNATURE_VERIFIED_IND,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.ACCOUNT_EXPIRE_DATE,
		:new.ACCOUNT_LOCK_DATE,
		:new.NUMBER_OF_LOGIN_ATTEMPTS,
		:new.INITIAL_LOGIN_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end USERS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM USERS FOR ADR.USERS;


ALTER TABLE ADR.USERS ADD (
  CONSTRAINT AVCON_1172521913_INACT_042
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT USER_PK
  PRIMARY KEY
  (USERID)
  USING INDEX ADR.USER_PK
  ENABLE VALIDATE,
  CONSTRAINT USER_1_UK2_UK
  UNIQUE (USERNAME)
  USING INDEX ADR.USER_1_UK2_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.USERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.USERS TO ADR_RW;

GRANT SELECT ON ADR.USERS TO CARUSR_R;

GRANT SELECT ON ADR.USERS TO IAM_R;

GRANT INSERT, SELECT, UPDATE ON ADR.USERS TO IAM_RW;
ALTER TABLE ADR.TRANSMISSION_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.TRANSMISSION_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.TRANSMISSION_TYPE
(
  TRANSMISSION_TYPE_ID   NUMBER(20)             NOT NULL,
  CODE                   VARCHAR2(2 BYTE)       NOT NULL,
  NAME                   VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(100 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(18)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.TRANSMISSION_TYPE.TRANSMISSION_TYPE_ID IS 'The primary key, generated by the database system in numeric form. Used to uniquely identify a data record in this table.';

COMMENT ON COLUMN ADR.TRANSMISSION_TYPE.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.TRANSMISSION_TYPE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.TRANSMISSION_TYPE.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.TRANSMISSION_TYPE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.TRANSMISSION_TYPE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.CODE_UK ON ADR.TRANSMISSION_TYPE
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.NAME_UK ON ADR.TRANSMISSION_TYPE
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.TRNTYP_PK ON ADR.TRANSMISSION_TYPE
(TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM TRANSMISSION_TYPE FOR ADR.TRANSMISSION_TYPE;


ALTER TABLE ADR.TRANSMISSION_TYPE ADD (
  CONSTRAINT TRNTYP_PK
  PRIMARY KEY
  (TRANSMISSION_TYPE_ID)
  USING INDEX ADR.TRNTYP_PK
  ENABLE VALIDATE,
  CONSTRAINT CODE_UK
  UNIQUE (CODE)
  USING INDEX ADR.CODE_UK
  ENABLE VALIDATE,
  CONSTRAINT NAME_UK
  UNIQUE (NAME)
  USING INDEX ADR.NAME_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.TRANSMISSION_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.TRANSMISSION_TYPE TO ADR_RW;
ALTER TABLE ADR.TRANSMISSION_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.TRANSMISSION_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.TRANSMISSION_STATUS
(
  TRANSMISSION_STATUS_ID  NUMBER(20)            NOT NULL,
  CODE                    VARCHAR2(10 BYTE)     NOT NULL,
  NAME                    VARCHAR2(30 BYTE)     NOT NULL,
  DESCRIPTION             VARCHAR2(250 BYTE)    NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.TRANSMISSION_STATUS IS 'This table contains reference lookup values to track the state of IRS submissions';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.TRANSMISSION_STATUS_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.CODE IS 'Lookup code short name value';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.NAME IS 'Lookup code long name value';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.DESCRIPTION IS 'Lookup code description';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.TRANSMISSION_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE UNIQUE INDEX ADR.TRANSMISSION_STATUS_ID_PK ON ADR.TRANSMISSION_STATUS
(TRANSMISSION_STATUS_ID)
LOGGING
TABLESPACE M_DATA_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.TRNS_STAT_CODE_NU_I ON ADR.TRANSMISSION_STATUS
(CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.TRNS_STAT_NAME_NU_I ON ADR.TRANSMISSION_STATUS
(NAME)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM TRANSMISSION_STATUS FOR ADR.TRANSMISSION_STATUS;


ALTER TABLE ADR.TRANSMISSION_STATUS ADD (
  CONSTRAINT TRANSMISSION_STATUS_ID_PK
  PRIMARY KEY
  (TRANSMISSION_STATUS_ID)
  USING INDEX ADR.TRANSMISSION_STATUS_ID_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.TRANSMISSION_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.TRANSMISSION_STATUS TO ADR_RW;
DROP TABLE ADR.STG_MEC_PERIOD_PERSON_ID CASCADE CONSTRAINTS;

CREATE GLOBAL TEMPORARY TABLE ADR.STG_MEC_PERIOD_PERSON_ID
(
  PERSON_ID  NUMBER(20)
)
ON COMMIT PRESERVE ROWS
RESULT_CACHE (MODE DEFAULT)
NOCACHE;


CREATE OR REPLACE PUBLIC SYNONYM STG_MEC_PERIOD_PERSON_ID FOR ADR.STG_MEC_PERIOD_PERSON_ID;
DROP TABLE ADR.STG_MEC_PERIOD_ENRMNT_DTRM_H CASCADE CONSTRAINTS;

CREATE GLOBAL TEMPORARY TABLE ADR.STG_MEC_PERIOD_ENRMNT_DTRM_H
(
  ENROLLMENT_DETERMINATION_H_ID  NUMBER,
  PERSON_ID                      NUMBER(20),
  DERVD_MEC_START_DATE           DATE,
  DERVD_MEC_END_DATE             DATE,
  CURRENT_RANK                   NUMBER
)
ON COMMIT DELETE ROWS
RESULT_CACHE (MODE DEFAULT)
NOCACHE;


CREATE OR REPLACE PUBLIC SYNONYM STG_MEC_PERIOD_ENRMNT_DTRM_H FOR ADR.STG_MEC_PERIOD_ENRMNT_DTRM_H;
DROP TABLE ADR.STG_MEC_PERIOD CASCADE CONSTRAINTS;

CREATE GLOBAL TEMPORARY TABLE ADR.STG_MEC_PERIOD
(
  MEC_PERIOD_ID         NUMBER,
  PERSON_ID             NUMBER(20),
  DERVD_MEC_START_DATE  DATE,
  DERVD_MEC_END_DATE    DATE
)
ON COMMIT PRESERVE ROWS
RESULT_CACHE (MODE DEFAULT)
NOCACHE;


CREATE OR REPLACE PUBLIC SYNONYM STG_MEC_PERIOD FOR ADR.STG_MEC_PERIOD;
DROP TABLE ADR.SSN_VERIFICATION_EXT CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN_VERIFICATION_EXT
(
  SSN              VARCHAR2(9 BYTE),
  ENTRY_CODE       VARCHAR2(3 BYTE),
  PROCESSING_CODE  VARCHAR2(3 BYTE),
  LAST_NAME        VARCHAR2(13 BYTE),
  FIRST_NAME       VARCHAR2(10 BYTE),
  MIDDLE_NAME      VARCHAR2(7 BYTE),
  DOB              VARCHAR2(8 BYTE),
  SEX              VARCHAR2(1 BYTE),
  INCOME_YEAR      VARCHAR2(4 BYTE),
  HEC_VA_ID        VARCHAR2(15 BYTE),
  SPOUSE_CODE      VARCHAR2(1 BYTE),
  BLANK_1          VARCHAR2(29 BYTE),
  BLANK_2          VARCHAR2(20 BYTE),
  REQUEST_CODE     VARCHAR2(4 BYTE),
  BLANK_3          VARCHAR2(3 BYTE)
)
ORGANIZATION EXTERNAL
  (  TYPE ORACLE_LOADER
     DEFAULT DIRECTORY BATCH_SSN_ADRTOPROCESS_DIR
     ACCESS PARAMETERS 
       ( RECORDS DELIMITED BY NEWLINE 
BADFILE BATCH_SSN_ERR_DIR:'SSA.r_%a_%p.err' 
LOGFILE BATCH_SSN_LOG_DIR:'SSA.r_%a_%p.log' 
FIELDS (
SSN          POSITION(1:9) CHAR(9),
ENTRY_CODE   POSITION(10:12) CHAR(3),
PROCESSING_CODE  POSITION(13:15) CHAR(3),
LAST_NAME    POSITION(16:28) CHAR(13),
FIRST_NAME   POSITION(29:38) CHAR(10),
MIDDLE_NAME  POSITION(39:45) CHAR(7),
DOB          POSITION(46:53) CHAR(8),
SEX          POSITION(54:54) CHAR(1),
INCOME_YEAR  POSITION(55:58) CHAR(4),
HEC_VA_ID    POSITION(59:73) CHAR(15),
SPOUSE_CODE  POSITION(74:74) CHAR(1),
BLANK_1      POSITION(75:103) CHAR(29),
BLANK_2      POSITION(104:123) CHAR(20),
REQUEST_CODE POSITION(124:127) CHAR(4),
BLANK_3      POSITION(128:130) CHAR(3)
)  )
     LOCATION (BATCH_SSN_ADRTOPROCESS_DIR:'SSA.r122491.txt')
  )
REJECT LIMIT UNLIMITED
PARALLEL ( DEGREE 4 INSTANCES 1 )
NOMONITORING;


CREATE OR REPLACE PUBLIC SYNONYM SSN_VERIFICATION_EXT FOR ADR.SSN_VERIFICATION_EXT;


GRANT SELECT ON ADR.SSN_VERIFICATION_EXT TO ADR_R;
ALTER TABLE ADR.SSN_VERIFICATION_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SSN_VERIFICATION_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN_VERIFICATION_DETAIL
(
  SSN_VERIFICATION_DETAIL_ID   NUMBER(20)       NOT NULL,
  SSN_VERIFICATION_ID          NUMBER(20),
  PERSON_ID                    NUMBER(20),
  SSN_ID                       NUMBER(20),
  SSN                          VARCHAR2(20 BYTE),
  VERIFICATION_REQUEST_NUMBER  VARCHAR2(20 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.SSN_VERIFICATION_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.SSN_VERIFICATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SSNVERFYDT_PK ON ADR.SSN_VERIFICATION_DETAIL
(SSN_VERIFICATION_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSNVERFYDT_PRSN_FK_I ON ADR.SSN_VERIFICATION_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSNVERFYDT_SSNVERIFY_FK_I ON ADR.SSN_VERIFICATION_DETAIL
(SSN_VERIFICATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSNVERFYDT_SSN_FK_I ON ADR.SSN_VERIFICATION_DETAIL
(SSN_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSNVERFYDT_VERFRQNO_NU_I ON ADR.SSN_VERIFICATION_DETAIL
(VERIFICATION_REQUEST_NUMBER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SSN_VERIFICATION_DETAIL FOR ADR.SSN_VERIFICATION_DETAIL;


ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_PK
  PRIMARY KEY
  (SSN_VERIFICATION_DETAIL_ID)
  USING INDEX ADR.SSNVERFYDT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SSN_VERIFICATION_DETAIL ADD (
  CONSTRAINT SSNVERFYDT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SSNVERFYDT_SSNVERIFY_FK 
  FOREIGN KEY (SSN_VERIFICATION_ID) 
  REFERENCES ADR.SSN_VERIFICATION (SSN_VERIFICATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SSN_VERIFICATION_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN_VERIFICATION_DETAIL TO ADR_RW;
ALTER TABLE ADR.SSN_VERIFICATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SSN_VERIFICATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN_VERIFICATION
(
  SSN_VERIFICATION_ID    NUMBER(20)             NOT NULL,
  SSA_SENT_DATE          DATE,
  SSN_COUNT              NUMBER(10),
  SSN_SENT_COUNT         NUMBER(10),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.SSN_VERIFICATION.SSN_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION.SSN_SENT_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SSN_VERIFICATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SSN_VERIFICATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SSN_VERIFICATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SSNVERIFY_PK ON ADR.SSN_VERIFICATION
(SSN_VERIFICATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SSN_VERIFICATION FOR ADR.SSN_VERIFICATION;


ALTER TABLE ADR.SSN_VERIFICATION ADD (
  CONSTRAINT SSNVERIFY_PK
  PRIMARY KEY
  (SSN_VERIFICATION_ID)
  USING INDEX ADR.SSNVERIFY_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SSN_VERIFICATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN_VERIFICATION TO ADR_RW;
ALTER TABLE ADR.SSN_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SSN_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN_H
(
  SSN_H_ID                   NUMBER(20),
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE),
  SSN_ID                     NUMBER(20),
  PERSON_ID                  NUMBER(20),
  PERSON_RELATION_ID         NUMBER(20),
  STD_SSNTYPE_ID             NUMBER(20),
  PSEUDO_SSN_REASON_TYPE_ID  NUMBER(20),
  SSN_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  SSN_VRFN_STATUS_TYPE_ID    NUMBER(20),
  SSA_MESSAGE_TYPE_ID        NUMBER(20),
  SSN                        VARCHAR2(20 BYTE),
  SSA_VERIFIED_DATE          DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE        DATE,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE       DATE,
  RECORD_MODIFIED_COUNT      NUMBER(10)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SSN_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SSN_H.SSN_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SSN_H.SSN_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN_H.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_H.PSEUDO_SSN_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_H.SSN_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_H.SSN_VRFN_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_H.SSA_MESSAGE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN_H.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.SSN_H.SSA_VERIFIED_DATE IS 'BR1590SSAVerification dateisdefinedasthe datetheSSASSNtapewas read.';

COMMENT ON COLUMN ADR.SSN_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SSN_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SSN_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SSN_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SSN_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SSNH_PK ON ADR.SSN_H
(SSN_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSNH_PRSNID_NU_I ON ADR.SSN_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSNH_PRSNRELID_NU_I ON ADR.SSN_H
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SSN_H FOR ADR.SSN_H;


ALTER TABLE ADR.SSN_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_016
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066233
  CHECK ("SSN_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066234
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066235
  CHECK ("SSN_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066236
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066237
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066238
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066239
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066240
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SSNH_PK
  PRIMARY KEY
  (SSN_H_ID)
  USING INDEX ADR.SSNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SSN_H TO ADR_R;

GRANT SELECT ON ADR.SSN_H TO ADR_RW;

GRANT SELECT ON ADR.SSN_H TO PSIM_ADR_R;
ALTER TABLE ADR.SSN
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SSN CASCADE CONSTRAINTS;

CREATE TABLE ADR.SSN
(
  SSN_ID                     NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20),
  PERSON_RELATION_ID         NUMBER(20),
  STD_SSNTYPE_ID             NUMBER(20),
  PSEUDO_SSN_REASON_TYPE_ID  NUMBER(20),
  SSN_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  SSN_VRFN_STATUS_TYPE_ID    NUMBER(20),
  SSA_MESSAGE_TYPE_ID        NUMBER(20),
  SSN                        VARCHAR2(20 BYTE),
  SSA_VERIFIED_DATE          DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SSN IS 'The table supports the SSN Verification process for Spouse and Dependent records only. The un-verified SSN s are sent to the Social Security Administration via a batch process. The return batch is processed and the record status is updated according to the SSA message returned for each SSN. OWNER: This is an E&E Table ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SSN.SSN_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SSN.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.PSEUDO_SSN_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSN_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSN_VRFN_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSA_MESSAGE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SSN.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.SSN.SSA_VERIFIED_DATE IS 'BR1590SSAVerification dateisdefinedasthe datetheSSASSNtapewas read.';

COMMENT ON COLUMN ADR.SSN.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SSN.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SSN.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SSN.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SSN.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SSN_PK ON ADR.SSN
(SSN_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_PRSNREL_FK_I ON ADR.SSN
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_PRSN_FK_I ON ADR.SSN
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_SSNTYPE_FK_I ON ADR.SSN
(STD_SSNTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_PSEUDOSSNRSN_FK_I ON ADR.SSN
(PSEUDO_SSN_REASON_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_SSAVRFNCD_FK_I ON ADR.SSN
(SSA_MESSAGE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_SSNCHGSRC_FK_I ON ADR.SSN
(SSN_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SSN_STD_SSNVRFNSTAT_FK_I ON ADR.SSN
(SSN_VRFN_STATUS_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SSN_audir_trgr
after Update or Delete or Insert
ON ADR.SSN
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SSN_H
		(
		SSN_H_ID,
		SSN_ID,
		PERSON_ID,
		PERSON_RELATION_ID,
		STD_SSNTYPE_ID,
		PSEUDO_SSN_REASON_TYPE_ID,
		SSN_CHANGE_SOURCE_TYPE_ID,
		SSN_VRFN_STATUS_TYPE_ID,
		SSA_MESSAGE_TYPE_ID,
		SSN,
		SSA_VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SSN_H_S.nextval,
		:old.SSN_ID,
		:old.PERSON_ID,
		:old.PERSON_RELATION_ID,
		:old.STD_SSNTYPE_ID,
		:old.PSEUDO_SSN_REASON_TYPE_ID,
		:old.SSN_CHANGE_SOURCE_TYPE_ID,
		:old.SSN_VRFN_STATUS_TYPE_ID,
		:old.SSA_MESSAGE_TYPE_ID,
		:old.SSN,
		:old.SSA_VERIFIED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SSN_H
		(
		SSN_H_ID,
		SSN_ID,
		PERSON_ID,
		PERSON_RELATION_ID,
		STD_SSNTYPE_ID,
		PSEUDO_SSN_REASON_TYPE_ID,
		SSN_CHANGE_SOURCE_TYPE_ID,
		SSN_VRFN_STATUS_TYPE_ID,
		SSA_MESSAGE_TYPE_ID,
		SSN,
		SSA_VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SSN_H_S.nextval,
		:new.SSN_ID,
		:new.PERSON_ID,
		:new.PERSON_RELATION_ID,
		:new.STD_SSNTYPE_ID,
		:new.PSEUDO_SSN_REASON_TYPE_ID,
		:new.SSN_CHANGE_SOURCE_TYPE_ID,
		:new.SSN_VRFN_STATUS_TYPE_ID,
		:new.SSA_MESSAGE_TYPE_ID,
		:new.SSN,
		:new.SSA_VERIFIED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SSN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SSN FOR ADR.SSN;


ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PK
  PRIMARY KEY
  (SSN_ID)
  USING INDEX ADR.SSN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SSN ADD (
  CONSTRAINT SSN_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SSN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SSN TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SSN TO ADR_RW;

GRANT SELECT ON ADR.SSN TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.SSN TO PSIM_ADR_RW;
ALTER TABLE ADR.SPECIAL_FACTOR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SPECIAL_FACTOR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SPECIAL_FACTOR_H
(
  SPECIAL_FACTOR_H_ID             NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  SPECIAL_FACTOR_ID               NUMBER(20),
  PERSON_ID                       NUMBER(20),
  RADIATION_EXP_METHOD_TYPE_ID    NUMBER(20),
  AGENT_ORANGE_LOCATION_TYPE_ID   NUMBER(20),
  SPCL_FACTOR_MAPPING_TYPE_CODE   VARCHAR2(5 BYTE),
  SPECIAL_FACTOR_STDYESNO_ID      NUMBER(20),
  SPECIAL_FACTOR_REGISTER_NUMBER  NUMBER(6),
  SPECIAL_FACTOR_REG_DATE_TXT     VARCHAR2(14 BYTE),
  SPECIAL_FACTOR_EXAM_DATE_TXT    VARCHAR2(14 BYTE),
  REMARKS                         VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10),
  CL_VERIFICATION_METHOD_CODE     NUMBER(20),
  CL_CHANGE_SITE                  NUMBER(20),
  CL_COMMENT                      VARCHAR2(255 BYTE),
  CL_SOURCE_OF_CHANGE             NUMBER(20),
  HISTORY_CREATED_DATE            DATE
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SPECIAL_FACTOR_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.SPECIAL_FACTOR_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.SPECIAL_FACTOR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.RADIATION_EXP_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.AGENT_ORANGE_LOCATION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.SPCL_FACTOR_MAPPING_TYPE_CODE IS 'BR607IncomeYearis definedastheIncome Yearthatthisfinancial informationpertainsto.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.SPECIAL_FACTOR_REGISTER_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.SPECIAL_FACTOR_REG_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.SPECIAL_FACTOR_EXAM_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.CL_VERIFICATION_METHOD_CODE IS 'FK to ADRREF.STD_CLVERIFICATIONTYPE.ID';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.CL_CHANGE_SITE IS 'The site that made changes to the Camp LeJeune Indicator.  These values come from the SDSADM.STD_INSTITUTION table.  If source of change is VAMC or HEC then this field will contain the institution value.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.CL_COMMENT IS 'User entered comments';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR_H.CL_SOURCE_OF_CHANGE IS 'Contains the value from the ID column of the ADRREF.STD_CLSOURCEOFCHANGE table.  This represent the origin of the Camp LeJeune eligibility indicator';


CREATE UNIQUE INDEX ADR.SPECFACTH_PK ON ADR.SPECIAL_FACTOR_H
(SPECIAL_FACTOR_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SPECFACTH_PRSNID_NU_I ON ADR.SPECIAL_FACTOR_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SPECIAL_FACTOR_H FOR ADR.SPECIAL_FACTOR_H;


ALTER TABLE ADR.SPECIAL_FACTOR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_019
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066275
  CHECK ("SPECIAL_FACTOR_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066276
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066277
  CHECK ("SPECIAL_FACTOR_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066278
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066279
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066280
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066281
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066282
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066283
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SPECFACTH_PK
  PRIMARY KEY
  (SPECIAL_FACTOR_H_ID)
  USING INDEX ADR.SPECFACTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SPECIAL_FACTOR_H TO ADR_R;

GRANT SELECT ON ADR.SPECIAL_FACTOR_H TO ADR_RW;
ALTER TABLE ADR.SPECIAL_FACTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SPECIAL_FACTOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.SPECIAL_FACTOR
(
  SPECIAL_FACTOR_ID               NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  AGENT_ORANGE_LOCATION_TYPE_ID   NUMBER(20),
  RADIATION_EXP_METHOD_TYPE_ID    NUMBER(20),
  SPECIAL_FACTOR_STDYESNO_ID      NUMBER(20),
  SPCL_FACTOR_MAPPING_TYPE_CODE   VARCHAR2(5 BYTE),
  SPECIAL_FACTOR_REGISTER_NUMBER  NUMBER(6),
  SPECIAL_FACTOR_REG_DATE_TXT     VARCHAR2(14 BYTE),
  SPECIAL_FACTOR_EXAM_DATE_TXT    VARCHAR2(14 BYTE),
  REMARKS                         VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  CL_VERIFICATION_METHOD_CODE     NUMBER(20),
  CL_CHANGE_SITE                  NUMBER(20),
  CL_COMMENT                      VARCHAR2(255 BYTE),
  CL_SOURCE_OF_CHANGE             NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SPECIAL_FACTOR IS 'The table contains data about what the VHA considers to be special factors for eligibility: Radiation Exposure SHAD Agent Orange Exposure Environmental Contamination Exposure ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.AGENT_ORANGE_LOCATION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.RADIATION_EXP_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.SPCL_FACTOR_MAPPING_TYPE_CODE IS 'BR607IncomeYearis definedastheIncome Yearthatthisfinancial informationpertainsto.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_REGISTER_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_REG_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.SPECIAL_FACTOR_EXAM_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.CL_VERIFICATION_METHOD_CODE IS 'FK to ADRREF.STD_CLVERIFICATIONTYPE.ID';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.CL_CHANGE_SITE IS 'The site that made changes to the Camp LeJeune Indicator.  These values come from the SDSADM.STD_INSTITUTION table.  If source of change is VAMC or HEC then this field will contain the institution value.';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.CL_COMMENT IS 'User entered comments';

COMMENT ON COLUMN ADR.SPECIAL_FACTOR.CL_SOURCE_OF_CHANGE IS 'Contains the value from the ID column of the ADRREF.STD_CLSOURCEOFCHANGE table.  This represent the origin of the Camp LeJeune eligibility indicator';


CREATE INDEX ADR.SPCLFCTR_STD_AGNTORNG_FK_I ON ADR.SPECIAL_FACTOR
(AGENT_ORANGE_LOCATION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SPCLFCTR_STD_RADEXPMTHD_FK_I ON ADR.SPECIAL_FACTOR
(RADIATION_EXP_METHOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.SPECFACT_PK ON ADR.SPECIAL_FACTOR
(SPECIAL_FACTOR_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SPECFACT_PRSN_FK_I ON ADR.SPECIAL_FACTOR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SPECFACT_STDYESNO_FK_I ON ADR.SPECIAL_FACTOR
(SPECIAL_FACTOR_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SP_STD_SPECIALFACTORMAP_FK_I ON ADR.SPECIAL_FACTOR
(SPCL_FACTOR_MAPPING_TYPE_CODE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SPECIAL_FACTOR_AUDIR_TRGR
after Update or Delete or Insert
on ADR.SPECIAL_FACTOR
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into SPECIAL_FACTOR_H
    (
    SPECIAL_FACTOR_H_ID,
    SPECIAL_FACTOR_ID,
    SPCL_FACTOR_MAPPING_TYPE_CODE,
    SPECIAL_FACTOR_REGISTER_NUMBER,
    SPECIAL_FACTOR_REG_DATE_TXT,
    SPECIAL_FACTOR_EXAM_DATE_TXT,
    REMARKS,
    SPECIAL_FACTOR_STDYESNO_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RADIATION_EXP_METHOD_TYPE_ID,
    PERSON_ID,
    AGENT_ORANGE_LOCATION_TYPE_ID,
    RECORD_MODIFIED_COUNT,
    CL_VERIFICATION_METHOD_CODE,
    CL_CHANGE_SITE,
    CL_COMMENT,
    CL_SOURCE_OF_CHANGE,
    HISTORY_CREATED_DATE,
    TRANSACTION_TYPE_CODE

    )
    values
    (
    SPECIAL_FACTOR_H_S.nextval,
    :old.SPECIAL_FACTOR_ID,
    :old.SPCL_FACTOR_MAPPING_TYPE_CODE,
    :old.SPECIAL_FACTOR_REGISTER_NUMBER,
    :old.SPECIAL_FACTOR_REG_DATE_TXT,
    :old.SPECIAL_FACTOR_EXAM_DATE_TXT,
    :old.REMARKS,
    :old.SPECIAL_FACTOR_STDYESNO_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.RADIATION_EXP_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.AGENT_ORANGE_LOCATION_TYPE_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.CL_VERIFICATION_METHOD_CODE,
    :old.CL_CHANGE_SITE,
    :old.CL_COMMENT,
    :old.CL_SOURCE_OF_CHANGE,
    SYSDATE,
    'D'
    );
  IF :OLD.PERSON_ID IS NOT NULL THEN
    INSERT INTO ADR_EXTRACT_CHGS
      (
      PERSON_ID   ,
      CHG_DATE,
      ADR_EXTRACT_CHGS_ID
      )
      VALUES
      (:OLD.PERSON_ID,
      TRUNC(SYSDATE),
      ADR_EXTRACT_CHGS_S.NEXTVAL
      );
  END IF;
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into SPECIAL_FACTOR_H
    (
    SPECIAL_FACTOR_H_ID,
    SPECIAL_FACTOR_ID,
    SPCL_FACTOR_MAPPING_TYPE_CODE,
    SPECIAL_FACTOR_REGISTER_NUMBER,
    SPECIAL_FACTOR_REG_DATE_TXT,
    SPECIAL_FACTOR_EXAM_DATE_TXT,
    REMARKS,
    SPECIAL_FACTOR_STDYESNO_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    RADIATION_EXP_METHOD_TYPE_ID,
    PERSON_ID,
    AGENT_ORANGE_LOCATION_TYPE_ID,
    RECORD_MODIFIED_COUNT,
    CL_VERIFICATION_METHOD_CODE,
    CL_CHANGE_SITE,
    CL_COMMENT,
    CL_SOURCE_OF_CHANGE,
    HISTORY_CREATED_DATE,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    SPECIAL_FACTOR_H_S.nextval,
    :new.SPECIAL_FACTOR_ID,
    :new.SPCL_FACTOR_MAPPING_TYPE_CODE,
    :new.SPECIAL_FACTOR_REGISTER_NUMBER,
    :new.SPECIAL_FACTOR_REG_DATE_TXT,
    :new.SPECIAL_FACTOR_EXAM_DATE_TXT,
    :new.REMARKS,
    :new.SPECIAL_FACTOR_STDYESNO_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.RADIATION_EXP_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.AGENT_ORANGE_LOCATION_TYPE_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.CL_VERIFICATION_METHOD_CODE,
    :new.CL_CHANGE_SITE,
    :new.CL_COMMENT,
    :new.CL_SOURCE_OF_CHANGE,
    SYSDATE,
    mDML
    );
  IF :NEW.PERSON_ID IS NOT NULL THEN
    INSERT INTO ADR_EXTRACT_CHGS
      (
      PERSON_ID   ,
      CHG_DATE,
      ADR_EXTRACT_CHGS_ID
      )
      VALUES
      (:NEW.PERSON_ID,
      TRUNC(SYSDATE),
      ADR_EXTRACT_CHGS_S.NEXTVAL
      );
  END IF;
  end if;

end SPECIAL_FACTOR_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SPECIAL_FACTOR FOR ADR.SPECIAL_FACTOR;


ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SPECFACT_PK
  PRIMARY KEY
  (SPECIAL_FACTOR_ID)
  USING INDEX ADR.SPECFACT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SPECIAL_FACTOR ADD (
  CONSTRAINT SPECFACT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SP_FAC_STD_CLSRCOFCHNG_FK 
  FOREIGN KEY (CL_SOURCE_OF_CHANGE) 
  REFERENCES ADRREF.STD_CLSOURCEOFCHANGE (ID)
  ENABLE VALIDATE,
  CONSTRAINT SP_FAC_STD_CLVERIFTYP_FK 
  FOREIGN KEY (CL_VERIFICATION_METHOD_CODE) 
  REFERENCES ADRREF.STD_CLVERIFICATIONTYPE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SPECIAL_FACTOR TO ADREXT;

GRANT SELECT ON ADR.SPECIAL_FACTOR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SPECIAL_FACTOR TO ADR_RW;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SITE_RECEIVED_ENROLLMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SITE_RECEIVED_ENROLLMENT_H
(
  SITE_RECEIVED_ENROLLMENT_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  SITE_RECEIVED_ENROLLMENT_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_ENROLLMENTSTATUS_ID        NUMBER(20),
  ENROLLMENT_DATA_SRC_TYPE_ID    NUMBER(20),
  PRIORITY_GROUP_TYPE_ID         NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID     NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ENROLLMENT_START_DATE          DATE,
  ENROLLMENT_END_DATE            DATE,
  ENROLLMENT_CHANGE_EFCTV_DATE   DATE,
  OVERRIDE_IND                   NUMBER(1),
  REMARKS                        VARCHAR2(200 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SITE_RECEIVED_ENROLLMENT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.SITE_RECEIVED_ENROLLMENT_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.SITE_RECEIVED_ENROLLMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.ENROLLMENT_DATA_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.ENROLLMENT_START_DATE IS 'BR2240EnrollmentDateis definedashestarting dateforthisenrollment.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.ENROLLMENT_END_DATE IS 'BR7771Theenrollmentend dateisdefinedasthe enddateofthispersons enrollment.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.OVERRIDE_IND IS 'Whenanactormanually RemailsorMailsaletter andtheconditionsto sendtheletteras identifiedintheLetter DecisionTablesandthe Supplementary Specificationsarenot metthesystemdisplays thismessagetotheactor Theletterhas failedPoImIetthe conditionstosendthe letter.Thecondition thatfailedisinsert LetterCriterianotmet ORtheHECReject Reason.Doyouwantto overridethiscondition andsendtheletter?';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SITERECENH_PK ON ADR.SITE_RECEIVED_ENROLLMENT_H
(SITE_RECEIVED_ENROLLMENT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERECENH_PRSNID_NU_I ON ADR.SITE_RECEIVED_ENROLLMENT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SITE_RECEIVED_ENROLLMENT_H FOR ADR.SITE_RECEIVED_ENROLLMENT_H;


ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_052
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SITERECENH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_H_ID)
  USING INDEX ADR.SITERECENH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ADR_R;

GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT_H TO ADR_RW;
ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SITE_RECEIVED_ENROLLMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.SITE_RECEIVED_ENROLLMENT
(
  SITE_RECEIVED_ENROLLMENT_ID   NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_ENROLLMENTSTATUS_ID       NUMBER(20),
  ENROLLMENT_DATA_SRC_TYPE_ID   NUMBER(20),
  PRIORITY_GROUP_TYPE_ID        NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID    NUMBER(20),
  STD_INSTITUTION_ID            NUMBER(20),
  ENROLLMENT_START_DATE         DATE,
  ENROLLMENT_END_DATE           DATE,
  ENROLLMENT_CHANGE_EFCTV_DATE  DATE,
  OVERRIDE_IND                  NUMBER(1),
  REMARKS                       VARCHAR2(200 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SITE_RECEIVED_ENROLLMENT IS 'The table stores data about the enrollment of a particular person, when that enrollment was received from a site, as opposed to being processed at the Health Eligibility Center (HEC).';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.SITE_RECEIVED_ENROLLMENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.ENROLLMENT_DATA_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.ENROLLMENT_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.ENROLLMENT_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.ENROLLMENT_CHANGE_EFCTV_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.OVERRIDE_IND IS 'BR7458Enrollment OverrideFlagisdefined asaflagthatwhenset willinitiatethere- calculationofa veteransenrollment priority.Itisusedin thosecaseswherea veteranmayhavebeen placedinaRejected; StopNewEnrollmentsOR Rejected;Below EnrollmentGroup ThresholdEnrollment statuses.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ENROLLMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SITERECENR_PK ON ADR.SITE_RECEIVED_ENROLLMENT
(SITE_RECEIVED_ENROLLMENT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERECENR_PRSN_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERECENR_STDINST_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.STRCVDENR_STD_ENRLPGRP_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.STRCVDENR_STD_ENRLPSGRP_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.STRCVDENR_STD_ENRLSRC_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(ENROLLMENT_DATA_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.STREVDENR_STD_ENRLST_FK_I ON ADR.SITE_RECEIVED_ENROLLMENT
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SITE_RECEIVED_ENROL_audir_trgr
after Update or Delete or Insert
ON ADR.SITE_RECEIVED_ENROLLMENT
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SITE_RECEIVED_ENROLLMENT_H
		(
		SITE_RECEIVED_ENROLLMENT_H_ID,
		SITE_RECEIVED_ENROLLMENT_ID,
		ENROLLMENT_START_DATE,
		ENROLLMENT_END_DATE,
		ENROLLMENT_CHANGE_EFCTV_DATE,
		OVERRIDE_IND,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_ENROLLMENTSTATUS_ID,
		PRIORITY_GROUP_TYPE_ID,
		ENROLLMENT_DATA_SRC_TYPE_ID,
		STD_INSTITUTION_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ENROLLMENT_H_S.nextval,
		:old.SITE_RECEIVED_ENROLLMENT_ID,
		:old.ENROLLMENT_START_DATE,
		:old.ENROLLMENT_END_DATE,
		:old.ENROLLMENT_CHANGE_EFCTV_DATE,
		:old.OVERRIDE_IND,
		:old.REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_ENROLLMENTSTATUS_ID,
		:old.PRIORITY_GROUP_TYPE_ID,
		:old.ENROLLMENT_DATA_SRC_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.PRIORITY_SUB_GROUP_TYPE_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SITE_RECEIVED_ENROLLMENT_H
		(
		SITE_RECEIVED_ENROLLMENT_H_ID,
		SITE_RECEIVED_ENROLLMENT_ID,
		ENROLLMENT_START_DATE,
		ENROLLMENT_END_DATE,
		ENROLLMENT_CHANGE_EFCTV_DATE,
		OVERRIDE_IND,
		REMARKS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_ENROLLMENTSTATUS_ID,
		PRIORITY_GROUP_TYPE_ID,
		ENROLLMENT_DATA_SRC_TYPE_ID,
		STD_INSTITUTION_ID,
		PRIORITY_SUB_GROUP_TYPE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ENROLLMENT_H_S.nextval,
		:new.SITE_RECEIVED_ENROLLMENT_ID,
		:new.ENROLLMENT_START_DATE,
		:new.ENROLLMENT_END_DATE,
		:new.ENROLLMENT_CHANGE_EFCTV_DATE,
		:new.OVERRIDE_IND,
		:new.REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_ENROLLMENTSTATUS_ID,
		:new.PRIORITY_GROUP_TYPE_ID,
		:new.ENROLLMENT_DATA_SRC_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.PRIORITY_SUB_GROUP_TYPE_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SITE_RECEIVED_ENROL_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SITE_RECEIVED_ENROLLMENT FOR ADR.SITE_RECEIVED_ENROLLMENT;


ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT ADD (
  CONSTRAINT SITERECENR_PK
  PRIMARY KEY
  (SITE_RECEIVED_ENROLLMENT_ID)
  USING INDEX ADR.SITERECENR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SITE_RECEIVED_ENROLLMENT ADD (
  CONSTRAINT SITERECENR_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SITE_RECEIVED_ENROLLMENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ENROLLMENT TO ADR_RW;
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H
(
  SITE_RECEIVED_ELIGIBILITY_H_ID  NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  SITE_RECEIVED_ELIGIBILITY_ID    NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20),
  ELIGIBILITY_TYPE_ID             NUMBER(20),
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  ALLIED_COUNTRY_TYPE_ID          NUMBER(20),
  FEDERAL_AGENCY_TYPE_ID          NUMBER(20),
  ELIGIBILITY_EFFECTIVE_DATE      DATE,
  ELIGIBILITY_EXPIRATION_DATE     DATE,
  ELIGIBILITY_STATUS_DATE         DATE,
  STATUS_DATE_TXT                 VARCHAR2(14 BYTE),
  PRIMARY_SECONDARY_OR_OTHER_IND  VARCHAR2(1 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.SITE_RECEIVED_ELIGIBILITY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.SITE_RECEIVED_ELIGIBILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.ELIGIBILITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.ALLIED_COUNTRY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.FEDERAL_AGENCY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.STATUS_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.PRIMARY_SECONDARY_OR_OTHER_IND IS 'PrimaryEligibilityCode fieldisdefinedasthe fieldthatcontainsthe veteranscurrent eligibilitycode.The PrimaryEligibilityCode isthecodethatis assignedtotheveteran basedonbenefitfactors capturedontheintake process.Thisisthe codethatisassignedthe highestprecedence.It istheprimaryfactor thatdeterminesthe veteransenrollment priority.Itcanbe usedasasingleentity orinconjunctionwith othereligibilitycodes inthecalculationofthe enrollmentpriority.The PrimaryEligibilitycode alsocontributesin determiningifthe veteranneedstocomplete aMeansTest.SecondaryEligibility Codesisdefinedasthe codesthatareassigned totheveteranbasedon thebenefitfactors capturedontheintake process.Theyare consideredadditional factorsandcombinedwith thePrimaryEligibility Codedeterminethe VeteransEnrollment Priority.Theyalso contributeindetermining iftheveteranneedsto completeaMeansTestThe veteranrecordwill containallthe eligibilitiesunderwhich thispatientmayreceive care.Theprimary eligibilityaswellas allothereligibilities he/sheisentitledtois storedbythesystem.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE UNIQUE INDEX ADR.SITERCVELH_PK ON ADR.SITE_RECEIVED_ELIGIBILITY_H
(SITE_RECEIVED_ELIGIBILITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELH_PRSNID_NU_I ON ADR.SITE_RECEIVED_ELIGIBILITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SITE_RECEIVED_ELIGIBILITY_H FOR ADR.SITE_RECEIVED_ELIGIBILITY_H;


ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_058
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SITERCVELH_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_H_ID)
  USING INDEX ADR.SITERCVELH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ELIGIBILITY_H TO ADR_RW;
ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SITE_RECEIVED_ELIGIBILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.SITE_RECEIVED_ELIGIBILITY
(
  SITE_RECEIVED_ELIGIBILITY_ID    NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  ELIGIBILITY_TYPE_ID             NUMBER(20),
  ALLIED_COUNTRY_TYPE_ID          NUMBER(20),
  FEDERAL_AGENCY_TYPE_ID          NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20),
  ELIGIBILITY_EFFECTIVE_DATE      DATE,
  ELIGIBILITY_EXPIRATION_DATE     DATE,
  ELIGIBILITY_STATUS_DATE         DATE,
  STATUS_DATE_TXT                 VARCHAR2(14 BYTE),
  PRIMARY_SECONDARY_OR_OTHER_IND  VARCHAR2(1 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SITE_RECEIVED_ELIGIBILITY IS 'The SITE_RECEIVED_ELIGIBILITY table stores data about the eligibility of a particular person, when that eligibility was received from a site, as opposed to being processed at the Health Eligibility Center (HEC).';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.SITE_RECEIVED_ELIGIBILITY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ALLIED_COUNTRY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.FEDERAL_AGENCY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_EFFECTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_EXPIRATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.ELIGIBILITY_STATUS_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.STATUS_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.PRIMARY_SECONDARY_OR_OTHER_IND IS 'PrimaryEligibilityCode fieldisdefinedasthe fieldthatcontainsthe veteranscurrent eligibilitycode.The PrimaryEligibilityCode isthecodethatis assignedtotheveteran basedonbenefitfactors capturedontheintake process.Thisisthe codethatisassignedthe highestprecedence.It istheprimaryfactor thatdeterminesthe veteransenrollment priority.Itcanbe usedasasingleentity orinconjunctionwith othereligibilitycodes inthecalculationofthe enrollmentpriority.The PrimaryEligibilitycode alsocontributesin determiningifthe veteranneedstocomplete aMeansTest.SecondaryEligibility Codesisdefinedasthe codesthatareassigned totheveteranbasedon thebenefitfactors capturedontheintake process.Theyare consideredadditional factorsandcombinedwith thePrimaryEligibility Codedeterminethe VeteransEnrollment Priority.Theyalso contributeindetermining iftheveteranneedsto completeaMeansTestThe veteranrecordwill containallthe eligibilitiesunderwhich thispatientmayreceive care.Theprimary eligibilityaswellas allothereligibilities he/sheisentitledtois storedbythesystem.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SITE_RECEIVED_ELIGIBILITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SITERCVELG_PK ON ADR.SITE_RECEIVED_ELIGIBILITY
(SITE_RECEIVED_ELIGIBILITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_PRSN_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STDINST_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STD_ALIEDCTRY_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(ALLIED_COUNTRY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STD_ELGBTYCODE_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(ELIGIBILITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SITERCVELG_STD_OTHRAGNCY_FK_I ON ADR.SITE_RECEIVED_ELIGIBILITY
(FEDERAL_AGENCY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SITE_RECEIVED_ELIG_audir_trgr
after Update or Delete or Insert
ON ADR.SITE_RECEIVED_ELIGIBILITY
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SITE_RECEIVED_ELIGIBILITY_H
		(
		SITE_RECEIVED_ELIGIBILITY_H_ID,
		SITE_RECEIVED_ELIGIBILITY_ID,
		ELIGIBILITY_EFFECTIVE_DATE,
		ELIGIBILITY_EXPIRATION_DATE,
		ELIGIBILITY_STATUS_DATE,
		STATUS_DATE_TXT,
		PRIMARY_SECONDARY_OR_OTHER_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		STD_INSTITUTION_ID,
		ELIGIBILITY_TYPE_ID,
		RECORD_MODIFIED_COUNT,
		ALLIED_COUNTRY_TYPE_ID,
		FEDERAL_AGENCY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ELIGIBILITY_H_S.nextval,
		:old.SITE_RECEIVED_ELIGIBILITY_ID,
		:old.ELIGIBILITY_EFFECTIVE_DATE,
		:old.ELIGIBILITY_EXPIRATION_DATE,
		:old.ELIGIBILITY_STATUS_DATE,
		:old.STATUS_DATE_TXT,
		:old.PRIMARY_SECONDARY_OR_OTHER_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.STD_INSTITUTION_ID,
		:old.ELIGIBILITY_TYPE_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.ALLIED_COUNTRY_TYPE_ID,
		:old.FEDERAL_AGENCY_TYPE_ID,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SITE_RECEIVED_ELIGIBILITY_H
		(
		SITE_RECEIVED_ELIGIBILITY_H_ID,
		SITE_RECEIVED_ELIGIBILITY_ID,
		ELIGIBILITY_EFFECTIVE_DATE,
		ELIGIBILITY_EXPIRATION_DATE,
		ELIGIBILITY_STATUS_DATE,
		STATUS_DATE_TXT,
		PRIMARY_SECONDARY_OR_OTHER_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		STD_INSTITUTION_ID,
		ELIGIBILITY_TYPE_ID,
		RECORD_MODIFIED_COUNT,
		ALLIED_COUNTRY_TYPE_ID,
		FEDERAL_AGENCY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SITE_RECEIVED_ELIGIBILITY_H_S.nextval,
		:new.SITE_RECEIVED_ELIGIBILITY_ID,
		:new.ELIGIBILITY_EFFECTIVE_DATE,
		:new.ELIGIBILITY_EXPIRATION_DATE,
		:new.ELIGIBILITY_STATUS_DATE,
		:new.STATUS_DATE_TXT,
		:new.PRIMARY_SECONDARY_OR_OTHER_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.STD_INSTITUTION_ID,
		:new.ELIGIBILITY_TYPE_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.ALLIED_COUNTRY_TYPE_ID,
		:new.FEDERAL_AGENCY_TYPE_ID,
		mDML
		);
	end if;

end SITE_RECEIVED_ELIG_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SITE_RECEIVED_ELIGIBILITY FOR ADR.SITE_RECEIVED_ELIGIBILITY;


ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT AVCON_1172521913_PRIMA_000
  CHECK (PRIMARY_SECONDARY_OR_OTHER_IND IN ('P', 'S', 'O'))
  ENABLE VALIDATE,
  CONSTRAINT SITERCVELG_PK
  PRIMARY KEY
  (SITE_RECEIVED_ELIGIBILITY_ID)
  USING INDEX ADR.SITERCVELG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SITE_RECEIVED_ELIGIBILITY ADD (
  CONSTRAINT SITERCVELG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SITE_RECEIVED_ELIGIBILITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SITE_RECEIVED_ELIGIBILITY TO ADR_RW;
ALTER TABLE ADR.SIGNATURE_IMAGE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SIGNATURE_IMAGE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SIGNATURE_IMAGE_H
(
  SIGNATURE_IMAGE_H_ID         NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  SIGNATURE_IMAGE_ID           NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  SIGNATURE_INDICATOR_TYPE_ID  NUMBER(20),
  SUBMITTING_SITE_ID           NUMBER(20),
  INCOME_YEAR                  NUMBER(4),
  IMAGE_NUMBER                 VARCHAR2(30 BYTE),
  INDEXED_DATE                 DATE,
  USERNAME                     VARCHAR2(30 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SIGNATURE_IMAGE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.SIGNATURE_IMAGE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.SIGNATURE_IMAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.SIGNATURE_INDICATOR_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.SUBMITTING_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.IMAGE_NUMBER IS 'BR5850 Consent/Authorization ImageIndexNumberis definedastheunique imageindexnumber associatedwiththe veteranthatisassigned bytheimagingsystem.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SIGNATUREH_PK ON ADR.SIGNATURE_IMAGE_H
(SIGNATURE_IMAGE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATUREH_PRSNID_NU_I ON ADR.SIGNATURE_IMAGE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SIGNATURE_IMAGE_H FOR ADR.SIGNATURE_IMAGE_H;


ALTER TABLE ADR.SIGNATURE_IMAGE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_072
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SIGNATUREH_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_H_ID)
  USING INDEX ADR.SIGNATUREH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SIGNATURE_IMAGE_H TO ADR_R;

GRANT SELECT ON ADR.SIGNATURE_IMAGE_H TO ADR_RW;
ALTER TABLE ADR.SIGNATURE_IMAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SIGNATURE_IMAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.SIGNATURE_IMAGE
(
  SIGNATURE_IMAGE_ID           NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  SIGNATURE_INDICATOR_TYPE_ID  NUMBER(20),
  SUBMITTING_SITE_ID           NUMBER(20),
  INCOME_YEAR                  NUMBER(4),
  IMAGE_NUMBER                 VARCHAR2(30 BYTE),
  INDEXED_DATE                 DATE,
  USERNAME                     VARCHAR2(30 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SIGNATURE_IMAGE IS 'The SIGNATURE_IMAGE table stores information about the image of a persons signature stored during the means test process. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.SIGNATURE_IMAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.SIGNATURE_INDICATOR_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.SUBMITTING_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.IMAGE_NUMBER IS 'BR5850 Consent/Authorization ImageIndexNumberis definedastheunique imageindexnumber associatedwiththe veteranthatisassigned bytheimagingsystem.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.USERNAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SIGNATURE_IMAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SIGNATURE_PK ON ADR.SIGNATURE_IMAGE
(SIGNATURE_IMAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATURE_PRSN_FK_I ON ADR.SIGNATURE_IMAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATURE_SIGNINDTYP_FK_I ON ADR.SIGNATURE_IMAGE
(SIGNATURE_INDICATOR_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIGNATURE_STDINST_FK_I ON ADR.SIGNATURE_IMAGE
(SUBMITTING_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SIGNATURE_IMAGE_audir_trgr
after Update or Delete or Insert
ON ADR.SIGNATURE_IMAGE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SIGNATURE_IMAGE_H
		(
		SIGNATURE_IMAGE_H_ID,
		SIGNATURE_IMAGE_ID,
		SIGNATURE_INDICATOR_TYPE_ID,
		IMAGE_NUMBER,
		INCOME_YEAR,
		INDEXED_DATE,
		USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		SUBMITTING_SITE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SIGNATURE_IMAGE_H_S.nextval,
		:old.SIGNATURE_IMAGE_ID,
		:old.SIGNATURE_INDICATOR_TYPE_ID,
		:old.IMAGE_NUMBER,
		:old.INCOME_YEAR,
		:old.INDEXED_DATE,
		:old.USERNAME,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.SUBMITTING_SITE_ID,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SIGNATURE_IMAGE_H
		(
		SIGNATURE_IMAGE_H_ID,
		SIGNATURE_IMAGE_ID,
		SIGNATURE_INDICATOR_TYPE_ID,
		IMAGE_NUMBER,
		INCOME_YEAR,
		INDEXED_DATE,
		USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		SUBMITTING_SITE_ID,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SIGNATURE_IMAGE_H_S.nextval,
		:new.SIGNATURE_IMAGE_ID,
		:new.SIGNATURE_INDICATOR_TYPE_ID,
		:new.IMAGE_NUMBER,
		:new.INCOME_YEAR,
		:new.INDEXED_DATE,
		:new.USERNAME,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.SUBMITTING_SITE_ID,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SIGNATURE_IMAGE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SIGNATURE_IMAGE FOR ADR.SIGNATURE_IMAGE;


ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PK
  PRIMARY KEY
  (SIGNATURE_IMAGE_ID)
  USING INDEX ADR.SIGNATURE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SIGNATURE_IMAGE ADD (
  CONSTRAINT SIGNATURE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SIGNATURE_IMAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SIGNATURE_IMAGE TO ADR_RW;
ALTER TABLE ADR.SHAD_REGISTRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY_H
(
  SHAD_REGISTRY_H_ID     NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  SHAD_REGISTRY_ID       NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20),
  REGISTRY_TRAIT_ID      NUMBER(20),
  SHAD_STDYESNO_ID       NUMBER(20),
  CLAIM_NUMBER           VARCHAR2(20 BYTE),
  LEGACY_USERNAME        VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.SHAD_REGISTRY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADRGSTRH_PK ON ADR.SHAD_REGISTRY_H
(SHAD_REGISTRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRH_PRSNID_NU_I ON ADR.SHAD_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY_H FOR ADR.SHAD_REGISTRY_H;


ALTER TABLE ADR.SHAD_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_056
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SHADRGSTRH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_H_ID)
  USING INDEX ADR.SHADRGSTRH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ADR_R;

GRANT SELECT ON ADR.SHAD_REGISTRY_H TO ADR_RW;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY_DETAIL_H
(
  SHAD_REGISTRY_DETAIL_H_ID  NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  SHAD_REGISTRY_DETAIL_ID    NUMBER(20)         NOT NULL,
  SHAD_REGISTRY_ID           NUMBER(20)         NOT NULL,
  SHAD_DOCUMENT_TYPE_ID      NUMBER(20),
  DOCUMENT_RECEIVED_DATE     DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_REGISTRY_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.SHAD_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.DOCUMENT_RECEIVED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADREGDH_PK ON ADR.SHAD_REGISTRY_DETAIL_H
(SHAD_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADREGDH_SHADRGSTRY_FK_I ON ADR.SHAD_REGISTRY_DETAIL_H
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY_DETAIL_H FOR ADR.SHAD_REGISTRY_DETAIL_H;


ALTER TABLE ADR.SHAD_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_026
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT SHADREGDH_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_H_ID)
  USING INDEX ADR.SHADREGDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.SHAD_REGISTRY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY_DETAIL
(
  SHAD_REGISTRY_DETAIL_ID  NUMBER(20)           NOT NULL,
  SHAD_REGISTRY_ID         NUMBER(20)           NOT NULL,
  SHAD_DOCUMENT_TYPE_ID    NUMBER(20)           NOT NULL,
  DOCUMENT_RECEIVED_DATE   DATE,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY_DETAIL IS 'Detail table for SHAD registry.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.SHAD_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.SHAD_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.DOCUMENT_RECEIVED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADREGDTL_PK ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADREGDTL_SHADRGSTRY_FK_I ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADREGDTL_STD_SHADOCTYP_FK_I ON ADR.SHAD_REGISTRY_DETAIL
(SHAD_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SHAD_REGISTRY_det_audir_trgr
after Update or Delete or Insert
ON ADR.SHAD_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SHAD_REGISTRY_DETAIL_H
		(
 		SHAD_REGISTRY_DETAIL_H_ID
 		,SHAD_REGISTRY_DETAIL_ID
 		,SHAD_REGISTRY_ID
 		,SHAD_DOCUMENT_TYPE_ID
		,DOCUMENT_RECEIVED_DATE
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_DETAIL_H_S.nextval,
		:old.SHAD_REGISTRY_DETAIL_ID,
		:old.SHAD_REGISTRY_ID,
		:old.SHAD_DOCUMENT_TYPE_ID,
		:OLD.DOCUMENT_RECEIVED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SHAD_REGISTRY_DETAIL_H
		(
 		SHAD_REGISTRY_DETAIL_H_ID
 		,SHAD_REGISTRY_DETAIL_ID
 		,SHAD_REGISTRY_ID
 		,SHAD_DOCUMENT_TYPE_ID
		,DOCUMENT_RECEIVED_DATE
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_DETAIL_H_S.nextval,
		:new.SHAD_REGISTRY_DETAIL_ID,
		:new.SHAD_REGISTRY_ID,
		:new.SHAD_DOCUMENT_TYPE_ID,
		:new.DOCUMENT_RECEIVED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end SHAD_REGISTRY_det_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY_DETAIL FOR ADR.SHAD_REGISTRY_DETAIL;


ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_PK
  PRIMARY KEY
  (SHAD_REGISTRY_DETAIL_ID)
  USING INDEX ADR.SHADREGDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SHAD_REGISTRY_DETAIL ADD (
  CONSTRAINT SHADREGDTL_SHADRGSTRY_FK 
  FOREIGN KEY (SHAD_REGISTRY_ID) 
  REFERENCES ADR.SHAD_REGISTRY (SHAD_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SHAD_REGISTRY_DETAIL TO ADR_RW;
ALTER TABLE ADR.SHAD_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SHAD_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.SHAD_REGISTRY
(
  SHAD_REGISTRY_ID       NUMBER(20)             NOT NULL,
  REGISTRY_TRAIT_ID      NUMBER(20),
  PERSON_ID              NUMBER(20),
  SHAD_STDYESNO_ID       NUMBER(20),
  CLAIM_NUMBER           VARCHAR2(20 BYTE),
  LEGACY_USERNAME        VARCHAR2(30 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SHAD_REGISTRY IS 'The contains data about persons who have been exposed to hazardous environments as part of their military service. The Shipboard Hazard and Defense (SHAD) data originates from the Veterans Benefits Administration (VBA). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.SHAD_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SHAD_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SHADRGSTRY_PK ON ADR.SHAD_REGISTRY
(SHAD_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRY_PRSN_FK_I ON ADR.SHAD_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRY_REGTRAIT_FK_I ON ADR.SHAD_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SHADRGSTRY_STDYESNO_FK_I ON ADR.SHAD_REGISTRY
(SHAD_STDYESNO_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SHAD_REGISTRY_audir_trgr
after Update or Delete or Insert
ON ADR.SHAD_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SHAD_REGISTRY_H
		(
		SHAD_REGISTRY_H_ID,
		SHAD_REGISTRY_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		CLAIM_NUMBER,
		SHAD_STDYESNO_ID,
		LEGACY_USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_H_S.nextval,
		:old.SHAD_REGISTRY_ID,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.CLAIM_NUMBER,
		:old.SHAD_STDYESNO_ID,
		:old.LEGACY_USERNAME,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	IF :OLD.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:OLD.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SHAD_REGISTRY_H
		(
		SHAD_REGISTRY_H_ID,
		SHAD_REGISTRY_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		CLAIM_NUMBER,
		SHAD_STDYESNO_ID,
		LEGACY_USERNAME,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SHAD_REGISTRY_H_S.nextval,
		:new.SHAD_REGISTRY_ID,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.CLAIM_NUMBER,
		:new.SHAD_STDYESNO_ID,
		:new.LEGACY_USERNAME,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	IF :NEW.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:NEW.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	end if;

end SHAD_REGISTRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SHAD_REGISTRY FOR ADR.SHAD_REGISTRY;


ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PK
  PRIMARY KEY
  (SHAD_REGISTRY_ID)
  USING INDEX ADR.SHADRGSTRY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SHAD_REGISTRY ADD (
  CONSTRAINT SHADRGSTRY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SHADRGSTRY_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SHAD_REGISTRY TO ADREXT;

GRANT SELECT ON ADR.SHAD_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SHAD_REGISTRY TO ADR_RW;
ALTER TABLE ADR.SERVICE_CONNECTED_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SERVICE_CONNECTED_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.SERVICE_CONNECTED_H
(
  SERVICE_CONNECTED_H_ID          NUMBER(20),
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE),
  SERVICE_CONNECTED_ID            NUMBER(20),
  PERSON_ID                       NUMBER(20),
  SC_TOTAL_AMOUNT                 NUMBER(10,2),
  SERVICE_AWARD_DATE_TXT          VARCHAR2(14 BYTE),
  SC_COMBINED_PERCENT             NUMBER(3),
  SC_COMBINED_PCT_EFCTV_DATE_TXT  VARCHAR2(14 BYTE),
  SC_PERMANENT_AND_TOTAL_IND      NUMBER(1)     DEFAULT 0,
  SC_PERMNT_AND_TOTAL_EFCTV_DT    DATE,
  UNEMPLOYABLE_INDICATOR          NUMBER(1)     DEFAULT 0,
  SERVICE_CONNECTED_IND           NUMBER(1),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE             DATE,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE            DATE,
  RECORD_MODIFIED_COUNT           NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SERVICE_CONNECTED_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SERVICE_CONNECTED_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SC_TOTAL_AMOUNT IS 'ServiceConnected-Total checkamount';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SERVICE_AWARD_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SC_COMBINED_PERCENT IS 'ServiceConnected- totalcombined percentage.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SC_COMBINED_PCT_EFCTV_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SC_PERMANENT_AND_TOTAL_IND IS 'BR1611Permanent&Total Indicatorisdefinedasa codethatindicatesif thepatientis permanentlyandtotally disableddeterminedby VAROduetoaservice- connectedcondition.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.SC_PERMNT_AND_TOTAL_EFCTV_DT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.UNEMPLOYABLE_INDICATOR IS 'BR1613Unemployable Indicatorisdefinedasa codethatindicatesif thispatientisrated unemployablebytheVARO duetoaservice connectedcondition.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SVCCONH_PK ON ADR.SERVICE_CONNECTED_H
(SERVICE_CONNECTED_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SVCCONH_PRSNID_NU_I ON ADR.SERVICE_CONNECTED_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SERVICE_CONNECTED_H FOR ADR.SERVICE_CONNECTED_H;


ALTER TABLE ADR.SERVICE_CONNECTED_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_077
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067608
  CHECK ("SERVICE_CONNECTED_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067609
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067610
  CHECK ("SERVICE_CONNECTED_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067611
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067612
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067613
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067614
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067615
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067616
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SVCCONH_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_H_ID)
  USING INDEX ADR.SVCCONH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SERVICE_CONNECTED_H TO ADR_R;

GRANT SELECT ON ADR.SERVICE_CONNECTED_H TO ADR_RW;
ALTER TABLE ADR.SERVICE_CONNECTED
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SERVICE_CONNECTED CASCADE CONSTRAINTS;

CREATE TABLE ADR.SERVICE_CONNECTED
(
  SERVICE_CONNECTED_ID            NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  SC_TOTAL_AMOUNT                 NUMBER(10,2),
  SERVICE_AWARD_DATE_TXT          VARCHAR2(14 BYTE),
  SC_COMBINED_PERCENT             NUMBER(3),
  SC_COMBINED_PCT_EFCTV_DATE_TXT  VARCHAR2(14 BYTE),
  SC_PERMANENT_AND_TOTAL_IND      NUMBER(1)     DEFAULT 0,
  SC_PERMNT_AND_TOTAL_EFCTV_DT    DATE,
  UNEMPLOYABLE_INDICATOR          NUMBER(1)     DEFAULT 0,
  SERVICE_CONNECTED_IND           NUMBER(1),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.SERVICE_CONNECTED IS 'The table stores information about a persons disabilities that are related to their time in the military, including the award amount, the associated dates, and whether the disability is permanent and total, and whether the person is unemployable. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_TOTAL_AMOUNT IS 'ServiceConnected-Total checkamount';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SERVICE_AWARD_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_COMBINED_PERCENT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_COMBINED_PCT_EFCTV_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_PERMANENT_AND_TOTAL_IND IS 'BR1611Permanent&Total Indicatorisdefinedasa codethatindicatesif thepatientis permanentlyandtotally disableddeterminedby VAROduetoaservice- connectedcondition.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.SC_PERMNT_AND_TOTAL_EFCTV_DT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.UNEMPLOYABLE_INDICATOR IS 'BR1613Unemployable Indicatorisdefinedasa codethatindicatesif thispatientisrated unemployablebytheVARO duetoaservice connectedcondition.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SERVICE_CONNECTED.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SVCCON_PK ON ADR.SERVICE_CONNECTED
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SVCCON_PRSN_FK_I ON ADR.SERVICE_CONNECTED
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.SERVICE_CONNECTED_audir_trgr
after Update or Delete or Insert
on ADR.SERVICE_CONNECTED
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into SERVICE_CONNECTED_H
		(
		SERVICE_CONNECTED_H_ID,
		SERVICE_CONNECTED_ID,
		SC_TOTAL_AMOUNT,
		SERVICE_AWARD_DATE_TXT,
		SC_COMBINED_PERCENT,
		SC_COMBINED_PCT_EFCTV_DATE_TXT,
		SC_PERMANENT_AND_TOTAL_IND,
		SC_PERMNT_AND_TOTAL_EFCTV_DT,
		UNEMPLOYABLE_INDICATOR,
		SERVICE_CONNECTED_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SERVICE_CONNECTED_H_S.nextval,
		:old.SERVICE_CONNECTED_ID,
		:old.SC_TOTAL_AMOUNT,
		:old.SERVICE_AWARD_DATE_TXT,
		:old.SC_COMBINED_PERCENT,
		:old.SC_COMBINED_PCT_EFCTV_DATE_TXT,
		:old.SC_PERMANENT_AND_TOTAL_IND,
		:old.SC_PERMNT_AND_TOTAL_EFCTV_DT,
		:old.UNEMPLOYABLE_INDICATOR,
		:old.SERVICE_CONNECTED_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	IF :OLD.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:OLD.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into SERVICE_CONNECTED_H
		(
		SERVICE_CONNECTED_H_ID,
		SERVICE_CONNECTED_ID,
		SC_TOTAL_AMOUNT,
		SERVICE_AWARD_DATE_TXT,
		SC_COMBINED_PERCENT,
		SC_COMBINED_PCT_EFCTV_DATE_TXT,
		SC_PERMANENT_AND_TOTAL_IND,
		SC_PERMNT_AND_TOTAL_EFCTV_DT,
		UNEMPLOYABLE_INDICATOR,
		SERVICE_CONNECTED_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		SERVICE_CONNECTED_H_S.nextval,
		:new.SERVICE_CONNECTED_ID,
		:new.SC_TOTAL_AMOUNT,
		:new.SERVICE_AWARD_DATE_TXT,
		:new.SC_COMBINED_PERCENT,
		:new.SC_COMBINED_PCT_EFCTV_DATE_TXT,
		:new.SC_PERMANENT_AND_TOTAL_IND,
		:new.SC_PERMNT_AND_TOTAL_EFCTV_DT,
		:new.UNEMPLOYABLE_INDICATOR,
		:new.SERVICE_CONNECTED_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	IF :NEW.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:NEW.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	end if;

end SERVICE_CONNECTED_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM SERVICE_CONNECTED FOR ADR.SERVICE_CONNECTED;


ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PK
  PRIMARY KEY
  (SERVICE_CONNECTED_ID)
  USING INDEX ADR.SVCCON_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SERVICE_CONNECTED ADD (
  CONSTRAINT SVCCON_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SERVICE_CONNECTED TO ADREXT;

GRANT SELECT ON ADR.SERVICE_CONNECTED TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SERVICE_CONNECTED TO ADR_RW;
ALTER TABLE ADR.SELF_IDENTIFIED_GENDER
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SELF_IDENTIFIED_GENDER CASCADE CONSTRAINTS;

CREATE TABLE ADR.SELF_IDENTIFIED_GENDER
(
  SELF_IDENTIFIED_GENDER_ID  NUMBER(20)         NOT NULL,
  CODE                       VARCHAR2(10 BYTE)  NOT NULL,
  NAME                       VARCHAR2(50 BYTE)  NOT NULL,
  DESCRIPTION                VARCHAR2(250 BYTE) NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.SELF_IDENTIFIED_GENDER_PK ON ADR.SELF_IDENTIFIED_GENDER
(SELF_IDENTIFIED_GENDER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIG_CODE_NU_I ON ADR.SELF_IDENTIFIED_GENDER
(CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SIG_NAME_NU_I ON ADR.SELF_IDENTIFIED_GENDER
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SELF_IDENTIFIED_GENDER FOR ADR.SELF_IDENTIFIED_GENDER;


ALTER TABLE ADR.SELF_IDENTIFIED_GENDER ADD (
  CONSTRAINT SELF_IDENTIFIED_GENDER_PK
  PRIMARY KEY
  (SELF_IDENTIFIED_GENDER_ID)
  USING INDEX ADR.SELF_IDENTIFIED_GENDER_PK
  ENABLE NOVALIDATE);

GRANT SELECT ON ADR.SELF_IDENTIFIED_GENDER TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.SELF_IDENTIFIED_GENDER TO ADR_RW;
ALTER TABLE ADR.SEEDING
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.SEEDING CASCADE CONSTRAINTS;

CREATE TABLE ADR.SEEDING
(
  SEEDING_ID                NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_SEEDSTATUS_ID         NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20),
  ORIGINATING_PROCESS_NAME  VARCHAR2(50 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(18)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.SEEDING.SEEDING_ID IS 'Unique identifier for Seeding Overview';

COMMENT ON COLUMN ADR.SEEDING.STD_SEEDSTATUS_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.SEEDING.STD_INSTITUTION_ID IS 'Unique Numeric Primary Key';

COMMENT ON COLUMN ADR.SEEDING.ORIGINATING_PROCESS_NAME IS 'Indicates if seeding process was initialized by batch or MSDS (part of Z07 process for on demand seeding).';

COMMENT ON COLUMN ADR.SEEDING.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.SEEDING.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.SEEDING.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.SEEDING.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.SEEDING.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SEEDING_PK ON ADR.SEEDING
(SEEDING_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SEED_PRSN_FK_I ON ADR.SEEDING
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SEED_SEEDSTAT_FK_I ON ADR.SEEDING
(STD_SEEDSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SEED_STDINST_FK_I ON ADR.SEEDING
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM SEEDING FOR ADR.SEEDING;


ALTER TABLE ADR.SEEDING ADD (
  CONSTRAINT SEEDING_PK
  PRIMARY KEY
  (SEEDING_ID)
  USING INDEX ADR.SEEDING_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.SEEDING ADD (
  CONSTRAINT RELATIONSHIP39 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.SEEDING TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.SEEDING TO ADR_RW;
ALTER TABLE ADR.RPT_WKF_CASE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_WKF_CASE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_WKF_CASE
(
  RPT_WKF_CASE_ID          NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  WKF_CASE_TYPE_ID         NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_WKF_CASE IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RPT_WKF_CASE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_WKF_CASE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTWKFCASE_PK ON ADR.RPT_WKF_CASE
(RPT_WKF_CASE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTWKFCASE_SCHEDRPT_FK_I ON ADR.RPT_WKF_CASE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTWKFCASE_WKFCASETYP_FK_I ON ADR.RPT_WKF_CASE
(WKF_CASE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_WKF_CASE FOR ADR.RPT_WKF_CASE;


ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_PK
  PRIMARY KEY
  (RPT_WKF_CASE_ID)
  USING INDEX ADR.RPTWKFCASE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_WKF_CASE ADD (
  CONSTRAINT RPTWKFCASE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTWKFCASE_WKFCASETYP_FK 
  FOREIGN KEY (WKF_CASE_TYPE_ID) 
  REFERENCES ADRREF.STD_WORKFLOWCASETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_WKF_CASE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_WKF_CASE TO ADR_RW;
ALTER TABLE ADR.RPT_VBA_QUERY_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_VBA_QUERY_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_VBA_QUERY_STATUS
(
  RPT_VBA_QUERY_STATUS_ID   NUMBER(20)          NOT NULL,
  RPT_SCHEDULED_REPORT_ID   NUMBER(20)          NOT NULL,
  VBA_QUERY_STATUS_TYPE_ID  NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_VBA_QUERY_STATUS IS 'ESR reporting table. Allows for reporting based on each of the VBA query status types, such as: No VBA Data on File VBA Data Auto-upload VBA Data Pending Rev VBA Data Manually Ac VBA Data Rejected VBA Query Initiated VBA Queried - Pending VBA Data Inconclusive Unsolicited Change O Unsolicited Eligible Unsolicited Lazarus';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RPT_VBA_QUERY_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.VBA_QUERY_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_VBA_QUERY_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTVBAQRY_PK ON ADR.RPT_VBA_QUERY_STATUS
(RPT_VBA_QUERY_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTVBAQRY_SCHEDRPT_FK_I ON ADR.RPT_VBA_QUERY_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTVBAQRY_STD_VBAQURYST_FK_I ON ADR.RPT_VBA_QUERY_STATUS
(VBA_QUERY_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_VBA_QUERY_STATUS FOR ADR.RPT_VBA_QUERY_STATUS;


ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_PK
  PRIMARY KEY
  (RPT_VBA_QUERY_STATUS_ID)
  USING INDEX ADR.RPTVBAQRY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_VBA_QUERY_STATUS ADD (
  CONSTRAINT RPTVBAQRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_VBA_QUERY_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_VBA_QUERY_STATUS TO ADR_RW;
ALTER TABLE ADR.RPT_USER_GROUP
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_USER_GROUP CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_USER_GROUP
(
  RPT_USER_GROUP_ID        NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  USER_GROUP_TYPE_ID       NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_USER_GROUP IS 'ESR reporting table. allows for reporting based on which group of users performed the query';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RPT_USER_GROUP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.USER_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_USER_GROUP.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTUSRGRP_PK ON ADR.RPT_USER_GROUP
(RPT_USER_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSRGRP_SCHEDRPT_FK_I ON ADR.RPT_USER_GROUP
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSRGRP_USRGRPTYP_FK_I ON ADR.RPT_USER_GROUP
(USER_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_USER_GROUP FOR ADR.RPT_USER_GROUP;


ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_PK
  PRIMARY KEY
  (RPT_USER_GROUP_ID)
  USING INDEX ADR.RPTUSRGRP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_USER_GROUP ADD (
  CONSTRAINT RPTUSRGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_USER_GROUP TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_USER_GROUP TO ADR_RW;
ALTER TABLE ADR.RPT_USERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_USERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_USERS
(
  RPT_USER_ID              NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  USERID                   NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_USERS IS 'ESR reporting table: Shows which user scheduled a particular report for run.';

COMMENT ON COLUMN ADR.RPT_USERS.RPT_USER_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USERS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_USERS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_USERS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTUSERS_PK ON ADR.RPT_USERS
(RPT_USER_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSERS_SCHEDRPT_FK_I ON ADR.RPT_USERS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTUSERS_USER_1_FK_I ON ADR.RPT_USERS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_USERS FOR ADR.RPT_USERS;


ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_PK
  PRIMARY KEY
  (RPT_USER_ID)
  USING INDEX ADR.RPTUSERS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_USERS ADD (
  CONSTRAINT RPTUSERS_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTUSERS_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_USERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_USERS TO ADR_RW;
ALTER TABLE ADR.RPT_STATUS_COMPONENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_STATUS_COMPONENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_STATUS_COMPONENT
(
  RPT_STATUS_COMPONENT_ID    NUMBER(20)         NOT NULL,
  RPT_SCHEDULED_REPORT_ID    NUMBER(20)         NOT NULL,
  STD_RPTSTATUSCOMPONENT_ID  NUMBER(20)         NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_STATUS_COMPONENT IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RPT_STATUS_COMPONENT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_STATUS_COMPONENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTSTATCMP_PK ON ADR.RPT_STATUS_COMPONENT
(RPT_STATUS_COMPONENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTSTATCMP_SCHEDRPT_FK_I ON ADR.RPT_STATUS_COMPONENT
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTSTATCMP_STDRPTSTCM_FK_I ON ADR.RPT_STATUS_COMPONENT
(STD_RPTSTATUSCOMPONENT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_STATUS_COMPONENT FOR ADR.RPT_STATUS_COMPONENT;


ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_PK
  PRIMARY KEY
  (RPT_STATUS_COMPONENT_ID)
  USING INDEX ADR.RPTSTATCMP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_STATUS_COMPONENT ADD (
  CONSTRAINT RPTSTATCMP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTSTATCMP_STDRPTSTCM_FK 
  FOREIGN KEY (STD_RPTSTATUSCOMPONENT_ID) 
  REFERENCES ADRREF.STD_RPTSTATUSCOMPONENT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_STATUS_COMPONENT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_STATUS_COMPONENT TO ADR_RW;
ALTER TABLE ADR.RPT_SITE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_SITE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_SITE
(
  RPT_SITE_ID              NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  STD_INSTITUTION_ID       NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_SITE IS 'ESR reporting table. Allows for reports to be printed on a per-site basis.';

COMMENT ON COLUMN ADR.RPT_SITE.RPT_SITE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_SITE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_SITE.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.RPT_SITE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_SITE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_SITE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_SITE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_SITE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTSITE_PK ON ADR.RPT_SITE
(RPT_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTSITE_SCHEDRPT_FK_I ON ADR.RPT_SITE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTSITE_STDINST_FK_I ON ADR.RPT_SITE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_SITE FOR ADR.RPT_SITE;


ALTER TABLE ADR.RPT_SITE ADD (
  CONSTRAINT RPTSITE_PK
  PRIMARY KEY
  (RPT_SITE_ID)
  USING INDEX ADR.RPTSITE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_SITE ADD (
  CONSTRAINT RPTSITE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_SITE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_SITE TO ADR_RW;
ALTER TABLE ADR.RPT_SCHEDULED_REPORTS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_SCHEDULED_REPORTS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_SCHEDULED_REPORTS
(
  RPT_SCHEDULED_REPORT_ID         NUMBER(20)    NOT NULL,
  USERID                          NUMBER(20),
  RPT_STANDARD_REPORT_ID          NUMBER(20)    NOT NULL,
  RPT_DIVISION_TYPE_ID            NUMBER(20),
  RPT_SCHEDULE_TYPE_ID            NUMBER(20),
  RPT_MONTH_LIST_TYPE_ID          NUMBER(20),
  RPT_QUARTER_LIST_TYPE_ID        NUMBER(20),
  RPT_DAY_OF_QUARTER_TYPE_ID      NUMBER(20),
  RPT_DAY_OF_MONTH_TYPE_ID        NUMBER(20),
  RPT_DAY_OF_WEEK_TYPE_ID         NUMBER(20),
  RPT_WEEK_OF_MONTH_TYPE_ID       NUMBER(20),
  RPT_OUTPUT_FORMAT_TYPE_ID       NUMBER(20),
  RPT_OUTPUT_FILE_TYPE_ID         NUMBER(20),
  RPT_WORK_ITEM_STATUS_TYPE_ID    NUMBER(20),
  RPT_PERIOD_TYPE_ID              NUMBER(20),
  RPT_SITE_DISPLAY_TYPE_ID        NUMBER(20),
  RPT_DETAIL_BY_TYPE_ID           NUMBER(20),
  RPT_DETAIL_FOR_TYPE_ID          NUMBER(20),
  RPT_RUN_FREQUENCY_TYPE_ID       NUMBER(20),
  RPT_EXCEPTION_TYPE_ID           NUMBER(20),
  RPT_ENROLLPRSTAT_ID             NUMBER(20),
  REPORT_BATCH_NUMBER             VARCHAR2(20 BYTE),
  BEGIN_INCOME_YEAR               NUMBER(4),
  END_INCOME_YEAR                 NUMBER(4),
  REPORT_GENERATE_DATE            DATE,
  REPORT_FROM_DATE                DATE,
  REPORT_TO_DATE                  DATE,
  REPORT_AS_OF_DATE               DATE,
  REPORT_RECIPIENT_EMAIL          VARCHAR2(1000 BYTE),
  REPORTING_PERIOD_YEAR           NUMBER(4),
  REPORTING_PERIOD_FROM_DATE      DATE,
  REPORTING_PERIOD_TO_DATE        DATE,
  LETTER_FILE_RECEIVED_DATE       DATE,
  ENROLLMENT_CHANGE_EFCTV_DATE    DATE,
  ADDRESS_UPDATE_DAYS_COUNT       NUMBER(10),
  PURPLE_HEART_DAYS_COUNT         NUMBER(10),
  ENROLLMENT_STATUS_RECORD_COUNT  NUMBER(10),
  DAY_NUMBER                      NUMBER(4),
  HOUR_NUMBER                     NUMBER(4),
  MINUTE_NUMBER                   NUMBER(4),
  RANDOM_RECORDS_COUNT            NUMBER(10),
  INCLUDE_USERS_FLAG              NUMBER(1)     DEFAULT 0                     NOT NULL,
  RUN_REPORT_BY_USER_FLAG         NUMBER(1)     DEFAULT 0                     NOT NULL,
  OUTLIER_DAYS                    NUMBER(3),
  UPDATE_BETWEEN_DAYS             NUMBER(3),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_SCHEDULED_REPORTS IS 'ESR Reporting table; This table stores all the reports that have been scheduled to run';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RPT_STANDARD_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.REPORT_BATCH_NUMBER IS 'Batchnumberthatthe reportbelongsto.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.BEGIN_INCOME_YEAR IS 'IncomeYearSpecifiedfor Reportrun';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.END_INCOME_YEAR IS 'IncomeYearSpecifiedfor Reportrun';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.REPORT_GENERATE_DATE IS 'Datethereportwas generated';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.ADDRESS_UPDATE_DAYS_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.PURPLE_HEART_DAYS_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.ENROLLMENT_STATUS_RECORD_COUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.INCLUDE_USERS_FLAG IS 'NumericFLAGfield-1 indicatesthatUsersare includedinthereport outputemail';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RUN_REPORT_BY_USER_FLAG IS 'NumericFLAGfield-1 indicatesthatreportis beingrunonaperuser basis';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_SCHEDULED_REPORTS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.SCHEDRPT_PK ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SCHEDRPT_RPTDIVTYPE_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DIVISION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SCHEDRPT_RPTWRKITM_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_WORK_ITEM_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SCHEDRPT_USER_1_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDAYQRTR_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_QUARTER_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDTLBY_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DETAIL_BY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDTLFOR_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DETAIL_FOR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTDYWKTYP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_WEEK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTENRLPRSTAT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_ENROLLPRSTAT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTEXCPT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_EXCEPTION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTFORMAT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_OUTPUT_FORMAT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTFREQTYP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_RUN_FREQUENCY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTMNTHDAY_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_DAY_OF_MONTH_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTMTHLST_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_MONTH_LIST_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTOUTFILE_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_OUTPUT_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTPERIOD_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_PERIOD_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTQRTRLST_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_QUARTER_LIST_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTSCHED_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SCHEDULE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTSITEDSP_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_SITE_DISPLAY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTSTDRPT_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_STANDARD_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.SRPT_STD_RPTWKMNTH_FK_I ON ADR.RPT_SCHEDULED_REPORTS
(RPT_WEEK_OF_MONTH_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_SCHEDULED_REPORTS FOR ADR.RPT_SCHEDULED_REPORTS;


ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT AVCON_1172521913_INCLU_000
  CHECK (INCLUDE_USERS_FLAG BETWEEN 0
AND 0 OR INCLUDE_USERS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_RUN_R_000
  CHECK (RUN_REPORT_BY_USER_FLAG BETWEEN 0
AND 0 OR RUN_REPORT_BY_USER_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_PK
  PRIMARY KEY
  (RPT_SCHEDULED_REPORT_ID)
  USING INDEX ADR.SCHEDRPT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_SCHEDULED_REPORTS ADD (
  CONSTRAINT SCHEDRPT_RPTDIVTYPE_FK 
  FOREIGN KEY (RPT_DIVISION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDIVISIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_RPTWRKITM_FK 
  FOREIGN KEY (RPT_WORK_ITEM_STATUS_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWORKITEMSTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SCHEDRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDAYQRTR_FK 
  FOREIGN KEY (RPT_DAY_OF_QUARTER_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFQUARTERTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDTLBY_FK 
  FOREIGN KEY (RPT_DETAIL_BY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILBYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDTLFOR_FK 
  FOREIGN KEY (RPT_DETAIL_FOR_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDETAILFORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTENRLPRSTAT_FK 
  FOREIGN KEY (RPT_ENROLLPRSTAT_ID) 
  REFERENCES ADRREF.STD_REPORTENROLLPRSTAT (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTFORMAT_FK 
  FOREIGN KEY (RPT_OUTPUT_FORMAT_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTFORMATTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTFREQTYP_FK 
  FOREIGN KEY (RPT_RUN_FREQUENCY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTRUNFREQUENCYTYP (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTMNTHDAY_FK 
  FOREIGN KEY (RPT_DAY_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTMTHLST_FK 
  FOREIGN KEY (RPT_MONTH_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTMONTHLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTPERIOD_FK 
  FOREIGN KEY (RPT_PERIOD_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTPERIODTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTQRTRLST_FK 
  FOREIGN KEY (RPT_QUARTER_LIST_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTQUARTERLIST (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTSCHED_FK 
  FOREIGN KEY (RPT_SCHEDULE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSCHEDULETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTSITEDSP_FK 
  FOREIGN KEY (RPT_SITE_DISPLAY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTSITEDISPLAYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT SRPT_STD_RPTWKMNTH_FK 
  FOREIGN KEY (RPT_WEEK_OF_MONTH_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTWEEKOFMONTHTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_SCHEDULED_REPORTS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_SCHEDULED_REPORTS TO ADR_RW;
ALTER TABLE ADR.RPT_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_REGISTRY
(
  RPT_REGISTRY_ID          NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  REGISTRY_TYPE_ID         NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_REGISTRY IS 'ESR reporting table. Allows for reporting to be performed on each of the Registries, namely; Prisoner of War Registry Purple Heart Registry SHAD Registry';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RPT_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTRGSTRY_PK ON ADR.RPT_REGISTRY
(RPT_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTRGSTRY_SCHEDRPT_FK_I ON ADR.RPT_REGISTRY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTRGSTRY_STD_REGTYPE_FK_I ON ADR.RPT_REGISTRY
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_REGISTRY FOR ADR.RPT_REGISTRY;


ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_PK
  PRIMARY KEY
  (RPT_REGISTRY_ID)
  USING INDEX ADR.RPTRGSTRY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_REGISTRY ADD (
  CONSTRAINT RPTRGSTRY_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_REGISTRY TO ADR_RW;
ALTER TABLE ADR.RPT_QUERY_SITE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_QUERY_SITE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_QUERY_SITE
(
  REPORT_QUERY_SITE_ID     NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  ID                       NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_QUERY_SITE IS 'ESR reporting table. Can be used to generate reports showing which site submitted the query';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.REPORT_QUERY_SITE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_QUERY_SITE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTQRYSITE_PK ON ADR.RPT_QUERY_SITE
(REPORT_QUERY_SITE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTQRYSITE_SCHEDRPT_FK_I ON ADR.RPT_QUERY_SITE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTQRYSITE_STDINST_FK_I ON ADR.RPT_QUERY_SITE
(ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_QUERY_SITE FOR ADR.RPT_QUERY_SITE;


ALTER TABLE ADR.RPT_QUERY_SITE ADD (
  CONSTRAINT RPTQRYSITE_PK
  PRIMARY KEY
  (REPORT_QUERY_SITE_ID)
  USING INDEX ADR.RPTQRYSITE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_QUERY_SITE ADD (
  CONSTRAINT RPTQRYSITE_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_QUERY_SITE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_QUERY_SITE TO ADR_RW;
ALTER TABLE ADR.RPT_PRIORITY_GROUP
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_PRIORITY_GROUP CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_PRIORITY_GROUP
(
  RPT_PRIORITY_GROUP_ID       NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  PRIORITY_GROUP_TYPE_ID      NUMBER(20),
  PRIORITY_SUB_GROUP_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_PRIORITY_GROUP IS 'ESR reporting table. Allows for reporting to be performed on each of the priority groups and priority sub-groups.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RPT_PRIORITY_GROUP_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.PRIORITY_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.PRIORITY_SUB_GROUP_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_PRIORITY_GROUP.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTPGRP_STD_ENRLMNTPSGRP_FK_I ON ADR.RPT_PRIORITY_GROUP
(PRIORITY_SUB_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTPRIOGRP_PK ON ADR.RPT_PRIORITY_GROUP
(RPT_PRIORITY_GROUP_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPRIOGRP_PRTYGRP_FK_I ON ADR.RPT_PRIORITY_GROUP
(PRIORITY_GROUP_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPRIOGRP_SCHEDRPT_FK_I ON ADR.RPT_PRIORITY_GROUP
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_PRIORITY_GROUP FOR ADR.RPT_PRIORITY_GROUP;


ALTER TABLE ADR.RPT_PRIORITY_GROUP ADD (
  CONSTRAINT RPTPRIOGRP_PK
  PRIMARY KEY
  (RPT_PRIORITY_GROUP_ID)
  USING INDEX ADR.RPTPRIOGRP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_PRIORITY_GROUP ADD (
  CONSTRAINT RPTPRIOGRP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_PRIORITY_GROUP TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PRIORITY_GROUP TO ADR_RW;
ALTER TABLE ADR.RPT_PH_REJECT_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_PH_REJECT_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_PH_REJECT_REASON
(
  RPT_PH_REJECT_REASON_ID  NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  STD_REJECTEDREMARKS_ID   NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_PH_REJECT_REASON IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RPT_PH_REJECT_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.STD_REJECTEDREMARKS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_PH_REJECT_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTPHRJCT_PK ON ADR.RPT_PH_REJECT_REASON
(RPT_PH_REJECT_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPHRJCT_SCHEDRPT_FK_I ON ADR.RPT_PH_REJECT_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPHRJCT_STDREJRMRK_FK_I ON ADR.RPT_PH_REJECT_REASON
(STD_REJECTEDREMARKS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_PH_REJECT_REASON FOR ADR.RPT_PH_REJECT_REASON;


ALTER TABLE ADR.RPT_PH_REJECT_REASON ADD (
  CONSTRAINT RPTPHRJCT_PK
  PRIMARY KEY
  (RPT_PH_REJECT_REASON_ID)
  USING INDEX ADR.RPTPHRJCT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_PH_REJECT_REASON ADD (
  CONSTRAINT RPTPHRJCT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_PH_REJECT_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PH_REJECT_REASON TO ADR_RW;
ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_PERSON_MERGE_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_PERSON_MERGE_STATUS
(
  RPT_PERSON_MERGE_STATUS_ID  NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  STD_PERSONMERGESTATUS_ID    NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_PERSON_MERGE_STATUS IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RPT_PERSON_MERGE_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_PERSON_MERGE_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTPRSNMRG_PK ON ADR.RPT_PERSON_MERGE_STATUS
(RPT_PERSON_MERGE_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPRSNMRG_SCHEDRPT_FK_I ON ADR.RPT_PERSON_MERGE_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPRSNMRG_STDPRSNMRG_FK_I ON ADR.RPT_PERSON_MERGE_STATUS
(STD_PERSONMERGESTATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_PERSON_MERGE_STATUS FOR ADR.RPT_PERSON_MERGE_STATUS;


ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_PK
  PRIMARY KEY
  (RPT_PERSON_MERGE_STATUS_ID)
  USING INDEX ADR.RPTPRSNMRG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_PERSON_MERGE_STATUS ADD (
  CONSTRAINT RPTPRSNMRG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_PERSON_MERGE_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PERSON_MERGE_STATUS TO ADR_RW;
ALTER TABLE ADR.RPT_PERMISSIONS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_PERMISSIONS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_PERMISSIONS
(
  RPT_PERMISSION_ID      NUMBER(20)             NOT NULL,
  RPT_TYPE_ID            NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_PERMISSIONS IS 'ESR Reporting table Allows the user to see reports based their assigned User Permissions such as: Add Address Information Add Capability Set Add Contact (Excluding Next of Kin) Add EGT Settings Edit Cancel/Decline Enrollment Status Edit Capability Set Edit Contact Information (Excluding Next of Kin) Edit Demographic Information Edit Duplicate Threshold Value';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.RPT_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_PERMISSIONS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTPERM_PK ON ADR.RPT_PERMISSIONS
(RPT_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPERM_STD_PERM_FK_I ON ADR.RPT_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTPERM_STD_RPTTYPE_FK_I ON ADR.RPT_PERMISSIONS
(RPT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_PERMISSIONS FOR ADR.RPT_PERMISSIONS;


ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_PK
  PRIMARY KEY
  (RPT_PERMISSION_ID)
  USING INDEX ADR.RPTPERM_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_PERMISSIONS ADD (
  CONSTRAINT RPTPERM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTPERM_STD_RPTTYPE_FK 
  FOREIGN KEY (RPT_TYPE_ID) 
  REFERENCES ADRREF.STD_REPORTTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_PERMISSIONS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_PERMISSIONS TO ADR_RW;
ALTER TABLE ADR.RPT_MESSAGE_ERROR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_MESSAGE_ERROR CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_MESSAGE_ERROR
(
  RPT_MESSAGE_ERROR_ID     NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  ACK_TYPE_ID              NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_MESSAGE_ERROR IS 'ESR reporting table. Allows reporting on the basis of various HL7 acknowledgement codes such as: Accept Commit Accept Commit Error Commit Reject Error Reject';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RPT_MESSAGE_ERROR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.ACK_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_MESSAGE_ERROR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTMSGERR_PK ON ADR.RPT_MESSAGE_ERROR
(RPT_MESSAGE_ERROR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTMSGERR_SCHEDRPT_FK_I ON ADR.RPT_MESSAGE_ERROR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTMSGERR_STD_MSGTYP_FK_I ON ADR.RPT_MESSAGE_ERROR
(ACK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_MESSAGE_ERROR FOR ADR.RPT_MESSAGE_ERROR;


ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_PK
  PRIMARY KEY
  (RPT_MESSAGE_ERROR_ID)
  USING INDEX ADR.RPTMSGERR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_MESSAGE_ERROR ADD (
  CONSTRAINT RPTMSGERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_MESSAGE_ERROR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_MESSAGE_ERROR TO ADR_RW;
ALTER TABLE ADR.RPT_MESSAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_MESSAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_MESSAGE
(
  RPT_MESSAGE_ID                NUMBER(20)      NOT NULL,
  RPT_SCHEDULED_REPORT_ID       NUMBER(20)      NOT NULL,
  MESSAGE_TRANSMISSION_TYPE_ID  NUMBER(20)      NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_MESSAGE IS 'ESR reporting table. Allows for reporting on the basis of various message transmission types, such as: AAC Communication Request to AAC EDB Financial Query to EDB EDB Communication Address Update to EDB EDB Communication Errors to EDB EDB Communication Rejects to EDB EDB Death to EDB EDB Demographic to EDB EDB Eligibility Solicited to EDB EDB Eligibility or Enrollment Query to EDB EDB Eligibility to EDB EDB Follow Up Insurance Data to EDB EDB Full Data Solicited to EDB EDB Full Data to EDB EDB IVM Billing or Collecting Data to EDB EDB Lazarus Death to EDB EDB MFA EGT Setting to EDB';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RPT_MESSAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.MESSAGE_TRANSMISSION_TYPE_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_MESSAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTMSG_HL7TRANTYP_FK_I ON ADR.RPT_MESSAGE
(MESSAGE_TRANSMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTMSG_PK ON ADR.RPT_MESSAGE
(RPT_MESSAGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTMSG_SCHEDRPT_FK_I ON ADR.RPT_MESSAGE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_MESSAGE FOR ADR.RPT_MESSAGE;


ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_PK
  PRIMARY KEY
  (RPT_MESSAGE_ID)
  USING INDEX ADR.RPTMSG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_MESSAGE ADD (
  CONSTRAINT RPTMSG_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_MESSAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_MESSAGE TO ADR_RW;
ALTER TABLE ADR.RPT_LETTER_FILE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_LETTER_FILE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_LETTER_FILE
(
  RPT_LETTER_FILE_ID       NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  RPT_LETTER_FILE_TYPE_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_LETTER_FILE IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RPT_LETTER_FILE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_LETTER_FILE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTLTRFLTP_PK ON ADR.RPT_LETTER_FILE
(RPT_LETTER_FILE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTLTRFLTP_RPTLTRFILE_FK_I ON ADR.RPT_LETTER_FILE
(RPT_LETTER_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTLTRFLTP_SCHEDRPT_FK_I ON ADR.RPT_LETTER_FILE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_LETTER_FILE FOR ADR.RPT_LETTER_FILE;


ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_PK
  PRIMARY KEY
  (RPT_LETTER_FILE_ID)
  USING INDEX ADR.RPTLTRFLTP_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_LETTER_FILE ADD (
  CONSTRAINT RPTLTRFLTP_RPTLTRFILE_FK 
  FOREIGN KEY (RPT_LETTER_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTLETTERFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTLTRFLTP_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_LETTER_FILE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_LETTER_FILE TO ADR_RW;
ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_INVALID_ADDRESS_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_INVALID_ADDRESS_REASON
(
  RPT_INVALID_ADDRESS_REASON_ID  NUMBER(20)     NOT NULL,
  RPT_SCHEDULED_REPORT_ID        NUMBER(20)     NOT NULL,
  ADDRESS_INVALID_TYPE_ID        NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_INVALID_ADDRESS_REASON IS 'ESR reporting table. Provides for reporting on the basis of various invalid address reasons: Mail was returned or is otherwise known to be undeliverable Veteran has no known address';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RPT_INVALID_ADDRESS_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.ADDRESS_INVALID_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_INVALID_ADDRESS_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTINVADDR_ADDRINVTYP_FK_I ON ADR.RPT_INVALID_ADDRESS_REASON
(ADDRESS_INVALID_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTINVADDR_PK ON ADR.RPT_INVALID_ADDRESS_REASON
(RPT_INVALID_ADDRESS_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTINVADDR_SCHEDRPT_FK_I ON ADR.RPT_INVALID_ADDRESS_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_INVALID_ADDRESS_REASON FOR ADR.RPT_INVALID_ADDRESS_REASON;


ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_PK
  PRIMARY KEY
  (RPT_INVALID_ADDRESS_REASON_ID)
  USING INDEX ADR.RPTINVADDR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_INVALID_ADDRESS_REASON ADD (
  CONSTRAINT RPTINVADDR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_INVALID_ADDRESS_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_INVALID_ADDRESS_REASON TO ADR_RW;
ALTER TABLE ADR.RPT_FORM_TYPE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_FORM_TYPE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_FORM_TYPE
(
  RPT_FORM_TYPE_ID         NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  ENROLLMENT_FORM_TYPE_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE INDEX ADR.ENROL_FORM_TYP_RPT_FORM_TYP_FK ON ADR.RPT_FORM_TYPE
(ENROLLMENT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RPT_SCHED_REP_RPT_FORM_TYP ON ADR.RPT_FORM_TYPE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPT_FORM_TYPE_ID_PK ON ADR.RPT_FORM_TYPE
(RPT_FORM_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_FORM_TYPE FOR ADR.RPT_FORM_TYPE;


ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT RPT_FORM_TYPE_ID_PK
  PRIMARY KEY
  (RPT_FORM_TYPE_ID)
  USING INDEX ADR.RPT_FORM_TYPE_ID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_FORM_TYPE ADD (
  CONSTRAINT ENRL_FORM_TYP_RPT_FORM_TYP_FK 
  FOREIGN KEY (ENROLLMENT_FORM_TYPE_ID) 
  REFERENCES VOA.ENROLLMENT_FORM_TYPE (ENROLLMENT_FORM_TYPE_ID)
  ENABLE VALIDATE,
  CONSTRAINT RPT_SCHED_REP_RPT_FORM_TYP 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_FORM_TYPE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_FORM_TYPE TO ADR_RW;
ALTER TABLE ADR.RPT_ENROLLMENT_STATUS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ENROLLMENT_STATUS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ENROLLMENT_STATUS
(
  RPT_ENROLLMENT_STATUS_ID  NUMBER(20)          NOT NULL,
  RPT_SCHEDULED_REPORT_ID   NUMBER(20)          NOT NULL,
  STD_ENROLLMENTSTATUS_ID   NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ENROLLMENT_STATUS IS 'ESR Reporting table: Provides reporting based on the following enrollment status: Unverified Verified Deceased Cancelled/Declined Rejected; Initial Application by VAMC Pending; No Eligibility Code Pending; Means Test Required Pending; Eligibility Status is Unverified Pending; Other Not Eligible; Refused to Pay Copay Not Eligible; Ineligible Date';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RPT_ENROLLMENT_STATUS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_STATUS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTENRSTAT_ENRLMTSTAT_FK_I ON ADR.RPT_ENROLLMENT_STATUS
(STD_ENROLLMENTSTATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTENRSTAT_PK ON ADR.RPT_ENROLLMENT_STATUS
(RPT_ENROLLMENT_STATUS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENRSTAT_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_STATUS
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ENROLLMENT_STATUS FOR ADR.RPT_ENROLLMENT_STATUS;


ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_STATUS_ID)
  USING INDEX ADR.RPTENRSTAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ENROLLMENT_STATUS ADD (
  CONSTRAINT RPTENRSTAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ENROLLMENT_STATUS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_STATUS TO ADR_RW;
ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ENROLLMENT_OVERRIDE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ENROLLMENT_OVERRIDE
(
  RPT_ENROLLMENT_OVERRIDE_ID  NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  STD_ENRLOVERRIDEREASON_ID   NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ENROLLMENT_OVERRIDE IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RPT_ENROLLMENT_OVERRIDE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_OVERRIDE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTENROVER_PK ON ADR.RPT_ENROLLMENT_OVERRIDE
(RPT_ENROLLMENT_OVERRIDE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENROVER_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_OVERRIDE
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENROVER_STDENROVRD_FK_I ON ADR.RPT_ENROLLMENT_OVERRIDE
(STD_ENRLOVERRIDEREASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ENROLLMENT_OVERRIDE FOR ADR.RPT_ENROLLMENT_OVERRIDE;


ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_OVERRIDE_ID)
  USING INDEX ADR.RPTENROVER_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ENROLLMENT_OVERRIDE ADD (
  CONSTRAINT RPTENROVER_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ENROLLMENT_OVERRIDE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_OVERRIDE TO ADR_RW;
ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ENROLLMENT_CATEGORY CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ENROLLMENT_CATEGORY
(
  RPT_ENROLLMENT_CATEGORY_ID  NUMBER(20)        NOT NULL,
  RPT_SCHEDULED_REPORT_ID     NUMBER(20)        NOT NULL,
  STD_ENROLLMENTCATTYPE_ID    NUMBER(20)        NOT NULL,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ENROLLMENT_CATEGORY IS 'ESR Reporting table. Enrollment Category reports for category types such as: Enrolled In-Process Not Enrolled';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RPT_ENROLLMENT_CATEGORY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ENROLLMENT_CATEGORY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTENRLCAT_PK ON ADR.RPT_ENROLLMENT_CATEGORY
(RPT_ENROLLMENT_CATEGORY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENRLCAT_SCHEDRPT_FK_I ON ADR.RPT_ENROLLMENT_CATEGORY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTENRLCAT_STD_ENRLMNTCAT_FK_I ON ADR.RPT_ENROLLMENT_CATEGORY
(STD_ENROLLMENTCATTYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ENROLLMENT_CATEGORY FOR ADR.RPT_ENROLLMENT_CATEGORY;


ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_PK
  PRIMARY KEY
  (RPT_ENROLLMENT_CATEGORY_ID)
  USING INDEX ADR.RPTENRLCAT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ENROLLMENT_CATEGORY ADD (
  CONSTRAINT RPTENRLCAT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ENROLLMENT_CATEGORY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ENROLLMENT_CATEGORY TO ADR_RW;
ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_ELIGIBILITY_FACTOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_ELIGIBILITY_FACTOR
(
  RPT_ELIGIBILITY_FACTOR_ID  NUMBER(20)         NOT NULL,
  RPT_SCHEDULED_REPORT_ID    NUMBER(20)         NOT NULL,
  STD_REPORTELIGFACTOR_ID    NUMBER(20)         NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_ELIGIBILITY_FACTOR IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RPT_ELIGIBILITY_FACTOR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_ELIGIBILITY_FACTOR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTELGFCTR_PK ON ADR.RPT_ELIGIBILITY_FACTOR
(RPT_ELIGIBILITY_FACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTELGFCTR_SCHEDRPT_FK_I ON ADR.RPT_ELIGIBILITY_FACTOR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTELGFCTR_STDRPTELGF_FK_I ON ADR.RPT_ELIGIBILITY_FACTOR
(STD_REPORTELIGFACTOR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_ELIGIBILITY_FACTOR FOR ADR.RPT_ELIGIBILITY_FACTOR;


ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_PK
  PRIMARY KEY
  (RPT_ELIGIBILITY_FACTOR_ID)
  USING INDEX ADR.RPTELGFCTR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_ELIGIBILITY_FACTOR ADD (
  CONSTRAINT RPTELGFCTR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTELGFCTR_STDRPTELGF_FK 
  FOREIGN KEY (STD_REPORTELIGFACTOR_ID) 
  REFERENCES ADRREF.STD_REPORTELIGFACTOR (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_ELIGIBILITY_FACTOR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_ELIGIBILITY_FACTOR TO ADR_RW;
ALTER TABLE ADR.RPT_EED_WEEKLY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_EED_WEEKLY CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_EED_WEEKLY
(
  RPT_EED_WEEKLY_ID        NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  RPT_EED_WEEKLY_TYPE_ID   NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_EED_WEEKLY IS 'ESR Reporting table, containing list of weekly reports Purple Heart Statistics Address Statistics from AAC Enrollment Letters from AAC';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RPT_EED_WEEKLY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_EED_WEEKLY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTEEDWKLY_PK ON ADR.RPT_EED_WEEKLY
(RPT_EED_WEEKLY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTEWK_SCHEDRPT_FK_I ON ADR.RPT_EED_WEEKLY
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTEWK_STD_EEDWKLYTYP_FK_I ON ADR.RPT_EED_WEEKLY
(RPT_EED_WEEKLY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_EED_WEEKLY FOR ADR.RPT_EED_WEEKLY;


ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEEDWKLY_PK
  PRIMARY KEY
  (RPT_EED_WEEKLY_ID)
  USING INDEX ADR.RPTEEDWKLY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_EED_WEEKLY ADD (
  CONSTRAINT RPTEWK_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTEWK_STD_EEDWKLYTYP_FK 
  FOREIGN KEY (RPT_EED_WEEKLY_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEEDWEEKLYTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_EED_WEEKLY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_EED_WEEKLY TO ADR_RW;
ALTER TABLE ADR.RPT_DAY_OF_WEEK
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_DAY_OF_WEEK CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_DAY_OF_WEEK
(
  RPT_DAY_OF_WEEK_ID       NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  RPT_DAY_OF_WEEK_TYPE_ID  NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_DAY_OF_WEEK IS 'ESR reporting table. Contains the RPT_SCHEDULED_REPORT_ID as well as the day of week that the report is scheduled to run';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RPT_DAY_OF_WEEK_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_DAY_OF_WEEK.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RPTDAYOFWK_PK ON ADR.RPT_DAY_OF_WEEK
(RPT_DAY_OF_WEEK_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTDAYOFWK_SCHEDRPT_FK_I ON ADR.RPT_DAY_OF_WEEK
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTDOWK_STD_RPTDYWKTYP_FK_I ON ADR.RPT_DAY_OF_WEEK
(RPT_DAY_OF_WEEK_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_DAY_OF_WEEK FOR ADR.RPT_DAY_OF_WEEK;


ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDAYOFWK_PK
  PRIMARY KEY
  (RPT_DAY_OF_WEEK_ID)
  USING INDEX ADR.RPTDAYOFWK_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_DAY_OF_WEEK ADD (
  CONSTRAINT RPTDAYOFWK_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTDOWK_STD_RPTDYWKTYP_FK 
  FOREIGN KEY (RPT_DAY_OF_WEEK_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTDAYOFWEEKTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_DAY_OF_WEEK TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_DAY_OF_WEEK TO ADR_RW;
ALTER TABLE ADR.RPT_COM_REJECT_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_COM_REJECT_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_COM_REJECT_REASON
(
  RPT_COM_REJECT_REASON_ID       NUMBER(20)     NOT NULL,
  RPT_SCHEDULED_REPORT_ID        NUMBER(20)     NOT NULL,
  COM_AAC_REJECT_REASON_TYPE_ID  NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_COM_REJECT_REASON IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RPT_COM_REJECT_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_COM_REJECT_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTCOMRJCT_COMAACRJCT_FK_I ON ADR.RPT_COM_REJECT_REASON
(COM_AAC_REJECT_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTCOMRJCT_PK ON ADR.RPT_COM_REJECT_REASON
(RPT_COM_REJECT_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTCOMRJCT_SCHEDRPT_FK_I ON ADR.RPT_COM_REJECT_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_COM_REJECT_REASON FOR ADR.RPT_COM_REJECT_REASON;


ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_PK
  PRIMARY KEY
  (RPT_COM_REJECT_REASON_ID)
  USING INDEX ADR.RPTCOMRJCT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_COM_REJECT_REASON ADD (
  CONSTRAINT RPTCOMRJCT_COMAACRJCT_FK 
  FOREIGN KEY (COM_AAC_REJECT_REASON_TYPE_ID) 
  REFERENCES ADRREF.STD_COMREJECTREASONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTCOMRJCT_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_COM_REJECT_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COM_REJECT_REASON TO ADR_RW;
ALTER TABLE ADR.RPT_COM_ERROR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_COM_ERROR CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_COM_ERROR
(
  RPT_COM_ERROR_ID         NUMBER(20)           NOT NULL,
  RPT_SCHEDULED_REPORT_ID  NUMBER(20)           NOT NULL,
  COM_AAC_ERROR_TYPE_ID    NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_COM_ERROR IS 'ESR reporting table. Reports can be run in order to track the various Purple Heart reject reasons such as: Entered In Error No Document Received Unacceptable Documentation Undeliverable Mail Unsupported Purple Heart VAMC';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RPT_COM_ERROR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_COM_ERROR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTCOMERR_COMERRTYP_FK_I ON ADR.RPT_COM_ERROR
(COM_AAC_ERROR_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTCOMERR_PK ON ADR.RPT_COM_ERROR
(RPT_COM_ERROR_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTCOMERR_SCHEDRPT_FK_I ON ADR.RPT_COM_ERROR
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_COM_ERROR FOR ADR.RPT_COM_ERROR;


ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_PK
  PRIMARY KEY
  (RPT_COM_ERROR_ID)
  USING INDEX ADR.RPTCOMERR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_COM_ERROR ADD (
  CONSTRAINT RPTCOMERR_COMERRTYP_FK 
  FOREIGN KEY (COM_AAC_ERROR_TYPE_ID) 
  REFERENCES ADRREF.STD_COMMERRORTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RPTCOMERR_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_COM_ERROR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COM_ERROR TO ADR_RW;
ALTER TABLE ADR.RPT_COMPLETED_REPORTS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_COMPLETED_REPORTS CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_COMPLETED_REPORTS
(
  RPT_COMPLETED_REPORT_ID  NUMBER(20)           NOT NULL,
  RPT_STANDARD_REPORT_ID   NUMBER(20),
  RPT_OUTPUT_FILE_TYPE_ID  NUMBER(20)           NOT NULL,
  USERID                   NUMBER(20),
  REPORT_COMPLETED_DATE    DATE,
  REPORT_PARAMETER_TXT     VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL,
  REPORT_OUTPUT_DATA       BLOB,
  INACTIVATED_DATE         DATE
)
LOB (REPORT_OUTPUT_DATA) STORE AS (
  TABLESPACE  M_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_COMPLETED_REPORTS IS 'ESR reporting table. Contains the RPT_SCHEDULED_REPORT_ID as well as the date when report was completed';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RPT_COMPLETED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RPT_STANDARD_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.USERID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.REPORT_COMPLETED_DATE IS 'Datethatthereportrun wascompleted';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.REPORT_PARAMETER_TXT IS 'TEXTfieldthatcontains theparametersusedfor buildingthereport';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.RPT_COMPLETED_REPORTS.REPORT_OUTPUT_DATA IS 'CLOBfieldthatcontains theoutputofthereport';


CREATE INDEX ADR.CMPRPT_USER_1_FK_I ON ADR.RPT_COMPLETED_REPORTS
(USERID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMRPT_STD_RPTOUTFILE_FK_I ON ADR.RPT_COMPLETED_REPORTS
(RPT_OUTPUT_FILE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.CMRPT_STD_RPTSTDRPT_FK_I ON ADR.RPT_COMPLETED_REPORTS
(RPT_STANDARD_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.COMPRPT_PK ON ADR.RPT_COMPLETED_REPORTS
(RPT_COMPLETED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_COMPLETED_REPORTS FOR ADR.RPT_COMPLETED_REPORTS;


ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT COMPRPT_PK
  PRIMARY KEY
  (RPT_COMPLETED_REPORT_ID)
  USING INDEX ADR.COMPRPT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_COMPLETED_REPORTS ADD (
  CONSTRAINT CMPRPT_USER_1_FK 
  FOREIGN KEY (USERID) 
  REFERENCES ADR.USERS (USERID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT CMRPT_STD_RPTOUTFILE_FK 
  FOREIGN KEY (RPT_OUTPUT_FILE_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTOUTPUTFILETYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT CMRPT_STD_RPTSTDRPT_FK 
  FOREIGN KEY (RPT_STANDARD_REPORT_ID) 
  REFERENCES ADRREF.STD_RPTSTANDARDREPORTS (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_COMPLETED_REPORTS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_COMPLETED_REPORTS TO ADR_RW;
ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RPT_CANCEL_DECLINE_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.RPT_CANCEL_DECLINE_REASON
(
  RPT_CANCEL_DECLINE_REASON_ID   NUMBER(20)     NOT NULL,
  RPT_SCHEDULED_REPORT_ID        NUMBER(20)     NOT NULL,
  CANCEL_DECLINE_REASON_TYPE_ID  NUMBER(20)     NOT NULL,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RPT_CANCEL_DECLINE_REASON IS 'ESR reporting table. Contains the RPT_SCHEDULED_REPORT_ID and the cancel / decline reason type id.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RPT_CANCEL_DECLINE_REASON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RPT_SCHEDULED_REPORT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.CANCEL_DECLINE_REASON_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RPT_CANCEL_DECLINE_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RPTCANDECL_CANDCLNRSN_FK_I ON ADR.RPT_CANCEL_DECLINE_REASON
(CANCEL_DECLINE_REASON_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RPTCANDECL_PK ON ADR.RPT_CANCEL_DECLINE_REASON
(RPT_CANCEL_DECLINE_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RPTCANDECL_SCHEDRPT_FK_I ON ADR.RPT_CANCEL_DECLINE_REASON
(RPT_SCHEDULED_REPORT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RPT_CANCEL_DECLINE_REASON FOR ADR.RPT_CANCEL_DECLINE_REASON;


ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_PK
  PRIMARY KEY
  (RPT_CANCEL_DECLINE_REASON_ID)
  USING INDEX ADR.RPTCANDECL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RPT_CANCEL_DECLINE_REASON ADD (
  CONSTRAINT RPTCANDECL_SCHEDRPT_FK 
  FOREIGN KEY (RPT_SCHEDULED_REPORT_ID) 
  REFERENCES ADR.RPT_SCHEDULED_REPORTS (RPT_SCHEDULED_REPORT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RPT_CANCEL_DECLINE_REASON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RPT_CANCEL_DECLINE_REASON TO ADR_RW;
ALTER TABLE ADR.ROLE_PERMISSION_SETS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLE_PERMISSION_SETS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLE_PERMISSION_SETS_H
(
  ROLE_PERMISSION_SET_H_ID  NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  ROLE_PERMISSION_SET_ID    NUMBER(20)          NOT NULL,
  ROLE_ID                   NUMBER(20)          NOT NULL,
  PERMISSION_SET_ID         NUMBER(20)          NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLE_PERMISSION_SETS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.ROLE_PERMISSION_SET_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.ROLE_PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLEPRMSTH_PK ON ADR.ROLE_PERMISSION_SETS_H
(ROLE_PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ROLE_PERMISSION_SETS_H FOR ADR.ROLE_PERMISSION_SETS_H;


ALTER TABLE ADR.ROLE_PERMISSION_SETS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_060
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ROLEPRMSTH_PK
  PRIMARY KEY
  (ROLE_PERMISSION_SET_H_ID)
  USING INDEX ADR.ROLEPRMSTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLE_PERMISSION_SETS_H TO ADR_R;

GRANT SELECT ON ADR.ROLE_PERMISSION_SETS_H TO ADR_RW;
ALTER TABLE ADR.ROLE_PERMISSION_SETS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLE_PERMISSION_SETS CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLE_PERMISSION_SETS
(
  ROLE_PERMISSION_SET_ID  NUMBER(20)            NOT NULL,
  PERMISSION_SET_ID       NUMBER(20)            NOT NULL,
  ROLE_ID                 NUMBER(20)            NOT NULL,
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLE_PERMISSION_SETS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.ROLE_PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLE_PERMISSION_SETS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.ROLEPERMST_PERMSET_FK_I ON ADR.ROLE_PERMISSION_SETS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ROLEPERMST_PK ON ADR.ROLE_PERMISSION_SETS
(ROLE_PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ROLEPERMST_ROLE_FK_I ON ADR.ROLE_PERMISSION_SETS
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ROLE_PERM_SET_audir_trgr
after Update or Delete or Insert
ON ADR.ROLE_PERMISSION_SETS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLE_PERMISSION_SETS_H
		(
		ROLE_PERMISSION_SET_H_ID,
		ROLE_PERMISSION_SET_ID,
		ROLE_ID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSION_SETS_H_S.nextval,
		:old.ROLE_PERMISSION_SET_ID,
		:old.ROLE_ID,
		:old.PERMISSION_SET_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLE_PERMISSION_SETS_H
		(
		ROLE_PERMISSION_SET_H_ID,
		ROLE_PERMISSION_SET_ID,
		ROLE_ID,
		PERMISSION_SET_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSION_SETS_H_S.nextval,
		:new.ROLE_PERMISSION_SET_ID,
		:new.ROLE_ID,
		:new.PERMISSION_SET_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLE_PERM_SET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ROLE_PERMISSION_SETS FOR ADR.ROLE_PERMISSION_SETS;


ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_PK
  PRIMARY KEY
  (ROLE_PERMISSION_SET_ID)
  USING INDEX ADR.ROLEPERMST_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ROLE_PERMISSION_SETS ADD (
  CONSTRAINT ROLEPERMST_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT ROLEPERMST_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLE_PERMISSION_SETS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLE_PERMISSION_SETS TO ADR_RW;
ALTER TABLE ADR.ROLE_PERMISSIONS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLE_PERMISSIONS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLE_PERMISSIONS_H
(
  ROLE_PERMISSIONS_H_ID  NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  ROLE_PERMISSION_ID     NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLE_PERMISSIONS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.ROLE_PERMISSIONS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.ROLE_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLEPRMSH_PK ON ADR.ROLE_PERMISSIONS_H
(ROLE_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ROLE_PERMISSIONS_H FOR ADR.ROLE_PERMISSIONS_H;


ALTER TABLE ADR.ROLE_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_048
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ROLEPRMSH_PK
  PRIMARY KEY
  (ROLE_PERMISSIONS_H_ID)
  USING INDEX ADR.ROLEPRMSH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ADR_R;

GRANT SELECT ON ADR.ROLE_PERMISSIONS_H TO ADR_RW;
ALTER TABLE ADR.ROLE_PERMISSIONS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLE_PERMISSIONS CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLE_PERMISSIONS
(
  ROLE_PERMISSION_ID     NUMBER(20)             NOT NULL,
  PERMISSION_TYPE_ID     NUMBER(20)             NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLE_PERMISSIONS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.ROLE_PERMISSION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLE_PERMISSIONS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLEPERMS_PK ON ADR.ROLE_PERMISSIONS
(ROLE_PERMISSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ROLEPERMS_ROLE_FK_I ON ADR.ROLE_PERMISSIONS
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.ROLEPERMS_STD_PERM_FK_I ON ADR.ROLE_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ROLE_PERMSSN_audir_trgr
after Update or Delete or Insert
ON ADR.ROLE_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLE_PERMISSIONS_H
		(
		ROLE_PERMISSIONS_H_ID,
		ROLE_PERMISSION_ID,
		ROLE_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSIONS_H_S.nextval,
		:old.ROLE_PERMISSION_ID,
		:old.ROLE_ID,
		:old.PERMISSION_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLE_PERMISSIONS_H
		(
		ROLE_PERMISSIONS_H_ID,
		ROLE_PERMISSION_ID,
		ROLE_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLE_PERMISSIONS_H_S.nextval,
		:new.ROLE_PERMISSION_ID,
		:new.ROLE_ID,
		:new.PERMISSION_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLE_PERMSSN_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ROLE_PERMISSIONS FOR ADR.ROLE_PERMISSIONS;


ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_PK
  PRIMARY KEY
  (ROLE_PERMISSION_ID)
  USING INDEX ADR.ROLEPERMS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.ROLE_PERMISSIONS ADD (
  CONSTRAINT ROLEPERMS_ROLE_FK 
  FOREIGN KEY (ROLE_ID) 
  REFERENCES ADR.ROLES (ROLE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT ROLEPERMS_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLE_PERMISSIONS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLE_PERMISSIONS TO ADR_RW;
ALTER TABLE ADR.ROLES_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLES_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLES_H
(
  ROLES_H_ID             NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  ROLE_ID                NUMBER(20)             NOT NULL,
  ROLE_NAME              VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  SORT_ORDER             NUMBER(6)              DEFAULT 0,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL,
  ACTIVE_DATE            DATE
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLES_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.ROLES_H.ROLES_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.ROLES_H.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLES_H.ROLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLES_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLESH_PK ON ADR.ROLES_H
(ROLES_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM ROLES_H FOR ADR.ROLES_H;


ALTER TABLE ADR.ROLES_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_050
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT ROLESH_PK
  PRIMARY KEY
  (ROLES_H_ID)
  USING INDEX ADR.ROLESH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLES_H TO ADR_R;

GRANT SELECT ON ADR.ROLES_H TO ADR_RW;

GRANT SELECT ON ADR.ROLES_H TO CARUSR_R;
ALTER TABLE ADR.ROLES
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.ROLES CASCADE CONSTRAINTS;

CREATE TABLE ADR.ROLES
(
  ROLE_ID                NUMBER(20)             NOT NULL,
  ROLE_NAME              VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  SORT_ORDER             NUMBER(6)              DEFAULT 0,
  INACTIVE_FLAG          NUMBER(1)              DEFAULT 0                     NOT NULL,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL,
  ACTIVE_DATE            DATE
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.ROLES IS 'The table is a application administration table that is used to designate a role for a particular user.';

COMMENT ON COLUMN ADR.ROLES.ROLE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.ROLES.ROLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.DESCRIPTION IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.SORT_ORDER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.INACTIVE_FLAG IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.ROLES.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.ROLES.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.ROLES.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.ROLES.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.ROLES.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.ROLE_PK ON ADR.ROLES
(ROLE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.ROLE_U_CODE_UK ON ADR.ROLES
(ROLE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.ROLES_audir_trgr
after Update or Delete or Insert
ON ADR.ROLES
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into ROLES_H
		(
		ROLES_H_ID,
		ROLE_ID,
		ROLE_NAME,
		DESCRIPTION,
		SORT_ORDER,
		ACTIVE_DATE,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLES_H_S.nextval,
		:old.ROLE_ID,
		:old.ROLE_NAME,
		:old.DESCRIPTION,
		:old.SORT_ORDER,
		:old.ACTIVE_DATE,
		:old.INACTIVE_FLAG,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into ROLES_H
		(
		ROLES_H_ID,
		ROLE_ID,
		ROLE_NAME,
		DESCRIPTION,
		SORT_ORDER,
		ACTIVE_DATE,
		INACTIVE_FLAG,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		ROLES_H_S.nextval,
		:new.ROLE_ID,
		:new.ROLE_NAME,
		:new.DESCRIPTION,
		:new.SORT_ORDER,
		:new.ACTIVE_DATE,
		:new.INACTIVE_FLAG,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end ROLES_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM ROLES FOR ADR.ROLES;


ALTER TABLE ADR.ROLES ADD (
  CONSTRAINT AVCON_1172521913_INACT_063
  CHECK (INACTIVE_FLAG BETWEEN 0 AND 0 OR INACTIVE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT ROLE_PK
  PRIMARY KEY
  (ROLE_ID)
  USING INDEX ADR.ROLE_PK
  ENABLE VALIDATE,
  CONSTRAINT ROLE_U_CODE_UK
  UNIQUE (ROLE_NAME)
  USING INDEX ADR.ROLE_U_CODE_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.ROLES TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.ROLES TO ADR_RW;

GRANT SELECT ON ADR.ROLES TO CARUSR_R;

GRANT SELECT ON ADR.ROLES TO IAM_R;

GRANT SELECT ON ADR.ROLES TO IAM_RW;
ALTER TABLE ADR.RELAXATION_PERCENTAGE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RELAXATION_PERCENTAGE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.RELAXATION_PERCENTAGE_H
(
  RELAXATION_PERCENTAGE_H_ID  NUMBER(20)        NOT NULL,
  RELAXATION_PERCENTAGE_ID    NUMBER(20)        NOT NULL,
  RELAXATION_PERCENTAGE       NUMBER            NOT NULL,
  START_DATE                  DATE,
  END_DATE                    DATE,
  INCOME_YEAR                 NUMBER(4)         DEFAULT 1,
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL,
  HISTORY_CREATED_DATE        DATE,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RELAXATION_PERCENTAGE_H IS 'The percentage to relax veterans healthcare eligibility threshold for an income year. ';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RELAXATION_PERCENTAGE_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RELAXATION_PERCENTAGE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RELAXATION_PERCENTAGE IS 'Percentage to relax the eligibility criteria.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.START_DATE IS 'Start of effective period.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.END_DATE IS 'End of effective period.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.INCOME_YEAR IS 'Applicatble income year';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RECORD_CREATED_DATE IS 'DATE the record was created.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RECORD_MODIFIED_DATE IS 'DATE of this modification to the record.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE_H.HISTORY_CREATED_DATE IS 'DATE history record created.';


CREATE INDEX ADR.RLXHINCYR_I ON ADR.RELAXATION_PERCENTAGE_H
(INCOME_YEAR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RLXPCTH_PK ON ADR.RELAXATION_PERCENTAGE_H
(RELAXATION_PERCENTAGE_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RELAXATION_PERCENTAGE_H FOR ADR.RELAXATION_PERCENTAGE_H;


ALTER TABLE ADR.RELAXATION_PERCENTAGE_H ADD (
  CONSTRAINT RLXPCTH_PK
  PRIMARY KEY
  (RELAXATION_PERCENTAGE_H_ID)
  USING INDEX ADR.RLXPCTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RELAXATION_PERCENTAGE_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.RELAXATION_PERCENTAGE_H TO ADR_RW;
ALTER TABLE ADR.RELAXATION_PERCENTAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RELAXATION_PERCENTAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.RELAXATION_PERCENTAGE
(
  RELAXATION_PERCENTAGE_ID  NUMBER(20)          NOT NULL,
  RELAXATION_PERCENTAGE     NUMBER              NOT NULL,
  START_DATE                DATE,
  END_DATE                  DATE,
  INCOME_YEAR               NUMBER(4)           DEFAULT 1,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RELAXATION_PERCENTAGE IS 'The percentage to relax veterans healthcare eligibility threshold for an income year. ';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RELAXATION_PERCENTAGE_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RELAXATION_PERCENTAGE IS 'Percentage to relax the eligibility criteria.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.START_DATE IS 'Start of effective period.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.END_DATE IS 'End of effective period.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.INCOME_YEAR IS 'Applicatble income year';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RECORD_CREATED_DATE IS 'DATE the record was created.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RECORD_MODIFIED_DATE IS 'DATE of this modification to the record.';

COMMENT ON COLUMN ADR.RELAXATION_PERCENTAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.RLXINCYR_I ON ADR.RELAXATION_PERCENTAGE
(INCOME_YEAR)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RLXPCT_PK ON ADR.RELAXATION_PERCENTAGE
(RELAXATION_PERCENTAGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.RELAXATION_PCT_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.RELAXATION_PERCENTAGE  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into RELAXATION_PERCENTAGE_H
        (
        RELAXATION_PERCENTAGE_H_ID,
        RELAXATION_PERCENTAGE_ID,
        RELAXATION_PERCENTAGE,
        START_DATE,
        END_DATE,
        INCOME_YEAR,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        RELAXATION_PERCENTAGE_H_S.nextval,
        :old.RELAXATION_PERCENTAGE_ID,
        :old.RELAXATION_PERCENTAGE,
        :old.START_DATE,
        :old.END_DATE,
        :old.INCOME_YEAR,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into RELAXATION_PERCENTAGE_H
        (
        RELAXATION_PERCENTAGE_H_ID,
        RELAXATION_PERCENTAGE_ID,
        RELAXATION_PERCENTAGE,
        START_DATE,
        END_DATE,
        INCOME_YEAR,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        RELAXATION_PERCENTAGE_H_S.nextval,
        :new.RELAXATION_PERCENTAGE_ID,
        :new.RELAXATION_PERCENTAGE,
        :new.START_DATE,
        :new.END_DATE,
        :new.INCOME_YEAR,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end;
/


CREATE OR REPLACE PUBLIC SYNONYM RELAXATION_PERCENTAGE FOR ADR.RELAXATION_PERCENTAGE;


ALTER TABLE ADR.RELAXATION_PERCENTAGE ADD (
  CONSTRAINT RLXPCT_PK
  PRIMARY KEY
  (RELAXATION_PERCENTAGE_ID)
  USING INDEX ADR.RLXPCT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RELAXATION_PERCENTAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RELAXATION_PERCENTAGE TO ADR_RW;
ALTER TABLE ADR.REGISTRY_TRAIT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_TRAIT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_TRAIT_H
(
  REGISTRY_TRAIT_H_ID    NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  REGISTRY_TRAIT_ID      NUMBER(20),
  REGISTRY_TYPE_ID       NUMBER(20),
  SSN                    VARCHAR2(20 BYTE),
  PREFIX                 VARCHAR2(12 BYTE),
  FIRST_NAME             VARCHAR2(30 BYTE),
  MIDDLE_NAME            VARCHAR2(30 BYTE),
  LAST_NAME              VARCHAR2(40 BYTE),
  SUFFIX                 VARCHAR2(12 BYTE),
  EDUCATIONAL_DEGREE     VARCHAR2(30 BYTE),
  DEATH_DATE_TXT         VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_TRAIT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.REGISTRY_TRAIT_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.REGTRAITH_PK ON ADR.REGISTRY_TRAIT_H
(REGISTRY_TRAIT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAITH_REGTRAIT_NU_I ON ADR.REGISTRY_TRAIT_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TRAIT_H FOR ADR.REGISTRY_TRAIT_H;


ALTER TABLE ADR.REGISTRY_TRAIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_040
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT REGTRAITH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_H_ID)
  USING INDEX ADR.REGTRAITH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ADR_R;

GRANT SELECT ON ADR.REGISTRY_TRAIT_H TO ADR_RW;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_TRAIT_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_TRAIT_DETAIL_H
(
  REGISTRY_TRAIT_DETAIL_H_ID  NUMBER(20)        NOT NULL,
  TRANSACTION_TYPE_CODE       VARCHAR2(1 BYTE)  NOT NULL,
  REGISTRY_TRAIT_DETAIL_ID    NUMBER(20),
  REGISTRY_TRAIT_ID           NUMBER(20),
  MILITARY_SERVICE_NUMBER     VARCHAR2(20 BYTE),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_TRAIT_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.REGISTRY_TRAIT_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.REGISTRY_TRAIT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.MILITARY_SERVICE_NUMBER IS 'MilitaryServiceNumber isaUniqueidentifier providedtoapersonby thebranchofthe militarywithwhichheor sheserved.Itisdefined astheservicenumber assignedduringthe veteransepisodesof militaryservice.The socialsecuritynumber andservicenumbercanbe thesame.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.REGTRAIDTH_PK ON ADR.REGISTRY_TRAIT_DETAIL_H
(REGISTRY_TRAIT_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAITDTH_REGTRAIT_NU_I ON ADR.REGISTRY_TRAIT_DETAIL_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TRAIT_DETAIL_H FOR ADR.REGISTRY_TRAIT_DETAIL_H;


ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_073
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT REGTRAIDTH_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_DETAIL_H_ID)
  USING INDEX ADR.REGTRAIDTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_TRAIT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_TRAIT_DETAIL
(
  REGISTRY_TRAIT_DETAIL_ID  NUMBER(20)          NOT NULL,
  REGISTRY_TRAIT_ID         NUMBER(20)          NOT NULL,
  MILITARY_SERVICE_NUMBER   VARCHAR2(20 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_TRAIT_DETAIL IS 'Contains the Military Service Number - this is required in cases where the veteran has rejoined the military after having been discharger';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.REGISTRY_TRAIT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.MILITARY_SERVICE_NUMBER IS 'MilitaryServiceNumber isaUniqueidentifier providedtoapersonby thebranchofthe militarywithwhichheor sheserved.Itisdefined astheservicenumber assignedduringthe veteransepisodesof militaryservice.The socialsecuritynumber andservicenumbercanbe thesame.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.REGTRAITDTL_MILSVCNBR_FB_I ON ADR.REGISTRY_TRAIT_DETAIL
(UPPER("MILITARY_SERVICE_NUMBER"))
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.REGTRAITDT_PK ON ADR.REGISTRY_TRAIT_DETAIL
(REGISTRY_TRAIT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAITDT_REGTRAIT_FK_I ON ADR.REGISTRY_TRAIT_DETAIL
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.REGISTRY_TRAIT_DET_audir_trgr
after Update or Delete or Insert
ON ADR.REGISTRY_TRAIT_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into REGISTRY_TRAIT_DETAIL_H
		(
 		REGISTRY_TRAIT_DETAIL_H_ID
 		,REGISTRY_TRAIT_DETAIL_ID
 		,REGISTRY_TRAIT_ID
 		,MILITARY_SERVICE_NUMBER
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_DETAIL_H_S.nextval,
		:old.REGISTRY_TRAIT_DETAIL_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.MILITARY_SERVICE_NUMBER,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into REGISTRY_TRAIT_DETAIL_H
		(
 		 REGISTRY_TRAIT_DETAIL_H_ID
 		,REGISTRY_TRAIT_DETAIL_ID
 		,REGISTRY_TRAIT_ID
 		,MILITARY_SERVICE_NUMBER
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
 		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_DETAIL_H_S.nextval,
		:new.REGISTRY_TRAIT_DETAIL_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.MILITARY_SERVICE_NUMBER,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  REGISTRY_TRAIT_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TRAIT_DETAIL FOR ADR.REGISTRY_TRAIT_DETAIL;


ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL ADD (
  CONSTRAINT REGTRAITDT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_DETAIL_ID)
  USING INDEX ADR.REGTRAITDT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.REGISTRY_TRAIT_DETAIL ADD (
  CONSTRAINT REGTRAITDT_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_TRAIT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_TRAIT_DETAIL TO ADR_RW;
ALTER TABLE ADR.REGISTRY_TRAIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_TRAIT CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_TRAIT
(
  REGISTRY_TRAIT_ID      NUMBER(20)             NOT NULL,
  REGISTRY_TYPE_ID       NUMBER(20)             NOT NULL,
  SSN                    VARCHAR2(20 BYTE),
  PREFIX                 VARCHAR2(12 BYTE),
  FIRST_NAME             VARCHAR2(30 BYTE),
  MIDDLE_NAME            VARCHAR2(30 BYTE),
  LAST_NAME              VARCHAR2(40 BYTE),
  SUFFIX                 VARCHAR2(12 BYTE),
  EDUCATIONAL_DEGREE     VARCHAR2(30 BYTE),
  DEATH_DATE_TXT         VARCHAR2(14 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_TRAIT IS 'Used to facilitate quick searching of the Registry information. This table contains a foreign key to the Registry type table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.SSN IS 'Theverifiedsocial securitynumberthathas beenassignedbythe SocialSecurityAgencyto theperson.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_TRAIT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.REGTRAIT_FNAME_FB_I ON ADR.REGISTRY_TRAIT
(UPPER("FIRST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAIT_LNAME_FB_I ON ADR.REGISTRY_TRAIT
(UPPER("LAST_NAME"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.REGTRAIT_PK ON ADR.REGISTRY_TRAIT
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAIT_SSN_NU_I ON ADR.REGISTRY_TRAIT
(SSN)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.REGTRAIT_STD_REGTYPE_FK_I ON ADR.REGISTRY_TRAIT
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.REGISTRY_TRAIT_audir_trgr
after Update or Delete or Insert
ON ADR.REGISTRY_TRAIT
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into REGISTRY_TRAIT_H
		(
 		 REGISTRY_TRAIT_H_ID
 		,REGISTRY_TRAIT_ID
 		,REGISTRY_TYPE_ID
 		,SSN
		,FIRST_NAME
 		,LAST_NAME
		,PREFIX
		,MIDDLE_NAME
		,SUFFIX
		,EDUCATIONAL_DEGREE
		,DEATH_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_H_S.nextval,
		:old.REGISTRY_TRAIT_ID,
		:old.REGISTRY_TYPE_ID,
		:old.SSN,
		:old.FIRST_NAME,
		:old.LAST_NAME,
		:old.PREFIX,
		:old.MIDDLE_NAME,
		:old.SUFFIX,
		:old.EDUCATIONAL_DEGREE,
		:old.DEATH_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into REGISTRY_TRAIT_H
		(
 		 REGISTRY_TRAIT_H_ID
 		,REGISTRY_TRAIT_ID
 		,REGISTRY_TYPE_ID
 		,SSN
		,FIRST_NAME
 		,LAST_NAME
		,PREFIX
		,MIDDLE_NAME
		,SUFFIX
		,EDUCATIONAL_DEGREE
		,DEATH_DATE_TXT
 		,RECORD_CREATED_BY
 		,RECORD_CREATED_DATE
		,RECORD_MODIFIED_BY
 		,RECORD_MODIFIED_DATE
 		,RECORD_MODIFIED_COUNT
		,TRANSACTION_TYPE_CODE
		)
		values
		(
		REGISTRY_TRAIT_H_S.nextval,
		:new.REGISTRY_TRAIT_ID,
		:new.REGISTRY_TYPE_ID,
		:new.SSN,
		:new.FIRST_NAME,
		:new.LAST_NAME,
		:new.PREFIX,
		:new.MIDDLE_NAME,
		:new.SUFFIX,
		:new.EDUCATIONAL_DEGREE,
		:new.DEATH_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end REGISTRY_TRAIT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TRAIT FOR ADR.REGISTRY_TRAIT;


ALTER TABLE ADR.REGISTRY_TRAIT ADD (
  CONSTRAINT REGTRAIT_PK
  PRIMARY KEY
  (REGISTRY_TRAIT_ID)
  USING INDEX ADR.REGTRAIT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_TRAIT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_TRAIT TO ADR_RW;
ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_LOAD_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_LOAD_STATISTICS
(
  REGISTRY_LOAD_STATISTICS_ID  NUMBER(20)       NOT NULL,
  REGISTRY_TYPE_ID             NUMBER(20)       NOT NULL,
  PROCESSED_COUNT              NUMBER(10),
  PASS_COUNT                   NUMBER(10),
  MATCH_COUNT                  NUMBER(10),
  NO_MATCH_COUNT               NUMBER(10),
  AMBIGUOUS_MATCH_COUNT        NUMBER(10),
  INSERT_COUNT                 NUMBER(10),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_LOAD_STATISTICS IS 'Stores statistics captured during migration of the Registry data from the HEC legacy system to ADR. Number of records processed, number inserted, pass count, match count etc.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.REGISTRY_LOAD_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.REGISTRY_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.REGSTAT_STD_REGTYPE_FK_I ON ADR.REGISTRY_LOAD_STATISTICS
(REGISTRY_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.RGSTRYSTAT_PK ON ADR.REGISTRY_LOAD_STATISTICS
(REGISTRY_LOAD_STATISTICS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_LOAD_STATISTICS FOR ADR.REGISTRY_LOAD_STATISTICS;


ALTER TABLE ADR.REGISTRY_LOAD_STATISTICS ADD (
  CONSTRAINT RGSTRYSTAT_PK
  PRIMARY KEY
  (REGISTRY_LOAD_STATISTICS_ID)
  USING INDEX ADR.RGSTRYSTAT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_LOAD_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.REGISTRY_LOAD_STATISTICS TO ADR_RW;
ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.REGISTRY_LOAD_EXCEPTION CASCADE CONSTRAINTS;

CREATE TABLE ADR.REGISTRY_LOAD_EXCEPTION
(
  REGISTRY_LOAD_EXCEPTION_ID   NUMBER(20)       NOT NULL,
  REGISTRY_LOAD_STATISTICS_ID  NUMBER(20),
  RPT_EXCEPTION_TYPE_ID        NUMBER(20),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  EXCEPTION_TXT                CLOB
)
LOB (EXCEPTION_TXT) STORE AS (
  TABLESPACE  M_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.REGISTRY_LOAD_EXCEPTION IS 'Stores statistics captured during migration of the Registry data from the HEC legacy system to ADR. Number of records processed, number inserted, pass count, match count etc.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.REGISTRY_LOAD_EXCEPTION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.REGISTRY_LOAD_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.REGISTRY_LOAD_EXCEPTION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RGSTRLODX_PK ON ADR.REGISTRY_LOAD_EXCEPTION
(REGISTRY_LOAD_EXCEPTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RGSTRLODX_RGSTRYSTAT_FK_I ON ADR.REGISTRY_LOAD_EXCEPTION
(REGISTRY_LOAD_STATISTICS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RGSTRLODX_STD_RPTEXCPT_FK_I ON ADR.REGISTRY_LOAD_EXCEPTION
(RPT_EXCEPTION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_LOAD_EXCEPTION FOR ADR.REGISTRY_LOAD_EXCEPTION;


ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_PK
  PRIMARY KEY
  (REGISTRY_LOAD_EXCEPTION_ID)
  USING INDEX ADR.RGSTRLODX_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.REGISTRY_LOAD_EXCEPTION ADD (
  CONSTRAINT RGSTRLODX_RGSTRYSTAT_FK 
  FOREIGN KEY (REGISTRY_LOAD_STATISTICS_ID) 
  REFERENCES ADR.REGISTRY_LOAD_STATISTICS (REGISTRY_LOAD_STATISTICS_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT RGSTRLODX_STD_RPTEXCPT_FK 
  FOREIGN KEY (RPT_EXCEPTION_TYPE_ID) 
  REFERENCES ADRREF.STD_RPTEXCEPTIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.REGISTRY_LOAD_EXCEPTION TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.REGISTRY_LOAD_EXCEPTION TO ADR_RW;
ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RATED_DISABILITY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.RATED_DISABILITY_DETAIL_H
(
  RATED_DISABILITY_DETAIL_H_ID  NUMBER(20)      NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  RATED_DISABILITY_DETAIL_ID    NUMBER(20)      NOT NULL,
  DIAGNOSTIC_EXTREMITY_TYPE_ID  NUMBER(20),
  STD_DISABILITYCONDITION_ID    NUMBER(20)      NOT NULL,
  SERVICE_CONNECTED_ID          NUMBER(20)      NOT NULL,
  RATED_DISABILITY_IS_SC_IND    VARCHAR2(3 BYTE),
  DISABILITY_PERCENT            NUMBER(3),
  DISABILITY_START_DATE         DATE,
  ORIG_EFCTV_RATING_DATE_TXT    VARCHAR2(14 BYTE),
  RATING_DATE_TXT               VARCHAR2(14 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RATED_DISABILITY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATED_DISABILITY_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATED_DISABILITY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.DIAGNOSTIC_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.STD_DISABILITYCONDITION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATED_DISABILITY_IS_SC_IND IS 'BR7255Rateddisability SCindicatorisdefined asayes/nocodethat identifiesiftherated disabilityisservice connectedornot.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.DISABILITY_PERCENT IS 'BR1633%Disabilityis definedasthepercentage atwhichtheVArated thisdisabilityforthis patient.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RATING_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RATEDISDTH_PK ON ADR.RATED_DISABILITY_DETAIL_H
(RATED_DISABILITY_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDTH_SVCCON_NU_I ON ADR.RATED_DISABILITY_DETAIL_H
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM RATED_DISABILITY_DETAIL_H FOR ADR.RATED_DISABILITY_DETAIL_H;


ALTER TABLE ADR.RATED_DISABILITY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_041
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT RATEDISDTH_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_H_ID)
  USING INDEX ADR.RATEDISDTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.RATED_DISABILITY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.RATED_DISABILITY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.RATED_DISABILITY_DETAIL
(
  RATED_DISABILITY_DETAIL_ID    NUMBER(20)      NOT NULL,
  DIAGNOSTIC_EXTREMITY_TYPE_ID  NUMBER(20),
  STD_DISABILITYCONDITION_ID    NUMBER(20)      NOT NULL,
  SERVICE_CONNECTED_ID          NUMBER(20)      NOT NULL,
  RATED_DISABILITY_IS_SC_IND    VARCHAR2(3 BYTE),
  DISABILITY_PERCENT            NUMBER(3),
  DISABILITY_START_DATE         DATE,
  ORIG_EFCTV_RATING_DATE_TXT    VARCHAR2(14 BYTE),
  RATING_DATE_TXT               VARCHAR2(14 BYTE),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.RATED_DISABILITY_DETAIL IS 'The table stores information about a persons disability or disabilities, including whether the disability is service connected, the percentage disabled the person is, the effective dates, and the code associated with the disability. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RATED_DISABILITY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.DIAGNOSTIC_EXTREMITY_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.STD_DISABILITYCONDITION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.SERVICE_CONNECTED_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RATED_DISABILITY_IS_SC_IND IS 'BR7255Rateddisability SCindicatorisdefined asayes/nocodethat identifiesiftherated disabilityisservice connectedornot.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.DISABILITY_PERCENT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.DISABILITY_START_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RATING_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.RATED_DISABILITY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.RATEDISDET_PK ON ADR.RATED_DISABILITY_DETAIL
(RATED_DISABILITY_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDET_STDDSBLCND_FK_I ON ADR.RATED_DISABILITY_DETAIL
(STD_DISABILITYCONDITION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDET_SVCCON_FK_I ON ADR.RATED_DISABILITY_DETAIL
(SERVICE_CONNECTED_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.RATEDISDET_XTRMTY_FK_I ON ADR.RATED_DISABILITY_DETAIL
(DIAGNOSTIC_EXTREMITY_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.RATED_DSBLTY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.RATED_DISABILITY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into RATED_DISABILITY_DETAIL_H
		(
		RATED_DISABILITY_DETAIL_H_ID,
		RATED_DISABILITY_DETAIL_ID,
		RATED_DISABILITY_IS_SC_IND,
		DISABILITY_PERCENT,
		DISABILITY_START_DATE,
		ORIG_EFCTV_RATING_DATE_TXT,
		RATING_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_DISABILITYCONDITION_ID,
		SERVICE_CONNECTED_ID,
		RECORD_MODIFIED_COUNT,
		DIAGNOSTIC_EXTREMITY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RATED_DISABILITY_DETAIL_H_S.nextval,
		:old.RATED_DISABILITY_DETAIL_ID,
		:old.RATED_DISABILITY_IS_SC_IND,
		:old.DISABILITY_PERCENT,
		:old.DISABILITY_START_DATE,
		:old.ORIG_EFCTV_RATING_DATE_TXT,
		:old.RATING_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.STD_DISABILITYCONDITION_ID,
		:old.SERVICE_CONNECTED_ID,
		:old.RECORD_MODIFIED_COUNT,
		:old.DIAGNOSTIC_EXTREMITY_TYPE_ID,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into RATED_DISABILITY_DETAIL_H
		(
		RATED_DISABILITY_DETAIL_H_ID,
		RATED_DISABILITY_DETAIL_ID,
		RATED_DISABILITY_IS_SC_IND,
		DISABILITY_PERCENT,
		DISABILITY_START_DATE,
		ORIG_EFCTV_RATING_DATE_TXT,
		RATING_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		STD_DISABILITYCONDITION_ID,
		SERVICE_CONNECTED_ID,
		RECORD_MODIFIED_COUNT,
		DIAGNOSTIC_EXTREMITY_TYPE_ID,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		RATED_DISABILITY_DETAIL_H_S.nextval,
		:new.RATED_DISABILITY_DETAIL_ID,
		:new.RATED_DISABILITY_IS_SC_IND,
		:new.DISABILITY_PERCENT,
		:new.DISABILITY_START_DATE,
		:new.ORIG_EFCTV_RATING_DATE_TXT,
		:new.RATING_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.STD_DISABILITYCONDITION_ID,
		:new.SERVICE_CONNECTED_ID,
		:new.RECORD_MODIFIED_COUNT,
		:new.DIAGNOSTIC_EXTREMITY_TYPE_ID,
		mDML
		);
	end if;

end RATED_DSBLTY_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM RATED_DISABILITY_DETAIL FOR ADR.RATED_DISABILITY_DETAIL;


ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_PK
  PRIMARY KEY
  (RATED_DISABILITY_DETAIL_ID)
  USING INDEX ADR.RATEDISDET_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.RATED_DISABILITY_DETAIL ADD (
  CONSTRAINT RATEDISDET_SVCCON_FK 
  FOREIGN KEY (SERVICE_CONNECTED_ID) 
  REFERENCES ADR.SERVICE_CONNECTED (SERVICE_CONNECTED_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.RATED_DISABILITY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.RATED_DISABILITY_DETAIL TO ADR_RW;
ALTER TABLE ADR.QRTZ_TRIGGER_LISTENERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_TRIGGER_LISTENERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_TRIGGER_LISTENERS
(
  TRIGGER_NAME      VARCHAR2(80 BYTE)           NOT NULL,
  TRIGGER_GROUP     VARCHAR2(80 BYTE)           NOT NULL,
  TRIGGER_LISTENER  VARCHAR2(80 BYTE)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
ENABLE ROW MOVEMENT;


CREATE UNIQUE INDEX ADR.QRTZ_TRGGRLSTNR_PK ON ADR.QRTZ_TRIGGER_LISTENERS
(TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_TRIGGER_LISTENERS FOR ADR.QRTZ_TRIGGER_LISTENERS;


ALTER TABLE ADR.QRTZ_TRIGGER_LISTENERS ADD (
  CONSTRAINT QRTZ_TRGGRLSTNR_PK
  PRIMARY KEY
  (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_LISTENER)
  USING INDEX ADR.QRTZ_TRGGRLSTNR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.QRTZ_TRIGGER_LISTENERS ADD (
  CONSTRAINT QRTZ_TRGGRLSTNR_TRGGR_FK 
  FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_TRIGGER_LISTENERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_TRIGGER_LISTENERS TO ADR_RW;
ALTER TABLE ADR.QRTZ_TRIGGERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_TRIGGERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_TRIGGERS
(
  TRIGGER_NAME    VARCHAR2(80 BYTE)             NOT NULL,
  TRIGGER_GROUP   VARCHAR2(80 BYTE)             NOT NULL,
  JOB_NAME        VARCHAR2(80 BYTE)             NOT NULL,
  JOB_GROUP       VARCHAR2(80 BYTE)             NOT NULL,
  IS_VOLATILE     VARCHAR2(1 BYTE)              NOT NULL,
  DESCRIPTION     VARCHAR2(120 BYTE),
  NEXT_FIRE_TIME  NUMBER(13),
  PREV_FIRE_TIME  NUMBER(13),
  TRIGGER_STATE   VARCHAR2(16 BYTE)             NOT NULL,
  TRIGGER_TYPE    VARCHAR2(8 BYTE)              NOT NULL,
  START_TIME      NUMBER(13)                    NOT NULL,
  END_TIME        NUMBER(13),
  CALENDAR_NAME   VARCHAR2(80 BYTE),
  MISFIRE_INSTR   NUMBER(2),
  JOB_DATA        BLOB
)
LOB (JOB_DATA) STORE AS (
  TABLESPACE  S_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128K
                  NEXT             128K
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
ENABLE ROW MOVEMENT;


CREATE INDEX ADR.IDX_QRTZ_T_NEXT_FIRE_TIME ON ADR.QRTZ_TRIGGERS
(NEXT_FIRE_TIME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_T_NFT_ST ON ADR.QRTZ_TRIGGERS
(NEXT_FIRE_TIME, TRIGGER_STATE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_T_STATE ON ADR.QRTZ_TRIGGERS
(TRIGGER_STATE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_T_VOLATILE ON ADR.QRTZ_TRIGGERS
(IS_VOLATILE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.QRTZ_TRGGR_PK ON ADR.QRTZ_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_TRIGGERS FOR ADR.QRTZ_TRIGGERS;


ALTER TABLE ADR.QRTZ_TRIGGERS ADD (
  CONSTRAINT QRTZ_TRGGR_PK
  PRIMARY KEY
  (TRIGGER_NAME, TRIGGER_GROUP)
  USING INDEX ADR.QRTZ_TRGGR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.QRTZ_TRIGGERS ADD (
  CONSTRAINT QRTZ_TRGGR_JBDTL_FK 
  FOREIGN KEY (JOB_NAME, JOB_GROUP) 
  REFERENCES ADR.QRTZ_JOB_DETAILS (JOB_NAME,JOB_GROUP)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_TRIGGERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_TRIGGERS TO ADR_RW;
ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_SIMPLE_TRIGGERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_SIMPLE_TRIGGERS
(
  TRIGGER_NAME     VARCHAR2(80 BYTE)            NOT NULL,
  TRIGGER_GROUP    VARCHAR2(80 BYTE)            NOT NULL,
  REPEAT_COUNT     NUMBER(7)                    NOT NULL,
  REPEAT_INTERVAL  NUMBER(12)                   NOT NULL,
  TIMES_TRIGGERED  NUMBER(7)                    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
ENABLE ROW MOVEMENT;


CREATE UNIQUE INDEX ADR.QRTZ_SMPTRGGR_PK ON ADR.QRTZ_SIMPLE_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_SIMPLE_TRIGGERS FOR ADR.QRTZ_SIMPLE_TRIGGERS;


ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS ADD (
  CONSTRAINT QRTZ_SMPTRGGR_PK
  PRIMARY KEY
  (TRIGGER_NAME, TRIGGER_GROUP)
  USING INDEX ADR.QRTZ_SMPTRGGR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.QRTZ_SIMPLE_TRIGGERS ADD (
  CONSTRAINT QRTZ_SMPTRGGR_TRGGR_FK 
  FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_SIMPLE_TRIGGERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_SIMPLE_TRIGGERS TO ADR_RW;
ALTER TABLE ADR.QRTZ_SCHEDULER_STATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_SCHEDULER_STATE CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_SCHEDULER_STATE
(
  INSTANCE_NAME      VARCHAR2(80 BYTE)          NOT NULL,
  LAST_CHECKIN_TIME  NUMBER(13)                 NOT NULL,
  CHECKIN_INTERVAL   NUMBER(13)                 NOT NULL,
  RECOVERER          VARCHAR2(80 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.QRTZ_SCHDST_PK ON ADR.QRTZ_SCHEDULER_STATE
(INSTANCE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_SCHEDULER_STATE FOR ADR.QRTZ_SCHEDULER_STATE;


ALTER TABLE ADR.QRTZ_SCHEDULER_STATE ADD (
  CONSTRAINT QRTZ_SCHDST_PK
  PRIMARY KEY
  (INSTANCE_NAME)
  USING INDEX ADR.QRTZ_SCHDST_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_SCHEDULER_STATE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_SCHEDULER_STATE TO ADR_RW;
ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS
(
  TRIGGER_GROUP  VARCHAR2(80 BYTE)              NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.QRTZ_PUSDTRGGR_PK ON ADR.QRTZ_PAUSED_TRIGGER_GRPS
(TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_PAUSED_TRIGGER_GRPS FOR ADR.QRTZ_PAUSED_TRIGGER_GRPS;


ALTER TABLE ADR.QRTZ_PAUSED_TRIGGER_GRPS ADD (
  CONSTRAINT QRTZ_PUSDTRGGR_PK
  PRIMARY KEY
  (TRIGGER_GROUP)
  USING INDEX ADR.QRTZ_PUSDTRGGR_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_PAUSED_TRIGGER_GRPS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_PAUSED_TRIGGER_GRPS TO ADR_RW;
ALTER TABLE ADR.QRTZ_LOCKS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_LOCKS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_LOCKS
(
  LOCK_NAME  VARCHAR2(40 BYTE)                  NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.QRTZ_LOCKS_PK ON ADR.QRTZ_LOCKS
(LOCK_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_LOCKS FOR ADR.QRTZ_LOCKS;


ALTER TABLE ADR.QRTZ_LOCKS ADD (
  CONSTRAINT QRTZ_LOCKS_PK
  PRIMARY KEY
  (LOCK_NAME)
  USING INDEX ADR.QRTZ_LOCKS_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_LOCKS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_LOCKS TO ADR_RW;
ALTER TABLE ADR.QRTZ_JOB_LISTENERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_JOB_LISTENERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_JOB_LISTENERS
(
  JOB_NAME      VARCHAR2(80 BYTE)               NOT NULL,
  JOB_GROUP     VARCHAR2(80 BYTE)               NOT NULL,
  JOB_LISTENER  VARCHAR2(80 BYTE)               NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.QRTZ_JBLSTNR_PK ON ADR.QRTZ_JOB_LISTENERS
(JOB_NAME, JOB_GROUP, JOB_LISTENER)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_JOB_LISTENERS FOR ADR.QRTZ_JOB_LISTENERS;


ALTER TABLE ADR.QRTZ_JOB_LISTENERS ADD (
  CONSTRAINT QRTZ_JBLSTNR_PK
  PRIMARY KEY
  (JOB_NAME, JOB_GROUP, JOB_LISTENER)
  USING INDEX ADR.QRTZ_JBLSTNR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.QRTZ_JOB_LISTENERS ADD (
  CONSTRAINT QRTZ_JBLSTNR_JBDTL_FK 
  FOREIGN KEY (JOB_NAME, JOB_GROUP) 
  REFERENCES ADR.QRTZ_JOB_DETAILS (JOB_NAME,JOB_GROUP)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_JOB_LISTENERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_JOB_LISTENERS TO ADR_RW;
ALTER TABLE ADR.QRTZ_JOB_DETAILS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_JOB_DETAILS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_JOB_DETAILS
(
  JOB_NAME           VARCHAR2(80 BYTE)          NOT NULL,
  JOB_GROUP          VARCHAR2(80 BYTE)          NOT NULL,
  DESCRIPTION        VARCHAR2(120 BYTE),
  JOB_CLASS_NAME     VARCHAR2(128 BYTE)         NOT NULL,
  IS_DURABLE         VARCHAR2(1 BYTE)           NOT NULL,
  IS_VOLATILE        VARCHAR2(1 BYTE)           NOT NULL,
  IS_STATEFUL        VARCHAR2(1 BYTE)           NOT NULL,
  REQUESTS_RECOVERY  VARCHAR2(1 BYTE)           NOT NULL,
  JOB_DATA           BLOB
)
LOB (JOB_DATA) STORE AS (
  TABLESPACE  S_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128K
                  NEXT             128K
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
ENABLE ROW MOVEMENT;


CREATE INDEX ADR.IDX_QRTZ_J_REQ_RECOVERY ON ADR.QRTZ_JOB_DETAILS
(REQUESTS_RECOVERY)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.QRTZ_JBDTL_PK ON ADR.QRTZ_JOB_DETAILS
(JOB_NAME, JOB_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_JOB_DETAILS FOR ADR.QRTZ_JOB_DETAILS;


ALTER TABLE ADR.QRTZ_JOB_DETAILS ADD (
  CONSTRAINT QRTZ_JBDTL_PK
  PRIMARY KEY
  (JOB_NAME, JOB_GROUP)
  USING INDEX ADR.QRTZ_JBDTL_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_JOB_DETAILS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_JOB_DETAILS TO ADR_RW;
ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_FIRED_TRIGGERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_FIRED_TRIGGERS
(
  ENTRY_ID           VARCHAR2(95 BYTE)          NOT NULL,
  TRIGGER_NAME       VARCHAR2(80 BYTE)          NOT NULL,
  TRIGGER_GROUP      VARCHAR2(80 BYTE)          NOT NULL,
  IS_VOLATILE        VARCHAR2(1 BYTE)           NOT NULL,
  INSTANCE_NAME      VARCHAR2(80 BYTE)          NOT NULL,
  FIRED_TIME         NUMBER(13)                 NOT NULL,
  STATE              VARCHAR2(16 BYTE)          NOT NULL,
  JOB_NAME           VARCHAR2(80 BYTE),
  JOB_GROUP          VARCHAR2(80 BYTE),
  IS_STATEFUL        VARCHAR2(1 BYTE),
  REQUESTS_RECOVERY  VARCHAR2(1 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.QRTZ_FIRED_TRIGGERS.STATE IS 'BR9Cityisdefinedas thenameofacityused foranaddress.';


CREATE INDEX ADR.IDX_QRTZ_FT_JOB_GROUP ON ADR.QRTZ_FIRED_TRIGGERS
(JOB_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_NAME ON ADR.QRTZ_FIRED_TRIGGERS
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_REQ_RECOVERY ON ADR.QRTZ_FIRED_TRIGGERS
(REQUESTS_RECOVERY)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_JOB_STATEFUL ON ADR.QRTZ_FIRED_TRIGGERS
(IS_STATEFUL)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_GROUP ON ADR.QRTZ_FIRED_TRIGGERS
(TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_INST_NAME ON ADR.QRTZ_FIRED_TRIGGERS
(INSTANCE_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_NAME ON ADR.QRTZ_FIRED_TRIGGERS
(TRIGGER_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_NM_GP ON ADR.QRTZ_FIRED_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IDX_QRTZ_FT_TRIG_VOLATILE ON ADR.QRTZ_FIRED_TRIGGERS
(IS_VOLATILE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.QRTZ_FRDTRGGR_PK ON ADR.QRTZ_FIRED_TRIGGERS
(ENTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_FIRED_TRIGGERS FOR ADR.QRTZ_FIRED_TRIGGERS;


ALTER TABLE ADR.QRTZ_FIRED_TRIGGERS ADD (
  CONSTRAINT QRTZ_FRDTRGGR_PK
  PRIMARY KEY
  (ENTRY_ID)
  USING INDEX ADR.QRTZ_FRDTRGGR_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_FIRED_TRIGGERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_FIRED_TRIGGERS TO ADR_RW;
ALTER TABLE ADR.QRTZ_CRON_TRIGGERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_CRON_TRIGGERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_CRON_TRIGGERS
(
  TRIGGER_NAME     VARCHAR2(80 BYTE)            NOT NULL,
  TRIGGER_GROUP    VARCHAR2(80 BYTE)            NOT NULL,
  CRON_EXPRESSION  VARCHAR2(80 BYTE)            NOT NULL,
  TIME_ZONE_ID     VARCHAR2(80 BYTE)
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
ENABLE ROW MOVEMENT;


CREATE UNIQUE INDEX ADR.QRTZ_CRNTRGGR_PK ON ADR.QRTZ_CRON_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_CRON_TRIGGERS FOR ADR.QRTZ_CRON_TRIGGERS;


ALTER TABLE ADR.QRTZ_CRON_TRIGGERS ADD (
  CONSTRAINT QRTZ_CRNTRGGR_PK
  PRIMARY KEY
  (TRIGGER_NAME, TRIGGER_GROUP)
  USING INDEX ADR.QRTZ_CRNTRGGR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.QRTZ_CRON_TRIGGERS ADD (
  CONSTRAINT QRTZ_CRNTRGGR_TRGGR_FK 
  FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_CRON_TRIGGERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_CRON_TRIGGERS TO ADR_RW;
ALTER TABLE ADR.QRTZ_CALENDARS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_CALENDARS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_CALENDARS
(
  CALENDAR_NAME  VARCHAR2(80 BYTE)              NOT NULL,
  CALENDAR       BLOB
)
LOB (CALENDAR) STORE AS (
  TABLESPACE  S_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128K
                  NEXT             128K
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.QRTZ_CLNDR_PK ON ADR.QRTZ_CALENDARS
(CALENDAR_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_CALENDARS FOR ADR.QRTZ_CALENDARS;


ALTER TABLE ADR.QRTZ_CALENDARS ADD (
  CONSTRAINT QRTZ_CLNDR_PK
  PRIMARY KEY
  (CALENDAR_NAME)
  USING INDEX ADR.QRTZ_CLNDR_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_CALENDARS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_CALENDARS TO ADR_RW;
ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.QRTZ_BLOB_TRIGGERS CASCADE CONSTRAINTS;

CREATE TABLE ADR.QRTZ_BLOB_TRIGGERS
(
  TRIGGER_NAME   VARCHAR2(80 BYTE)              NOT NULL,
  TRIGGER_GROUP  VARCHAR2(80 BYTE)              NOT NULL,
  BLOB_DATA      BLOB
)
LOB (BLOB_DATA) STORE AS (
  TABLESPACE  S_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          128K
                  NEXT             128K
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING
ENABLE ROW MOVEMENT;


CREATE UNIQUE INDEX ADR.QRTZ_BLOBTRGGR_PK ON ADR.QRTZ_BLOB_TRIGGERS
(TRIGGER_NAME, TRIGGER_GROUP)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM QRTZ_BLOB_TRIGGERS FOR ADR.QRTZ_BLOB_TRIGGERS;


ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS ADD (
  CONSTRAINT QRTZ_BLOBTRGGR_PK
  PRIMARY KEY
  (TRIGGER_NAME, TRIGGER_GROUP)
  USING INDEX ADR.QRTZ_BLOBTRGGR_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.QRTZ_BLOB_TRIGGERS ADD (
  CONSTRAINT QRTZ_BLOBTRGGR_TRGGR_FK 
  FOREIGN KEY (TRIGGER_NAME, TRIGGER_GROUP) 
  REFERENCES ADR.QRTZ_TRIGGERS (TRIGGER_NAME,TRIGGER_GROUP)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.QRTZ_BLOB_TRIGGERS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.QRTZ_BLOB_TRIGGERS TO ADR_RW;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PURPLE_HEART_REGISTRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PURPLE_HEART_REGISTRY_H
(
  PURPLE_HEART_REGISTRY_H_ID     NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  PURPLE_HEART_REGISTRY_ID       NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20),
  REGISTRY_TRAIT_ID              NUMBER(20),
  PH_STATUS_TYPE_ID              NUMBER(20),
  STD_REJECTEDREMARKS_ID         NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  PURPLE_HEART_IND               VARCHAR2(1 BYTE),
  ASSIGNED_CONTACT_REP_USERNAME  VARCHAR2(30 BYTE),
  PH_STATUS_LAST_EDIT_USERNAME   VARCHAR2(30 BYTE),
  PH_STATUS_LAST_EDIT_DATE       DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PURPLE_HEART_REGISTRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.PURPLE_HEART_REGISTRY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.PURPLE_HEART_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.PH_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.STD_REJECTEDREMARKS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.PURPLE_HEART_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRPLHRTREH_PK ON ADR.PURPLE_HEART_REGISTRY_H
(PURPLE_HEART_REGISTRY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREH_PRPLHRTRE_NU_I ON ADR.PURPLE_HEART_REGISTRY_H
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREH_PRSNID_NU_I ON ADR.PURPLE_HEART_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREH_REGTRAIT_NU_I ON ADR.PURPLE_HEART_REGISTRY_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PURPLE_HEART_REGISTRY_H FOR ADR.PURPLE_HEART_REGISTRY_H;


ALTER TABLE ADR.PURPLE_HEART_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_008
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRPLHRTREH_PK
  PRIMARY KEY
  (PURPLE_HEART_REGISTRY_H_ID)
  USING INDEX ADR.PRPLHRTREH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY_H TO ADR_R;

GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY_H TO ADR_RW;
ALTER TABLE ADR.PURPLE_HEART_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PURPLE_HEART_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.PURPLE_HEART_REGISTRY
(
  PURPLE_HEART_REGISTRY_ID       NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20),
  REGISTRY_TRAIT_ID              NUMBER(20),
  PH_STATUS_TYPE_ID              NUMBER(20),
  STD_REJECTEDREMARKS_ID         NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  PURPLE_HEART_IND               VARCHAR2(1 BYTE),
  PH_STATUS_LAST_EDIT_DATE       DATE,
  PH_STATUS_LAST_EDIT_USERNAME   VARCHAR2(30 BYTE),
  ASSIGNED_CONTACT_REP_USERNAME  VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PURPLE_HEART_REGISTRY IS 'The table contains data about persons who received Purple Heart decorations. The data originates from the veteran, military documentation, VAMC, and VBA. This table corresponds to the Purple Heart Registry File. All persons in the POW registry file are enumerated and a record is created for them in this table with full details. The Enrollment application uses some of the information in this table as a factor in enrollment calculations. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.PURPLE_HEART_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.PH_STATUS_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.STD_REJECTEDREMARKS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.PURPLE_HEART_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PURPLE_HEART_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRPLHRTREG_PK ON ADR.PURPLE_HEART_REGISTRY
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREG_PRSN_FK_I ON ADR.PURPLE_HEART_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREG_REGTRAIT_FK_I ON ADR.PURPLE_HEART_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREG_STDINST_FK_I ON ADR.PURPLE_HEART_REGISTRY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREG_STDREJRMRK_FK_I ON ADR.PURPLE_HEART_REGISTRY
(STD_REJECTEDREMARKS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRPLHRTREG_STD_DCRNSTAT_FK_I ON ADR.PURPLE_HEART_REGISTRY
(PH_STATUS_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PH_REGISTRY_audir_trgr
after Update or Delete or Insert
on ADR.PURPLE_HEART_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PURPLE_HEART_REGISTRY_H
		(
		PURPLE_HEART_REGISTRY_H_ID,
		PURPLE_HEART_REGISTRY_ID,
		PH_STATUS_TYPE_ID,
		STD_INSTITUTION_ID,
                STD_REJECTEDREMARKS_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		PH_STATUS_LAST_EDIT_USERNAME,
		PH_STATUS_LAST_EDIT_DATE,
		ASSIGNED_CONTACT_REP_USERNAME,
		PURPLE_HEART_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PURPLE_HEART_REGISTRY_H_S.nextval,
		:old.PURPLE_HEART_REGISTRY_ID,
		:old.PH_STATUS_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.STD_REJECTEDREMARKS_ID,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.PH_STATUS_LAST_EDIT_USERNAME,
		:old.PH_STATUS_LAST_EDIT_DATE,
		:old.ASSIGNED_CONTACT_REP_USERNAME,
		:old.PURPLE_HEART_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	IF :OLD.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:OLD.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PURPLE_HEART_REGISTRY_H
		(
		PURPLE_HEART_REGISTRY_H_ID,
		PURPLE_HEART_REGISTRY_ID,
		PH_STATUS_TYPE_ID,
		STD_INSTITUTION_ID,
		STD_REJECTEDREMARKS_ID,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		PH_STATUS_LAST_EDIT_USERNAME,
		PH_STATUS_LAST_EDIT_DATE,
		ASSIGNED_CONTACT_REP_USERNAME,
		PURPLE_HEART_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PURPLE_HEART_REGISTRY_H_S.nextval,
		:new.PURPLE_HEART_REGISTRY_ID,
		:new.PH_STATUS_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.STD_REJECTEDREMARKS_ID,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.PH_STATUS_LAST_EDIT_USERNAME,
		:new.PH_STATUS_LAST_EDIT_DATE,
		:new.ASSIGNED_CONTACT_REP_USERNAME,
		:new.PURPLE_HEART_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	IF :NEW.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:NEW.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	end if;

end PH_REGISTRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PURPLE_HEART_REGISTRY FOR ADR.PURPLE_HEART_REGISTRY;


ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_PK
  PRIMARY KEY
  (PURPLE_HEART_REGISTRY_ID)
  USING INDEX ADR.PRPLHRTREG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PURPLE_HEART_REGISTRY ADD (
  CONSTRAINT PRPLHRTREG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT PRPLHRTREG_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY TO ADREXT;

GRANT SELECT ON ADR.PURPLE_HEART_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PURPLE_HEART_REGISTRY TO ADR_RW;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PRISONER_OF_WAR_REGISTRY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PRISONER_OF_WAR_REGISTRY_H
(
  PRISONER_OF_WAR_REGISTRY_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  PRISONER_OF_WAR_REGISTRY_ID    NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20),
  REGISTRY_TRAIT_ID              NUMBER(20),
  POW_STDYESNO_ID                NUMBER(20),
  LEGACY_ICN                     VARCHAR2(30 BYTE),
  LEGACY_USERNAME                VARCHAR2(30 BYTE),
  LEGACY_ENTERED_DATE            DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PRISONER_OF_WAR_REGISTRY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.PRISONER_OF_WAR_REGISTRY_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.POWH_PK ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PRISONER_OF_WAR_REGISTRY_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWH_POWREGID_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWH_PRSNID_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWH_REGTRAIT_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY_H
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PRISONER_OF_WAR_REGISTRY_H FOR ADR.PRISONER_OF_WAR_REGISTRY_H;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_011
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT POWH_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_H_ID)
  USING INDEX ADR.POWH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ADR_R;

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY_H TO ADR_RW;
ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PRISONER_OF_WAR_REGISTRY CASCADE CONSTRAINTS;

CREATE TABLE ADR.PRISONER_OF_WAR_REGISTRY
(
  PRISONER_OF_WAR_REGISTRY_ID  NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20),
  REGISTRY_TRAIT_ID            NUMBER(20),
  POW_STDYESNO_ID              NUMBER(20),
  LEGACY_ICN                   VARCHAR2(30 BYTE),
  LEGACY_USERNAME              VARCHAR2(30 BYTE),
  LEGACY_ENTERED_DATE          DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PRISONER_OF_WAR_REGISTRY IS 'The table contains data about persons who have been captured and imprisoned as prisoners of war, The data originates from the Department of Defense, Veterans Benefits Administration, and the National Archives. This table corresponds to the Prisoner of War Registry File. All persons in the POW registry file are enumerated and a record is created for them in this table with full details. The Enrollment application uses some of the information in this table as a factor in enrollment calculations. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.REGISTRY_TRAIT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.LEGACY_ENTERED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PRISONER_OF_WAR_REGISTRY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.POW_LGCYICN_NU_I ON ADR.PRISONER_OF_WAR_REGISTRY
(LEGACY_ICN)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.POW_PK ON ADR.PRISONER_OF_WAR_REGISTRY
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POW_PRSN_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POW_REGTRAIT_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(REGISTRY_TRAIT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POW_STDYESNO_FK_I ON ADR.PRISONER_OF_WAR_REGISTRY
(POW_STDYESNO_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.POW_REGISTRY_audir_trgr
after Update or Delete or Insert
on ADR.PRISONER_OF_WAR_REGISTRY
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PRISONER_OF_WAR_REGISTRY_H
		(
		PRISONER_OF_WAR_REGISTRY_H_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		LEGACY_ICN,
		LEGACY_USERNAME,
		LEGACY_ENTERED_DATE,
		POW_STDYESNO_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PRISONER_OF_WAR_REGISTRY_H_S.nextval,
		:old.PRISONER_OF_WAR_REGISTRY_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.PERSON_ID,
		:old.REGISTRY_TRAIT_ID,
		:old.LEGACY_ICN,
		:old.LEGACY_USERNAME,
		:old.LEGACY_ENTERED_DATE,
		:old.POW_STDYESNO_ID,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	IF :OLD.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:OLD.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PRISONER_OF_WAR_REGISTRY_H
		(
		PRISONER_OF_WAR_REGISTRY_H_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		PERSON_ID,
		REGISTRY_TRAIT_ID,
		LEGACY_ICN,
		LEGACY_USERNAME,
		LEGACY_ENTERED_DATE,
		POW_STDYESNO_ID,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PRISONER_OF_WAR_REGISTRY_H_S.nextval,
		:new.PRISONER_OF_WAR_REGISTRY_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.PERSON_ID,
		:new.REGISTRY_TRAIT_ID,
		:new.LEGACY_ICN,
		:new.LEGACY_USERNAME,
		:new.LEGACY_ENTERED_DATE,
		:new.POW_STDYESNO_ID,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	IF :NEW.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:NEW.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	end if;

end POW_REGISTRY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PRISONER_OF_WAR_REGISTRY FOR ADR.PRISONER_OF_WAR_REGISTRY;


ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PK
  PRIMARY KEY
  (PRISONER_OF_WAR_REGISTRY_ID)
  USING INDEX ADR.POW_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PRISONER_OF_WAR_REGISTRY ADD (
  CONSTRAINT POW_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT POW_REGTRAIT_FK 
  FOREIGN KEY (REGISTRY_TRAIT_ID) 
  REFERENCES ADR.REGISTRY_TRAIT (REGISTRY_TRAIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ADREXT;

GRANT SELECT ON ADR.PRISONER_OF_WAR_REGISTRY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PRISONER_OF_WAR_REGISTRY TO ADR_RW;
ALTER TABLE ADR.PREFERRED_FACILITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PREFERRED_FACILITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PREFERRED_FACILITY_H
(
  PREFERRED_FACILITY_H_ID        NUMBER(20),
  PREFERRED_FACILITY_ID          NUMBER(20),
  PERSON_ID                      NUMBER(20),
  STD_PREFERRED_FACILITY_SRC_ID  NUMBER(20),
  STD_INSTITUTION_ID             NUMBER(20),
  ASSIGNMENT_DATE                DATE,
  UNASSIGNMENT_DATE              DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10),
  HISTORY_CREATED_DATE           DATE,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PREFERRED_FACILITY_H IS 'A PREFERRED FACILITY assigned to the patient on an ASSIGNMENT_DATE.';

COMMENT ON COLUMN ADR.PREFERRED_FACILITY_H.ASSIGNMENT_DATE IS 'Date when this site was assigned as a PREFERRED FACILITY.';

COMMENT ON COLUMN ADR.PREFERRED_FACILITY_H.UNASSIGNMENT_DATE IS 'Date when this site was unassigned from being PREFERRED FACILITY.';

COMMENT ON COLUMN ADR.PREFERRED_FACILITY_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.PRFFCLH_PK ON ADR.PREFERRED_FACILITY_H
(PREFERRED_FACILITY_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PREFERRED_FACILITY_H FOR ADR.PREFERRED_FACILITY_H;


ALTER TABLE ADR.PREFERRED_FACILITY_H ADD (
  CONSTRAINT SYS_C00160861
  CHECK ("PREFERRED_FACILITY_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160862
  CHECK ("PREFERRED_FACILITY_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160863
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160864
  CHECK ("STD_PREFERRED_FACILITY_SRC_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160865
  CHECK ("STD_INSTITUTION_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160866
  CHECK ("ASSIGNMENT_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160867
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160868
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160869
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160870
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160871
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160872
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C00160873
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE NOVALIDATE,
  CONSTRAINT PRFFCLH_PK
  PRIMARY KEY
  (PREFERRED_FACILITY_H_ID)
  USING INDEX ADR.PRFFCLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PREFERRED_FACILITY_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PREFERRED_FACILITY_H TO ADR_RW;
ALTER TABLE ADR.PREFERRED_FACILITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PREFERRED_FACILITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.PREFERRED_FACILITY
(
  PREFERRED_FACILITY_ID          NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_PREFERRED_FACILITY_SRC_ID  NUMBER(20)     NOT NULL,
  STD_INSTITUTION_ID             NUMBER(20)     NOT NULL,
  ASSIGNMENT_DATE                DATE           NOT NULL,
  UNASSIGNMENT_DATE              DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PREFERRED_FACILITY IS 'A PREFERRED FACILITY assigned to the patient on an ASSIGNMENT_DATE.';

COMMENT ON COLUMN ADR.PREFERRED_FACILITY.ASSIGNMENT_DATE IS 'Date when this site was assigned as a PREFERRED FACILITY.';

COMMENT ON COLUMN ADR.PREFERRED_FACILITY.UNASSIGNMENT_DATE IS 'Date when this site was unassigned from being PREFERRED FACILITY.';


CREATE INDEX ADR.IX_RELATIONSHIP60 ON ADR.PREFERRED_FACILITY
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRFFCL_PK ON ADR.PREFERRED_FACILITY
(PREFERRED_FACILITY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRFFCL_STDINS_NU_I ON ADR.PREFERRED_FACILITY
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PREFERRED_FACILITY_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PREFERRED_FACILITY
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into PREFERRED_FACILITY_H
        (
        PREFERRED_FACILITY_H_ID,
        PREFERRED_FACILITY_ID,
        PERSON_ID,
        STD_PREFERRED_FACILITY_SRC_ID,
        STD_INSTITUTION_ID,
        ASSIGNMENT_DATE,
        UNASSIGNMENT_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PREFERRED_FACILITY_H_S.nextval,
        :old.PREFERRED_FACILITY_ID,
        :old.PERSON_ID,
        :old.STD_PREFERRED_FACILITY_SRC_ID,
        :old.STD_INSTITUTION_ID,
        :old.ASSIGNMENT_DATE,
        :old.UNASSIGNMENT_DATE,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into PREFERRED_FACILITY_H
        (
        PREFERRED_FACILITY_H_ID,
        PREFERRED_FACILITY_ID,
        PERSON_ID,
        STD_PREFERRED_FACILITY_SRC_ID,
        STD_INSTITUTION_ID,
        ASSIGNMENT_DATE,
        UNASSIGNMENT_DATE,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PREFERRED_FACILITY_H_S.nextval,
        :new.PREFERRED_FACILITY_ID,
        :new.PERSON_ID,
        :new.STD_PREFERRED_FACILITY_SRC_ID,
        :new.STD_INSTITUTION_ID,
        :new.ASSIGNMENT_DATE,
        :new.UNASSIGNMENT_DATE,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end PREFERRED_FACILITY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PREFERRED_FACILITY FOR ADR.PREFERRED_FACILITY;


ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT PRFFCL_PK
  PRIMARY KEY
  (PREFERRED_FACILITY_ID)
  USING INDEX ADR.PRFFCL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PREFERRED_FACILITY ADD (
  CONSTRAINT RELATIONSHIP60 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PREFERRED_FACILITY TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PREFERRED_FACILITY TO ADR_RW;

GRANT DELETE ON ADR.PREFERRED_FACILITY TO EEUSR;
ALTER TABLE ADR.POW_REGISTRY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.POW_REGISTRY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.POW_REGISTRY_DETAIL_H
(
  POW_REGISTRY_DETAIL_H_ID     NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  POW_REGISTRY_DETAIL_ID       NUMBER(20)       NOT NULL,
  PRISONER_OF_WAR_REGISTRY_ID  NUMBER(20)       NOT NULL,
  POW_DATA_SOURCE_TYPE_ID      NUMBER(20),
  POW_DOCUMENT_TYPE_ID         NUMBER(20),
  STD_POWCASUALTYLOCATION_ID   NUMBER(20),
  POW_CONFINE_LOCN_TYPE_ID     NUMBER(20),
  POW_CAPTURE_DATE_TXT         VARCHAR2(14 BYTE),
  POW_RELEASE_DATE_TXT         VARCHAR2(14 BYTE),
  NUMBER_OF_DAYS_IN_CAPTIVITY  NUMBER(6),
  LEGACY_ENTERED_DATE          DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.POW_REGISTRY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_REGISTRY_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_DOCUMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.STD_POWCASUALTYLOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.POW_CONFINE_LOCN_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.POWREGDTH_PK ON ADR.POW_REGISTRY_DETAIL_H
(POW_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTH_POWREGID_NU_I ON ADR.POW_REGISTRY_DETAIL_H
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM POW_REGISTRY_DETAIL_H FOR ADR.POW_REGISTRY_DETAIL_H;


ALTER TABLE ADR.POW_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_022
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT POWREGDTH_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_H_ID)
  USING INDEX ADR.POWREGDTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.POW_REGISTRY_DETAIL_H TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.POW_REGISTRY_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.POW_REGISTRY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.POW_REGISTRY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.POW_REGISTRY_DETAIL
(
  POW_REGISTRY_DETAIL_ID       NUMBER(20)       NOT NULL,
  PRISONER_OF_WAR_REGISTRY_ID  NUMBER(20)       NOT NULL,
  POW_DATA_SOURCE_TYPE_ID      NUMBER(20),
  POW_DOCUMENT_TYPE_ID         NUMBER(20),
  POW_CONFINE_LOCN_TYPE_ID     NUMBER(20),
  STD_POWCASUALTYLOCATION_ID   NUMBER(20),
  POW_CAPTURE_DATE_TXT         VARCHAR2(14 BYTE),
  POW_RELEASE_DATE_TXT         VARCHAR2(14 BYTE),
  NUMBER_OF_DAYS_IN_CAPTIVITY  NUMBER(6),
  LEGACY_ENTERED_DATE          DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.POW_REGISTRY_DETAIL IS 'Detail table of Prisoner of War When Veteran was captured, released, how many days in captivity etc.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.PRISONER_OF_WAR_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_DOCUMENT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.POW_CONFINE_LOCN_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.STD_POWCASUALTYLOCATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.POW_REGISTRY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.POWREGDTL_PK ON ADR.POW_REGISTRY_DETAIL
(POW_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_POWCSLTLOC_FK_I ON ADR.POW_REGISTRY_DETAIL
(STD_POWCASUALTYLOCATION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_POW_FK_I ON ADR.POW_REGISTRY_DETAIL
(PRISONER_OF_WAR_REGISTRY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_STD_POWDATASRC_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_DATA_SOURCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_STD_POWDOC_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.POWREGDTL_STD_POWPRD_FK_I ON ADR.POW_REGISTRY_DETAIL
(POW_CONFINE_LOCN_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.pow_reg_det_audir_trgr
after Update or Delete or Insert
ON ADR.POW_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into POW_REGISTRY_DETAIL_H
		(
		POW_REGISTRY_DETAIL_H_ID,
		POW_REGISTRY_DETAIL_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		POW_DATA_SOURCE_TYPE_ID,
		POW_DOCUMENT_TYPE_ID,
		POW_CONFINE_LOCN_TYPE_ID,
		STD_POWCASUALTYLOCATION_ID,
		POW_CAPTURE_DATE_TXT,
		POW_RELEASE_DATE_TXT,
		NUMBER_OF_DAYS_IN_CAPTIVITY,
		LEGACY_ENTERED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		POW_REGISTRY_DETAIL_H_S.nextval,
		:old.POW_REGISTRY_DETAIL_ID,
		:old.PRISONER_OF_WAR_REGISTRY_ID,
		:old.POW_DATA_SOURCE_TYPE_ID,
		:old.POW_DOCUMENT_TYPE_ID,
		:old.POW_CONFINE_LOCN_TYPE_ID,
		:old.STD_POWCASUALTYLOCATION_ID,
		:old.POW_CAPTURE_DATE_TXT,
		:old.POW_RELEASE_DATE_TXT,
		:old.NUMBER_OF_DAYS_IN_CAPTIVITY,
		:old.LEGACY_ENTERED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into POW_REGISTRY_DETAIL_H
		(
		POW_REGISTRY_DETAIL_H_ID,
		POW_REGISTRY_DETAIL_ID,
		PRISONER_OF_WAR_REGISTRY_ID,
		POW_DATA_SOURCE_TYPE_ID,
		POW_DOCUMENT_TYPE_ID,
		POW_CONFINE_LOCN_TYPE_ID,
		STD_POWCASUALTYLOCATION_ID,
		POW_CAPTURE_DATE_TXT,
		POW_RELEASE_DATE_TXT,
		NUMBER_OF_DAYS_IN_CAPTIVITY,
		LEGACY_ENTERED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		POW_REGISTRY_DETAIL_H_S.nextval,
		:new.POW_REGISTRY_DETAIL_ID,
		:new.PRISONER_OF_WAR_REGISTRY_ID,
		:new.POW_DATA_SOURCE_TYPE_ID,
		:new.POW_DOCUMENT_TYPE_ID,
		:new.POW_CONFINE_LOCN_TYPE_ID,
		:new.STD_POWCASUALTYLOCATION_ID,
		:new.POW_CAPTURE_DATE_TXT,
		:new.POW_RELEASE_DATE_TXT,
		:new.NUMBER_OF_DAYS_IN_CAPTIVITY,
		:new.LEGACY_ENTERED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end pow_reg_det_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM POW_REGISTRY_DETAIL FOR ADR.POW_REGISTRY_DETAIL;


ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_PK
  PRIMARY KEY
  (POW_REGISTRY_DETAIL_ID)
  USING INDEX ADR.POWREGDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.POW_REGISTRY_DETAIL ADD (
  CONSTRAINT POWREGDTL_POW_FK 
  FOREIGN KEY (PRISONER_OF_WAR_REGISTRY_ID) 
  REFERENCES ADR.PRISONER_OF_WAR_REGISTRY (PRISONER_OF_WAR_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.POW_REGISTRY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.POW_REGISTRY_DETAIL TO ADR_RW;
ALTER TABLE ADR.PH_REGISTRY_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PH_REGISTRY_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PH_REGISTRY_DETAIL_H
(
  PH_REGISTRY_DETAIL_H_ID      NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  PH_REGISTRY_DETAIL_ID        NUMBER(20)       NOT NULL,
  PURPLE_HEART_REGISTRY_ID     NUMBER(20)       NOT NULL,
  PH_DOCUMENT_TYPE_ID          NUMBER(20),
  PH_DATA_SOURCE_TYPE_ID       NUMBER(20),
  PH_DOCUMENT_RECEIVED_DATE    DATE,
  PH_DOCUMENT_LOGIN_DATE       DATE,
  PH_DOCUMENT_LOGIN_USERNAME   VARCHAR2(30 BYTE),
  PH_DOCUMENT_ACCEPTABLE_IND   VARCHAR2(1 BYTE),
  PH_DOC_UNACCEPTABLE_REMARKS  VARCHAR2(2000 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PH_REGISTRY_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_REGISTRY_DETAIL_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PURPLE_HEART_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DOCUMENT_RECEIVED_DATE IS 'BR2352DateDocument Receivedisdefinedasis thedatetheHECreceived PHdocumentationfroma siteoraveteranor veteranrepresentative. Acceptableentriesare: thecurrentdaysdateor oneinthepastbutNOTa futuredate.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DOCUMENT_LOGIN_DATE IS 'DatethePHDocumentation wasenteredintothe system';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DOCUMENT_LOGIN_USERNAME IS 'Nameofuserwhokeyedin PHDocumentationintothe system';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DOCUMENT_ACCEPTABLE_IND IS 'BR2358Document AcceptableIndicatoris definedasthevalueof YESorNOifthedocument receivedfromasiteor theveteranhasmetthe criteriadefinedinthe VHADirective.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.PH_DOC_UNACCEPTABLE_REMARKS IS 'BR2361Unacceptable Remarksisdefinedasis afreetextfieldthat allowstheuserto commentonwhyadocument wasunacceptableafter theyhavesentaPH630A letter.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PHREGDTLH_PK ON ADR.PH_REGISTRY_DETAIL_H
(PH_REGISTRY_DETAIL_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTLH_PRPLHRTREG_NU_I ON ADR.PH_REGISTRY_DETAIL_H
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PH_REGISTRY_DETAIL_H FOR ADR.PH_REGISTRY_DETAIL_H;


ALTER TABLE ADR.PH_REGISTRY_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_071
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PHREGDTLH_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_H_ID)
  USING INDEX ADR.PHREGDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PH_REGISTRY_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.PH_REGISTRY_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.PH_REGISTRY_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PH_REGISTRY_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.PH_REGISTRY_DETAIL
(
  PH_REGISTRY_DETAIL_ID        NUMBER(20)       NOT NULL,
  PURPLE_HEART_REGISTRY_ID     NUMBER(20)       NOT NULL,
  PH_DOCUMENT_TYPE_ID          NUMBER(20),
  PH_DATA_SOURCE_TYPE_ID       NUMBER(20),
  PH_DOCUMENT_RECEIVED_DATE    DATE,
  PH_DOCUMENT_LOGIN_DATE       DATE,
  PH_DOCUMENT_LOGIN_USERNAME   VARCHAR2(30 BYTE),
  PH_DOCUMENT_ACCEPTABLE_IND   VARCHAR2(1 BYTE),
  PH_DOC_UNACCEPTABLE_REMARKS  VARCHAR2(2000 BYTE),
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PH_REGISTRY_DETAIL IS 'Contains details about a Purple Heart Registry Such as when PH documentation was received, when and who logged it in to the system.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_REGISTRY_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PURPLE_HEART_REGISTRY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_TYPE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DATA_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_RECEIVED_DATE IS 'BR2352DateDocument Receivedisdefinedasis thedatetheHECreceived PHdocumentationfroma siteoraveteranor veteranrepresentative. Acceptableentriesare: thecurrentdaysdateor oneinthepastbutNOTa futuredate.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_LOGIN_DATE IS 'DatethePHDocumentation wasenteredintothe system';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_LOGIN_USERNAME IS 'Nameofuserwhokeyedin PHDocumentationintothe system';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOCUMENT_ACCEPTABLE_IND IS 'BR2358Document AcceptableIndicatoris definedasthevalueof YESorNOifthedocument receivedfromasiteor theveteranhasmetthe criteriadefinedinthe VHADirective.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.PH_DOC_UNACCEPTABLE_REMARKS IS 'BR2361Unacceptable Remarksisdefinedasis afreetextfieldthat allowstheuserto commentonwhyadocument wasunacceptableafter theyhavesentaPH630A letter.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PH_REGISTRY_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PHREGDTL_PK ON ADR.PH_REGISTRY_DETAIL
(PH_REGISTRY_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTL_PRPLHRTREG_FK_I ON ADR.PH_REGISTRY_DETAIL
(PURPLE_HEART_REGISTRY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTL_STD_DCRNDOCTYP_FK_I ON ADR.PH_REGISTRY_DETAIL
(PH_DOCUMENT_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHREGDTL_STD_PHDATASRC_FK_I ON ADR.PH_REGISTRY_DETAIL
(PH_DATA_SOURCE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PH_REGISTRY_DET_audir_trgr
after Update or Delete or Insert
ON ADR.PH_REGISTRY_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PH_REGISTRY_DETAIL_H
		(
  		 PH_REGISTRY_DETAIL_H_ID,
 		 PH_REGISTRY_DETAIL_ID,
 		 PH_DOCUMENT_TYPE_ID,
		 PURPLE_HEART_REGISTRY_ID,
		 PH_DATA_SOURCE_TYPE_ID,
 		 PH_DOCUMENT_RECEIVED_DATE,
 		 PH_DOCUMENT_LOGIN_DATE,
 		 PH_DOCUMENT_LOGIN_USERNAME,
 		 PH_DOCUMENT_ACCEPTABLE_IND,
 		 PH_DOC_UNACCEPTABLE_REMARKS,
 		 RECORD_CREATED_BY,
 		 RECORD_CREATED_DATE,
 		 RECORD_MODIFIED_BY,
 		 RECORD_MODIFIED_DATE,
 		 RECORD_MODIFIED_COUNT,
		 TRANSACTION_TYPE_CODE
		)
		values
		(
		PH_REGISTRY_DETAIL_H_S.nextval,
		:old.PH_REGISTRY_DETAIL_ID,
		:old.PH_DOCUMENT_TYPE_ID,
		:old.PURPLE_HEART_REGISTRY_ID,
		:old.PH_DATA_SOURCE_TYPE_ID,
		:old.PH_DOCUMENT_RECEIVED_DATE,
		:old.PH_DOCUMENT_LOGIN_DATE,
		:old.PH_DOCUMENT_LOGIN_USERNAME,
		:old.PH_DOCUMENT_ACCEPTABLE_IND,
		:old.PH_DOC_UNACCEPTABLE_REMARKS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PH_REGISTRY_DETAIL_H
		(
  		 PH_REGISTRY_DETAIL_H_ID,
 		 PH_REGISTRY_DETAIL_ID,
 		 PH_DOCUMENT_TYPE_ID,
		 PURPLE_HEART_REGISTRY_ID,
		 PH_DATA_SOURCE_TYPE_ID,
 		 PH_DOCUMENT_RECEIVED_DATE,
 		 PH_DOCUMENT_LOGIN_DATE,
 		 PH_DOCUMENT_LOGIN_USERNAME,
 		 PH_DOCUMENT_ACCEPTABLE_IND,
 		 PH_DOC_UNACCEPTABLE_REMARKS,
 		 RECORD_CREATED_BY,
 		 RECORD_CREATED_DATE,
 		 RECORD_MODIFIED_BY,
 		 RECORD_MODIFIED_DATE,
 		 RECORD_MODIFIED_COUNT,
		 TRANSACTION_TYPE_CODE
		)
		values
		(
		PH_REGISTRY_DETAIL_H_S.nextval,
		:new.PH_REGISTRY_DETAIL_ID,
		:new.PH_DOCUMENT_TYPE_ID,
		:new.PURPLE_HEART_REGISTRY_ID,
		:new.PH_DATA_SOURCE_TYPE_ID,
		:new.PH_DOCUMENT_RECEIVED_DATE,
		:new.PH_DOCUMENT_LOGIN_DATE,
		:new.PH_DOCUMENT_LOGIN_USERNAME,
		:new.PH_DOCUMENT_ACCEPTABLE_IND,
		:new.PH_DOC_UNACCEPTABLE_REMARKS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PH_REGISTRY_DET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PH_REGISTRY_DETAIL FOR ADR.PH_REGISTRY_DETAIL;


ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PK
  PRIMARY KEY
  (PH_REGISTRY_DETAIL_ID)
  USING INDEX ADR.PHREGDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PH_REGISTRY_DETAIL ADD (
  CONSTRAINT PHREGDTL_PRPLHRTREG_FK 
  FOREIGN KEY (PURPLE_HEART_REGISTRY_ID) 
  REFERENCES ADR.PURPLE_HEART_REGISTRY (PURPLE_HEART_REGISTRY_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PH_REGISTRY_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PH_REGISTRY_DETAIL TO ADR_RW;
ALTER TABLE ADR.PHONE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PHONE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PHONE_H
(
  PHONE_H_ID                   NUMBER(20)       NOT NULL,
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE) NOT NULL,
  PHONE_ID                     NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20),
  INSURANCE_ID                 NUMBER(20),
  PHONE_TYPE_ID                NUMBER(20)       NOT NULL,
  PHONE_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  PHONE_NUMBER                 VARCHAR2(128 BYTE) NOT NULL,
  CHANGE_EFFECTIVE_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE),
  PERSON_RELATION_ID           NUMBER(20)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PHONE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PHONE_H.PHONE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PHONE_H.PHONE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PHONE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PHONE_H.INSURANCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE_H.PHONE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE_H.PHONE_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.PHONE_H.PHONE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE_H.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof emailaddresswentinto effect.';

COMMENT ON COLUMN ADR.PHONE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PHONE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PHONE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PHONE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PHONE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PHONE_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.PHONE_H.PERSON_RELATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';


CREATE UNIQUE INDEX ADR.PHONEH_PK ON ADR.PHONE_H
(PHONE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHONEH_PRSNID_NU_I ON ADR.PHONE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PHONE_H FOR ADR.PHONE_H;


ALTER TABLE ADR.PHONE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_064
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PHONEH_PK
  PRIMARY KEY
  (PHONE_H_ID)
  USING INDEX ADR.PHONEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PHONE_H TO ADR_R;

GRANT SELECT ON ADR.PHONE_H TO ADR_RW;

GRANT SELECT ON ADR.PHONE_H TO PSIM_ADR_R;
ALTER TABLE ADR.PHONE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PHONE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PHONE
(
  PHONE_ID                     NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20),
  INSURANCE_ID                 NUMBER(20),
  PHONE_TYPE_ID                NUMBER(20)       NOT NULL,
  PHONE_CHANGE_SOURCE_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID           NUMBER(20),
  PHONE_NUMBER                 VARCHAR2(128 BYTE) NOT NULL,
  CHANGE_EFFECTIVE_DATE        DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE),
  PERSON_RELATION_ID           NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PHONE IS 'The PHONE table stores phone numbers for persons and insurance companies. Maintains all types of phone information for Persons. Also stores Insurance Company telephone information. Foreign Keys present in table: PERSON_ID INSURANCE_ID PHONE_TYPE_ID (Types of telephones applicable to persons - Residential, Business etc.) DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PHONE.PHONE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PHONE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PHONE.INSURANCE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE.PHONE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE.PHONE_CHANGE_SOURCE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE.PHONE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PHONE.CHANGE_EFFECTIVE_DATE IS 'Dateonwhichachangeof phonewentintoeffect.';

COMMENT ON COLUMN ADR.PHONE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PHONE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PHONE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PHONE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PHONE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PHONE.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.PHONE.PERSON_RELATION_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';


CREATE INDEX ADR.PHONE_INSURANCE_FK_I ON ADR.PHONE
(INSURANCE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PHONE_PK ON ADR.PHONE
(PHONE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHONE_PRSNREL_FK_I ON ADR.PHONE
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHONE_PRSN_FK_I ON ADR.PHONE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHONE_STDINST_FK_I ON ADR.PHONE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHONE_STD_PHCHGSRC_FK_I ON ADR.PHONE
(PHONE_CHANGE_SOURCE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PHONE_STD_PHONECTACTTYP_FK_I ON ADR.PHONE
(PHONE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PHONE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PHONE for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PHONE_H
    (
    PHONE_H_ID,
    PHONE_ID  ,
    PHONE_NUMBER,
    CHANGE_EFFECTIVE_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY ,
    RECORD_MODIFIED_DATE,
    INSURANCE_ID        ,
    PHONE_TYPE_ID       ,
    PERSON_ID           ,
    RECORD_MODIFIED_COUNT,
    STD_INSTITUTION_ID  ,
    PHONE_CHANGE_SOURCE_TYPE_ID,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PHONE_h_s.nextval,
    :old.PHONE_ID  ,
    :old.PHONE_NUMBER,
    :old.CHANGE_EFFECTIVE_DATE,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY ,
    :old.RECORD_MODIFIED_DATE,
    :old.INSURANCE_ID        ,
    :old.PHONE_TYPE_ID       ,
    :old.PERSON_ID           ,
    :old.RECORD_MODIFIED_COUNT,
    :old.STD_INSTITUTION_ID  ,
    :old.PHONE_CHANGE_SOURCE_TYPE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    :old.PERSON_RELATION_ID,
    'D'
    );
  IF :OLD.PERSON_ID IS NOT NULL THEN
    INSERT INTO ADR_EXTRACT_CHGS
      (
      PERSON_ID   ,
      CHG_DATE,
      ADR_EXTRACT_CHGS_ID
      )
      VALUES
      (:OLD.PERSON_ID,
      TRUNC(SYSDATE),
      ADR_EXTRACT_CHGS_S.NEXTVAL
      );
  END IF;
  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;
    insert into PHONE_H
    (
    PHONE_H_ID,
    PHONE_ID  ,
    PHONE_NUMBER,
    CHANGE_EFFECTIVE_DATE,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY ,
    RECORD_MODIFIED_DATE,
    INSURANCE_ID        ,
    PHONE_TYPE_ID       ,
    PERSON_ID           ,
    RECORD_MODIFIED_COUNT,
    STD_INSTITUTION_ID  ,
    PHONE_CHANGE_SOURCE_TYPE_ID,
    RECORD_MODIFIED_SRC_NAME,
    PERSON_RELATION_ID,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PHONE_h_s.nextval,
    :new.PHONE_ID  ,
    :new.PHONE_NUMBER,
    :new.CHANGE_EFFECTIVE_DATE,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY ,
    :new.RECORD_MODIFIED_DATE,
    :new.INSURANCE_ID        ,
    :new.PHONE_TYPE_ID       ,
    :new.PERSON_ID           ,
    :new.RECORD_MODIFIED_COUNT,
    :new.STD_INSTITUTION_ID  ,
    :new.PHONE_CHANGE_SOURCE_TYPE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    :new.PERSON_RELATION_ID,
    mDML
    );
  IF :NEW.PERSON_ID IS NOT NULL THEN
    INSERT INTO ADR_EXTRACT_CHGS
      (
      PERSON_ID   ,
      CHG_DATE,
      ADR_EXTRACT_CHGS_ID
      )
      VALUES
      (:NEW.PERSON_ID,
      TRUNC(SYSDATE),
      ADR_EXTRACT_CHGS_S.NEXTVAL
      );
  END IF;
  end if;

end PHONE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PHONE FOR ADR.PHONE;


ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_PK
  PRIMARY KEY
  (PHONE_ID)
  USING INDEX ADR.PHONE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PHONE ADD (
  CONSTRAINT PHONE_INSURANCE_FK 
  FOREIGN KEY (INSURANCE_ID) 
  REFERENCES ADR.INSURANCE (INSURANCE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT PHONE_PRSNREL_FK 
  FOREIGN KEY (PERSON_RELATION_ID) 
  REFERENCES ADR.PERSON_RELATION (PERSON_RELATION_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT PHONE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PHONE TO ADREXT;

GRANT SELECT ON ADR.PHONE TO ADRTMP;

GRANT SELECT ON ADR.PHONE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PHONE TO ADR_RW;

GRANT SELECT ON ADR.PHONE TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PHONE TO PSIM_ADR_RW;
ALTER TABLE ADR.PERSON_UNMERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_UNMERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_UNMERGE
(
  PERSON_UNMERGE_ID      NUMBER(20)             NOT NULL,
  PERSON_ID_1            NUMBER(20),
  PERSON_ID_2            NUMBER(20),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_UNMERGE IS 'In the case that two distinct identities of Persons have mistakenly been merged into a single record, the merged record will now have to be un-merged in this table.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.PERSON_UNMERGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_UNMERGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNUNMRG_PK ON ADR.PERSON_UNMERGE
(PERSON_UNMERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_UNMERGE FOR ADR.PERSON_UNMERGE;


ALTER TABLE ADR.PERSON_UNMERGE ADD (
  CONSTRAINT PRSNUNMRG_PK
  PRIMARY KEY
  (PERSON_UNMERGE_ID)
  USING INDEX ADR.PRSNUNMRG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_UNMERGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_UNMERGE TO ADR_RW;
ALTER TABLE ADR.PERSON_RELATION_UNMERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RELATION_UNMERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RELATION_UNMERGE
(
  PERSON_RELATION_UNMERGE_ID  NUMBER(20)        NOT NULL,
  PERSON_RELATION_ID_2        NUMBER(20),
  PERSON_RELATION_ID_1        NUMBER(20),
  RECORD_CREATED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE         DATE              NOT NULL,
  RECORD_MODIFIED_BY          VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE        DATE              NOT NULL,
  RECORD_MODIFIED_COUNT       NUMBER(10)        NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RELATION_UNMERGE IS 'In the case that two distinct identities of person relations (such as spouses or dependents) have mistakenly been merged into a single record, the merged record will now have to be un-merged in this table.';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.PERSON_RELATION_UNMERGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.PERSON_RELATION_ID_2 IS 'StorestheID(first duplicate)ofthespouse ordependent.';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.PERSON_RELATION_ID_1 IS 'StorestheIDofthe spouseordependent record.';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RELATION_UNMERGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNRELUNM_PK ON ADR.PERSON_RELATION_UNMERGE
(PERSON_RELATION_UNMERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_RELATION_UNMERGE FOR ADR.PERSON_RELATION_UNMERGE;


ALTER TABLE ADR.PERSON_RELATION_UNMERGE ADD (
  CONSTRAINT PRSNRELUNM_PK
  PRIMARY KEY
  (PERSON_RELATION_UNMERGE_ID)
  USING INDEX ADR.PRSNRELUNM_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RELATION_UNMERGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION_UNMERGE TO ADR_RW;
ALTER TABLE ADR.PERSON_RELATION_MERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RELATION_MERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RELATION_MERGE
(
  PERSON_RELATION_MERGE_ID  NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  PERSON_RELATION_ID_1      NUMBER(20),
  PERSON_RELATION_ID_2      NUMBER(20),
  MERGE_IN_PROGRESS_FLAG    NUMBER(1)           DEFAULT 0,
  MERGE_RECORD_LOCKED_FLAG  NUMBER(1)           DEFAULT 0,
  MERGE_DATA_TEXT           VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RELATION_MERGE IS ' In the case that the identity of a person relation (such as a spouse or dependent) has been duplicated in the system, the duplicate records are merged together in this table.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.PERSON_RELATION_MERGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.PERSON_RELATION_ID_1 IS 'StorestheIDofthe spouseordependent record.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.PERSON_RELATION_ID_2 IS 'StorestheID(first duplicate)ofthespouse ordependent.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.MERGE_IN_PROGRESS_FLAG IS 'NumericFLAGrecord-if 1,indicatesthatthe mergeprocessisongoing';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.MERGE_RECORD_LOCKED_FLAG IS 'FLAGvalue-indicates whetherrecordislocked ornot.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.MERGE_DATA_TEXT IS 'Storesalltherelated datageneratedduringthe mergeprocess,forthis record';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RELATION_MERGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNRELMRG_PK ON ADR.PERSON_RELATION_MERGE
(PERSON_RELATION_MERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRELMRG_PRSN_FK_I ON ADR.PERSON_RELATION_MERGE
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_RELATION_MERGE FOR ADR.PERSON_RELATION_MERGE;


ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_001
  CHECK (MERGE_IN_PROGRESS_FLAG BETWEEN 0
AND 0 OR MERGE_IN_PROGRESS_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_MERGE_002
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT PRSNRELMRG_PK
  PRIMARY KEY
  (PERSON_RELATION_MERGE_ID)
  USING INDEX ADR.PRSNRELMRG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_RELATION_MERGE ADD (
  CONSTRAINT PRSNRELMRG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RELATION_MERGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION_MERGE TO ADR_RW;
ALTER TABLE ADR.PERSON_RELATION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RELATION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RELATION_H
(
  PERSON_RELATION_H_ID           NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  PERSON_RELATION_ID             NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_GENDER_ID                  NUMBER(20),
  PERSON_RELATION_TYPE_ID        NUMBER(20),
  PRSN_RELATION_MAPPING_TYPE_CD  VARCHAR2(5 BYTE),
  HEC_IEN                        VARCHAR2(20 BYTE),
  PREFIX                         VARCHAR2(12 BYTE),
  FIRST_NAME                     VARCHAR2(30 BYTE),
  MIDDLE_NAME                    VARCHAR2(30 BYTE),
  LAST_NAME                      VARCHAR2(40 BYTE),
  MAIDEN_NAME                    VARCHAR2(40 BYTE),
  SUFFIX                         VARCHAR2(12 BYTE),
  BIRTH_DATE_TXT                 VARCHAR2(14 BYTE),
  EDUCATIONAL_DEGREE             VARCHAR2(30 BYTE),
  RELATION_EFFECTIVE_DATE_TXT    VARCHAR2(14 BYTE),
  RELATION_END_DATE              DATE,
  INCAPABLE_SELF_SUPPORT_IND     VARCHAR2(1 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RELATION_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.PERSON_RELATION_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.STD_GENDER_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.PERSON_RELATION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.PRSN_RELATION_MAPPING_TYPE_CD IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.HEC_IEN IS 'Uniqueidentifierusedin thelegacyHECsystem. RecordsfromtheADR,the HECLegacysystemand alsothecurrentIVM systemcanbetied togetherusingthis number.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.BIRTH_DATE_TXT IS 'BR7731Thedateofbirth isdefinedasthebirth dateoftheveteranor spouseassociatedwith thecommunicationtobe mailed.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RELATION_EFFECTIVE_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RELATION_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.INCAPABLE_SELF_SUPPORT_IND IS 'BR2084DependentChildis PermanentlyIncapableOf Self-Support.Indicator isdefinedasan Indicatorifthechildis overtheageof18and becamepermanently incapableofselfsupport beforereachingtheage of18.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RELATION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNRELH_PK ON ADR.PERSON_RELATION_H
(PERSON_RELATION_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRELH_PRSNID_NU_I ON ADR.PERSON_RELATION_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRELH_PRSNRELID_NU_I ON ADR.PERSON_RELATION_H
(PERSON_RELATION_ID, PRSN_RELATION_MAPPING_TYPE_CD)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_RELATION_H FOR ADR.PERSON_RELATION_H;


ALTER TABLE ADR.PERSON_RELATION_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_027
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRSNRELH_PK
  PRIMARY KEY
  (PERSON_RELATION_H_ID)
  USING INDEX ADR.PRSNRELH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RELATION_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_RELATION_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RELATION_H TO PSIM_ADR_R;
ALTER TABLE ADR.PERSON_RELATION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RELATION CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RELATION
(
  PERSON_RELATION_ID             NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  STD_GENDER_ID                  NUMBER(20),
  PERSON_RELATION_TYPE_ID        NUMBER(20),
  PRSN_RELATION_MAPPING_TYPE_CD  VARCHAR2(5 BYTE),
  HEC_IEN                        VARCHAR2(20 BYTE),
  PREFIX                         VARCHAR2(12 BYTE),
  FIRST_NAME                     VARCHAR2(30 BYTE),
  MIDDLE_NAME                    VARCHAR2(30 BYTE),
  LAST_NAME                      VARCHAR2(40 BYTE),
  MAIDEN_NAME                    VARCHAR2(40 BYTE),
  SUFFIX                         VARCHAR2(12 BYTE),
  BIRTH_DATE_TXT                 VARCHAR2(14 BYTE),
  EDUCATIONAL_DEGREE             VARCHAR2(30 BYTE),
  RELATION_EFFECTIVE_DATE_TXT    VARCHAR2(14 BYTE),
  RELATION_END_DATE              DATE,
  INCAPABLE_SELF_SUPPORT_IND     VARCHAR2(1 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   4
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RELATION IS 'The table stores information about the spouse and dependent(s) associated with a person, including their name, date of birth, gender, and type of relationship. Spouses and Dependents are not enumerated by the Identity Management service. They exist only as details to the Person record. PERSON_ID is a mandatory foreign key to this table. DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PERSON_RELATION.PERSON_RELATION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RELATION.STD_GENDER_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PERSON_RELATION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PRSN_RELATION_MAPPING_TYPE_CD IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.HEC_IEN IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_RELATION.FIRST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.MIDDLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.LAST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.MAIDEN_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_RELATION.BIRTH_DATE_TXT IS 'BR7731Thedateofbirth isdefinedasthebirth dateoftheveteranor spouseassociatedwith thecommunicationtobe mailed.';

COMMENT ON COLUMN ADR.PERSON_RELATION.EDUCATIONAL_DEGREE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RELATION_EFFECTIVE_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RELATION_END_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.INCAPABLE_SELF_SUPPORT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RELATION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRSNREL_PK ON ADR.PERSON_RELATION
(PERSON_RELATION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_PRSN_FK_I ON ADR.PERSON_RELATION
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_SG_FK_I ON ADR.PERSON_RELATION
(STD_GENDER_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_STD_PRSNREL_FK_I ON ADR.PERSON_RELATION
(PRSN_RELATION_MAPPING_TYPE_CD)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNREL_STD_RELTYP_FK_I ON ADR.PERSON_RELATION
(PERSON_RELATION_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_RELATION_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_RELATION
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERSON_RELATION_H
		(
		PERSON_RELATION_H_ID,
		PERSON_RELATION_ID,
		PERSON_ID,
		STD_GENDER_ID,
		PERSON_RELATION_TYPE_ID,
		PRSN_RELATION_MAPPING_TYPE_CD,
		HEC_IEN,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		SUFFIX,
		BIRTH_DATE_TXT,
		EDUCATIONAL_DEGREE,
		RELATION_EFFECTIVE_DATE_TXT,
		RELATION_END_DATE,
		INCAPABLE_SELF_SUPPORT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_RELATION_H_S.nextval,
		:old.PERSON_RELATION_ID,
		:old.PERSON_ID,
		:old.STD_GENDER_ID,
		:old.PERSON_RELATION_TYPE_ID,
		:old.PRSN_RELATION_MAPPING_TYPE_CD,
		:old.HEC_IEN,
		:old.PREFIX,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.MAIDEN_NAME,
		:old.SUFFIX,
		:old.BIRTH_DATE_TXT,
		:old.EDUCATIONAL_DEGREE,
		:old.RELATION_EFFECTIVE_DATE_TXT,
		:old.RELATION_END_DATE,
		:old.INCAPABLE_SELF_SUPPORT_IND,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERSON_RELATION_H
		(
		PERSON_RELATION_H_ID,
		PERSON_RELATION_ID,
		PERSON_ID,
		STD_GENDER_ID,
		PERSON_RELATION_TYPE_ID,
		PRSN_RELATION_MAPPING_TYPE_CD,
		HEC_IEN,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		MAIDEN_NAME,
		SUFFIX,
		BIRTH_DATE_TXT,
		EDUCATIONAL_DEGREE,
		RELATION_EFFECTIVE_DATE_TXT,
		RELATION_END_DATE,
		INCAPABLE_SELF_SUPPORT_IND,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_RELATION_H_S.nextval,
		:new.PERSON_RELATION_ID,
		:new.PERSON_ID,
		:new.STD_GENDER_ID,
		:new.PERSON_RELATION_TYPE_ID,
		:new.PRSN_RELATION_MAPPING_TYPE_CD,
		:new.HEC_IEN,
		:new.PREFIX,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.MAIDEN_NAME,
		:new.SUFFIX,
		:new.BIRTH_DATE_TXT,
		:new.EDUCATIONAL_DEGREE,
		:new.RELATION_EFFECTIVE_DATE_TXT,
		:new.RELATION_END_DATE,
		:new.INCAPABLE_SELF_SUPPORT_IND,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERSON_RELATION_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_RELATION FOR ADR.PERSON_RELATION;


ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PK
  PRIMARY KEY
  (PERSON_RELATION_ID)
  USING INDEX ADR.PRSNREL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_RELATION ADD (
  CONSTRAINT PRSNREL_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RELATION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RELATION TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RELATION TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_RELATION TO PSIM_ADR_RW;
ALTER TABLE ADR.PERSON_RACE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RACE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RACE_H
(
  PERSON_RACE_H_ID           NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  PERSON_RACE_ID             NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_RACE_ID                NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RACE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.	All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.PERSON_RACE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.PERSON_RACE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.STD_RACE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_RACE_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNRACEH_PK ON ADR.PERSON_RACE_H
(PERSON_RACE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACEH_PRSNID_NU_I ON ADR.PERSON_RACE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_RACE_H FOR ADR.PERSON_RACE_H;


ALTER TABLE ADR.PERSON_RACE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_034
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRSNRACEH_PK
  PRIMARY KEY
  (PERSON_RACE_H_ID)
  USING INDEX ADR.PRSNRACEH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RACE_H TO ADREXT;

GRANT SELECT ON ADR.PERSON_RACE_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_RACE_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RACE_H TO PSIM_ADR_R;
ALTER TABLE ADR.PERSON_RACE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_RACE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_RACE
(
  PERSON_RACE_ID             NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_RACE_ID                NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_RACE IS 'The table stores information a persons reported race and the method by which that information was reported. DEMOGRAPHICS';

COMMENT ON COLUMN ADR.PERSON_RACE.PERSON_RACE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_RACE.STD_RACE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_RACE.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNRACE_PK ON ADR.PERSON_RACE
(PERSON_RACE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_PRSN_FK_I ON ADR.PERSON_RACE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_STDINST2_FK_I ON ADR.PERSON_RACE
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_STDRACE_FK_I ON ADR.PERSON_RACE
(STD_RACE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNRACE_STD_CLLNMTHD_FK_I ON ADR.PERSON_RACE
(COLLECTION_METHOD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_RACE_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_RACE for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PERSON_RACE_H
    (
    PERSON_RACE_H_ID,
    PERSON_RACE_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_RACE_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_RACE_H_S.nextval,
    :old.PERSON_RACE_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.STD_RACE_ID,
    :old.COLLECTION_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.RECORD_MODIFIED_SITE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    'D'
    );

    IF :OLD.PERSON_ID IS NOT NULL THEN
      INSERT INTO ADR_EXTRACT_CHGS
        (
        PERSON_ID   ,
        CHG_DATE,
        ADR_EXTRACT_CHGS_ID
        )
        VALUES
        (:OLD.PERSON_ID,
        TRUNC(SYSDATE),
        ADR_EXTRACT_CHGS_S.NEXTVAL
        );
    END IF;

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into PERSON_RACE_H
    (
    PERSON_RACE_H_ID,
    PERSON_RACE_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_RACE_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_RACE_H_S.nextval,
    :new.PERSON_RACE_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.STD_RACE_ID,
    :new.COLLECTION_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.RECORD_MODIFIED_SITE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    mDML
    );

    IF :NEW.Person_id IS NOT NULL THEN

      IF Mdml = 'I'
      OR NVL(:OLD.STD_RACE_ID,-9) !=
          NVL(:NEW.STD_RACE_ID,-9) THEN

        INSERT
        INTO      Adr_Extract_Chgs
                  (Person_id,
                   Chg_date,
                   Adr_extract_chgs_id )
        VALUES    (:NEW.Person_id,
                   TRUNC( SYSDATE ),
                   Adr_extract_chgs_s.NEXTVAL);

      END IF;

    END IF;

  end if;

end PERSON_RACE_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_RACE FOR ADR.PERSON_RACE;


ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PK
  PRIMARY KEY
  (PERSON_RACE_ID)
  USING INDEX ADR.PRSNRACE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_RACE ADD (
  CONSTRAINT PRSNRACE_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_RACE TO ADREXT;

GRANT SELECT ON ADR.PERSON_RACE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_RACE TO ADR_RW;

GRANT SELECT ON ADR.PERSON_RACE TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_RACE TO PSIM_ADR_RW;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_PREFERRED_LANGUAGE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_PREFERRED_LANGUAGE_H
(
  PERSON_PREFERRED_LANG_H_ID    NUMBER(20)      NOT NULL,
  PERSON_PREFERRED_LANGUAGE_ID  NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_LANGUAGECODE_ID           NUMBER(20)      NOT NULL,
  LANGUAGE_ENTRY_DATE           DATE            NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL,
  HISTORY_CREATED_DATE          DATE            NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.PERSON_PREFERRED_LANG_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.PERSON_PREFERRED_LANGUAGE_ID IS 'Person_preferred_language table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.PERSON_ID IS 'person table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.STD_LANGUAGECODE_ID IS 'Language_code table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.HISTORY_CREATED_DATE IS 'Date history record created.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';


CREATE UNIQUE INDEX ADR.PERSON_PREFERRED_LANGUAGE_H_PK ON ADR.PERSON_PREFERRED_LANGUAGE_H
(PERSON_PREFERRED_LANG_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_PREFERRED_LANGUAGE_H FOR ADR.PERSON_PREFERRED_LANGUAGE_H;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE_H ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_H_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANG_H_ID)
  USING INDEX ADR.PERSON_PREFERRED_LANGUAGE_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PERSON_PREFERRED_LANGUAGE_H TO ADR_RW;
ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_PREFERRED_LANGUAGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_PREFERRED_LANGUAGE
(
  PERSON_PREFERRED_LANGUAGE_ID  NUMBER(20)      NOT NULL,
  PERSON_ID                     NUMBER(20)      NOT NULL,
  STD_LANGUAGECODE_ID           NUMBER(20)      NOT NULL,
  LANGUAGE_ENTRY_DATE           DATE            NOT NULL,
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.PERSON_PREFERRED_LANGUAGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.PERSON_ID IS 'Person table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.STD_LANGUAGECODE_ID IS 'Language_code table primary key';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_PREFERRED_LANGUAGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PERSON_PREFERRED_LANGUAGE_PK ON ADR.PERSON_PREFERRED_LANGUAGE
(PERSON_PREFERRED_LANGUAGE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRSNPRFLNG_PRSN_ID_UI ON ADR.PERSON_PREFERRED_LANGUAGE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PRSN_PREF_LANG_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PERSON_PREFERRED_LANGUAGE  REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
  if DELETING then
      insert into PERSON_PREFERRED_LANGUAGE_H
      (
      PERSON_PREFERRED_LANG_H_ID,
      PERSON_PREFERRED_LANGUAGE_ID,
      PERSON_ID,
      STD_LANGUAGECODE_ID,
      LANGUAGE_ENTRY_DATE,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      HISTORY_CREATED_DATE,
      TRANSACTION_TYPE_CODE
      )
      values
      (
      PERSON_PREFERRED_LANGUAGE_H_S.nextval,
      :old.PERSON_PREFERRED_LANGUAGE_ID,
      :old.PERSON_ID,
      :old.STD_LANGUAGECODE_ID,
      :old.LANGUAGE_ENTRY_DATE,
      :old.RECORD_CREATED_BY,
      :old.RECORD_CREATED_DATE,
      :old.RECORD_MODIFIED_BY,
      :old.RECORD_MODIFIED_DATE,
      :old.RECORD_MODIFIED_COUNT,
      SYSDATE,
      'D'
      );
      IF :OLD.PERSON_ID IS NOT NULL THEN
        INSERT
        INTO      ADR_EXTRACT_CHGS
                  (PERSON_ID   ,
                   CHG_DATE,
                   ADR_EXTRACT_CHGS_ID)
        VALUES    (:OLD.PERSON_ID,
                   TRUNC(SYSDATE),
                   ADR_EXTRACT_CHGS_S.NEXTVAL);
      END IF;
  else
      if UPDATING then
          mDML := 'U';
      else
          mDML := 'I';
      end if;

       insert into PERSON_PREFERRED_LANGUAGE_H
      (
      PERSON_PREFERRED_LANG_H_ID,
      PERSON_PREFERRED_LANGUAGE_ID,
      PERSON_ID,
      STD_LANGUAGECODE_ID,
      LANGUAGE_ENTRY_DATE,
      RECORD_CREATED_BY,
      RECORD_CREATED_DATE,
      RECORD_MODIFIED_BY,
      RECORD_MODIFIED_DATE,
      RECORD_MODIFIED_COUNT,
      HISTORY_CREATED_DATE,
      TRANSACTION_TYPE_CODE
      )
      values
      (
      PERSON_PREFERRED_LANGUAGE_H_S.nextval,
      :new.PERSON_PREFERRED_LANGUAGE_ID,
      :new.PERSON_ID,
      :new.STD_LANGUAGECODE_ID,
      :new.LANGUAGE_ENTRY_DATE,
      :new.RECORD_CREATED_BY,
      :new.RECORD_CREATED_DATE,
      :new.RECORD_MODIFIED_BY,
      :new.RECORD_MODIFIED_DATE,
      :new.RECORD_MODIFIED_COUNT,
      SYSDATE,
      mDML
      );
      IF :NEW.PERSON_ID IS NOT NULL THEN
        INSERT
        INTO      ADR_EXTRACT_CHGS
                  (PERSON_ID   ,
                   CHG_DATE,
                   ADR_EXTRACT_CHGS_ID)
        VALUES    (:NEW.PERSON_ID,
                   TRUNC(SYSDATE),
                   ADR_EXTRACT_CHGS_S.NEXTVAL);
        END IF;
  end if;

end PRSN_PREF_LANG_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_PREFERRED_LANGUAGE FOR ADR.PERSON_PREFERRED_LANGUAGE;


ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PERSON_PREFERRED_LANGUAGE_PK
  PRIMARY KEY
  (PERSON_PREFERRED_LANGUAGE_ID)
  USING INDEX ADR.PERSON_PREFERRED_LANGUAGE_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_PREFERRED_LANGUAGE ADD (
  CONSTRAINT PRSNPRSNPREFLANG_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE,
  CONSTRAINT STDLNGCD_PRSNPREFLNG_FK 
  FOREIGN KEY (STD_LANGUAGECODE_ID) 
  REFERENCES ADRREF.STD_LANGUAGECODE (ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ADREXT;

GRANT SELECT ON ADR.PERSON_PREFERRED_LANGUAGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_PREFERRED_LANGUAGE TO ADR_RW;
ALTER TABLE ADR.PERSON_MERGE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_MERGE CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_MERGE
(
  PERSON_MERGE_ID           NUMBER(20)          NOT NULL,
  PRIMARY_PERSON_ID         NUMBER(20),
  DEPRECATED_PERSON_ID      NUMBER(20),
  MERGE_RECORD_LOCKED_FLAG  NUMBER(1)           DEFAULT 0,
  MERGE_START_DATE          DATE,
  MERGE_END_DATE            DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  MERGE_DATA_TEXT           CLOB
)
LOB (MERGE_DATA_TEXT) STORE AS (
  TABLESPACE  M_INDEX_01
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  RETENTION
  NOCACHE
  LOGGING
      STORAGE    (
                  INITIAL          4M
                  NEXT             4M
                  MINEXTENTS       1
                  MAXEXTENTS       UNLIMITED
                  PCTINCREASE      0
                  BUFFER_POOL      DEFAULT
                  FLASH_CACHE      DEFAULT
                  CELL_FLASH_CACHE DEFAULT
                 ))
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_MERGE IS 'This table supports the person merge process - in the case of a single identity sharing two or more records in the system, the identities are merged together into a single record.';

COMMENT ON COLUMN ADR.PERSON_MERGE.PERSON_MERGE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_MERGE.PRIMARY_PERSON_ID IS 'Non-keyID-thereisno foreignkeyenforcing thisvalue.Thisfieldcontainsthe IDvaluefortheperson recordtobemerged.';

COMMENT ON COLUMN ADR.PERSON_MERGE.DEPRECATED_PERSON_ID IS 'Non-keyID-thereisno foreignkeyenforcing thisvalue.Thisfieldcontainsthe IDvalueforthe duplicatepersonrecord.';

COMMENT ON COLUMN ADR.PERSON_MERGE.MERGE_RECORD_LOCKED_FLAG IS 'NeumericFLAGrecord-if 1indicatesthatthe recordislocked.';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_MERGE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_MERGE.MERGE_DATA_TEXT IS 'Textvaluecontaining detailsofmergedrecord';


CREATE INDEX ADR.PRSNMRG_DEPRECPRSNID_NU_I ON ADR.PERSON_MERGE
(DEPRECATED_PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRSNMRG_PK ON ADR.PERSON_MERGE
(PERSON_MERGE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNMRG_PRIMRYPRSNID_NU_I ON ADR.PERSON_MERGE
(PRIMARY_PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_MERGE FOR ADR.PERSON_MERGE;


ALTER TABLE ADR.PERSON_MERGE ADD (
  CONSTRAINT AVCON_1172521913_MERGE_000
  CHECK (MERGE_RECORD_LOCKED_FLAG BETWEEN 0
AND 0 OR MERGE_RECORD_LOCKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT PRSNMRG_PK
  PRIMARY KEY
  (PERSON_MERGE_ID)
  USING INDEX ADR.PRSNMRG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_MERGE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_MERGE TO ADR_RW;
ALTER TABLE ADR.PERSON_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_H
(
  PERSON_H_ID                     NUMBER(20)    NOT NULL,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL,
  PERSON_ID                       NUMBER(20)    NOT NULL,
  VPID_ID                         NUMBER(20),
  VPID_VALUE                      VARCHAR2(30 BYTE) NOT NULL,
  HEC_IEN                         VARCHAR2(20 BYTE),
  CLAIM_FOLDER_NUMBER             VARCHAR2(20 BYTE),
  EDUCATIONAL_DEGREE              VARCHAR2(30 BYTE),
  REMARKS                         VARCHAR2(4000 BYTE),
  SENSITIVITY_IND                 VARCHAR2(1 BYTE) DEFAULT '0',
  SENSITIVITY_FLAG_SET_BY         VARCHAR2(30 BYTE),
  SENSITIVITY_FLAG_SET_DATE       DATE,
  VETERAN_IND                     VARCHAR2(1 BYTE) DEFAULT '0',
  DEATH_DATE_TXT                  VARCHAR2(14 BYTE),
  DEATH_REPORTED_DATE             DATE,
  LAZARUS_DATE_TXT                VARCHAR2(14 BYTE),
  USER_ENROLEE_SITE_ID            NUMBER(20),
  USER_ENROLEE_THROUGH_YEAR       NUMBER(4),
  DISABILITY_DISCHARGE_IND        VARCHAR2(1 BYTE),
  COMBAT_VET_ELIGIBILITY_END_DT   DATE,
  STD_PROGRAMOFSTUDY_ID           NUMBER(20),
  STD_MARITALSTATUS_ID            NUMBER(20),
  STD_RELIGION_ID                 NUMBER(20),
  MILITARY_DSBLTY_RETIREMENT_IND  VARCHAR2(1 BYTE),
  DEATH_REPORTING_SITE_ID         NUMBER(20),
  CLAIM_FOLDER_LOCATION_SITE_ID   NUMBER(20),
  DEATH_NOTIFICATION_SRC_TYPE_ID  NUMBER(20),
  VA_ASSOCIATE_TITLE              VARCHAR2(50 BYTE),
  VA_SIGNATURE_BLOCK_PRINT_NAME   VARCHAR2(40 BYTE),
  VA_SIGNATURE_BLOCK_TITLE        VARCHAR2(50 BYTE),
  VA_LAST_TRAINING_YEAR           VARCHAR2(4 BYTE),
  VAMC_MAIL_CODE                  VARCHAR2(10 BYTE),
  VA_ROOM_NUMBER                  VARCHAR2(30 BYTE),
  VA_TERMINATION_REASON_TEXT      VARCHAR2(45 BYTE),
  VA_TERMINATION_DATE             DATE,
  DEMOGRAPHIC_UPDATE_EVENT_DATE   DATE,
  PREFERRED_SITE_ID               NUMBER(20),
  WAS_PRISONER_OF_WAR_IND         VARCHAR2(1 BYTE),
  EE_MIGRATED_IND                 VARCHAR2(1 BYTE),
  APPOINTMENT_WAS_REQUESTED_IND   VARCHAR2(1 BYTE),
  APPOINTMENT_REQUESTED_DATE      DATE,
  SENSITIVITY_FLAG_SET_SRC_ID     NUMBER(20),
  SENSITIVITY_FLAG_SET_SITE_ID    NUMBER(20),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_MODIFIED_SITE_ID         NUMBER(20),
  RECORD_MODIFIED_SRC_NAME        VARCHAR2(30 BYTE),
  VOA_IND                         CHAR(1 BYTE),
  STD_MILITARYSVCQRYSTAT_ID       NUMBER(20),
  DENTAL_CLASS2_IND               VARCHAR2(1 BYTE),
  DENTAL_CLS2_APP_BEF_DUE_DATE    DATE,
  HISTORY_CREATED_DATE            DATE,
  DOD_VERIFIED_IND                VARCHAR2(1 BYTE),
  DEATH_REPORTED_BY               VARCHAR2(30 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PERSON_H.PERSON_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_H.VPID_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VPID_VALUE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.HEC_IEN IS 'Uniqueidentifierusedin thelegacyHECsystem. RecordsfromtheADR,the HECLegacysystemand alsothecurrentIVM systemcanbetied togetherusingthis number.';

COMMENT ON COLUMN ADR.PERSON_H.CLAIM_FOLDER_NUMBER IS 'Claimfoldernumberas suppliedbyVBA.Usually thesameasthepersons socialsecuritynumber.';

COMMENT ON COLUMN ADR.PERSON_H.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_IND IS 'Patientsensitivityflag fromAACisdefinedasan indicationthatthis veteranrecordisa sensitiverecordandonly thosewithabusiness purposeshouldviewthe relatedinformation.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_BY IS 'BR7316Sensitivity assignedbyisdefinedas thepersonwhosetthe recordtosensitive.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_DATE IS 'BR7318Date/Time sensitivityflagsetis definedasthetimestamp associatedwiththe sensitivityflag.';

COMMENT ON COLUMN ADR.PERSON_H.VETERAN_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.USER_ENROLEE_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.USER_ENROLEE_THROUGH_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.DISABILITY_DISCHARGE_IND IS 'Indicatesifbeneficiary wasretiredfromtheU.S. ArmedForcesduetoa disabilityincurredwhile serving.';

COMMENT ON COLUMN ADR.PERSON_H.STD_PROGRAMOFSTUDY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.STD_MARITALSTATUS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.STD_RELIGION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.MILITARY_DSBLTY_RETIREMENT_IND IS 'Indicatesifbeneficiary isreceivingMilitary Disability';

COMMENT ON COLUMN ADR.PERSON_H.DEATH_REPORTING_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.CLAIM_FOLDER_LOCATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.DEATH_NOTIFICATION_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_ASSOCIATE_TITLE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_SIGNATURE_BLOCK_PRINT_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_SIGNATURE_BLOCK_TITLE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_LAST_TRAINING_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VAMC_MAIL_CODE IS 'VAHOSPITALSERVICE NUMBER,I.E.116AFOR PSYCHIATRY,116BFOR PSYCHOLOGY,ETC';

COMMENT ON COLUMN ADR.PERSON_H.VA_ROOM_NUMBER IS 'Thisistheroomnumber assignedtotheperson.';

COMMENT ON COLUMN ADR.PERSON_H.VA_TERMINATION_REASON_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.VA_TERMINATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.PREFERRED_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.WAS_PRISONER_OF_WAR_IND IS 'BR2376PHOnlyIndicator isdefinedasthe indicatorthatidentifies theveteransinthePH Registryfilewhoarenot currentlyintheHECEDB asenrolleeswithother eligibility/enrollment datareceivingVHA services.Oncethe veteranrecordiscreated intheEDBthenthisflag isremoved';

COMMENT ON COLUMN ADR.PERSON_H.APPOINTMENT_WAS_REQUESTED_IND IS 'Indicatesifbeneficiary wasretiredfromtheU.S. ArmedForcesduetoa disabilityincurredwhile serving.';

COMMENT ON COLUMN ADR.PERSON_H.APPOINTMENT_REQUESTED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_SRC_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.SENSITIVITY_FLAG_SET_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.PERSON_H.VOA_IND IS 'Veterans Online Application indicator';

COMMENT ON COLUMN ADR.PERSON_H.DENTAL_CLASS2_IND IS 'Derived from the VBA DD214 Dental Indicator. The DD214 Dental Indicator specifies whether or not the Veteran received dental treatment at service separation. The Dental Indicator is translated from the DD214 Indicator to state whether or not the Veteran is eligible for dental services.
  2  Null means not initialized
  3  0 means `NO
  4  1 means `YES';

COMMENT ON COLUMN ADR.PERSON_H.DENTAL_CLS2_APP_BEF_DUE_DATE IS 'Null means not initialized
  2  0 means `NO
  3  1 means `YES';


CREATE UNIQUE INDEX ADR.PRSNH_PK ON ADR.PERSON_H
(PERSON_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNH_PRSNID_NU_I ON ADR.PERSON_H
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_H FOR ADR.PERSON_H;


ALTER TABLE ADR.PERSON_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_009
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRSNH_PK
  PRIMARY KEY
  (PERSON_H_ID)
  USING INDEX ADR.PRSNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_H TO CARUSR_R;

GRANT SELECT ON ADR.PERSON_H TO PSIM_ADR_R;

GRANT SELECT ON ADR.PERSON_H TO VHAISPSTALLP;
ALTER TABLE ADR.PERSON_ETHNICITY_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_ETHNICITY_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_ETHNICITY_H
(
  PERSON_ETHNICITY_H_ID      NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  PERSON_ETHNICITY_ID        NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_ETHNICITY_ID           NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_ETHNICITY_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.PERSON_ETHNICITY_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.PERSON_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.STD_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNETNCTH_PK ON ADR.PERSON_ETHNICITY_H
(PERSON_ETHNICITY_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTH_PRSNID_NU_I ON ADR.PERSON_ETHNICITY_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_ETHNICITY_H FOR ADR.PERSON_ETHNICITY_H;


ALTER TABLE ADR.PERSON_ETHNICITY_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_003
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRSNETNCTH_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_H_ID)
  USING INDEX ADR.PRSNETNCTH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADREXT;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_ETHNICITY_H TO PSIM_ADR_R;
ALTER TABLE ADR.PERSON_ETHNICITY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_ETHNICITY CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_ETHNICITY
(
  PERSON_ETHNICITY_ID        NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_ETHNICITY_ID           NUMBER(20)         NOT NULL,
  COLLECTION_METHOD_TYPE_ID  NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL,
  RECORD_MODIFIED_SITE_ID    NUMBER(20),
  RECORD_MODIFIED_SRC_NAME   VARCHAR2(30 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_ETHNICITY IS 'The table stores information a persons reported ethnic group and the method by which that information was reported. DEMOGRAPHICS';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.PERSON_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.STD_ETHNICITY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.COLLECTION_METHOD_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_ETHNICITY.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNETNCTY_PK ON ADR.PERSON_ETHNICITY
(PERSON_ETHNICITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_PRSN_FK_I ON ADR.PERSON_ETHNICITY
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_STDETH_FK_I ON ADR.PERSON_ETHNICITY
(STD_ETHNICITY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_STDINST2_FK_I ON ADR.PERSON_ETHNICITY
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNETNCTY_STD_CLLNMTHD_FK_I ON ADR.PERSON_ETHNICITY
(COLLECTION_METHOD_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_ETHNICITY_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_ETHNICITY for each row
declare
    mDML char(1);
begin

  if DELETING then
    insert into PERSON_ETHNICITY_H
    (
    PERSON_ETHNICITY_H_ID,
    PERSON_ETHNICITY_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_ETHNICITY_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_ETHNICITY_H_S.nextval,
    :old.PERSON_ETHNICITY_ID,
    :old.RECORD_CREATED_BY,
    :old.RECORD_CREATED_DATE,
    :old.RECORD_MODIFIED_BY,
    :old.RECORD_MODIFIED_DATE,
    :old.STD_ETHNICITY_ID,
    :old.COLLECTION_METHOD_TYPE_ID,
    :old.PERSON_ID,
    :old.RECORD_MODIFIED_COUNT,
    :old.RECORD_MODIFIED_SITE_ID,
    :old.RECORD_MODIFIED_SRC_NAME,
    'D'
    );

    IF :OLD.PERSON_ID IS NOT NULL THEN
      INSERT INTO ADR_EXTRACT_CHGS
        (
        PERSON_ID   ,
        CHG_DATE,
        ADR_EXTRACT_CHGS_ID
        )
        VALUES
        (:OLD.PERSON_ID,
        TRUNC(SYSDATE),
        ADR_EXTRACT_CHGS_S.NEXTVAL
        );
    END IF;

  else
    if UPDATING then
      mDML := 'U';
    else
      mDML := 'I';
    end if;

    insert into PERSON_ETHNICITY_H
    (
    PERSON_ETHNICITY_H_ID,
    PERSON_ETHNICITY_ID,
    RECORD_CREATED_BY,
    RECORD_CREATED_DATE,
    RECORD_MODIFIED_BY,
    RECORD_MODIFIED_DATE,
    STD_ETHNICITY_ID,
    COLLECTION_METHOD_TYPE_ID,
    PERSON_ID,
    RECORD_MODIFIED_COUNT,
    RECORD_MODIFIED_SITE_ID,
    RECORD_MODIFIED_SRC_NAME,
    TRANSACTION_TYPE_CODE
    )
    values
    (
    PERSON_ETHNICITY_H_S.nextval,
    :new.PERSON_ETHNICITY_ID,
    :new.RECORD_CREATED_BY,
    :new.RECORD_CREATED_DATE,
    :new.RECORD_MODIFIED_BY,
    :new.RECORD_MODIFIED_DATE,
    :new.STD_ETHNICITY_ID,
    :new.COLLECTION_METHOD_TYPE_ID,
    :new.PERSON_ID,
    :new.RECORD_MODIFIED_COUNT,
    :new.RECORD_MODIFIED_SITE_ID,
    :new.RECORD_MODIFIED_SRC_NAME,
    mDML
    );

    IF :NEW.Person_id IS NOT NULL THEN

      IF Mdml = 'I'
      OR NVL(:OLD.STD_ETHNICITY_ID,-9) !=
          NVL(:NEW.STD_ETHNICITY_ID,-9) THEN

        INSERT
        INTO      Adr_Extract_Chgs
                  (Person_id,
                   Chg_date,
                   Adr_extract_chgs_id )
        VALUES    (:NEW.Person_id,
                   TRUNC( SYSDATE ),
                   Adr_extract_chgs_s.NEXTVAL);

      END IF;

    END IF;

  end if;

end PERSON_ETHNICITY_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_ETHNICITY FOR ADR.PERSON_ETHNICITY;


ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PK
  PRIMARY KEY
  (PERSON_ETHNICITY_ID)
  USING INDEX ADR.PRSNETNCTY_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_ETHNICITY ADD (
  CONSTRAINT PRSNETNCTY_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_ETHNICITY TO ADREXT;

GRANT SELECT ON ADR.PERSON_ETHNICITY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_ETHNICITY TO ADR_RW;

GRANT SELECT ON ADR.PERSON_ETHNICITY TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_ETHNICITY TO PSIM_ADR_RW;
ALTER TABLE ADR.PERSON_CONTACT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_CONTACT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_CONTACT_H
(
  PERSON_CONTACT_H_ID          NUMBER(20),
  TRANSACTION_TYPE_CODE        VARCHAR2(1 BYTE),
  PERSON_CONTACT_ID            NUMBER(20),
  PERSON_ID                    NUMBER(20),
  PERSON_CONTACT_TYPE_ID       NUMBER(20),
  CONTACT_RELATIONSHIP_TEXT    VARCHAR2(250 BYTE),
  ORGANIZATION_NAME            VARCHAR2(100 BYTE),
  PREFIX                       VARCHAR2(12 BYTE),
  FIRST_NAME                   VARCHAR2(30 BYTE),
  MIDDLE_NAME                  VARCHAR2(30 BYTE),
  LAST_NAME                    VARCHAR2(40 BYTE),
  SUFFIX                       VARCHAR2(12 BYTE),
  ADDRESS_LINE1                VARCHAR2(100 BYTE),
  ADDRESS_LINE2                VARCHAR2(100 BYTE),
  ADDRESS_LINE3                VARCHAR2(100 BYTE),
  CITY                         VARCHAR2(60 BYTE),
  STATE_CODE                   VARCHAR2(50 BYTE),
  COUNTY_CODE                  VARCHAR2(50 BYTE),
  PROVINCE_CODE                VARCHAR2(50 BYTE),
  POSTAL_CODE                  VARCHAR2(20 BYTE),
  ZIP_CODE                     VARCHAR2(20 BYTE),
  ZIP_PLUS_4                   VARCHAR2(10 BYTE),
  COUNTRY_CODE                 VARCHAR2(50 BYTE),
  EMAIL_ADDRESS                VARCHAR2(128 BYTE),
  HOME_PHONE                   VARCHAR2(30 BYTE),
  HOME_PHONE_UPDATE_DATE       DATE,
  WORK_PHONE                   VARCHAR2(30 BYTE),
  WORK_PHONE_UPDATE_DATE       DATE,
  CONTACT_DATA_LAST_EDIT_DATE  DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE          DATE,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE         DATE,
  RECORD_MODIFIED_COUNT        NUMBER(10),
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE),
  DEACTIVATION_DATE            DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_CONTACT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.PERSON_CONTACT_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.PERSON_CONTACT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.PERSON_CONTACT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.CONTACT_RELATIONSHIP_TEXT IS 'Storesafreetext descriptionofthenature oftheassociation betweenthePersonand theContact';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.ORGANIZATION_NAME IS 'BR947Organizationname isdefinedasthenameof theorganization.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.FIRST_NAME IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.MIDDLE_NAME IS 'BR7325Representative middleNameisdefinedas themiddlenameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.LAST_NAME IS 'BR7321Representative LastNameisdefinedas thefamilynameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.CITY IS 'Cityisdefinedasthe nameofacityusedfor anaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.COUNTY_CODE IS 'FIPSCountyCODEis definedasthelast3 charactersoftheFIPS state/countycode.The FIPScountycodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied5-DIGITFIPSCODEis definedasthe2digit statecode+3digit countycode.This5digit FIPScodeisassociated withtheveterans permanentmailing address,Ifnopermanent mailingaddressis supplied,andaMTis required,itis associatedwiththe Facilityaddressin whichtheprimaryMTwas supplied';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.POSTAL_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.COUNTRY_CODE IS 'Countryisdefinedasthe uniqueidentifier assignedbythe International Organizationof Standardizationfora country.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.EMAIL_ADDRESS IS 'Theemailaddressforthe personorinsurance company.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.HOME_PHONE IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.HOME_PHONE_UPDATE_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.WORK_PHONE IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.WORK_PHONE_UPDATE_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_CONTACT_H.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNCTACH_PK ON ADR.PERSON_CONTACT_H
(PERSON_CONTACT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNCTACH_PRSNID_NU_I ON ADR.PERSON_CONTACT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_CONTACT_H FOR ADR.PERSON_CONTACT_H;


ALTER TABLE ADR.PERSON_CONTACT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_020
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066291
  CHECK ("PERSON_CONTACT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066292
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066293
  CHECK ("PERSON_CONTACT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066294
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066295
  CHECK ("PERSON_CONTACT_TYPE_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066296
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066297
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066298
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066299
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066300
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT PRSNCTACH_PK
  PRIMARY KEY
  (PERSON_CONTACT_H_ID)
  USING INDEX ADR.PRSNCTACH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_CONTACT_H TO ADR_R;

GRANT SELECT ON ADR.PERSON_CONTACT_H TO ADR_RW;

GRANT SELECT ON ADR.PERSON_CONTACT_H TO PSIM_ADR_R;
ALTER TABLE ADR.PERSON_CONTACT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_CONTACT CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_CONTACT
(
  PERSON_CONTACT_ID            NUMBER(20)       NOT NULL,
  PERSON_ID                    NUMBER(20)       NOT NULL,
  PERSON_CONTACT_TYPE_ID       NUMBER(20)       NOT NULL,
  CONTACT_RELATIONSHIP_TEXT    VARCHAR2(250 BYTE),
  ORGANIZATION_NAME            VARCHAR2(100 BYTE),
  PREFIX                       VARCHAR2(12 BYTE),
  FIRST_NAME                   VARCHAR2(30 BYTE),
  MIDDLE_NAME                  VARCHAR2(30 BYTE),
  LAST_NAME                    VARCHAR2(40 BYTE),
  SUFFIX                       VARCHAR2(12 BYTE),
  ADDRESS_LINE1                VARCHAR2(100 BYTE),
  ADDRESS_LINE2                VARCHAR2(100 BYTE),
  ADDRESS_LINE3                VARCHAR2(100 BYTE),
  CITY                         VARCHAR2(60 BYTE),
  STATE_CODE                   VARCHAR2(50 BYTE),
  COUNTY_CODE                  VARCHAR2(50 BYTE),
  PROVINCE_CODE                VARCHAR2(50 BYTE),
  ZIP_CODE                     VARCHAR2(20 BYTE),
  ZIP_PLUS_4                   VARCHAR2(10 BYTE),
  POSTAL_CODE                  VARCHAR2(20 BYTE),
  COUNTRY_CODE                 VARCHAR2(50 BYTE),
  HOME_PHONE                   VARCHAR2(30 BYTE),
  HOME_PHONE_UPDATE_DATE       DATE,
  WORK_PHONE                   VARCHAR2(30 BYTE),
  WORK_PHONE_UPDATE_DATE       DATE,
  EMAIL_ADDRESS                VARCHAR2(128 BYTE),
  CONTACT_DATA_LAST_EDIT_DATE  DATE,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL,
  RECORD_MODIFIED_SITE_ID      NUMBER(20),
  RECORD_MODIFIED_SRC_NAME     VARCHAR2(30 BYTE),
  DEACTIVATION_DATE            DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_CONTACT IS 'The table stores information (address, phone, and email) about contacts associated with persons of import to the VHA. Types of contacts include Next of Kin, Guardian (VA and civilian), and Power of Attorney. These contact persons have not been enumerated through the Identity Management process. As a result they have no VPIDs assigned to their records. The address and telephone information for these contact persons is denormalized in this table. PERSON_ID Foreign key to the PERSON table. PERSON_CONTACT_TYPE_ID Foreign key to the PERSON_CONTACT_TYPE table. DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PERSON_CONTACT.PERSON_CONTACT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.PERSON_CONTACT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.CONTACT_RELATIONSHIP_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.ORGANIZATION_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.PREFIX IS 'BR7327Representative prefixisdefinedasthe prefixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.FIRST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.MIDDLE_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.LAST_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.SUFFIX IS 'BR7329Representative suffixisdefinedasthe suffixoftheassociation typeidentified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.ADDRESS_LINE1 IS 'BR3Addressline#1is definedasthefreetext formofthenumberand streetorpostofficebox ofamailingaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.ADDRESS_LINE2 IS 'BR5Addressline#2is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.ADDRESS_LINE3 IS 'BR7Addressline#3is definedasthefreetext supplementaltothe numberandstreetofa mailingaddress.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.CITY IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.STATE_CODE IS 'FIPSSTATECODEis definedasthe2 charactersFIPSState code.TheFIPSStatecode isthefirsttwo charactersofthe5- characterFIPScode.The FIPSstatecodeis associatedwiththe veteranspermanent mailingaddress,Ifno permanentmailingaddress issupplied,andaMTis Required,itis associatedwiththe Facilityaddressinwhich theprimaryMTwas supplied.Statecodeisdefinesas theuniquecountrycode/ stateabbreviation combinationfoundinthe databasethatbest identifiesthestate';

COMMENT ON COLUMN ADR.PERSON_CONTACT.COUNTY_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.PROVINCE_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.ZIP_CODE IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.ZIP_PLUS_4 IS 'Postalcodeisdefinedas themailcodeusedfor maildeliverytoa countryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.POSTAL_CODE IS 'BR17Postalcodeis definedasthemailcode usedformaildeliveryto acountryotherthanthe USAonly.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.COUNTRY_CODE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.HOME_PHONE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.HOME_PHONE_UPDATE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.WORK_PHONE IS 'BR7323Representative FirstNameisdefinedas thegivennameofthe associationtype identified.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.WORK_PHONE_UPDATE_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.PERSON_CONTACT.EMAIL_ADDRESS IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.CONTACT_DATA_LAST_EDIT_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_CONTACT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_CONTACT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON_CONTACT.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';


CREATE UNIQUE INDEX ADR.PRSNCTAC_PK ON ADR.PERSON_CONTACT
(PERSON_CONTACT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNCTAC_PRSN_FK_I ON ADR.PERSON_CONTACT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNCTAC_STDINST2_FK_I ON ADR.PERSON_CONTACT
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNCTAC_STD_PRNSCTAC_FK_I ON ADR.PERSON_CONTACT
(PERSON_CONTACT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_CONTACT_AUDIR_TRGR
after Update or Delete or Insert
ON ADR.PERSON_CONTACT
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERSON_CONTACT_H
		(
		PERSON_CONTACT_H_ID,
		PERSON_CONTACT_ID,
		PERSON_ID,
		PERSON_CONTACT_TYPE_ID,
		CONTACT_RELATIONSHIP_TEXT,
		ORGANIZATION_NAME,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		SUFFIX,
		ADDRESS_LINE1,
		ADDRESS_LINE2,
		ADDRESS_LINE3,
		CITY,
		STATE_CODE,
		COUNTY_CODE,
		PROVINCE_CODE,
		POSTAL_CODE,
		ZIP_PLUS_4,
		COUNTRY_CODE,
		HOME_PHONE,
		WORK_PHONE,
		EMAIL_ADDRESS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		HOME_PHONE_UPDATE_DATE,
		WORK_PHONE_UPDATE_DATE,
		ZIP_CODE,
		CONTACT_DATA_LAST_EDIT_DATE,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		deactivation_date,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_CONTACT_H_S.nextval,
		:old.PERSON_CONTACT_ID,
		:old.PERSON_ID,
		:old.PERSON_CONTACT_TYPE_ID,
		:old.CONTACT_RELATIONSHIP_TEXT,
		:old.ORGANIZATION_NAME,
		:old.PREFIX,
		:old.FIRST_NAME,
		:old.MIDDLE_NAME,
		:old.LAST_NAME,
		:old.SUFFIX,
		:old.ADDRESS_LINE1,
		:old.ADDRESS_LINE2,
		:old.ADDRESS_LINE3,
		:old.CITY,
		:old.STATE_CODE,
		:old.COUNTY_CODE,
		:old.PROVINCE_CODE,
		:old.POSTAL_CODE,
		:old.ZIP_PLUS_4,
		:old.COUNTRY_CODE,
		:old.HOME_PHONE,
		:old.WORK_PHONE,
		:old.EMAIL_ADDRESS,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		:old.HOME_PHONE_UPDATE_DATE,
		:old.WORK_PHONE_UPDATE_DATE,
		:old.ZIP_CODE,
		:old.CONTACT_DATA_LAST_EDIT_DATE,
		:old.RECORD_MODIFIED_SITE_ID,
		:old.RECORD_MODIFIED_SRC_NAME,
		:old.deactivation_date,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERSON_CONTACT_H
		(
		PERSON_CONTACT_H_ID,
		PERSON_CONTACT_ID,
		PERSON_ID,
		PERSON_CONTACT_TYPE_ID,
		CONTACT_RELATIONSHIP_TEXT,
		ORGANIZATION_NAME,
		PREFIX,
		FIRST_NAME,
		MIDDLE_NAME,
		LAST_NAME,
		SUFFIX,
		ADDRESS_LINE1,
		ADDRESS_LINE2,
		ADDRESS_LINE3,
		CITY,
		STATE_CODE,
		COUNTY_CODE,
		PROVINCE_CODE,
		POSTAL_CODE,
		ZIP_PLUS_4,
		COUNTRY_CODE,
		HOME_PHONE,
		WORK_PHONE,
		EMAIL_ADDRESS,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		HOME_PHONE_UPDATE_DATE,
		WORK_PHONE_UPDATE_DATE,
		ZIP_CODE,
		CONTACT_DATA_LAST_EDIT_DATE,
		RECORD_MODIFIED_SITE_ID,
		RECORD_MODIFIED_SRC_NAME,
		deactivation_date,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERSON_CONTACT_H_S.nextval,
		:new.PERSON_CONTACT_ID,
		:new.PERSON_ID,
		:new.PERSON_CONTACT_TYPE_ID,
		:new.CONTACT_RELATIONSHIP_TEXT,
		:new.ORGANIZATION_NAME,
		:new.PREFIX,
		:new.FIRST_NAME,
		:new.MIDDLE_NAME,
		:new.LAST_NAME,
		:new.SUFFIX,
		:new.ADDRESS_LINE1,
		:new.ADDRESS_LINE2,
		:new.ADDRESS_LINE3,
		:new.CITY,
		:new.STATE_CODE,
		:new.COUNTY_CODE,
		:new.PROVINCE_CODE,
		:new.POSTAL_CODE,
		:new.ZIP_PLUS_4,
		:new.COUNTRY_CODE,
		:new.HOME_PHONE,
		:new.WORK_PHONE,
		:new.EMAIL_ADDRESS,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		:new.HOME_PHONE_UPDATE_DATE,
		:new.WORK_PHONE_UPDATE_DATE,
		:new.ZIP_CODE,
		:new.CONTACT_DATA_LAST_EDIT_DATE,
		:new.RECORD_MODIFIED_SITE_ID,
		:new.RECORD_MODIFIED_SRC_NAME,
		:new.deactivation_date,
		mDML
		);
	end if;

end PERSON_CONTACT_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON_CONTACT FOR ADR.PERSON_CONTACT;


ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT PRSNCTAC_PK
  PRIMARY KEY
  (PERSON_CONTACT_ID)
  USING INDEX ADR.PRSNCTAC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_CONTACT ADD (
  CONSTRAINT PRSNCTAC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_CONTACT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_CONTACT TO ADR_RW;

GRANT SELECT ON ADR.PERSON_CONTACT TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON_CONTACT TO PSIM_ADR_RW;
ALTER TABLE ADR.PERSON_CHANGE_LOG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON_CHANGE_LOG CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON_CHANGE_LOG
(
  PERSON_CHANGE_LOG_ID   NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  INCOME_YEAR            NUMBER(4),
  SUBMITTER_DESCRIPTION  VARCHAR2(250 BYTE),
  SUBMITTED_DATE         DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON_CHANGE_LOG IS 'This is a process related table - whenever there is merge or unmerge of a Beneficiary record, a log of all changes made to the record is stored here.';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.PERSON_CHANGE_LOG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.SUBMITTER_DESCRIPTION IS 'AuditField-Useror Processcreatingthe recordindatabase';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.SUBMITTED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON_CHANGE_LOG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.PRSNCHGLOG_DESC_DT_NU_I ON ADR.PERSON_CHANGE_LOG
(SUBMITTER_DESCRIPTION, SUBMITTED_DATE, INCOME_YEAR, PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRSNCHGLOG_PK ON ADR.PERSON_CHANGE_LOG
(PERSON_CHANGE_LOG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSNCHGLOG_PRSN_FK_I ON ADR.PERSON_CHANGE_LOG
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERSON_CHANGE_LOG FOR ADR.PERSON_CHANGE_LOG;


ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT PRSNCHGLOG_PK
  PRIMARY KEY
  (PERSON_CHANGE_LOG_ID)
  USING INDEX ADR.PRSNCHGLOG_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERSON_CHANGE_LOG ADD (
  CONSTRAINT PRSNCHGLOG_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERSON_CHANGE_LOG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON_CHANGE_LOG TO ADR_RW;
ALTER TABLE ADR.PERSON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERSON CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERSON
(
  PERSON_ID                       NUMBER(20)    NOT NULL,
  VPID_ID                         NUMBER(20),
  VPID_VALUE                      VARCHAR2(30 BYTE) NOT NULL,
  HEC_IEN                         VARCHAR2(20 BYTE),
  STD_PROGRAMOFSTUDY_ID           NUMBER(20),
  STD_RELIGION_ID                 NUMBER(20),
  STD_MARITALSTATUS_ID            NUMBER(20),
  USER_ENROLEE_SITE_ID            NUMBER(20),
  PREFERRED_SITE_ID               NUMBER(20),
  DEATH_REPORTING_SITE_ID         NUMBER(20),
  DEATH_NOTIFICATION_SRC_TYPE_ID  NUMBER(20),
  CLAIM_FOLDER_LOCATION_SITE_ID   NUMBER(20),
  CLAIM_FOLDER_NUMBER             VARCHAR2(20 BYTE),
  EDUCATIONAL_DEGREE              VARCHAR2(30 BYTE),
  REMARKS                         VARCHAR2(4000 BYTE),
  SENSITIVITY_FLAG_SET_SRC_ID     NUMBER(20),
  SENSITIVITY_FLAG_SET_SITE_ID    NUMBER(20),
  SENSITIVITY_IND                 VARCHAR2(1 BYTE) DEFAULT '0',
  SENSITIVITY_FLAG_SET_BY         VARCHAR2(30 BYTE),
  SENSITIVITY_FLAG_SET_DATE       DATE,
  VETERAN_IND                     VARCHAR2(1 BYTE) DEFAULT '0',
  WAS_PRISONER_OF_WAR_IND         VARCHAR2(1 BYTE),
  EE_MIGRATED_IND                 VARCHAR2(1 BYTE),
  DEATH_DATE_TXT                  VARCHAR2(14 BYTE),
  DEATH_REPORTED_DATE             DATE,
  LAZARUS_DATE_TXT                VARCHAR2(14 BYTE),
  USER_ENROLEE_THROUGH_YEAR       NUMBER(4),
  DISABILITY_DISCHARGE_IND        VARCHAR2(1 BYTE),
  MILITARY_DSBLTY_RETIREMENT_IND  VARCHAR2(1 BYTE),
  COMBAT_VET_ELIGIBILITY_END_DT   DATE,
  APPOINTMENT_WAS_REQUESTED_IND   VARCHAR2(1 BYTE),
  APPOINTMENT_REQUESTED_DATE      DATE,
  VA_ASSOCIATE_TITLE              VARCHAR2(50 BYTE),
  VA_SIGNATURE_BLOCK_PRINT_NAME   VARCHAR2(40 BYTE),
  VA_SIGNATURE_BLOCK_TITLE        VARCHAR2(50 BYTE),
  VA_LAST_TRAINING_YEAR           VARCHAR2(4 BYTE),
  VAMC_MAIL_CODE                  VARCHAR2(10 BYTE),
  VA_ROOM_NUMBER                  VARCHAR2(30 BYTE),
  VA_TERMINATION_REASON_TEXT      VARCHAR2(45 BYTE),
  VA_TERMINATION_DATE             DATE,
  DEMOGRAPHIC_UPDATE_EVENT_DATE   DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_MODIFIED_SITE_ID         NUMBER(20),
  RECORD_MODIFIED_SRC_NAME        VARCHAR2(30 BYTE),
  VOA_IND                         CHAR(1 BYTE),
  STD_MILITARYSVCQRYSTAT_ID       NUMBER(20),
  DENTAL_CLASS2_IND               VARCHAR2(1 BYTE),
  DENTAL_CLS2_APP_BEF_DUE_DATE    DATE,
  DOD_VERIFIED_IND                VARCHAR2(1 BYTE),
  DEATH_REPORTED_BY               VARCHAR2(30 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERSON IS 'The PERSON table is the central table in the ADR database for any information connected to a person of import to the Veterans Health Administration. This table contains data for persons of the following categories: Patient/Beneficiary, IT User, VA Associates, and Practioners. This is the base table of the ADR person-centric model. A record is created in this table for each Person who has been enumerated and assigned a VPID through the Identity Management service. This record is appended with further information about a person, such as demographic or Enrollment and Eligibility attributes and details, by the respective Services. Foreign keys into this table include: VPID_ID Unique and Not Null Foreign Key from PS_PERSON_VPID table USER_ENROLEE_SITE_ID Site where the person is enrolled STD_PROGRAMOFSTUDY_ID Program of study for a VA Employee Nursing, Pharmacy etc. STD_MARITALSTATUS_ID Marital Status STD_RELIGION_ID Religion DEATH_REPORTING_SITE_ID Site Reporting the persons death information CLAIM_FOLDER_LOCATION_SITE_ID Site where the Claim folder is located DEATH_NOTIFICATION_SRC_TYPE_ID Source notifying the death of a person SSA, VBA, DoD etc. VA_ASSOCIATE_TYPE_ID Type of associate EMPLOYMENT_STATUS_TYPE_ID Employment Status PREFERRED_SITE_ID The preferred facility for health care IDENTITY MANAGEMENT / DEMOGRAPHICS / ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.PERSON.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERSON.VPID_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VPID_VALUE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.HEC_IEN IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.STD_PROGRAMOFSTUDY_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.STD_RELIGION_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.STD_MARITALSTATUS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.USER_ENROLEE_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.PREFERRED_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.DEATH_REPORTING_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.DEATH_NOTIFICATION_SRC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.CLAIM_FOLDER_LOCATION_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.CLAIM_FOLDER_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.EDUCATIONAL_DEGREE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.REMARKS IS 'Textincludingany additionalinformation fortheactiontakenfor theparticularmailing record';

COMMENT ON COLUMN ADR.PERSON.SENSITIVITY_FLAG_SET_SRC_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.SENSITIVITY_FLAG_SET_SITE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.SENSITIVITY_IND IS 'Patientsensitivityflag fromAACisdefinedasan indicationthatthis veteranrecordisa sensitiverecordandonly thosewithabusiness purposeshouldviewthe relatedinformation.';

COMMENT ON COLUMN ADR.PERSON.SENSITIVITY_FLAG_SET_BY IS 'BR7316Sensitivity assignedbyisdefinedas thepersonwhosetthe recordtosensitive.';

COMMENT ON COLUMN ADR.PERSON.SENSITIVITY_FLAG_SET_DATE IS 'BR7318Date/Time sensitivityflagsetis definedasthetimestamp associatedwiththe sensitivityflag.';

COMMENT ON COLUMN ADR.PERSON.VETERAN_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.WAS_PRISONER_OF_WAR_IND IS 'BR2376PHOnlyIndicator isdefinedasthe indicatorthatidentifies theveteransinthePH Registryfilewhoarenot currentlyintheHECEDB asenrolleeswithother eligibility/enrollment datareceivingVHA services.Oncethe veteranrecordiscreated intheEDBthenthisflag isremoved';

COMMENT ON COLUMN ADR.PERSON.DEATH_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.DEATH_REPORTED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.LAZARUS_DATE_TXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.USER_ENROLEE_THROUGH_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.DISABILITY_DISCHARGE_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.MILITARY_DSBLTY_RETIREMENT_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.COMBAT_VET_ELIGIBILITY_END_DT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.APPOINTMENT_WAS_REQUESTED_IND IS 'Indicatesifbeneficiary wasretiredfromtheU.S. ArmedForcesduetoa disabilityincurredwhile serving.';

COMMENT ON COLUMN ADR.PERSON.APPOINTMENT_REQUESTED_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VA_ASSOCIATE_TITLE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VA_SIGNATURE_BLOCK_PRINT_NAME IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VA_SIGNATURE_BLOCK_TITLE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VA_LAST_TRAINING_YEAR IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VAMC_MAIL_CODE IS 'VAHOSPITALSERVICE NUMBER,I.E.116AFOR PSYCHIATRY,116BFOR PSYCHOLOGY,ETC';

COMMENT ON COLUMN ADR.PERSON.VA_ROOM_NUMBER IS 'Thisistheroomnumber assignedtotheperson.';

COMMENT ON COLUMN ADR.PERSON.VA_TERMINATION_REASON_TEXT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.VA_TERMINATION_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERSON.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERSON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERSON.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERSON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERSON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PERSON.RECORD_MODIFIED_SRC_NAME IS 'Believed by ADR to be the record modified source name, but on March, 2012 the column was not populated in any of the 10 base and 10 history tables using the column in the ADR database.  As far as ADR can tell, this is not a standard ADR column that needs to be used in future tables. It is being replaced with the STD_DELIVERYPREFSRCTYPE  Standard Data Services (SDS) reference table.';

COMMENT ON COLUMN ADR.PERSON.VOA_IND IS 'Veterans Online Application indicator';

COMMENT ON COLUMN ADR.PERSON.DENTAL_CLASS2_IND IS 'Derived from the VBA DD214 Dental Indicator. The DD214 Dental Indicator specifies whether or not the Veteran received dental treatment at service separation. The Dental Indicator is translated from the DD214 Indicator to state whether or not the Veteran is eligible for dental services.
  2  Null means not initialized
  3  0 means `NO
  4  1 means `YES';

COMMENT ON COLUMN ADR.PERSON.DENTAL_CLS2_APP_BEF_DUE_DATE IS 'Null means not initialized
  2  0 means `NO
  3  1 means `YES';


CREATE INDEX ADR.PRSN_CLMFLDRNO_NU_I ON ADR.PERSON
(CLAIM_FOLDER_NUMBER)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_ENRLEESITE_FK_I ON ADR.PERSON
(USER_ENROLEE_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PRSN_PK ON ADR.PERSON
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_PSPRSNVPID_FK_I ON ADR.PERSON
(VPID_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_SNSTCHGTYP_FK_I ON ADR.PERSON
(SENSITIVITY_FLAG_SET_SRC_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDINST2_FK_I ON ADR.PERSON
(RECORD_MODIFIED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDINST_FK_I ON ADR.PERSON
(DEATH_REPORTING_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDINST_H_FK_2_I ON ADR.PERSON
(SENSITIVITY_FLAG_SET_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDINST_H_FK_I ON ADR.PERSON
(CLAIM_FOLDER_LOCATION_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDINST_PREF_FAC_FK_I ON ADR.PERSON
(PREFERRED_SITE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDMAR_FK_I ON ADR.PERSON
(STD_MARITALSTATUS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDMSQS_FK_I ON ADR.PERSON
(STD_MILITARYSVCQRYSTAT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDPGMSTDY_FK_I ON ADR.PERSON
(STD_PROGRAMOFSTUDY_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STDREL_FK_I ON ADR.PERSON
(STD_RELIGION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_STD_DEATHNOTIFY_FK_I ON ADR.PERSON
(DEATH_NOTIFICATION_SRC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PRSN_VPIDVALUE_NU_I ON ADR.PERSON
(VPID_VALUE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERSON_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PERSON
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
         insert into person_h
        (
        PERSON_H_ID,
        PERSON_ID,
        VPID_ID,
        HEC_IEN,
        CLAIM_FOLDER_NUMBER,
        EDUCATIONAL_DEGREE,
        REMARKS,
        SENSITIVITY_IND,
        SENSITIVITY_FLAG_SET_BY,
        SENSITIVITY_FLAG_SET_DATE,
        VETERAN_IND,
        DEATH_DATE_TXT,
        DEATH_REPORTED_DATE,
        LAZARUS_DATE_TXT,
        USER_ENROLEE_SITE_ID,
        USER_ENROLEE_THROUGH_YEAR,
        DISABILITY_DISCHARGE_IND,
        COMBAT_VET_ELIGIBILITY_END_DT,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        STD_PROGRAMOFSTUDY_ID,
        STD_MARITALSTATUS_ID,
        STD_RELIGION_ID,
        MILITARY_DSBLTY_RETIREMENT_IND,
        DEATH_REPORTING_SITE_ID,
        CLAIM_FOLDER_LOCATION_SITE_ID,
        DEATH_NOTIFICATION_SRC_TYPE_ID,
        VA_ASSOCIATE_TITLE,
        VA_SIGNATURE_BLOCK_PRINT_NAME,
        VA_SIGNATURE_BLOCK_TITLE,
        VA_LAST_TRAINING_YEAR,
        VAMC_MAIL_CODE,
        VA_ROOM_NUMBER,
        VA_TERMINATION_REASON_TEXT,
        VA_TERMINATION_DATE,
        RECORD_MODIFIED_COUNT,
        VPID_VALUE,
        PREFERRED_SITE_ID,
        WAS_PRISONER_OF_WAR_IND,
        APPOINTMENT_WAS_REQUESTED_IND,
        APPOINTMENT_REQUESTED_DATE,
        SENSITIVITY_FLAG_SET_SRC_ID,
        SENSITIVITY_FLAG_SET_SITE_ID,
        DEMOGRAPHIC_UPDATE_EVENT_DATE,
        EE_MIGRATED_IND,
        RECORD_MODIFIED_SITE_ID,
        RECORD_MODIFIED_SRC_NAME,
        TRANSACTION_TYPE_CODE,
        DENTAL_CLASS2_IND,
        DENTAL_CLS2_APP_BEF_DUE_DATE,
        HISTORY_CREATED_DATE,
        STD_MILITARYSVCQRYSTAT_ID,
        VOA_IND,
        DOD_VERIFIED_IND,
        DEATH_REPORTED_BY
        )
        values
        (
        person_h_s.nextval  ,
        :old.PERSON_ID,
        :old.VPID_ID,
        :old.HEC_IEN,
        :old.CLAIM_FOLDER_NUMBER,
        :old.EDUCATIONAL_DEGREE,
        :old.REMARKS,
        :old.SENSITIVITY_IND,
        :old.SENSITIVITY_FLAG_SET_BY,
        :old.SENSITIVITY_FLAG_SET_DATE,
        :old.VETERAN_IND,
        :old.DEATH_DATE_TXT,
        :old.DEATH_REPORTED_DATE,
        :old.LAZARUS_DATE_TXT,
        :old.USER_ENROLEE_SITE_ID,
        :old.USER_ENROLEE_THROUGH_YEAR,
        :old.DISABILITY_DISCHARGE_IND,
        :old.COMBAT_VET_ELIGIBILITY_END_DT,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.STD_PROGRAMOFSTUDY_ID,
        :old.STD_MARITALSTATUS_ID,
        :old.STD_RELIGION_ID,
        :old.MILITARY_DSBLTY_RETIREMENT_IND,
        :old.DEATH_REPORTING_SITE_ID,
        :old.CLAIM_FOLDER_LOCATION_SITE_ID,
        :old.DEATH_NOTIFICATION_SRC_TYPE_ID,
        :old.VA_ASSOCIATE_TITLE,
        :old.VA_SIGNATURE_BLOCK_PRINT_NAME,
        :old.VA_SIGNATURE_BLOCK_TITLE,
        :old.VA_LAST_TRAINING_YEAR,
        :old.VAMC_MAIL_CODE,
        :old.VA_ROOM_NUMBER,
        :old.VA_TERMINATION_REASON_TEXT,
        :old.VA_TERMINATION_DATE,
        :old.RECORD_MODIFIED_COUNT,
        :old.VPID_VALUE,
        :old.PREFERRED_SITE_ID,
        :old.WAS_PRISONER_OF_WAR_IND,
        :old.APPOINTMENT_WAS_REQUESTED_IND,
        :old.APPOINTMENT_REQUESTED_DATE,
        :old.SENSITIVITY_FLAG_SET_SRC_ID,
        :old.SENSITIVITY_FLAG_SET_SITE_ID,
        :old.DEMOGRAPHIC_UPDATE_EVENT_DATE,
        :old.EE_MIGRATED_IND,
        :old.RECORD_MODIFIED_SITE_ID,
        :old.RECORD_MODIFIED_SRC_NAME,
                'D',
        :old.DENTAL_CLASS2_IND,
        :old.DENTAL_CLS2_APP_BEF_DUE_DATE,
        SYSDATE,
        :old.STD_MILITARYSVCQRYSTAT_ID,
        :old.VOA_IND,
        :old.DOD_VERIFIED_IND,
        :old.DEATH_REPORTED_BY
        );
    IF :OLD.PERSON_ID IS NOT NULL THEN
        INSERT INTO ADR_EXTRACT_CHGS
            (
            PERSON_ID   ,
            CHG_DATE,
            ADR_EXTRACT_CHGS_ID
            )
            VALUES
            (:OLD.PERSON_ID,
            TRUNC(SYSDATE),
            ADR_EXTRACT_CHGS_S.NEXTVAL
            );
    END IF;
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

         insert into person_h
        (
        PERSON_H_ID,
        PERSON_ID,
        VPID_ID,
        HEC_IEN,
        CLAIM_FOLDER_NUMBER,
        EDUCATIONAL_DEGREE,
        REMARKS,
        SENSITIVITY_IND,
        SENSITIVITY_FLAG_SET_BY,
        SENSITIVITY_FLAG_SET_DATE,
        VETERAN_IND,
        DEATH_DATE_TXT,
        DEATH_REPORTED_DATE,
        LAZARUS_DATE_TXT,
        USER_ENROLEE_SITE_ID,
        USER_ENROLEE_THROUGH_YEAR,
        DISABILITY_DISCHARGE_IND,
        COMBAT_VET_ELIGIBILITY_END_DT,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        STD_PROGRAMOFSTUDY_ID,
        STD_MARITALSTATUS_ID,
        STD_RELIGION_ID,
        MILITARY_DSBLTY_RETIREMENT_IND,
        DEATH_REPORTING_SITE_ID,
        CLAIM_FOLDER_LOCATION_SITE_ID,
        DEATH_NOTIFICATION_SRC_TYPE_ID,
        VA_ASSOCIATE_TITLE,
        VA_SIGNATURE_BLOCK_PRINT_NAME,
        VA_SIGNATURE_BLOCK_TITLE,
        VA_LAST_TRAINING_YEAR,
        VAMC_MAIL_CODE,
        VA_ROOM_NUMBER,
        VA_TERMINATION_REASON_TEXT,
        VA_TERMINATION_DATE,
        RECORD_MODIFIED_COUNT,
        VPID_VALUE,
        PREFERRED_SITE_ID,
        WAS_PRISONER_OF_WAR_IND,
        APPOINTMENT_WAS_REQUESTED_IND,
        APPOINTMENT_REQUESTED_DATE,
        SENSITIVITY_FLAG_SET_SRC_ID,
        SENSITIVITY_FLAG_SET_SITE_ID,
        DEMOGRAPHIC_UPDATE_EVENT_DATE,
        EE_MIGRATED_IND,
        RECORD_MODIFIED_SITE_ID,
        RECORD_MODIFIED_SRC_NAME,
        TRANSACTION_TYPE_CODE,
        DENTAL_CLASS2_IND,
        DENTAL_CLS2_APP_BEF_DUE_DATE,
        HISTORY_CREATED_DATE,
        STD_MILITARYSVCQRYSTAT_ID,
        VOA_IND,
        DOD_VERIFIED_IND,
        DEATH_REPORTED_BY
        )
        values
        (
        person_h_s.nextval  ,
        :new.PERSON_ID,
        :new.VPID_ID,
        :new.HEC_IEN,
        :new.CLAIM_FOLDER_NUMBER,
        :new.EDUCATIONAL_DEGREE,
        :new.REMARKS,
        :new.SENSITIVITY_IND,
        :new.SENSITIVITY_FLAG_SET_BY,
        :new.SENSITIVITY_FLAG_SET_DATE,
        :new.VETERAN_IND,
        :new.DEATH_DATE_TXT,
        :new.DEATH_REPORTED_DATE,
        :new.LAZARUS_DATE_TXT,
        :new.USER_ENROLEE_SITE_ID,
        :new.USER_ENROLEE_THROUGH_YEAR,
        :new.DISABILITY_DISCHARGE_IND,
        :new.COMBAT_VET_ELIGIBILITY_END_DT,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.STD_PROGRAMOFSTUDY_ID,
        :new.STD_MARITALSTATUS_ID,
        :new.STD_RELIGION_ID,
        :new.MILITARY_DSBLTY_RETIREMENT_IND,
        :new.DEATH_REPORTING_SITE_ID,
        :new.CLAIM_FOLDER_LOCATION_SITE_ID,
        :new.DEATH_NOTIFICATION_SRC_TYPE_ID,
        :new.VA_ASSOCIATE_TITLE,
        :new.VA_SIGNATURE_BLOCK_PRINT_NAME,
        :new.VA_SIGNATURE_BLOCK_TITLE,
        :new.VA_LAST_TRAINING_YEAR,
        :new.VAMC_MAIL_CODE,
        :new.VA_ROOM_NUMBER,
        :new.VA_TERMINATION_REASON_TEXT,
        :new.VA_TERMINATION_DATE,
        :new.RECORD_MODIFIED_COUNT,
        :new.VPID_VALUE,
        :new.PREFERRED_SITE_ID,
        :new.WAS_PRISONER_OF_WAR_IND,
        :new.APPOINTMENT_WAS_REQUESTED_IND,
        :new.APPOINTMENT_REQUESTED_DATE,
        :new.SENSITIVITY_FLAG_SET_SRC_ID,
        :new.SENSITIVITY_FLAG_SET_SITE_ID,
        :new.DEMOGRAPHIC_UPDATE_EVENT_DATE,
        :new.EE_MIGRATED_IND,
        :new.RECORD_MODIFIED_SITE_ID,
        :new.RECORD_MODIFIED_SRC_NAME,
                mDML,
        :new.DENTAL_CLASS2_IND,
        :new.DENTAL_CLS2_APP_BEF_DUE_DATE,
        SYSDATE,
        :new.STD_MILITARYSVCQRYSTAT_ID,
        :new.VOA_IND,
        :new.DOD_VERIFIED_IND,
        :new.DEATH_REPORTED_BY

        );
    IF :NEW.PERSON_ID IS NOT NULL THEN
        INSERT INTO ADR_EXTRACT_CHGS
            (
            PERSON_ID   ,
            CHG_DATE,
            ADR_EXTRACT_CHGS_ID
            )
            VALUES
            (:NEW.PERSON_ID,
            TRUNC(SYSDATE),
            ADR_EXTRACT_CHGS_S.NEXTVAL
            );
    END IF;
    end if;

End person_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERSON FOR ADR.PERSON;


ALTER TABLE ADR.PERSON ADD (
  CONSTRAINT PRSN_PK
  PRIMARY KEY
  (PERSON_ID)
  USING INDEX ADR.PRSN_PK
  ENABLE VALIDATE,
  CONSTRAINT PRSN_U_VPID_UK
  UNIQUE (VPID_ID)
  USING INDEX ADR.PRSN_PSPRSNVPID_FK_I
  ENABLE VALIDATE,
  CONSTRAINT PRSN_VPIDVALUE_UK
  UNIQUE (VPID_VALUE)
  USING INDEX ADR.PRSN_VPIDVALUE_NU_I
  ENABLE VALIDATE);

GRANT REFERENCES ON ADR.PERSON TO ADRAAP;

GRANT SELECT ON ADR.PERSON TO ADREXT;

GRANT SELECT ON ADR.PERSON TO ADRTMP;

GRANT SELECT ON ADR.PERSON TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERSON TO ADR_RW;

GRANT SELECT ON ADR.PERSON TO BIZFLOW_R;

GRANT SELECT ON ADR.PERSON TO CARUSR_R;

GRANT SELECT ON ADR.PERSON TO PSIM;

GRANT SELECT ON ADR.PERSON TO PSIM_ADR_R;

GRANT DELETE, INSERT, UPDATE ON ADR.PERSON TO PSIM_ADR_RW;

GRANT SELECT ON ADR.PERSON TO VHAISPSTALLP;

GRANT REFERENCES ON ADR.PERSON TO VOA;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET_PERMISSIONS_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET_PERMISSIONS_H
(
  PERM_SET_PERMISSIONS_H_ID  NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  PERM_SET_PERMISSIONS_ID    NUMBER(20)         NOT NULL,
  PERMISSION_SET_ID          NUMBER(20)         NOT NULL,
  PERMISSION_TYPE_ID         NUMBER(20)         NOT NULL,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET_PERMISSIONS_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.PERM_SET_PERMISSIONS_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.PERM_SET_PERMISSIONS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRMSTPRMH_PK ON ADR.PERMISSION_SET_PERMISSIONS_H
(PERM_SET_PERMISSIONS_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET_PERMISSIONS_H FOR ADR.PERMISSION_SET_PERMISSIONS_H;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_063
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PRMSTPRMH_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_H_ID)
  USING INDEX ADR.PRMSTPRMH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS_H TO ADR_R;

GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS_H TO ADR_RW;
ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET_PERMISSIONS CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET_PERMISSIONS
(
  PERM_SET_PERMISSIONS_ID  NUMBER(20)           NOT NULL,
  PERMISSION_TYPE_ID       NUMBER(20)           NOT NULL,
  PERMISSION_SET_ID        NUMBER(20)           NOT NULL,
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET_PERMISSIONS IS 'Intersection table mapping users and roles The USER_ROLES table is an application administration table that stores the role that determines database access for users.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.PERM_SET_PERMISSIONS_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.PERMISSION_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET_PERMISSIONS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PRMSTPRM_PK ON ADR.PERMISSION_SET_PERMISSIONS
(PERM_SET_PERMISSIONS_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PSETPRM_PERMSET_FK_I ON ADR.PERMISSION_SET_PERMISSIONS
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PSETPRM_STD_PERM_FK_I ON ADR.PERMISSION_SET_PERMISSIONS
(PERMISSION_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERM_SET_PERM_audir_trgr
after Update or Delete or Insert
ON ADR.PERMISSION_SET_PERMISSIONS
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERMISSION_SET_PERMISSIONS_H
		(
		PERM_SET_PERMISSIONS_H_ID,
		PERM_SET_PERMISSIONS_ID,
		PERMISSION_SET_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMSSN_SET_PERMSSNS_H_S.nextval,
		:old.PERM_SET_PERMISSIONS_ID,
		:old.PERMISSION_SET_ID,
		:old.PERMISSION_TYPE_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERMISSION_SET_PERMISSIONS_H
		(
		PERM_SET_PERMISSIONS_H_ID,
		PERM_SET_PERMISSIONS_ID,
		PERMISSION_SET_ID,
		PERMISSION_TYPE_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMSSN_SET_PERMSSNS_H_S.nextval,
		:new.PERM_SET_PERMISSIONS_ID,
		:new.PERMISSION_SET_ID,
		:new.PERMISSION_TYPE_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERM_SET_PERM_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET_PERMISSIONS FOR ADR.PERMISSION_SET_PERMISSIONS;


ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PRMSTPRM_PK
  PRIMARY KEY
  (PERM_SET_PERMISSIONS_ID)
  USING INDEX ADR.PRMSTPRM_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PERMISSION_SET_PERMISSIONS ADD (
  CONSTRAINT PSETPRM_PERMSET_FK 
  FOREIGN KEY (PERMISSION_SET_ID) 
  REFERENCES ADR.PERMISSION_SET (PERMISSION_SET_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT PSETPRM_STD_PERM_FK 
  FOREIGN KEY (PERMISSION_TYPE_ID) 
  REFERENCES ADRREF.STD_PERMISSIONTYPE (ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET_PERMISSIONS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERMISSION_SET_PERMISSIONS TO ADR_RW;
ALTER TABLE ADR.PERMISSION_SET_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET_H
(
  PERMISSION_SET_H_ID    NUMBER(20)             NOT NULL,
  TRANSACTION_TYPE_CODE  VARCHAR2(1 BYTE)       NOT NULL,
  PERMISSION_SET_ID      NUMBER(20)             NOT NULL,
  NAME                   VARCHAR2(100 BYTE)     NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.PERMISSION_SET_H_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.INACTIVE_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PERMSETH_PK ON ADR.PERMISSION_SET_H
(PERMISSION_SET_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET_H FOR ADR.PERMISSION_SET_H;


ALTER TABLE ADR.PERMISSION_SET_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_036
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT PERMSETH_PK
  PRIMARY KEY
  (PERMISSION_SET_H_ID)
  USING INDEX ADR.PERMSETH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET_H TO ADR_R;

GRANT SELECT ON ADR.PERMISSION_SET_H TO ADR_RW;

GRANT SELECT ON ADR.PERMISSION_SET_H TO CARUSR_R;
ALTER TABLE ADR.PERMISSION_SET
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PERMISSION_SET CASCADE CONSTRAINTS;

CREATE TABLE ADR.PERMISSION_SET
(
  PERMISSION_SET_ID      NUMBER(20)             NOT NULL,
  NAME                   VARCHAR2(100 BYTE)     NOT NULL,
  DESCRIPTION            VARCHAR2(250 BYTE),
  ACTIVE_DATE            DATE,
  INACTIVE_DATE          DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PERMISSION_SET IS 'LOOKUP TABLE - this contains the list of permissions present in the application: Administer Application Parameters Administer System Parameters Manage Address Manage All Eligibility & Enrollment Manage Communications Log Manage EGT Setting Manage Financial Information Manage Person Associations Manage Person Demographics Manage Person Insurance Manage Person Military Service Info Manage Person POW Information Manage Person Purple Heart Manage Registries Manage Select Eligibility & Enrollment Manage User Profile Manage Workload Perform S&D Merge Perform Veteran Merge Re-transmit Messages Schedule/Run Reports View Completed Reports View Registries';

COMMENT ON COLUMN ADR.PERMISSION_SET.PERMISSION_SET_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PERMISSION_SET.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PERMSET_PK ON ADR.PERMISSION_SET
(PERMISSION_SET_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PERMSET_U_CODE_UK ON ADR.PERMISSION_SET
(NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PERMISSION_SET_audir_trgr
after Update or Delete or Insert
ON ADR.PERMISSION_SET
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into PERMISSION_SET_H
		(
		PERMISSION_SET_H_ID,
		PERMISSION_SET_ID,
		NAME,
		DESCRIPTION,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMISSION_SET_H_S.nextval,
		:old.PERMISSION_SET_ID,
		:old.NAME,
		:old.DESCRIPTION,
		:old.ACTIVE_DATE,
		:old.INACTIVE_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into PERMISSION_SET_H
		(
		PERMISSION_SET_H_ID,
		PERMISSION_SET_ID,
		NAME,
		DESCRIPTION,
		ACTIVE_DATE,
		INACTIVE_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
		)
		values
		(
		PERMISSION_SET_H_S.nextval,
		:new.PERMISSION_SET_ID,
		:new.NAME,
		:new.DESCRIPTION,
		:new.ACTIVE_DATE,
		:new.INACTIVE_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end PERMISSION_SET_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_SET FOR ADR.PERMISSION_SET;


ALTER TABLE ADR.PERMISSION_SET ADD (
  CONSTRAINT PERMSET_PK
  PRIMARY KEY
  (PERMISSION_SET_ID)
  USING INDEX ADR.PERMSET_PK
  ENABLE VALIDATE,
  CONSTRAINT PERMSET_U_CODE_UK
  UNIQUE (NAME)
  USING INDEX ADR.PERMSET_U_CODE_UK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PERMISSION_SET TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PERMISSION_SET TO ADR_RW;

GRANT SELECT ON ADR.PERMISSION_SET TO CARUSR_R;
ALTER TABLE ADR.PENSION_REASON
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PENSION_REASON CASCADE CONSTRAINTS;

CREATE TABLE ADR.PENSION_REASON
(
  PENSION_REASON_ID      NUMBER(20)             NOT NULL,
  CODE                   VARCHAR2(12 BYTE)      NOT NULL,
  NAME                   VARCHAR2(50 BYTE)      NOT NULL,
  DESCRIPTION            VARCHAR2(100 BYTE),
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PENSION_REASON IS 'Reason for awarding a pension or terminationg a pension award';

COMMENT ON COLUMN ADR.PENSION_REASON.PENSION_REASON_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.PENSION_REASON.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.PENSION_REASON.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PENSION_REASON.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.PENSION_REASON.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PENSION_REASON.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.PNSRSN_PK ON ADR.PENSION_REASON
(PENSION_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PENSION_REASON FOR ADR.PENSION_REASON;


ALTER TABLE ADR.PENSION_REASON ADD (
  CONSTRAINT PNSRSN_PK
  PRIMARY KEY
  (PENSION_REASON_ID)
  USING INDEX ADR.PNSRSN_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PENSION_REASON TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PENSION_REASON TO ADR_RW;
ALTER TABLE ADR.PENSION_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PENSION_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PENSION_H
(
  PENSION_H_ID                    NUMBER(20)    NOT NULL,
  PENSION_ID                      NUMBER(20)    NOT NULL,
  MONETARY_BENEFIT_DETAIL_ID      NUMBER(20),
  PENSION_AWARD_REASON_ID         NUMBER(20),
  PENSION_AWARD_TERMINATION_ID1   NUMBER(20),
  PENSION_AWARD_TERMINATION_ID2   NUMBER(20),
  PENSION_AWARD_TERMINATION_ID3   NUMBER(20),
  PENSION_AWARD_TERMINATION_ID4   NUMBER(20),
  PENSION_AWARD_EFFECTIVE_DATE    DATE,
  PENSION_AWARD_TERMINATION_DATE  DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  HISTORY_CREATED_DATE            DATE,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PENSION_H.PENSION_H_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.PENSION_H.PENSION_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.PENSION_H.PENSION_AWARD_REASON_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.PENSION_H.PENSION_AWARD_EFFECTIVE_DATE IS 'Beginning of effective period.';

COMMENT ON COLUMN ADR.PENSION_H.PENSION_AWARD_TERMINATION_DATE IS 'End of effective period.';

COMMENT ON COLUMN ADR.PENSION_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.PENSION_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PENSION_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.PENSION_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PENSION_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PENSION_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE INDEX ADR.PNSH_MNTBENDTL_FK_I ON ADR.PENSION_H
(MONETARY_BENEFIT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PNSH_PK ON ADR.PENSION_H
(PENSION_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PENSION_H FOR ADR.PENSION_H;


ALTER TABLE ADR.PENSION_H ADD (
  CONSTRAINT PNSH_PK
  PRIMARY KEY
  (PENSION_H_ID)
  USING INDEX ADR.PNSH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PENSION_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PENSION_H TO ADR_RW;
ALTER TABLE ADR.PENSION
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PENSION CASCADE CONSTRAINTS;

CREATE TABLE ADR.PENSION
(
  PENSION_ID                      NUMBER(20)    NOT NULL,
  MONETARY_BENEFIT_DETAIL_ID      NUMBER(20),
  PENSION_AWARD_REASON_ID         NUMBER(20),
  PENSION_AWARD_TERMINATION_ID1   NUMBER(20),
  PENSION_AWARD_TERMINATION_ID2   NUMBER(20),
  PENSION_AWARD_TERMINATION_ID3   NUMBER(20),
  PENSION_AWARD_TERMINATION_ID4   NUMBER(20),
  PENSION_AWARD_EFFECTIVE_DATE    DATE,
  PENSION_AWARD_TERMINATION_DATE  DATE,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.PENSION.PENSION_ID IS 'The primary key, generated by the database system in numeric form, used to uniquely identiry a data record in this table.';

COMMENT ON COLUMN ADR.PENSION.PENSION_AWARD_EFFECTIVE_DATE IS 'Beginning of effective period.';

COMMENT ON COLUMN ADR.PENSION.PENSION_AWARD_TERMINATION_DATE IS 'End of effective period.';

COMMENT ON COLUMN ADR.PENSION.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.PENSION.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PENSION.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.PENSION.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PENSION.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.IX_RELATIONSHIP51 ON ADR.PENSION
(PENSION_AWARD_REASON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP52 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID1)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP53 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID2)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP54 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID3)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP55 ON ADR.PENSION
(PENSION_AWARD_TERMINATION_ID4)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PNS_MNTBENDTL_FK_I ON ADR.PENSION
(MONETARY_BENEFIT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PNS_PK ON ADR.PENSION
(PENSION_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PENSION_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PENSION
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into PENSION_H
        (
        PENSION_H_ID,
        PENSION_ID,
        MONETARY_BENEFIT_DETAIL_ID,
        PENSION_AWARD_REASON_ID,
        PENSION_AWARD_EFFECTIVE_DATE,
        PENSION_AWARD_TERMINATION_DATE,
        PENSION_AWARD_TERMINATION_ID1,
        PENSION_AWARD_TERMINATION_ID2,
        PENSION_AWARD_TERMINATION_ID3,
        PENSION_AWARD_TERMINATION_ID4,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PENSION_H_S.nextval,
        :old.PENSION_ID,
        :old.MONETARY_BENEFIT_DETAIL_ID,
        :old.PENSION_AWARD_REASON_ID,
        :old.PENSION_AWARD_EFFECTIVE_DATE,
        :old.PENSION_AWARD_TERMINATION_DATE,
        :old.PENSION_AWARD_TERMINATION_ID1,
        :old.PENSION_AWARD_TERMINATION_ID2,
        :old.PENSION_AWARD_TERMINATION_ID3,
        :old.PENSION_AWARD_TERMINATION_ID4,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into PENSION_H
        (
        PENSION_H_ID,
        PENSION_ID,
        MONETARY_BENEFIT_DETAIL_ID,
        PENSION_AWARD_REASON_ID,
        PENSION_AWARD_EFFECTIVE_DATE,
        PENSION_AWARD_TERMINATION_DATE,
        PENSION_AWARD_TERMINATION_ID1,
        PENSION_AWARD_TERMINATION_ID2,
        PENSION_AWARD_TERMINATION_ID3,
        PENSION_AWARD_TERMINATION_ID4,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PENSION_H_S.nextval,
        :new.PENSION_ID,
        :new.MONETARY_BENEFIT_DETAIL_ID,
        :new.PENSION_AWARD_REASON_ID,
        :new.PENSION_AWARD_EFFECTIVE_DATE,
        :new.PENSION_AWARD_TERMINATION_DATE,
        :new.PENSION_AWARD_TERMINATION_ID1,
        :new.PENSION_AWARD_TERMINATION_ID2,
        :new.PENSION_AWARD_TERMINATION_ID3,
        :new.PENSION_AWARD_TERMINATION_ID4,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end PENSION_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM PENSION FOR ADR.PENSION;


ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT PNS_PK
  PRIMARY KEY
  (PENSION_ID)
  USING INDEX ADR.PNS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PENSION ADD (
  CONSTRAINT RELATIONSHIP51 
  FOREIGN KEY (PENSION_AWARD_REASON_ID) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP52 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID1) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP53 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID2) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP54 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID3) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP55 
  FOREIGN KEY (PENSION_AWARD_TERMINATION_ID4) 
  REFERENCES ADR.PENSION_REASON (PENSION_REASON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PENSION TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.PENSION TO ADR_RW;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H
(
  PATIENT_PROVIDER_ASSIGN_H_ID    NUMBER(20)    NOT NULL,
  PATIENT_PROVIDER_ASSIGNMENT_ID  NUMBER(20)    NOT NULL,
  HEALTH_CARE_PROVIDER_ID         NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20),
  STD_TEAM_PURPOSE_ID             NUMBER(20)    NOT NULL,
  STD_INSTITUTION_ID              NUMBER(20)    NOT NULL,
  TEAM_ID                         NUMBER(20),
  TEAM_NAME                       VARCHAR2(30 BYTE),
  DATE_ASSIGNED                   DATE          NOT NULL,
  DATE_UNASSIGNED                 DATE,
  PATIENT_IEN                     VARCHAR2(20 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  HISTORY_CREATED_DATE            DATE,
  TRANSACTION_TYPE_CODE           VARCHAR2(1 BYTE) NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H IS 'A current HEALTH CARE PROVIDER assigned to PATIRNT at a facility.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.HEALTH_CARE_PROVIDER_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.DATE_ASSIGNED IS 'Date Provider Assigned to Team Position at Assigning Facility.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.DATE_UNASSIGNED IS 'Date Provider Un-Assigned from Team Position';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.PATIENT_IEN IS 'Uniquely tracks the PATIENT, PROVIDER, TEAM relationship.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.PATPRVASGNH_PK ON ADR.PATIENT_PROVIDER_ASSIGNMENT_H
(PATIENT_PROVIDER_ASSIGN_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM PATIENT_PROVIDER_ASSIGNMENT_H FOR ADR.PATIENT_PROVIDER_ASSIGNMENT_H;


ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT_H ADD (
  CHECK ("HISTORY_CREATED_DATE" IS NOT NULL)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE,
  CONSTRAINT PATPRVASGNH_PK
  PRIMARY KEY
  (PATIENT_PROVIDER_ASSIGN_H_ID)
  USING INDEX ADR.PATPRVASGNH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PATIENT_PROVIDER_ASSIGNMENT_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PATIENT_PROVIDER_ASSIGNMENT_H TO ADR_RW;
ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT CASCADE CONSTRAINTS;

CREATE TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT
(
  PATIENT_PROVIDER_ASSIGNMENT_ID  NUMBER(20)    NOT NULL,
  HEALTH_CARE_PROVIDER_ID         NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20),
  STD_TEAM_PURPOSE_ID             NUMBER(20),
  STD_INSTITUTION_ID              NUMBER(20)    NOT NULL,
  TEAM_ID                         NUMBER(20),
  TEAM_NAME                       VARCHAR2(30 BYTE),
  DATE_ASSIGNED                   DATE          NOT NULL,
  DATE_UNASSIGNED                 DATE,
  PATIENT_IEN                     VARCHAR2(20 BYTE),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT IS 'A current HEALTH CARE PROVIDER assigned to PATIRNT at a facility.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.DATE_ASSIGNED IS 'Date Provider Assigned to Team Position at Assigning Facility.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.DATE_UNASSIGNED IS 'Date Provider Un-Assigned from Team Position';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.PATIENT_IEN IS 'Uniquely tracks the PATIENT, PROVIDER, TEAM relationship.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.PATIENT_PROVIDER_ASSIGNMENT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE INDEX ADR.IX_RELATIONSHIP59 ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(HEALTH_CARE_PROVIDER_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP65 ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IX_RELATIONSHIP74 ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(STD_TEAM_PURPOSE_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.PATPRVASGN_PK ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(PATIENT_PROVIDER_ASSIGNMENT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.PPA_STDINS_FK_I ON ADR.PATIENT_PROVIDER_ASSIGNMENT
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.PAT_PROV_ASSIGN_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.PATIENT_PROVIDER_ASSIGNMENT
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin
    if DELETING then
        insert into PATIENT_PROVIDER_ASSIGNMENT_H
        (
        PATIENT_PROVIDER_ASSIGN_H_ID,
        PATIENT_PROVIDER_ASSIGNMENT_ID,
        HEALTH_CARE_PROVIDER_ID,
        PERSON_ID,
        STD_TEAM_PURPOSE_ID,
        STD_INSTITUTION_ID,
        TEAM_ID,
        TEAM_NAME,
        DATE_ASSIGNED,
        DATE_UNASSIGNED,
        PATIENT_IEN,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PATIENT_PROV_ASSIGN_H_S.nextval,
        :old.PATIENT_PROVIDER_ASSIGNMENT_ID,
        :old.HEALTH_CARE_PROVIDER_ID,
        :old.PERSON_ID,
        :old.STD_TEAM_PURPOSE_ID,
        :old.STD_INSTITUTION_ID,
        :old.TEAM_ID,
        :old.TEAM_NAME,
        :old.DATE_ASSIGNED,
        :old.DATE_UNASSIGNED,
        :old.PATIENT_IEN,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into PATIENT_PROVIDER_ASSIGNMENT_H
        (
        PATIENT_PROVIDER_ASSIGN_H_ID,
        PATIENT_PROVIDER_ASSIGNMENT_ID,
        HEALTH_CARE_PROVIDER_ID,
        PERSON_ID,
        STD_TEAM_PURPOSE_ID,
        STD_INSTITUTION_ID,
        TEAM_ID,
        TEAM_NAME,
        DATE_ASSIGNED,
        DATE_UNASSIGNED,
        PATIENT_IEN,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        PATIENT_PROV_ASSIGN_H_S.nextval,
        :new.PATIENT_PROVIDER_ASSIGNMENT_ID,
        :new.HEALTH_CARE_PROVIDER_ID,
        :new.PERSON_ID,
        :new.STD_TEAM_PURPOSE_ID,
        :new.STD_INSTITUTION_ID,
        :new.TEAM_ID,
        :new.TEAM_NAME,
        :new.DATE_ASSIGNED,
        :new.DATE_UNASSIGNED,
        :new.PATIENT_IEN,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end PAT_PROV_ASSIGN_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM PATIENT_PROVIDER_ASSIGNMENT FOR ADR.PATIENT_PROVIDER_ASSIGNMENT;


ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT PATPRVASGN_PK
  PRIMARY KEY
  (PATIENT_PROVIDER_ASSIGNMENT_ID)
  USING INDEX ADR.PATPRVASGN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.PATIENT_PROVIDER_ASSIGNMENT ADD (
  CONSTRAINT RELATIONSHIP59 
  FOREIGN KEY (HEALTH_CARE_PROVIDER_ID) 
  REFERENCES ADR.HEALTH_CARE_PROVIDER (HEALTH_CARE_PROVIDER_ID)
  ENABLE VALIDATE,
  CONSTRAINT RELATIONSHIP65 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.PATIENT_PROVIDER_ASSIGNMENT TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.PATIENT_PROVIDER_ASSIGNMENT TO ADR_RW;

GRANT DELETE ON ADR.PATIENT_PROVIDER_ASSIGNMENT TO EEUSR;
ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY CASCADE CONSTRAINTS;

CREATE TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY
(
  NCOA_ADDRESS_VERIFY_SUMMARY_ID  NUMBER(20)    NOT NULL,
  SCREENED_ADDRESS_COUNT          NUMBER(10),
  EXCLUDED_ADDRESS_COUNT          NUMBER(10),
  DECEASED_ADDRESS_COUNT          NUMBER(10),
  SENT_TO_AAC_COUNT               NUMBER(10),
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL,
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY IS 'Contains a summary of the address batch that was sent for NCOA processing';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.NCOA_ADDRESS_VERIFY_SUMMARY_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.NCOA_ADDRESS_VERIFY_SUMMARY.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.VERIFYSUM_PK ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY
(NCOA_ADDRESS_VERIFY_SUMMARY_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM NCOA_ADDRESS_VERIFY_SUMMARY FOR ADR.NCOA_ADDRESS_VERIFY_SUMMARY;


ALTER TABLE ADR.NCOA_ADDRESS_VERIFY_SUMMARY ADD (
  CONSTRAINT VERIFYSUM_PK
  PRIMARY KEY
  (NCOA_ADDRESS_VERIFY_SUMMARY_ID)
  USING INDEX ADR.VERIFYSUM_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.NCOA_ADDRESS_VERIFY_SUMMARY TO ADR_RW;
ALTER TABLE ADR.MONETARY_BENEFIT_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MONETARY_BENEFIT_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MONETARY_BENEFIT_H
(
  MONETARY_BENEFIT_H_ID          NUMBER(20),
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE),
  MONETARY_BENEFIT_ID            NUMBER(20),
  PERSON_ID                      NUMBER(20),
  MONETARY_BENEFIT_AWARD_AMOUNT  NUMBER(10,2),
  VERIFIED_DATE                  DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE            DATE,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE           DATE,
  RECORD_MODIFIED_COUNT          NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MONETARY_BENEFIT_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.MONETARY_BENEFIT_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.VERIFIED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MONEYBENH_PK ON ADR.MONETARY_BENEFIT_H
(MONETARY_BENEFIT_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MONEYBENH_PRSNID_NU_I ON ADR.MONETARY_BENEFIT_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MONETARY_BENEFIT_H FOR ADR.MONETARY_BENEFIT_H;


ALTER TABLE ADR.MONETARY_BENEFIT_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_046
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066811
  CHECK ("MONETARY_BENEFIT_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066812
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066813
  CHECK ("MONETARY_BENEFIT_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066814
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066815
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066816
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066817
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066818
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0066819
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT MONEYBENH_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_H_ID)
  USING INDEX ADR.MONEYBENH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MONETARY_BENEFIT_H TO ADR_R;

GRANT SELECT ON ADR.MONETARY_BENEFIT_H TO ADR_RW;
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MONETARY_BENEFIT_DETAIL_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MONETARY_BENEFIT_DETAIL_H
(
  MONETARY_BENEFIT_DETAIL_H_ID  NUMBER(20)      NOT NULL,
  TRANSACTION_TYPE_CODE         VARCHAR2(1 BYTE) NOT NULL,
  MONETARY_BENEFIT_DETAIL_ID    NUMBER(20)      NOT NULL,
  MONETARY_BENEFIT_ID           NUMBER(20)      NOT NULL,
  MONETARY_BENEFIT_TYPE_ID      NUMBER(20)      NOT NULL,
  MONETARY_BENEFIT_STDYESNO_ID  NUMBER(20),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MONETARY_BENEFIT_DETAIL_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.MONETARY_BENEFIT_DETAIL_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.MONETARY_BENEFIT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.MONETARY_BENEFIT_STDYESNO_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.MONEYBNDTLH_MONEYBEN_NU_I ON ADR.MONETARY_BENEFIT_DETAIL_H
(MONETARY_BENEFIT_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MONEYBNDTLH_PK ON ADR.MONETARY_BENEFIT_DETAIL_H
(MONETARY_BENEFIT_DETAIL_H_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MONETARY_BENEFIT_DETAIL_H FOR ADR.MONETARY_BENEFIT_DETAIL_H;


ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_021
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT MONEYBNDTLH_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_DETAIL_H_ID)
  USING INDEX ADR.MONEYBNDTLH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL_H TO ADR_R;

GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL_H TO ADR_RW;
ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MONETARY_BENEFIT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.MONETARY_BENEFIT_DETAIL
(
  MONETARY_BENEFIT_DETAIL_ID    NUMBER(20)      NOT NULL,
  MONETARY_BENEFIT_ID           NUMBER(20)      NOT NULL,
  MONETARY_BENEFIT_TYPE_ID      NUMBER(20)      NOT NULL,
  MONETARY_BENEFIT_STDYESNO_ID  NUMBER(20),
  RECORD_CREATED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE           DATE            NOT NULL,
  RECORD_MODIFIED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE          DATE            NOT NULL,
  RECORD_MODIFIED_COUNT         NUMBER(10)      NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MONETARY_BENEFIT_DETAIL IS 'The table stores details about a persons individual monetary awards as provided by the Veterans Benefits Administration (VBA). This is a child table of MONETARY_BENEFIT. MONETARY_BENEFIT_ID Foreign key for the MONETARY_BENEFIT table. MONETARY_BENEFIT_TYPE_ID Foreign key for the MONETARY_BENEFIT_TYPE table. Indicates the type of monetary benefit provided (for example Aid and Attendance, Housebound). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.MONETARY_BENEFIT_DETAIL_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.MONETARY_BENEFIT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.MONETARY_BENEFIT_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.MONEYBNDTL_MONEYBEN_FK_I ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MONEYBNDTL_PK ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_DETAIL_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MONEYBNDTL_STDYESNO_FK_I ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_STDYESNO_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MONEYBNDTL_STD_MNTRYBNTYP_FK_I ON ADR.MONETARY_BENEFIT_DETAIL
(MONETARY_BENEFIT_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.MONETARY_BENF_DEF_audir_trgr
after Update or Delete or Insert
ON ADR.MONETARY_BENEFIT_DETAIL
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MONETARY_BENEFIT_DETAIL_H
		(
		MONETARY_BENEFIT_DETAIL_H_ID,
		MONETARY_BENEFIT_DETAIL_ID,
		MONETARY_BENEFIT_ID,
		MONETARY_BENEFIT_TYPE_ID,
		MONETARY_BENEFIT_STDYESNO_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_DETAIL_H_S.nextval,
		:old.MONETARY_BENEFIT_DETAIL_ID,
		:old.MONETARY_BENEFIT_ID,
		:old.MONETARY_BENEFIT_TYPE_ID,
		:old.MONETARY_BENEFIT_STDYESNO_ID,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MONETARY_BENEFIT_DETAIL_H
		(
		MONETARY_BENEFIT_DETAIL_H_ID,
		MONETARY_BENEFIT_DETAIL_ID,
		MONETARY_BENEFIT_ID,
		MONETARY_BENEFIT_TYPE_ID,
		MONETARY_BENEFIT_STDYESNO_ID,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_DETAIL_H_S.nextval,
		:new.MONETARY_BENEFIT_DETAIL_ID,
		:new.MONETARY_BENEFIT_ID,
		:new.MONETARY_BENEFIT_TYPE_ID,
		:new.MONETARY_BENEFIT_STDYESNO_ID,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  MONETARY_BENF_DEF_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM MONETARY_BENEFIT_DETAIL FOR ADR.MONETARY_BENEFIT_DETAIL;


ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT MONEYBNDTL_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_DETAIL_ID)
  USING INDEX ADR.MONEYBNDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MONETARY_BENEFIT_DETAIL ADD (
  CONSTRAINT MONEYBNDTL_MONEYBEN_FK 
  FOREIGN KEY (MONETARY_BENEFIT_ID) 
  REFERENCES ADR.MONETARY_BENEFIT (MONETARY_BENEFIT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL TO ADREXT;

GRANT SELECT ON ADR.MONETARY_BENEFIT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MONETARY_BENEFIT_DETAIL TO ADR_RW;
ALTER TABLE ADR.MONETARY_BENEFIT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MONETARY_BENEFIT CASCADE CONSTRAINTS;

CREATE TABLE ADR.MONETARY_BENEFIT
(
  MONETARY_BENEFIT_ID            NUMBER(20)     NOT NULL,
  PERSON_ID                      NUMBER(20)     NOT NULL,
  MONETARY_BENEFIT_AWARD_AMOUNT  NUMBER(10,2),
  VERIFIED_DATE                  DATE,
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MONETARY_BENEFIT IS 'The table stores information about a persons monetary awards as provided by the Veterans Benefits Administration (VBA). PERSON_ID Foreign key for the PERSON table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.MONETARY_BENEFIT_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.MONETARY_BENEFIT_AWARD_AMOUNT IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.VERIFIED_DATE IS 'AuditField-Datethe recordwascreatedin database';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MONETARY_BENEFIT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MONEYBEN_PK ON ADR.MONETARY_BENEFIT
(MONETARY_BENEFIT_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MONEYBEN_PRSN_FK_I ON ADR.MONETARY_BENEFIT
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.MONETARY_BENF_audir_trgr
after Update or Delete or Insert
on ADR.MONETARY_BENEFIT
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MONETARY_BENEFIT_H
		(
		MONETARY_BENEFIT_H_ID,
		MONETARY_BENEFIT_ID,
		PERSON_ID,
		MONETARY_BENEFIT_AWARD_AMOUNT,
		VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_H_S.nextval,
		:old.MONETARY_BENEFIT_ID,
		:old.PERSON_ID,
		:old.MONETARY_BENEFIT_AWARD_AMOUNT,
		:old.VERIFIED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	IF :OLD.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:OLD.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MONETARY_BENEFIT_H
		(
		MONETARY_BENEFIT_H_ID,
		MONETARY_BENEFIT_ID,
		PERSON_ID,
		MONETARY_BENEFIT_AWARD_AMOUNT,
		VERIFIED_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MONETARY_BENEFIT_H_S.nextval,
		:new.MONETARY_BENEFIT_ID,
		:new.PERSON_ID,
		:new.MONETARY_BENEFIT_AWARD_AMOUNT,
		:new.VERIFIED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	IF :NEW.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:NEW.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	end if;

end  MONETARY_BENF_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM MONETARY_BENEFIT FOR ADR.MONETARY_BENEFIT;


ALTER TABLE ADR.MONETARY_BENEFIT ADD (
  CONSTRAINT MONEYBEN_PK
  PRIMARY KEY
  (MONETARY_BENEFIT_ID)
  USING INDEX ADR.MONEYBEN_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MONETARY_BENEFIT ADD (
  CONSTRAINT MONEYBEN_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MONETARY_BENEFIT TO ADREXT;

GRANT SELECT ON ADR.MONETARY_BENEFIT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MONETARY_BENEFIT TO ADR_RW;
ALTER TABLE ADR.MILITARY_SERVICE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MILITARY_SERVICE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MILITARY_SERVICE_H
(
  MILITARY_SERVICE_H_ID     NUMBER(20)          NOT NULL,
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE)    NOT NULL,
  MILITARY_SERVICE_ID       NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_PERIODOFSERVICE_ID    NUMBER(20),
  FILIPINO_VET_DOC_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20)          NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MILITARY_SERVICE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.MILITARY_SERVICE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.MILITARY_SERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.STD_PERIODOFSERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.FILIPINO_VET_DOC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MILSRVCH_PK ON ADR.MILITARY_SERVICE_H
(MILITARY_SERVICE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVCH_PRSNID_NU_I ON ADR.MILITARY_SERVICE_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MILITARY_SERVICE_H FOR ADR.MILITARY_SERVICE_H;


ALTER TABLE ADR.MILITARY_SERVICE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_033
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT MILSRVCH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_H_ID)
  USING INDEX ADR.MILSRVCH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ADR_R;

GRANT SELECT ON ADR.MILITARY_SERVICE_H TO ADR_RW;
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MILITARY_SERVICE_EPISODE_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MILITARY_SERVICE_EPISODE_H
(
  MILITARY_SERVICE_EPISODE_H_ID  NUMBER(20)     NOT NULL,
  TRANSACTION_TYPE_CODE          VARCHAR2(1 BYTE) NOT NULL,
  MILITARY_SERVICE_EPISODE_ID    NUMBER(20)     NOT NULL,
  MILITARY_SERVICE_ID            NUMBER(20)     NOT NULL,
  SERVICECOMPONENTTYPE_ID        NUMBER(20),
  SERVICE_BRANCH_TYPE_ID         NUMBER(20),
  SERVICE_DISCHARGE_TYPE_ID      NUMBER(20),
  MILITARY_SERVICE_NUMBER        VARCHAR2(20 BYTE),
  SERVICE_ENTRY_DATE_TXT         VARCHAR2(14 BYTE),
  SERVICE_SEPARATION_DATE_TXT    VARCHAR2(14 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MILITARY_SERVICE_EPISODE_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_EPISODE_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_EPISODE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_BRANCH_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_DISCHARGE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.MILITARY_SERVICE_NUMBER IS 'MilitaryServiceNumber isaUniqueidentifier providedtoapersonby thebranchofthe militarywithwhichheor sheserved.Itisdefined astheservicenumber assignedduringthe veteransepisodesof militaryservice.The socialsecuritynumber andservicenumbercanbe thesame.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_ENTRY_DATE_TXT IS 'BR3278ServiceEntryDate isdefinedasthedate theveterancommenced his/herepisodesof militaryservice. ServiceEntryDateis usedtodetermine enrollmentappropriately for24monthsofservice computation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.SERVICE_SEPARATION_DATE_TXT IS 'BR3281ServiceSeparation Dateisdefinedasthe datetheveteranended his/herepisodesof militaryservice. ServiceSeparationDate isusedtodetermine enrollmentappropriately for24monthsofservice computation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.MILSRVCEPH_MILSRVC_NU_I ON ADR.MILITARY_SERVICE_EPISODE_H
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MILSRVCEPH_PK ON ADR.MILITARY_SERVICE_EPISODE_H
(MILITARY_SERVICE_EPISODE_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MILITARY_SERVICE_EPISODE_H FOR ADR.MILITARY_SERVICE_EPISODE_H;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_042
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT MILSRVCEPH_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_H_ID)
  USING INDEX ADR.MILSRVCEPH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ADR_R;

GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE_H TO ADR_RW;
ALTER TABLE ADR.MILITARY_SERVICE_EPISODE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MILITARY_SERVICE_EPISODE CASCADE CONSTRAINTS;

CREATE TABLE ADR.MILITARY_SERVICE_EPISODE
(
  MILITARY_SERVICE_EPISODE_ID  NUMBER(20)       NOT NULL,
  MILITARY_SERVICE_ID          NUMBER(20)       NOT NULL,
  SERVICE_BRANCH_TYPE_ID       NUMBER(20),
  SERVICE_DISCHARGE_TYPE_ID    NUMBER(20),
  SERVICECOMPONENTTYPE_ID      NUMBER(20),
  MILITARY_SERVICE_NUMBER      VARCHAR2(20 BYTE),
  SERVICE_ENTRY_DATE_TXT       VARCHAR2(14 BYTE),
  SERVICE_SEPARATION_DATE_TXT  VARCHAR2(14 BYTE),
  RECORD_CREATED_DATE          DATE             NOT NULL,
  RECORD_CREATED_BY            VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_BY           VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE         DATE             NOT NULL,
  RECORD_MODIFIED_COUNT        NUMBER(10)       NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MILITARY_SERVICE_EPISODE IS 'The table stores details about a persons individual episodes of service, including entry and separation dates, and discharge type. This is a child table of MILITARY_SERVICE table. MILITARY_SERVICE_ID Foreign key to the MILITARY_SERVICE table. SERVICE_BRANCH_TYPE_ID Foreign key to the SERVICE_BRANCH_TYPE table. Indicates the branch of the armed forces associated with the service episode (for example, Army, Navy). SERVICE_DISCHARGE_TYPE_ID Foreign key to the SERVICE_DISCHARGE_TYPE table. Indicates the classification of the discharge from the service (for example, Honorable, Dishonorable). ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.MILITARY_SERVICE_EPISODE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.MILITARY_SERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.SERVICE_BRANCH_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.SERVICE_DISCHARGE_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.MILITARY_SERVICE_NUMBER IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.SERVICE_ENTRY_DATE_TXT IS 'BR3278ServiceEntryDate isdefinedasthedate theveterancommenced his/herepisodesof militaryservice. ServiceEntryDateis usedtodetermine enrollmentappropriately for24monthsofservice computation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.SERVICE_SEPARATION_DATE_TXT IS 'BR3281ServiceSeparation Dateisdefinedasthe datetheveteranended his/herepisodesof militaryservice. ServiceSeparationDate isusedtodetermine enrollmentappropriately for24monthsofservice computation.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE_EPISODE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.MILSRVCEPS_MILSRVC_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVCEPS_MILSVCNBR_FB_I ON ADR.MILITARY_SERVICE_EPISODE
(UPPER("MILITARY_SERVICE_NUMBER"))
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MILSRVCEPS_PK ON ADR.MILITARY_SERVICE_EPISODE
(MILITARY_SERVICE_EPISODE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVCEPS_STDMSVCMPT_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(SERVICECOMPONENTTYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVCEPS_STD_SVCBRNCH_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(SERVICE_BRANCH_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVCEPS_STD_SVCDSCHRG_FK_I ON ADR.MILITARY_SERVICE_EPISODE
(SERVICE_DISCHARGE_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.MILITARY_SERV_EPIS_audir_trgr
after Update or Delete or Insert
ON ADR.MILITARY_SERVICE_EPISODE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MILITARY_SERVICE_EPISODE_H
		(
		MILITARY_SERVICE_EPISODE_H_ID,
		MILITARY_SERVICE_EPISODE_ID,
		MILITARY_SERVICE_ID,
		SERVICE_BRANCH_TYPE_ID,
		SERVICE_DISCHARGE_TYPE_ID,
		SERVICECOMPONENTTYPE_ID,
		MILITARY_SERVICE_NUMBER,
		SERVICE_ENTRY_DATE_TXT,
		SERVICE_SEPARATION_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MILITARY_SERVICE_EPISODE_H_S.nextval,
		:old.MILITARY_SERVICE_EPISODE_ID,
		:old.MILITARY_SERVICE_ID,
		:old.SERVICE_BRANCH_TYPE_ID,
		:old.SERVICE_DISCHARGE_TYPE_ID,
		:old.SERVICECOMPONENTTYPE_ID,
		:old.MILITARY_SERVICE_NUMBER,
		:old.SERVICE_ENTRY_DATE_TXT,
		:old.SERVICE_SEPARATION_DATE_TXT,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MILITARY_SERVICE_EPISODE_H
		(
		MILITARY_SERVICE_EPISODE_H_ID,
		MILITARY_SERVICE_EPISODE_ID,
		MILITARY_SERVICE_ID,
		SERVICE_BRANCH_TYPE_ID,
		SERVICE_DISCHARGE_TYPE_ID,
		SERVICECOMPONENTTYPE_ID,
		MILITARY_SERVICE_NUMBER,
		SERVICE_ENTRY_DATE_TXT,
		SERVICE_SEPARATION_DATE_TXT,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MILITARY_SERVICE_EPISODE_H_S.nextval,
		:new.MILITARY_SERVICE_EPISODE_ID,
		:new.MILITARY_SERVICE_ID,
		:new.SERVICE_BRANCH_TYPE_ID,
		:new.SERVICE_DISCHARGE_TYPE_ID,
		:new.SERVICECOMPONENTTYPE_ID,
		:new.MILITARY_SERVICE_NUMBER,
		:new.SERVICE_ENTRY_DATE_TXT,
		:new.SERVICE_SEPARATION_DATE_TXT,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  MILITARY_SERV_EPIS_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM MILITARY_SERVICE_EPISODE FOR ADR.MILITARY_SERVICE_EPISODE;


ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MILSRVCEPS_PK
  PRIMARY KEY
  (MILITARY_SERVICE_EPISODE_ID)
  USING INDEX ADR.MILSRVCEPS_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MILITARY_SERVICE_EPISODE ADD (
  CONSTRAINT MILSRVCEPS_MILSRVC_FK 
  FOREIGN KEY (MILITARY_SERVICE_ID) 
  REFERENCES ADR.MILITARY_SERVICE (MILITARY_SERVICE_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MILITARY_SERVICE_EPISODE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MILITARY_SERVICE_EPISODE TO ADR_RW;
ALTER TABLE ADR.MILITARY_SERVICE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MILITARY_SERVICE CASCADE CONSTRAINTS;

CREATE TABLE ADR.MILITARY_SERVICE
(
  MILITARY_SERVICE_ID       NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  STD_PERIODOFSERVICE_ID    NUMBER(20),
  FILIPINO_VET_DOC_TYPE_ID  NUMBER(20),
  STD_INSTITUTION_ID        NUMBER(20)          NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MILITARY_SERVICE IS 'The table stores information about a persons military service. Individuation episodes of service are stored in the child MILITARY_SERVICE _EPISODE table. PERSON_ID Foreign key to the PERSON table. FILIPINO_VET_DOC_TYPE_ID Foreign key to the FILIPINO_VET_DOC_TYPE table. Indicates the documentation used to prove identity as a Filipino Veteran of the US Armed Services (defined as one whose branch of service is F. Commonwealth, F.Guerilla, or F.Scouts New) Examples of these documents are: US Passport or US Birth Certificate. STD_PERIODOFSERVICE_ID Foreign key to the STD_PERIODOFSERVICE table. Indicates the period in which the person performed his or her military service (for example, World War 1, World War II). STD_INSTITUTION_ID Foreign key to the STD_INSTITUTION table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.MILITARY_SERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.STD_PERIODOFSERVICE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.FILIPINO_VET_DOC_TYPE_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.STD_INSTITUTION_ID IS 'Acknowledgementmessage typeassociatedwiththe event';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MILITARY_SERVICE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MILSRVC_PK ON ADR.MILITARY_SERVICE
(MILITARY_SERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVC_PRSN_FK_I ON ADR.MILITARY_SERVICE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVC_STDINST_FK_I ON ADR.MILITARY_SERVICE
(STD_INSTITUTION_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVC_STDPERSRVC_FK_I ON ADR.MILITARY_SERVICE
(STD_PERIODOFSERVICE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MILSRVC_STD_FLPNOVTRN_FK_I ON ADR.MILITARY_SERVICE
(FILIPINO_VET_DOC_TYPE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.MILITARY_SERV_audir_trgr
after Update or Delete or Insert
ON ADR.MILITARY_SERVICE
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MILITARY_SERVICE_H
		(
		MILITARY_SERVICE_H_ID,
		MILITARY_SERVICE_ID,
		PERSON_ID,
		STD_PERIODOFSERVICE_ID,
		FILIPINO_VET_DOC_TYPE_ID,
		STD_INSTITUTION_ID,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MILITARY_SERVICE_H_S.nextval,
		:old.MILITARY_SERVICE_ID,
		:old.PERSON_ID,
		:old.STD_PERIODOFSERVICE_ID,
		:old.FILIPINO_VET_DOC_TYPE_ID,
		:old.STD_INSTITUTION_ID,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MILITARY_SERVICE_H
		(
		MILITARY_SERVICE_H_ID,
		MILITARY_SERVICE_ID,
		PERSON_ID,
		STD_PERIODOFSERVICE_ID,
		FILIPINO_VET_DOC_TYPE_ID,
		STD_INSTITUTION_ID,
		RECORD_CREATED_DATE,
		RECORD_CREATED_BY,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MILITARY_SERVICE_H_S.nextval,
		:new.MILITARY_SERVICE_ID,
		:new.PERSON_ID,
		:new.STD_PERIODOFSERVICE_ID,
		:new.FILIPINO_VET_DOC_TYPE_ID,
		:new.STD_INSTITUTION_ID,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	end if;

end  MILITARY_SERV_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM MILITARY_SERVICE FOR ADR.MILITARY_SERVICE;


ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT MILSRVC_PK
  PRIMARY KEY
  (MILITARY_SERVICE_ID)
  USING INDEX ADR.MILSRVC_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MILITARY_SERVICE ADD (
  CONSTRAINT MILSRVC_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MILITARY_SERVICE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MILITARY_SERVICE TO ADR_RW;
ALTER TABLE ADR.MEDICAID_FACTOR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEDICAID_FACTOR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEDICAID_FACTOR_H
(
  MEDICAID_FACTOR_H_ID      NUMBER(20),
  TRANSACTION_TYPE_CODE     VARCHAR2(1 BYTE),
  MEDICAID_FACTOR_ID        NUMBER(20),
  PERSON_ID                 NUMBER(20),
  MEDICAID_ELIGIBILITY_IND  VARCHAR2(1 BYTE),
  MEDICAID_LAST_EDIT_DATE   DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE),
  RECORD_CREATED_DATE       DATE,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE),
  RECORD_MODIFIED_DATE      DATE,
  RECORD_MODIFIED_COUNT     NUMBER(10)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   11
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
COMPRESS FOR OLTP 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MEDICAID_FACTOR_H IS 'The Standard History table name appends _H to the end of the table name and adds two columns, the primary key column appends _H_ID to the table name and a column named TRANSACTION_TYPE_CODE containing a code defining what was done to the row.  All other columns contain a copy of the data row before the change.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.MEDICAID_FACTOR_H_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.TRANSACTION_TYPE_CODE IS 'Code for the action performed on the record in the base table (followed by it being copied into this history table). I for insert, U for update and D for delete.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.MEDICAID_FACTOR_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.MEDICAID_ELIGIBILITY_IND IS 'BR709Eligiblefor MedicaidIndicatoris definedasacodeto indicateifthispatient iseligibletoreceive Medicaidcoverage.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.MEDICAID_LAST_EDIT_DATE IS 'BR7665DateMedicaidlast askedisdefinedasthe datethattheEligible forMedicaidwaslast asked.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MEDICAIDH_PK ON ADR.MEDICAID_FACTOR_H
(MEDICAID_FACTOR_H_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MEDICAIDH_PRSNID_NU_I ON ADR.MEDICAID_FACTOR_H
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MEDICAID_FACTOR_H FOR ADR.MEDICAID_FACTOR_H;


ALTER TABLE ADR.MEDICAID_FACTOR_H ADD (
  CONSTRAINT AVCON_1172521913_TRANS_059
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067141
  CHECK ("MEDICAID_FACTOR_H_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067142
  CHECK ("TRANSACTION_TYPE_CODE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067143
  CHECK ("MEDICAID_FACTOR_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067144
  CHECK ("PERSON_ID" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067145
  CHECK ("MEDICAID_ELIGIBILITY_IND" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067146
  CHECK ("RECORD_CREATED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067147
  CHECK ("RECORD_CREATED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067148
  CHECK ("RECORD_MODIFIED_BY" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067149
  CHECK ("RECORD_MODIFIED_DATE" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT SYS_C0067150
  CHECK ("RECORD_MODIFIED_COUNT" IS NOT NULL)
  ENABLE NOVALIDATE,
  CONSTRAINT MEDICAIDH_PK
  PRIMARY KEY
  (MEDICAID_FACTOR_H_ID)
  USING INDEX ADR.MEDICAIDH_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEDICAID_FACTOR_H TO ADR_R;

GRANT SELECT ON ADR.MEDICAID_FACTOR_H TO ADR_RW;
ALTER TABLE ADR.MEDICAID_FACTOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEDICAID_FACTOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEDICAID_FACTOR
(
  MEDICAID_FACTOR_ID        NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  MEDICAID_ELIGIBILITY_IND  VARCHAR2(1 BYTE)    NOT NULL,
  MEDICAID_LAST_EDIT_DATE   DATE,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.MEDICAID_FACTOR IS 'The table stores data about whether a person is eligible for Medicaid. PERSON_ID Foreign key to the PERSON table. ENROLLMENT ELIGIBILITY';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.MEDICAID_FACTOR_ID IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.MEDICAID_ELIGIBILITY_IND IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.MEDICAID_LAST_EDIT_DATE IS 'Retrofitted.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MEDICAID_FACTOR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.MEDICAID_PK ON ADR.MEDICAID_FACTOR
(MEDICAID_FACTOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MEDICAID_PRSN_FK_I ON ADR.MEDICAID_FACTOR
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   10
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.MEDICAID_FACTOR_audir_trgr
after Update or Delete or Insert
on ADR.MEDICAID_FACTOR
REFERENCING NEW AS NEW OLD AS OLD
for each row
declare
   	mDML char(1);
begin

	if DELETING then
		insert into MEDICAID_FACTOR_H
		(
		MEDICAID_FACTOR_H_ID,
		MEDICAID_FACTOR_ID,
		PERSON_ID,
		MEDICAID_ELIGIBILITY_IND,
		MEDICAID_LAST_EDIT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MEDICAID_FACTOR_H_S.nextval,
		:old.MEDICAID_FACTOR_ID,
		:old.PERSON_ID,
		:old.MEDICAID_ELIGIBILITY_IND,
		:old.MEDICAID_LAST_EDIT_DATE,
		:old.RECORD_CREATED_BY,
		:old.RECORD_CREATED_DATE,
		:old.RECORD_MODIFIED_BY,
		:old.RECORD_MODIFIED_DATE,
		:old.RECORD_MODIFIED_COUNT,
		'D'
		);
	IF :OLD.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:OLD.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	else
		if UPDATING then
			mDML := 'U';
		else
			mDML := 'I';
		end if;

		insert into MEDICAID_FACTOR_H
		(
		MEDICAID_FACTOR_H_ID,
		MEDICAID_FACTOR_ID,
		PERSON_ID,
		MEDICAID_ELIGIBILITY_IND,
		MEDICAID_LAST_EDIT_DATE,
		RECORD_CREATED_BY,
		RECORD_CREATED_DATE,
		RECORD_MODIFIED_BY,
		RECORD_MODIFIED_DATE,
		RECORD_MODIFIED_COUNT,
		TRANSACTION_TYPE_CODE
      	)
		values
		(
		MEDICAID_FACTOR_H_S.nextval,
		:new.MEDICAID_FACTOR_ID,
		:new.PERSON_ID,
		:new.MEDICAID_ELIGIBILITY_IND,
		:new.MEDICAID_LAST_EDIT_DATE,
		:new.RECORD_CREATED_BY,
		:new.RECORD_CREATED_DATE,
		:new.RECORD_MODIFIED_BY,
		:new.RECORD_MODIFIED_DATE,
		:new.RECORD_MODIFIED_COUNT,
		mDML
		);
	IF :NEW.PERSON_ID IS NOT NULL THEN
		INSERT INTO ADR_EXTRACT_CHGS
			(
			PERSON_ID   ,
			CHG_DATE,
			ADR_EXTRACT_CHGS_ID
			)
			VALUES
			(:NEW.PERSON_ID,
			TRUNC(SYSDATE),
			ADR_EXTRACT_CHGS_S.NEXTVAL
			);
	END IF;
	end if;

end  MEDICAID_FACTOR_audir_trgr;
/


CREATE OR REPLACE PUBLIC SYNONYM MEDICAID_FACTOR FOR ADR.MEDICAID_FACTOR;


ALTER TABLE ADR.MEDICAID_FACTOR ADD (
  CONSTRAINT MEDICAID_PK
  PRIMARY KEY
  (MEDICAID_FACTOR_ID)
  USING INDEX ADR.MEDICAID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MEDICAID_FACTOR ADD (
  CONSTRAINT MEDICAID_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEDICAID_FACTOR TO ADREXT;

GRANT SELECT ON ADR.MEDICAID_FACTOR TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MEDICAID_FACTOR TO ADR_RW;
ALTER TABLE ADR.MEDAL_OF_HONOR_H
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEDAL_OF_HONOR_H CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEDAL_OF_HONOR_H
(
  MEDAL_OF_HONOR_H_ID        NUMBER(20)         NOT NULL,
  TRANSACTION_TYPE_CODE      VARCHAR2(1 BYTE)   NOT NULL,
  MEDAL_OF_HONOR_ID          NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20),
  MH_INDICATOR               VARCHAR2(1 BYTE),
  MH_STATUS_UPDATE_DATE      DATE,
  STD_DECORATIONSTATUS_ID    NUMBER(20),
  DOCUMENT_RECEIPT_DATE      DATE,
  STD_DECORATIONDOCUMENT_ID  NUMBER(20),
  STD_MHDATASOURCE_ID        NUMBER(20),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(18)         NOT NULL,
  HISTORY_CREATED_DATE       DATE
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.MEDAL_OF_HONOR_ID IS 'Unique identifier for a Medal  of Honor';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.PERSON_ID IS 'Person Identifier';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.MH_INDICATOR IS 'Indicates if person has MH';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.MH_STATUS_UPDATE_DATE IS 'Last Edit Date';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.STD_DECORATIONSTATUS_ID IS 'Use existing SDS lookup';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.DOCUMENT_RECEIPT_DATE IS 'Date received';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.STD_DECORATIONDOCUMENT_ID IS 'Use existing SDS lookup';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.STD_MHDATASOURCE_ID IS 'New lookup in SDS';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR_H.HISTORY_CREATED_DATE IS 'Date history record created.';


CREATE UNIQUE INDEX ADR.MOH_H_PK ON ADR.MEDAL_OF_HONOR_H
(MEDAL_OF_HONOR_H_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MEDAL_OF_HONOR_H FOR ADR.MEDAL_OF_HONOR_H;


ALTER TABLE ADR.MEDAL_OF_HONOR_H ADD (
  CONSTRAINT AVCON_1252960469_TRANS_002
  CHECK (TRANSACTION_TYPE_CODE IN ('U', 'I', 'D'))
  ENABLE VALIDATE,
  CONSTRAINT MOH_H_PK
  PRIMARY KEY
  (MEDAL_OF_HONOR_H_ID)
  USING INDEX ADR.MOH_H_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEDAL_OF_HONOR_H TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.MEDAL_OF_HONOR_H TO ADR_RW;
ALTER TABLE ADR.MEDAL_OF_HONOR
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEDAL_OF_HONOR CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEDAL_OF_HONOR
(
  MEDAL_OF_HONOR_ID          NUMBER(20)         NOT NULL,
  PERSON_ID                  NUMBER(20)         NOT NULL,
  STD_DECORATIONSTATUS_ID    NUMBER(20),
  STD_DECORATIONDOCUMENT_ID  NUMBER(20),
  STD_MHDATASOURCE_ID        NUMBER(20),
  MH_INDICATOR               VARCHAR2(1 BYTE),
  MH_STATUS_UPDATE_DATE      DATE,
  DOCUMENT_RECEIPT_DATE      DATE,
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(18)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.MEDAL_OF_HONOR_ID IS 'The primary key, generated by the database system in numeric form. Uniquely identifies a record in this table.';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.MH_INDICATOR IS 'Indicates if person has a Medal Of Honor';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.MH_STATUS_UPDATE_DATE IS 'Last Edit Date';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.DOCUMENT_RECEIPT_DATE IS 'Date received';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.RECORD_CREATED_BY IS 'Account or user ID that created the record';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.RECORD_MODIFIED_BY IS 'Account or user ID for this modification to the record';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.MEDAL_OF_HONOR.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.MOH_PERSON_FK_I ON ADR.MEDAL_OF_HONOR
(PERSON_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MOH_PK ON ADR.MEDAL_OF_HONOR
(MEDAL_OF_HONOR_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE TRIGGER ADR.MOH_AUDIR_TRGR
  AFTER DELETE OR INSERT OR UPDATE
  ON ADR.MEDAL_OF_HONOR
 REFERENCING  OLD AS OLD NEW AS NEW
 FOR EACH ROW
declare
       mDML char(1);
begin

    if DELETING then
        insert into MEDAL_OF_HONOR_H
        (
        MEDAL_OF_HONOR_H_ID,
        MEDAL_OF_HONOR_ID,
        PERSON_ID,
        MH_INDICATOR,
        MH_STATUS_UPDATE_DATE,
        STD_DECORATIONSTATUS_ID,
        DOCUMENT_RECEIPT_DATE,
        STD_DECORATIONDOCUMENT_ID,
        STD_MHDATASOURCE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        MEDAL_OF_HONOR_H_S.nextval,
        :old.MEDAL_OF_HONOR_ID,
        :old.PERSON_ID,
        :old.MH_INDICATOR,
        :old.MH_STATUS_UPDATE_DATE,
        :old.STD_DECORATIONSTATUS_ID,
        :old.DOCUMENT_RECEIPT_DATE,
        :old.STD_DECORATIONDOCUMENT_ID,
        :old.STD_MHDATASOURCE_ID,
        :old.RECORD_CREATED_BY,
        :old.RECORD_CREATED_DATE,
        :old.RECORD_MODIFIED_BY,
        :old.RECORD_MODIFIED_DATE,
        :old.RECORD_MODIFIED_COUNT,
        SYSDATE,
        'D'
        );
    else
        if UPDATING then
            mDML := 'U';
        else
            mDML := 'I';
        end if;

        insert into MEDAL_OF_HONOR_H
        (
        MEDAL_OF_HONOR_H_ID,
        MEDAL_OF_HONOR_ID,
        PERSON_ID,
        MH_INDICATOR,
        MH_STATUS_UPDATE_DATE,
        STD_DECORATIONSTATUS_ID,
        DOCUMENT_RECEIPT_DATE,
        STD_DECORATIONDOCUMENT_ID,
        STD_MHDATASOURCE_ID,
        RECORD_CREATED_BY,
        RECORD_CREATED_DATE,
        RECORD_MODIFIED_BY,
        RECORD_MODIFIED_DATE,
        RECORD_MODIFIED_COUNT,
        HISTORY_CREATED_DATE,
        TRANSACTION_TYPE_CODE
        )
        values
        (
        MEDAL_OF_HONOR_H_S.nextval,
        :new.MEDAL_OF_HONOR_ID,
        :new.PERSON_ID,
        :new.MH_INDICATOR,
        :new.MH_STATUS_UPDATE_DATE,
        :new.STD_DECORATIONSTATUS_ID,
        :new.DOCUMENT_RECEIPT_DATE,
        :new.STD_DECORATIONDOCUMENT_ID,
        :new.STD_MHDATASOURCE_ID,
        :new.RECORD_CREATED_BY,
        :new.RECORD_CREATED_DATE,
        :new.RECORD_MODIFIED_BY,
        :new.RECORD_MODIFIED_DATE,
        :new.RECORD_MODIFIED_COUNT,
        SYSDATE,
        mDML
        );
    end if;

end MOH_AUDIR_TRGR;
/


CREATE OR REPLACE PUBLIC SYNONYM MEDAL_OF_HONOR FOR ADR.MEDAL_OF_HONOR;


ALTER TABLE ADR.MEDAL_OF_HONOR ADD (
  CONSTRAINT MOH_PK
  PRIMARY KEY
  (MEDAL_OF_HONOR_ID)
  USING INDEX ADR.MOH_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MEDAL_OF_HONOR ADD (
  CONSTRAINT RELATIONSHIP25 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEDAL_OF_HONOR TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.MEDAL_OF_HONOR TO ADR_RW;
ALTER TABLE ADR.MEC_PERIOD_NEW
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEC_PERIOD_NEW CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEC_PERIOD_NEW
(
  MEC_PERIOD_ID          NUMBER,
  PERSON_ID              NUMBER(20)             NOT NULL,
  MEC_START_DATE         DATE,
  MEC_END_DATE           DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.MEC_PERIOD_ID_PK ON ADR.MEC_PERIOD_NEW
(MEC_PERIOD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MEC_PERIOD_NEW FOR ADR.MEC_PERIOD_NEW;


ALTER TABLE ADR.MEC_PERIOD_NEW ADD (
  CONSTRAINT MEC_PERIOD_ID_PK
  PRIMARY KEY
  (MEC_PERIOD_ID)
  USING INDEX ADR.MEC_PERIOD_ID_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MEC_PERIOD_NEW ADD (
  CONSTRAINT MEC_PERIOD_NEW_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEC_PERIOD_NEW TO ADR_R;
ALTER TABLE ADR.MEC_PERIOD_LAST_HIST_NEW
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEC_PERIOD_LAST_HIST_NEW CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEC_PERIOD_LAST_HIST_NEW
(
  PERSON_ID                NUMBER(20),
  LAST_ENROLL_DETERM_H_ID  NUMBER(20),
  STATUS                   CHAR(1 BYTE)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX ADR.PERSON_ID_MAX_PK ON ADR.MEC_PERIOD_LAST_HIST_NEW
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MEC_PERIOD_LAST_HIST_NEW FOR ADR.MEC_PERIOD_LAST_HIST_NEW;


ALTER TABLE ADR.MEC_PERIOD_LAST_HIST_NEW ADD (
  CONSTRAINT PERSON_ID_MAX_PK
  PRIMARY KEY
  (PERSON_ID)
  USING INDEX ADR.PERSON_ID_MAX_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEC_PERIOD_LAST_HIST_NEW TO ADR_R;
DROP TABLE ADR.MEC_PERIOD_LAST_HIST CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEC_PERIOD_LAST_HIST
(
  PERSON_ID                NUMBER(20),
  LAST_ENROLL_DETERM_H_ID  NUMBER(20), 
  CONSTRAINT MEC_PERIOD_LAST_HIST_PK
  PRIMARY KEY
  (PERSON_ID)
  ENABLE VALIDATE
)
ORGANIZATION INDEX
PCTTHRESHOLD 10
TABLESPACE M_INDEX_01
RESULT_CACHE (MODE DEFAULT)
PCTFREE    10
INITRANS   20
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOPARALLEL
NOMONITORING;


-- Index MEC_PERIOD_LAST_HIST_PK is created auPIIatically by Oracle with index organized table MEC_PERIOD_LAST_HIST.

CREATE OR REPLACE PUBLIC SYNONYM MEC_PERIOD_LAST_HIST FOR ADR.MEC_PERIOD_LAST_HIST;


GRANT SELECT ON ADR.MEC_PERIOD_LAST_HIST TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.MEC_PERIOD_LAST_HIST TO ADR_RW;
ALTER TABLE ADR.MEC_PERIOD
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.MEC_PERIOD CASCADE CONSTRAINTS;

CREATE TABLE ADR.MEC_PERIOD
(
  MEC_PERIOD_ID          NUMBER(20)             NOT NULL,
  PERSON_ID              NUMBER(20)             NOT NULL,
  MEC_START_DATE         DATE,
  MEC_END_DATE           DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.MEC_PERIOD.MEC_PERIOD_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.MEC_PERIOD.PERSON_ID IS 'FK to Person table';

COMMENT ON COLUMN ADR.MEC_PERIOD.MEC_END_DATE IS 'Date Minimum Essential Coverage Ended';

COMMENT ON COLUMN ADR.MEC_PERIOD.RECORD_CREATED_BY IS 'What caused this record to get created.  Either individual, application or Work Item number.';

COMMENT ON COLUMN ADR.MEC_PERIOD.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.MEC_PERIOD.RECORD_MODIFIED_BY IS 'Who made the modification to this record.  Can be an individual, an application or a Work Item Number.';

COMMENT ON COLUMN ADR.MEC_PERIOD.RECORD_MODIFIED_DATE IS 'Date the record was modified.';

COMMENT ON COLUMN ADR.MEC_PERIOD.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified.';


CREATE INDEX ADR.MEC_PERIOD_END_DATE_NU_I ON ADR.MEC_PERIOD
(MEC_END_DATE)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.MEC_PERIOD_PERSON_FK_I ON ADR.MEC_PERIOD
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.MEC_PERIOD_PK ON ADR.MEC_PERIOD
(MEC_PERIOD_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM MEC_PERIOD FOR ADR.MEC_PERIOD;


ALTER TABLE ADR.MEC_PERIOD ADD (
  CONSTRAINT MEC_PERIOD_PK
  PRIMARY KEY
  (MEC_PERIOD_ID)
  USING INDEX ADR.MEC_PERIOD_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.MEC_PERIOD ADD (
  CONSTRAINT MEC_PERIOD_PERSON_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  ENABLE VALIDATE);

GRANT SELECT ON ADR.MEC_PERIOD TO ADR_R;

GRANT INSERT, SELECT, UPDATE ON ADR.MEC_PERIOD TO ADR_RW;
ALTER TABLE ADR.JOB_RESULT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.JOB_RESULT CASCADE CONSTRAINTS;

CREATE TABLE ADR.JOB_RESULT
(
  JOB_RESULT_ID          NUMBER(20)             NOT NULL,
  JOB_NAME               VARCHAR2(80 BYTE)      NOT NULL,
  JOB_GROUP_NAME         VARCHAR2(80 BYTE)      NOT NULL,
  JOB_STATUS_CODE        VARCHAR2(50 BYTE),
  JOB_CONTEXT            VARCHAR2(250 BYTE),
  JOB_STATISTICS         VARCHAR2(4000 BYTE),
  JOB_START_DATE         DATE,
  JOB_END_DATE           DATE,
  RECORD_CREATED_BY      VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_CREATED_DATE    DATE                   NOT NULL,
  RECORD_MODIFIED_BY     VARCHAR2(30 BYTE)      NOT NULL,
  RECORD_MODIFIED_DATE   DATE                   NOT NULL,
  RECORD_MODIFIED_COUNT  NUMBER(10)             NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.JOB_RESULT.JOB_RESULT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.JOB_RESULT.JOB_STATUS_CODE IS 'BR5850 Consent/Authorization ImageIndexNumberis definedastheunique imageindexnumber associatedwiththe veteranthatisassigned bytheimagingsystem.';

COMMENT ON COLUMN ADR.JOB_RESULT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.JOB_RESULT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.JOB_RESULT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.JOB_RESULT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.JOB_RESULT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.JOB_RESULT_GRPNAME_I ON ADR.JOB_RESULT
(JOB_GROUP_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.JOB_RESULT_NAME_I ON ADR.JOB_RESULT
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.JOB_RESULT_STATUS_I ON ADR.JOB_RESULT
(JOB_STATUS_CODE)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.JRESULT_PK ON ADR.JOB_RESULT
(JOB_RESULT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM JOB_RESULT FOR ADR.JOB_RESULT;


ALTER TABLE ADR.JOB_RESULT ADD (
  CONSTRAINT JRESULT_PK
  PRIMARY KEY
  (JOB_RESULT_ID)
  USING INDEX ADR.JRESULT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.JOB_RESULT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.JOB_RESULT TO ADR_RW;
ALTER TABLE ADR.JOB_CONFIG
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.JOB_CONFIG CASCADE CONSTRAINTS;

CREATE TABLE ADR.JOB_CONFIG
(
  JOB_CONFIG_ID            NUMBER(20)           NOT NULL,
  JOB_NAME                 VARCHAR2(80 BYTE)    NOT NULL,
  JOB_GROUP_NAME           VARCHAR2(80 BYTE)    NOT NULL,
  EMAIL_DISTRIBUTION_LIST  VARCHAR2(4000 BYTE),
  RECORD_CREATED_BY        VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_CREATED_DATE      DATE                 NOT NULL,
  RECORD_MODIFIED_BY       VARCHAR2(30 BYTE)    NOT NULL,
  RECORD_MODIFIED_DATE     DATE                 NOT NULL,
  RECORD_MODIFIED_COUNT    NUMBER(10)           NOT NULL
)
TABLESPACE S_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON COLUMN ADR.JOB_CONFIG.JOB_CONFIG_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.JOB_CONFIG.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.JCONFIG_PK ON ADR.JOB_CONFIG
(JOB_CONFIG_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.JOB_CONFIG_GRPNAME_I ON ADR.JOB_CONFIG
(JOB_GROUP_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.JOB_CONFIG_NAME_I ON ADR.JOB_CONFIG
(JOB_NAME)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM JOB_CONFIG FOR ADR.JOB_CONFIG;


ALTER TABLE ADR.JOB_CONFIG ADD (
  CONSTRAINT JCONFIG_PK
  PRIMARY KEY
  (JOB_CONFIG_ID)
  USING INDEX ADR.JCONFIG_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.JOB_CONFIG TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.JOB_CONFIG TO ADR_RW;
ALTER TABLE ADR.IVM_MIGRATE_STATISTICS
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE_STATISTICS CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_STATISTICS
(
  IVM_MIGRATE_STATISTICS_ID  NUMBER(20)         NOT NULL,
  PROCESSED_COUNT            NUMBER(10),
  LOAD_FAIL_CLEAR_COUNT      NUMBER(10),
  NO_IVM_CRITERIA_COUNT      NUMBER(10),
  NO_MATCH_COUNT             NUMBER(10),
  RECORD_CREATED_BY          VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_CREATED_DATE        DATE               NOT NULL,
  RECORD_MODIFIED_BY         VARCHAR2(30 BYTE)  NOT NULL,
  RECORD_MODIFIED_DATE       DATE               NOT NULL,
  RECORD_MODIFIED_COUNT      NUMBER(10)         NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_STATISTICS IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.IVM_MIGRATE_STATISTICS_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_STATISTICS.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.IVMMIGSTAT_PK ON ADR.IVM_MIGRATE_STATISTICS
(IVM_MIGRATE_STATISTICS_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_STATISTICS FOR ADR.IVM_MIGRATE_STATISTICS;


ALTER TABLE ADR.IVM_MIGRATE_STATISTICS ADD (
  CONSTRAINT IVMMIGSTAT_PK
  PRIMARY KEY
  (IVM_MIGRATE_STATISTICS_ID)
  USING INDEX ADR.IVMMIGSTAT_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE_STATISTICS TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_STATISTICS TO ADR_RW;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL
(
  IVM_MIGRATE_EXTRACT_DETAIL_ID  NUMBER(20)     NOT NULL,
  IVM_MIGRATE_EXTRACT_ID         NUMBER(20)     NOT NULL,
  INCOME_YEAR                    NUMBER(4),
  LEGACY_ICN                     VARCHAR2(30 BYTE),
  RECORD_CREATED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE            DATE           NOT NULL,
  RECORD_MODIFIED_BY             VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE           DATE           NOT NULL,
  RECORD_MODIFIED_COUNT          NUMBER(10)     NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.IVM_MIGRATE_EXTRACT_DETAIL_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.IVM_MIGRATE_EXTRACT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.INCOME_YEAR IS 'Incomeyearforwhichthe visitsummaryinformation isbeingcollected.IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.IVMMGEXDTL_IVMMGEX_FK_I ON ADR.IVM_MIGRATE_EXTRACT_DETAIL
(IVM_MIGRATE_EXTRACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.IVMMGEXDTL_PK ON ADR.IVM_MIGRATE_EXTRACT_DETAIL
(IVM_MIGRATE_EXTRACT_DETAIL_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_EXTRACT_DETAIL FOR ADR.IVM_MIGRATE_EXTRACT_DETAIL;


ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_DETAIL_ID)
  USING INDEX ADR.IVMMGEXDTL_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.IVM_MIGRATE_EXTRACT_DETAIL ADD (
  CONSTRAINT IVMMGEXDTL_IVMMGEX_FK 
  FOREIGN KEY (IVM_MIGRATE_EXTRACT_ID) 
  REFERENCES ADR.IVM_MIGRATE_EXTRACT (IVM_MIGRATE_EXTRACT_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_EXTRACT_DETAIL TO ADR_RW;
ALTER TABLE ADR.IVM_MIGRATE_EXTRACT
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE_EXTRACT CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_EXTRACT
(
  IVM_MIGRATE_EXTRACT_ID  NUMBER(20)            NOT NULL,
  IVM_MIGRATE_TYPE_ID     NUMBER(20)            NOT NULL,
  EXTRACT_FILE_NAME       VARCHAR2(100 BYTE),
  EXTRACT_START_DATE      DATE,
  EXTRACT_END_DATE        DATE,
  EXTRACT_RECORD_COUNT    NUMBER(10),
  RECORD_CREATED_BY       VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_CREATED_DATE     DATE                  NOT NULL,
  RECORD_MODIFIED_BY      VARCHAR2(30 BYTE)     NOT NULL,
  RECORD_MODIFIED_DATE    DATE                  NOT NULL,
  RECORD_MODIFIED_COUNT   NUMBER(10)            NOT NULL
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_EXTRACT IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.IVM_MIGRATE_EXTRACT_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_EXTRACT.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.IVMMGEX_PK ON ADR.IVM_MIGRATE_EXTRACT
(IVM_MIGRATE_EXTRACT_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IVMMGEX_STD_IVMMGRTYP_FK_I ON ADR.IVM_MIGRATE_EXTRACT
(IVM_MIGRATE_TYPE_ID)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_EXTRACT FOR ADR.IVM_MIGRATE_EXTRACT;


ALTER TABLE ADR.IVM_MIGRATE_EXTRACT ADD (
  CONSTRAINT IVMMGEX_PK
  PRIMARY KEY
  (IVM_MIGRATE_EXTRACT_ID)
  USING INDEX ADR.IVMMGEX_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE_EXTRACT TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_EXTRACT TO ADR_RW;
DROP TABLE ADR.IVM_MIGRATE_ARCHIVE CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE_ARCHIVE
(
  IVM_MIGRATE_ID            NUMBER(20)          NOT NULL,
  IVM_MIGRATE_ARCHIVE_ID    NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  MIGRATE_DATE              DATE,
  INCOME_YEAR               NUMBER(4),
  LEGACY_ICN                VARCHAR2(30 BYTE),
  LOAD_FAILURE_DESCRIPTION  VARCHAR2(2000 BYTE),
  MARKED_FLAG               NUMBER(1)           DEFAULT 0                     NOT NULL,
  REMIGRATE_FLAG            NUMBER(1)           DEFAULT 0                     NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  STD_MESSAGESTATUS_ID      NUMBER(20)
)
COMPRESS FOR OLTP 
TABLESPACE L_DATA_03
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
PARTITION BY RANGE (RECORD_CREATED_DATE)
INTERVAL( NUMTOYMINTERVAL(1,'MONTH'))
(  
  PARTITION IVMMGRTARC_P001 VALUES LESS THAN (TO_DATE(' 2014-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                MAXSIZE          UNLIMITED
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-11-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2014-12-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-01-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-02-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-06-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-07-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-08-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-09-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2015-10-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-01-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-02-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-03-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-04-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               ),  
  PARTITION VALUES LESS THAN (TO_DATE(' 2016-05-01 00:00:00', 'SYYYY-MM-DD HH24:MI:SS', 'NLS_CALENDAR=GREGORIAN'))
    LOGGING
    COMPRESS FOR OLTP 
    TABLESPACE L_DATA_03
    PCTFREE    10
    INITRANS   1
    MAXTRANS   255
    STORAGE    (
                INITIAL          128M
                NEXT             128M
                MAXSIZE          UNLIMITED
                MINEXTENTS       1
                MAXEXTENTS       UNLIMITED
                PCTINCREASE      0
                BUFFER_POOL      DEFAULT
                FLASH_CACHE      DEFAULT
                CELL_FLASH_CACHE DEFAULT
               )
)
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE_ARCHIVE IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.IVM_MIGRATE_ARCHIVE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.INCOME_YEAR IS 'IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE_ARCHIVE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE UNIQUE INDEX ADR.IVMMGRTARC_PK ON ADR.IVM_MIGRATE_ARCHIVE
(IVM_MIGRATE_ARCHIVE_ID)
  TABLESPACE L_INDEX_03
  PCTFREE    10
  INITRANS   2
  MAXTRANS   255
  STORAGE    (
              BUFFER_POOL      DEFAULT
              FLASH_CACHE      DEFAULT
              CELL_FLASH_CACHE DEFAULT
             )
LOGGING
GLOBAL PARTITION BY HASH (IVM_MIGRATE_ARCHIVE_ID) (  
  PARTITION IVMMGRTARC_IDX_P001
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P002
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P003
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P004
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P005
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P006
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P007
    TABLESPACE L_INDEX_03,  
  PARTITION IVMMGRTARC_IDX_P008
    TABLESPACE L_INDEX_03
)
PARALLEL ( DEGREE DEFAULT INSTANCES DEFAULT );

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_ARCHIVE FOR ADR.IVM_MIGRATE_ARCHIVE;


GRANT SELECT ON ADR.IVM_MIGRATE_ARCHIVE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE_ARCHIVE TO ADR_RW;
ALTER TABLE ADR.IVM_MIGRATE
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IVM_MIGRATE CASCADE CONSTRAINTS;

CREATE TABLE ADR.IVM_MIGRATE
(
  IVM_MIGRATE_ID            NUMBER(20)          NOT NULL,
  PERSON_ID                 NUMBER(20)          NOT NULL,
  MIGRATE_DATE              DATE,
  INCOME_YEAR               NUMBER(4),
  LEGACY_ICN                VARCHAR2(30 BYTE),
  LOAD_FAILURE_DESCRIPTION  VARCHAR2(2000 BYTE),
  MARKED_FLAG               NUMBER(1)           DEFAULT 0                     NOT NULL,
  REMIGRATE_FLAG            NUMBER(1)           DEFAULT 0                     NOT NULL,
  RECORD_CREATED_BY         VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_CREATED_DATE       DATE                NOT NULL,
  RECORD_MODIFIED_BY        VARCHAR2(30 BYTE)   NOT NULL,
  RECORD_MODIFIED_DATE      DATE                NOT NULL,
  RECORD_MODIFIED_COUNT     NUMBER(10)          NOT NULL,
  STD_MESSAGESTATUS_ID      NUMBER(20)
)
TABLESPACE M_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IVM_MIGRATE IS 'For a brief period just after Deployment, the ADR database to be running in parallel with an EDB database that contains the IVM data. During this period, any deltas that occur in the ADR system after initial migration, will be stored in this table. Hence, this is a one-time, IVM migration related table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE.IVM_MIGRATE_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE.PERSON_ID IS 'Theprimarykey, generatedbythedatabase systeminnumericform, usedtouniquelyidentify adatarecordinthis table.';

COMMENT ON COLUMN ADR.IVM_MIGRATE.INCOME_YEAR IS 'IncomeYearisdefinedas theIncomeYearthatthis financialinformation pertainsto.';

COMMENT ON COLUMN ADR.IVM_MIGRATE.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IVM_MIGRATE.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IVM_MIGRATE.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';

COMMENT ON COLUMN ADR.IVM_MIGRATE.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';


CREATE INDEX ADR.IVMMGRT_LGCYICN_NU_I ON ADR.IVM_MIGRATE
(LEGACY_ICN)
LOGGING
TABLESPACE S_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128K
            NEXT             128K
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE UNIQUE INDEX ADR.IVMMGRT_PK ON ADR.IVM_MIGRATE
(IVM_MIGRATE_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IVMMGRT_PRSN_FK_I ON ADR.IVM_MIGRATE
(PERSON_ID)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IVMMGRT_PRSN_INCYR_REMIG_NU_I ON ADR.IVM_MIGRATE
(PERSON_ID, INCOME_YEAR, REMIGRATE_FLAG)
LOGGING
TABLESPACE M_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          4M
            NEXT             4M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IVMMGRT_RCDCRTDT_NU_I ON ADR.IVM_MIGRATE
(RECORD_CREATED_DATE)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IVMMGRT_STDMSGSTA_NU_I ON ADR.IVM_MIGRATE
(STD_MESSAGESTATUS_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE FOR ADR.IVM_MIGRATE;


ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT AVCON_1172521913_MARKE_000
  CHECK (MARKED_FLAG BETWEEN 0 AND 0 OR MARKED_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT AVCON_1172521913_REMIG_000
  CHECK (REMIGRATE_FLAG BETWEEN 0 AND 0 OR REMIGRATE_FLAG BETWEEN 1 AND 1)
  ENABLE VALIDATE,
  CONSTRAINT IVMMGRT_PK
  PRIMARY KEY
  (IVM_MIGRATE_ID)
  USING INDEX ADR.IVMMGRT_PK
  ENABLE VALIDATE);

ALTER TABLE ADR.IVM_MIGRATE ADD (
  CONSTRAINT IVMMGRT_PRSN_FK 
  FOREIGN KEY (PERSON_ID) 
  REFERENCES ADR.PERSON (PERSON_ID)
  DEFERRABLE INITIALLY DEFERRED
  ENABLE VALIDATE);

GRANT SELECT ON ADR.IVM_MIGRATE TO ADR_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADR.IVM_MIGRATE TO ADR_RW;
ALTER TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
 DROP PRIMARY KEY CASCADE;

DROP TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL CASCADE CONSTRAINTS;

CREATE TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL
(
  IRS_TRANSMISSION_LOG_DETAIL_ID  NUMBER(20)    NOT NULL,
  IRS_TRANSMISSION_LOG_ID         NUMBER(20)    NOT NULL,
  PERSON_ID                       NUMBER(20),
  IEN                             VARCHAR2(30 BYTE),
  RECORD_SEQUENCE                 NUMBER(10)    NOT NULL,
  ERROR_DESCRIPTION               VARCHAR2(1000 BYTE),
  RECORD_MODIFIED_COUNT           NUMBER(10)    NOT NULL,
  RECORD_CREATED_BY               VARCHAR2(30 BYTE) NOT NULL,
  RECORD_CREATED_DATE             DATE          NOT NULL,
  RECORD_MODIFIED_BY              VARCHAR2(30 BYTE) NOT NULL,
  RECORD_MODIFIED_DATE            DATE          NOT NULL
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE ADR.IRS_TRANSMISSION_LOG_DETAIL IS 'This table contains details of each person transmitted in a batch submission to IRS.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.IRS_TRANSMISSION_LOG_DETAIL_ID IS 'Primary Key';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.IRS_TRANSMISSION_LOG_ID IS 'FK to ADR.IRS_TRANSMISSION_LOG.IRS_TRANSMISSION_LOG_ID';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.PERSON_ID IS 'FK to ADR.PERSON.PERSON_ID';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.IEN IS 'Unique ID of Beneficiary person record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.RECORD_SEQUENCE IS 'Sequence number 1n of this records position in the batch';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.ERROR_DESCRIPTION IS 'Error string provided by IRS describing reject reason for this particular record data';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.RECORD_MODIFIED_COUNT IS 'Number of times this record has been modified with zero indicating the initial creation, 1...n.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.RECORD_CREATED_BY IS 'Account/user ID that created the record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.RECORD_CREATED_DATE IS 'Date the record was created.';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.RECORD_MODIFIED_BY IS 'Account/user ID for this modification to the record';

COMMENT ON COLUMN ADR.IRS_TRANSMISSION_LOG_DETAIL.RECORD_MODIFIED_DATE IS 'Date of this modification to the record.';


CREATE INDEX ADR.IRSTRNSLGDET_IEN_NU_I ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(IEN)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IRSTRNSLGDET_IRSTRNSLG_FK_I ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(IRS_TRANSMISSION_LOG_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          128M
            NEXT             128M
            MAXSIZE          UNLIMITED
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX ADR.IRSTRNSLGDET_PERS_FK_I ON ADR.IRS_TRANSMISSION_LOG_DETAIL
(PERSON_ID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255